/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.jacorb.orb.factory.PortRangeFactory;

public class PortRangeSocketFactory
extends AbstractSocketFactory {
    public static final String MIN_PROP = "jacorb.net.socket_factory.port.min";
    public static final String MAX_PROP = "jacorb.net.socket_factory.port.max";
    private final int portMin;
    private final int portMax;

    public PortRangeSocketFactory() {
        PortRangeFactory util = new PortRangeFactory(MIN_PROP, MAX_PROP);
        this.portMin = util.portMin;
        this.portMax = util.portMax;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.createSocketInternal(host, port, 0);
    }

    protected final Socket createSocketInternal(String host, int port, int timeout) throws UnknownHostException, BindException {
        InetAddress localHost = InetAddress.getLocalHost();
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            try {
                Socket socket = this.newSocket(host, port, localPort, localHost, timeout);
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("PortRangeSocketFactory: Created socket between " + localHost.getHostAddress() + ":" + localPort + " and " + host + ":" + port);
                }
                return socket;
            }
            catch (IOException ex) {
                this.logger.debug("cannot open local port " + localPort, ex);
                continue;
            }
        }
        this.logger.warn("Cannot bind socket between ports " + this.portMin + " and " + this.portMax + " to target " + host + ":" + port);
        throw new BindException("PortRangeSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    protected Socket newSocket(String host, int port, int localPort, InetAddress localHost, int timeout) throws IOException {
        return new Socket(host, port, localHost, localPort);
    }

    @Override
    public boolean isSSL(Socket socket) {
        return false;
    }
}

