/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.ETF.Profile;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class ClientIIOPConnection
extends IIOPConnection {
    private IIOPProfile target_profile;
    private boolean use_ssl = false;
    private int ssl_port = -1;
    private final Logger logger = Debug.getNamedLogger("jacorb.iiop.conn");
    private static int openTransports = 0;
    private Exception exception = null;
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final String DEFAULT_HOST_MSG = "Unable to resolve local host - using default 127.0.0.1";

    @Override
    public synchronized void connect(Profile server_profile, long time_out) {
        if (!this.connected) {
            if (!(server_profile instanceof IIOPProfile)) {
                throw new BAD_PARAM("attempt to connect an IIOP connection to a non-IIOP profile: " + server_profile.getClass());
            }
            this.target_profile = (IIOPProfile)server_profile;
            this.checkSSL();
            int retries = Environment.noOfRetries();
            while (retries >= 0) {
                try {
                    this.createSocket(time_out);
                    this.socket.setTcpNoDelay(true);
                    if (Environment.getClientIdleTimeout() != 0) {
                        this.socket.setSoTimeout(Environment.getClientIdleTimeout());
                    }
                    this.socket.setKeepAlive(Environment.getClientKeepAlive());
                    this.in_stream = this.socket.getInputStream();
                    this.out_stream = new BufferedOutputStream(this.socket.getOutputStream());
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Connected to " + this.connection_info + " from local port " + this.socket.getLocalPort() + (this.isSSL() ? " via SSL" : ""));
                    }
                    this.connected = true;
                    ++openTransports;
                    return;
                }
                catch (IOException c) {
                    if (--retries < 0) continue;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Retrying to connect to " + this.connection_info);
                    }
                    try {
                        Thread.sleep(Environment.retryInterval());
                    }
                    catch (InterruptedException i) {}
                }
                catch (TIMEOUT e) {
                    this.target_profile = null;
                    this.use_ssl = false;
                    this.ssl_port = -1;
                    throw e;
                }
            }
            if (retries < 0) {
                this.target_profile = null;
                this.use_ssl = false;
                this.ssl_port = -1;
                throw new TRANSIENT("Retries exceeded, couldn't reconnect to " + this.connection_info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSocket(long time_out) throws IOException {
        ArrayList<IIOPAddress> addressList = new ArrayList<IIOPAddress>();
        addressList.add(this.target_profile.getAddress());
        addressList.addAll(this.target_profile.getAlternateAddresses());
        Iterator addressIterator = addressList.iterator();
        this.exception = null;
        this.socket = null;
        while (this.socket == null && addressIterator.hasNext()) {
            IIOPAddress address = (IIOPAddress)addressIterator.next();
            try {
                SocketFactory factory = this.use_ssl ? this.getSSLSocketFactory() : this.getSocketFactory();
                String ipAddress = address.getIP();
                int port = this.use_ssl ? this.ssl_port : address.getPort();
                this.connection_info = ipAddress.indexOf(58) == -1 ? ipAddress + ":" + port : "[" + ipAddress + "]:" + port;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to connect to " + this.connection_info + " with timeout=" + time_out + (this.use_ssl ? " using SSL." : ""));
                }
                this.exception = null;
                this.socket = null;
                if (time_out > 0L) {
                    int truncated = (int)time_out;
                    if ((long)truncated != time_out && this.logger.isWarnEnabled()) {
                        this.logger.warn("Timeout might be modified by conversion from long to int old value:" + time_out + " new value: " + truncated);
                    }
                    this.socket = factory.createSocket(ipAddress, port, truncated);
                    continue;
                }
                this.socket = factory.createSocket(ipAddress, port);
            }
            catch (Exception e) {
                this.exception = e;
            }
            finally {
                String localhost;
                if (this.socket == null || SocketFactoryManager.getTCPListener() == null) continue;
                try {
                    localhost = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException uhe) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(DEFAULT_HOST_MSG);
                    }
                    localhost = DEFAULT_HOST;
                }
                SocketFactoryManager.getTCPListener().connectionOpened(new TCPConnectionEvent(this, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), this.socket.getLocalPort(), localhost));
            }
        }
        if (this.exception != null) {
            if (this.exception instanceof IOException) {
                throw (IOException)this.exception;
            }
            if (this.exception instanceof TIMEOUT) {
                throw (TIMEOUT)this.exception;
            }
            throw new IOException("Unexpected exception occured: " + this.exception.toString());
        }
    }

    @Override
    public synchronized void close() {
        try {
            if (this.connected && this.socket != null) {
                if (this.socket.getClass().isAssignableFrom(Socket.class)) {
                    try {
                        this.socket.shutdownOutput();
                    }
                    catch (SocketException ignore) {
                        // empty catch block
                    }
                }
                this.socket.close();
                if (this.in_stream != null) {
                    this.in_stream.close();
                }
                if (this.out_stream != null) {
                    this.out_stream.close();
                }
                --openTransports;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Client-side TCP transport to " + this.connection_info + " closed.");
                }
            }
            this.connected = false;
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception when closing the socket", ex);
            }
            throw this.to_COMM_FAILURE(ex);
        }
        finally {
            if (this.socket != null && SocketFactoryManager.getTCPListener() != null) {
                String localhost;
                try {
                    localhost = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException uhe) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(DEFAULT_HOST_MSG);
                    }
                    localhost = DEFAULT_HOST;
                }
                SocketFactoryManager.getTCPListener().connectionClosed(new TCPConnectionEvent(this, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), this.socket.getLocalPort(), localhost));
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Client-side TCP transport to " + this.connection_info + " closed.");
        }
    }

    @Override
    public boolean isSSL() {
        return this.use_ssl;
    }

    @Override
    public Profile get_server_profile() {
        return this.target_profile;
    }

    private void checkSSL() {
        if (this.target_profile.getSSL() == null) {
            return;
        }
        CompoundSecMechList sas = (CompoundSecMechList)this.target_profile.getComponent(33, CompoundSecMechListHelper.class);
        TLS_SEC_TRANS tls = null;
        if (sas != null && sas.mechanism_list[0].transport_mech.tag == 36) {
            try {
                byte[] tagData = sas.mechanism_list[0].transport_mech.component_data;
                CDRInputStream in = new CDRInputStream(null, tagData);
                in.openEncapsulatedArray();
                tls = TLS_SEC_TRANSHelper.read(in);
            }
            catch (Exception ex) {
                this.logger.warn("Error parsing TLS_SEC_TRANS: " + ex);
            }
        }
        SSL ssl = (SSL)this.target_profile.getComponent(20, SSLHelper.class);
        int minimum_options = 126;
        int client_required = 0;
        int client_supported = 0;
        if (Environment.getSupportSSL()) {
            client_required = Environment.getIntProperty("jacorb.security.ssl.client.required_options", 16);
            client_supported = Environment.getIntProperty("jacorb.security.ssl.client.supported_options", 16);
        }
        if (tls != null && (tls.target_supports & minimum_options) != 0 && Environment.getSupportSSL() && (client_supported & minimum_options) != 0 && ((tls.target_requires & minimum_options) != 0 || (client_required & minimum_options) != 0)) {
            this.use_ssl = true;
            this.ssl_port = tls.addresses[0].port;
            if (this.ssl_port < 0) {
                this.ssl_port += 65536;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting TLS for connection");
            }
        } else if (ssl != null && (ssl.target_supports & minimum_options) != 0 && Environment.getSupportSSL() && (client_supported & minimum_options) != 0 && ((ssl.target_requires & minimum_options) != 0 || (client_required & minimum_options) != 0)) {
            this.use_ssl = true;
            this.ssl_port = ssl.port;
            if (this.ssl_port < 0) {
                this.ssl_port += 65536;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting SSL for connection");
            }
        } else {
            if (Environment.getSupportSSL() && (client_required & minimum_options) != 0) {
                throw new NO_PERMISSION("Client-side policy requires SSL/TLS, but server doesn't support it");
            }
            this.use_ssl = false;
            this.ssl_port = -1;
        }
    }

    private SocketFactory getSocketFactory() {
        return SocketFactoryManager.getSocketFactory();
    }

    private SocketFactory getSSLSocketFactory() {
        return SocketFactoryManager.getSSLSocketFactory();
    }
}

