/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.listener.SSLListenerUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.BufferHolder;
import org.omg.ETF._ConnectionLocalBase;

public abstract class IIOPConnection
extends _ConnectionLocalBase {
    protected boolean connected = false;
    protected InputStream in_stream = null;
    protected OutputStream out_stream = null;
    private ByteArrayOutputStream b_out;
    protected String connection_info;
    protected Socket socket;
    private final int finalTimeout;
    protected Logger logger = Debug.getNamedLogger("jacorb.iiop.conn");

    public IIOPConnection() {
        String dump_outgoing = Environment.getProperty("jacorb.debug.dump_outgoing_messages", "off");
        if ("on".equals(dump_outgoing)) {
            this.b_out = new ByteArrayOutputStream();
        }
        this.finalTimeout = Environment.getIntPropertyWithDefault("jacorb.connection.timeout_after_closeconnection", 20000);
    }

    @Override
    public void read(BufferHolder data, int offset, int min_length, int max_length, long time_out) {
        int n;
        for (int read = 0; read < min_length; read += n) {
            n = 0;
            try {
                n = this.in_stream.read(data.value, offset + read, min_length - read);
            }
            catch (InterruptedIOException e) {
                int soTimeout = 0;
                try {
                    soTimeout = this.socket.getSoTimeout();
                }
                catch (SocketException ex) {
                    throw this.to_COMM_FAILURE(ex);
                }
                if (soTimeout != 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Socket timeout (timeout period: " + soTimeout + ")");
                    }
                    throw new TIMEOUT();
                }
                throw new TRANSIENT("Interrupted I/O: " + e);
            }
            catch (IOException se) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Transport to " + this.connection_info + ": stream closed" + se.getMessage());
                }
                throw this.to_COMM_FAILURE(se);
            }
            if (n >= 0) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Transport to " + this.connection_info + ": stream closed on read < 0");
            }
            throw new COMM_FAILURE("read() did not return any data");
        }
    }

    @Override
    public void write(boolean is_first, boolean is_last, byte[] data, int offset, int length, long time_out) {
        try {
            this.out_stream.write(data, offset, length);
            if (this.b_out != null) {
                this.b_out.write(data, offset, length);
            }
        }
        catch (IOException ex) {
            throw this.to_COMM_FAILURE(ex);
        }
    }

    @Override
    public void flush() {
        try {
            if (this.b_out != null) {
                byte[] b = this.b_out.toByteArray();
                Debug.output(1, "sendMessages()", b);
                this.b_out.reset();
            }
            this.out_stream.flush();
        }
        catch (IOException ex) {
            throw this.to_COMM_FAILURE(ex);
        }
    }

    @Override
    public synchronized boolean is_connected() {
        return this.connected;
    }

    public int hashCode() {
        if (this.socket == null || !this.connected) {
            return super.hashCode();
        }
        return this.socket.hashCode();
    }

    public void turnOnFinalTimeout() {
        if (this.socket != null) {
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Socket timeout set to " + this.finalTimeout + " ms");
                }
                this.socket.setSoTimeout(this.finalTimeout);
            }
            catch (SocketException se) {
                Debug.output(2, se);
            }
        }
    }

    public abstract boolean isSSL();

    protected COMM_FAILURE to_COMM_FAILURE(IOException ex) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Caught exception", ex);
        }
        SSLListenerUtil.processException(this, this.socket, ex);
        return new COMM_FAILURE("IOException: " + ex.toString());
    }

    @Override
    public boolean is_data_available() {
        try {
            return this.in_stream.available() > 0;
        }
        catch (IOException ex) {
            throw this.to_COMM_FAILURE(ex);
        }
    }

    @Override
    public boolean wait_next_data(long time_out) {
        throw new NO_IMPLEMENT();
    }

    @Override
    public boolean supports_callback() {
        return true;
    }

    @Override
    public boolean use_handle_time_out() {
        return false;
    }
}

