/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.listener;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.iiop.IIOPListener;
import org.jacorb.orb.listener.AcceptorExceptionEvent;
import org.jacorb.orb.listener.AcceptorExceptionListener;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;

public class DefaultAcceptorExceptionListener
implements AcceptorExceptionListener {
    private Class sslException;
    private final Logger logger;

    public DefaultAcceptorExceptionListener() {
        try {
            this.sslException = Environment.classForName("javax.net.ssl.SSLException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.logger = Debug.getNamedLogger("jacorb.orb.iiop");
    }

    @Override
    public void exceptionCaught(AcceptorExceptionEvent ae) {
        this.logger.fatalError("DefaultAcceptorExceptionListener#exceptionCaught", ae.getException());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Caught acceptor event " + ae.toString());
        }
        if (ae.getException() instanceof Error || !((IIOPListener.Acceptor)ae.getSource()).getAcceptorSocketLoop() && this.sslException != null && this.sslException.isInstance(ae.getException())) {
            ae.getORB().shutdown(true);
        }
    }
}

