/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.IORInfoImpl;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.sasPolicy.ATLASPolicy;
import org.jacorb.sasPolicy.ATLASPolicyValues;
import org.jacorb.sasPolicy.SASPolicy;
import org.jacorb.sasPolicy.SASPolicyValues;
import org.jacorb.security.sas.ISASContext;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.ATLAS.ATLASLocator;
import org.omg.ATLAS.ATLASProfile;
import org.omg.ATLAS.ATLASProfileHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;

public class SASComponentInterceptor
extends LocalObject
implements IORInterceptor {
    private static Logger logger = Debug.getNamedLogger("jacorb.SAS.IOR");
    private final ORB orb;
    private Codec codec = null;
    private TaggedComponent tc = null;
    private ISASContext sasContext = null;

    public SASComponentInterceptor(ORBInitInfo info) {
        this.orb = ((ORBInitInfoImpl)info).getORB();
        try {
            Encoding encoding = new Encoding(0, 1, 0);
            CodecFactory codec_factory = (CodecFactory)this.orb.resolve_initial_references("CodecFactory");
            this.codec = codec_factory.create_codec(encoding);
        }
        catch (Exception e) {
            logger.error("Error initing SASComponentInterceptor: ", e);
        }
        String contextClass = Environment.getProperty("jacorb.security.sas.contextClass");
        if (contextClass != null) {
            try {
                Class c = Environment.classForName(contextClass);
                this.sasContext = (ISASContext)c.newInstance();
            }
            catch (Exception e) {
                logger.error("Could not instantiate SAS Context class " + contextClass + ": " + e);
            }
        }
        if (this.sasContext == null) {
            logger.error("Could not load SAS context class: " + contextClass);
        }
    }

    @Override
    public String name() {
        return "SASComponentCreator";
    }

    @Override
    public void destroy() {
    }

    @Override
    public void establish_components(IORInfo info) {
        if (this.sasContext == null) {
            return;
        }
        SASPolicyValues sasValues = null;
        try {
            SASPolicy policy = (SASPolicy)((IORInfoImpl)info).get_effective_policy(100);
            if (policy != null) {
                sasValues = policy.value();
            }
        }
        catch (BAD_PARAM e) {
            logger.debug("No SAS Policy");
        }
        catch (Exception e) {
            logger.warn("Error fetching SAS policy: " + e);
        }
        if (sasValues == null) {
            return;
        }
        if (sasValues.targetRequires == 0 && sasValues.targetSupports == 0) {
            return;
        }
        ATLASPolicyValues atlasValues = null;
        try {
            ATLASPolicy policy = (ATLASPolicy)info.get_effective_policy(101);
            if (policy != null) {
                atlasValues = policy.value();
            }
        }
        catch (BAD_PARAM e) {
            logger.debug("No ATLAS Policy");
        }
        catch (Exception e) {
            logger.warn("Error fetching ATLAS policy: " + e);
        }
        try {
            if (this.tc == null) {
                byte[] clientAuthenticationMech;
                TaggedComponent transportMech = new TaggedComponent(34, new byte[0]);
                byte[] targetName = this.sasContext.getClientPrincipal().getBytes();
                ServiceConfiguration[] serviceConfiguration = null;
                if (atlasValues == null) {
                    serviceConfiguration = new ServiceConfiguration[]{};
                } else {
                    if (atlasValues.atlasCache == null) {
                        atlasValues.atlasCache = "";
                    }
                    ATLASLocator atlasLoc = new ATLASLocator();
                    atlasLoc.the_url(atlasValues.atlasURL);
                    ATLASProfile profile = new ATLASProfile();
                    profile.the_cache_id = atlasValues.atlasCache.getBytes();
                    profile.the_locator = atlasLoc;
                    byte[] cdrProfile = new byte[]{};
                    Any any = this.orb.create_any();
                    ATLASProfileHelper.insert((Any)any, (ATLASProfile)profile);
                    cdrProfile = this.codec.encode(any);
                    serviceConfiguration = new ServiceConfiguration[]{new ServiceConfiguration(3, cdrProfile)};
                }
                SAS_ContextSec sasContextSec = new SAS_ContextSec(0, 0, serviceConfiguration, new byte[0][0], 0);
                boolean useStateful = Boolean.valueOf(Environment.getProperty("jacorb.security.sas.stateful", "true"));
                CompoundSecMech[] compoundSecMech = new CompoundSecMech[1];
                try {
                    Class<?> jgssOid = Class.forName("org.ietf.jgss.Oid");
                    Constructor<?> jgssCtr = jgssOid.getConstructor(String.class);
                    Method jgssMthd = jgssOid.getDeclaredMethod("getDER", new Class[0]);
                    clientAuthenticationMech = (byte[])jgssMthd.invoke(jgssCtr.newInstance(this.sasContext.getMechOID()), new Object[0]);
                }
                catch (Exception e) {
                    clientAuthenticationMech = new byte[]{};
                }
                AS_ContextSec asContextSec = new AS_ContextSec(sasValues.targetSupports, sasValues.targetRequires, clientAuthenticationMech, targetName);
                compoundSecMech[0] = new CompoundSecMech(sasValues.targetRequires, transportMech, asContextSec, sasContextSec);
                CompoundSecMechList compoundSecMechList = new CompoundSecMechList(useStateful, compoundSecMech);
                CDROutputStream sasDataStream = new CDROutputStream(this.orb);
                sasDataStream.beginEncapsulatedArray();
                CompoundSecMechListHelper.write(sasDataStream, compoundSecMechList);
                this.tc = new TaggedComponent(33, sasDataStream.getBufferCopy());
                sasDataStream.close();
                sasDataStream = null;
            }
            info.add_ior_component_to_profile(this.tc, 0);
        }
        catch (Exception e) {
            logger.error("establish_components error: ", e);
        }
    }
}

