/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.typecode;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.typecode.AbstractInterfaceTypeCodeReader;
import org.jacorb.orb.typecode.AliasTypeCodeReader;
import org.jacorb.orb.typecode.EnumTypeCodeReader;
import org.jacorb.orb.typecode.ExceptTypeCodeReader;
import org.jacorb.orb.typecode.IndirectionTypeCodeReader;
import org.jacorb.orb.typecode.ObjectReferenceTypeCodeReader;
import org.jacorb.orb.typecode.PrimitiveTypeCodeReader;
import org.jacorb.orb.typecode.SequenceTypeCodeReader;
import org.jacorb.orb.typecode.SimpleTypeCodeReader;
import org.jacorb.orb.typecode.StructTypeCodeReader;
import org.jacorb.orb.typecode.TypeCodeReader;
import org.jacorb.orb.typecode.UnionTypeCodeReader;
import org.jacorb.orb.typecode.ValueBoxTypeCodeReader;
import org.jacorb.orb.typecode.ValueTypeCodeReader;
import org.jacorb.util.Debug;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.TypeCode;

public class DelegatingTypeCodeReader {
    private final Map readerMap = new HashMap();

    public DelegatingTypeCodeReader() {
        this.readerMap.put(new Integer(-1), new IndirectionTypeCodeReader());
        PrimitiveTypeCodeReader primitiveReader = new PrimitiveTypeCodeReader();
        for (int x = 0; x < 14; ++x) {
            this.readerMap.put(new Integer(x), primitiveReader);
        }
        this.readerMap.put(new Integer(23), primitiveReader);
        this.readerMap.put(new Integer(24), primitiveReader);
        this.readerMap.put(new Integer(26), primitiveReader);
        this.readerMap.put(new Integer(14), new ObjectReferenceTypeCodeReader());
        this.readerMap.put(new Integer(15), new StructTypeCodeReader());
        this.readerMap.put(new Integer(16), new UnionTypeCodeReader());
        this.readerMap.put(new Integer(17), new EnumTypeCodeReader());
        this.readerMap.put(new Integer(21), new AliasTypeCodeReader());
        this.readerMap.put(new Integer(22), new ExceptTypeCodeReader());
        this.readerMap.put(new Integer(29), new ValueTypeCodeReader());
        this.readerMap.put(new Integer(30), new ValueBoxTypeCodeReader());
        this.readerMap.put(new Integer(32), new AbstractInterfaceTypeCodeReader());
        SimpleTypeCodeReader simpleReader = new SimpleTypeCodeReader();
        this.readerMap.put(new Integer(18), simpleReader);
        this.readerMap.put(new Integer(27), simpleReader);
        this.readerMap.put(new Integer(28), simpleReader);
        SequenceTypeCodeReader sequenceReader = new SequenceTypeCodeReader();
        this.readerMap.put(new Integer(19), sequenceReader);
        this.readerMap.put(new Integer(20), sequenceReader);
    }

    public TypeCode readTypeCode(CDRInputStream in, Map recursiveTCMap, Map repeatedTCMap) {
        in.mark(0);
        int kind = in.read_long();
        int start_pos = in.get_pos() - 4;
        try {
            in.reset();
        }
        catch (IOException e) {
            throw new RuntimeException("should not happen");
        }
        if (Debug.isDebugEnabled()) {
            Debug.output(in.getIndentString() + "read TypeCode kind " + kind + " at startposition " + start_pos);
        }
        TypeCode result = this.doReadTypeCode(in, recursiveTCMap, repeatedTCMap, kind);
        if (Debug.isDebugEnabled()) {
            Debug.output(in.getIndentString() + "return " + result + " (" + result.getClass().getName() + "@" + System.identityHashCode(result) + ")");
        }
        return result;
    }

    private TypeCode doReadTypeCode(CDRInputStream in, Map recursiveTCMap, Map repeatedTCMap, int kind) {
        TypeCodeReader delegate = (TypeCodeReader)this.readerMap.get(new Integer(kind));
        if (delegate == null) {
            throw new MARSHAL("cannot handle TypeCode with kind=" + kind);
        }
        return delegate.readTypeCode(in, recursiveTCMap, repeatedTCMap);
    }
}

