/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.util;

import java.util.ArrayList;
import java.util.List;
import org.jacorb.orb.Delegate;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.util.IdUtil;
import org.jacorb.util.Debug;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicy;
import org.omg.PortableServer.ThreadPolicyValue;

public final class POAUtil {
    private static final int bytesPerLine = 20;

    private POAUtil() {
    }

    public static String convert(byte[] data) {
        StringBuffer result = new StringBuffer();
        result.append('\n');
        int k = 0;
        for (int j = 0; j < data.length; ++j) {
            boolean lastLine;
            result.append(Debug.toHex(data[j]));
            boolean bl = lastLine = j >= data.length - 1;
            if (lastLine) {
                for (int p = 0; p < 20 - j % 20 - 1; ++p) {
                    result.append("   ");
                }
            }
            if (j % 20 != 19 && !lastLine) continue;
            while (k <= j) {
                result.append(data[k] < 32 ? (char)'.' : (char)data[k]);
                ++k;
            }
            result.append('\n');
        }
        return result.toString();
    }

    public static String convert(Policy policy, int policy_type) {
        switch (policy_type) {
            case 16: {
                if (policy == null || ((ThreadPolicy)policy).value() == ThreadPolicyValue.ORB_CTRL_MODEL) {
                    return "ORB_CTRL_MODEL";
                }
                if (((ThreadPolicy)policy).value() != ThreadPolicyValue.SINGLE_THREAD_MODEL) break;
                return "SINGLE_THREAD_MODEL";
            }
            case 17: {
                if (policy == null || ((LifespanPolicy)policy).value() == LifespanPolicyValue.TRANSIENT) {
                    return "TRANSIENT";
                }
                if (((LifespanPolicy)policy).value() != LifespanPolicyValue.PERSISTENT) break;
                return "PERSISTENT";
            }
            case 18: {
                if (policy == null || ((IdUniquenessPolicy)policy).value() == IdUniquenessPolicyValue.UNIQUE_ID) {
                    return "UNIQUE_ID";
                }
                if (((IdUniquenessPolicy)policy).value() != IdUniquenessPolicyValue.MULTIPLE_ID) break;
                return "MULTIPLE_ID";
            }
            case 19: {
                if (policy == null || ((IdAssignmentPolicy)policy).value() == IdAssignmentPolicyValue.SYSTEM_ID) {
                    return "SYSTEM_ID";
                }
                if (((IdAssignmentPolicy)policy).value() != IdAssignmentPolicyValue.USER_ID) break;
                return "USER_ID";
            }
            case 21: {
                if (policy == null || ((ServantRetentionPolicy)policy).value() == ServantRetentionPolicyValue.RETAIN) {
                    return "RETAIN";
                }
                if (((ServantRetentionPolicy)policy).value() != ServantRetentionPolicyValue.NON_RETAIN) break;
                return "NON_RETAIN";
            }
            case 22: {
                if (policy == null || ((RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY) {
                    return "USE_ACTIVE_OBJECT_MAP_ONLY";
                }
                if (((RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER) {
                    return "USE_SERVANT_MANAGER";
                }
                if (((RequestProcessingPolicy)policy).value() != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) break;
                return "USE_DEFAULT_SERVANT";
            }
            case 20: {
                if (policy == null || ((ImplicitActivationPolicy)policy).value() == ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION) {
                    return "NO_IMPLICIT_ACTIVATION";
                }
                if (((ImplicitActivationPolicy)policy).value() != ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION) break;
                return "IMPLICIT_ACTIVATION";
            }
        }
        return "unknown";
    }

    public static String convert(State state) {
        if (state.value() == 1) {
            return "active";
        }
        if (state.value() == 0) {
            return "holding";
        }
        if (state.value() == 2) {
            return "discarding";
        }
        if (state.value() == 3) {
            return "inactive";
        }
        return "unknown";
    }

    public static String extractImplName(byte[] object_key) {
        for (int i = 0; i < object_key.length; ++i) {
            if (object_key[i] != 47) continue;
            byte[] result = IdUtil.extract(object_key, 0, i);
            return POAUtil.unmaskStr(new String(result));
        }
        throw new POAInternalError("error extracting impl name from object_key: " + POAUtil.convert(object_key));
    }

    public static byte[] extractOID(byte[] object_key) {
        for (int i = object_key.length - 1; i >= 0; --i) {
            if (object_key[i] != 47) continue;
            byte[] result = IdUtil.extract(object_key, ++i, object_key.length - i);
            return POAUtil.unmaskId(result);
        }
        throw new POAInternalError("error extracting oid from object_key: " + POAUtil.convert(object_key));
    }

    public static byte[] extractOID(Object reference) {
        return ((Delegate)((ObjectImpl)reference)._get_delegate()).getObjectId();
    }

    public static String extractPOAName(byte[] object_key) {
        int i;
        int begin = object_key.length;
        int end = 0;
        for (i = 0; i < object_key.length; ++i) {
            if (object_key[i] != 47) continue;
            begin = i;
            break;
        }
        for (i = object_key.length - 1; i >= 0; --i) {
            if (object_key[i] != 47) continue;
            end = i;
            break;
        }
        if (begin > end) {
            throw new POAInternalError("error extracting poa name from object_key: " + POAUtil.convert(object_key));
        }
        if (begin == end) {
            return "";
        }
        return new String(IdUtil.extract(object_key, ++begin, end - begin));
    }

    public static List extractScopedPOANames(String poa_name) {
        ArrayList<String> scopes = new ArrayList<String>();
        if (poa_name.length() > 0) {
            int current;
            int previous = 0;
            for (current = 0; current < poa_name.length(); ++current) {
                if (poa_name.charAt(current) != '/') continue;
                scopes.add(poa_name.substring(previous, current));
                previous = ++current;
            }
            scopes.add(poa_name.substring(previous, current));
        }
        return scopes;
    }

    public static Policy getPolicy(Policy[] policies, int policy_type) {
        if (policies != null) {
            for (int i = 0; i < policies.length; ++i) {
                if (policies[i].policy_type() != policy_type) continue;
                return policies[i];
            }
        }
        return null;
    }

    public static boolean isActive(State state) {
        return state.value() == 1;
    }

    public static boolean isDiscarding(State state) {
        return state.value() == 2;
    }

    public static boolean isHolding(State state) {
        return state.value() == 0;
    }

    public static boolean isInactive(State state) {
        return state.value() == 3;
    }

    public static byte[] maskId(byte[] id) {
        int altered = id.length;
        for (int i = 0; i < id.length; ++i) {
            if (id[i] == 47) {
                ++altered;
                continue;
            }
            if (id[i] != 38) continue;
            ++altered;
        }
        if (altered == id.length) {
            return id;
        }
        byte[] result = new byte[altered];
        altered = 0;
        for (int i = 0; i < id.length; ++i) {
            if (id[i] == 47) {
                result[altered] = 38;
                result[altered + 1] = 37;
                altered += 2;
                continue;
            }
            if (id[i] == 38) {
                result[altered] = 38;
                result[altered + 1] = 38;
                altered += 2;
                continue;
            }
            result[altered] = id[i];
            ++altered;
        }
        return result;
    }

    public static String maskStr(String str) {
        return new String(POAUtil.maskId(str.getBytes()));
    }

    public static String unmaskStr(String str) {
        return new String(POAUtil.unmaskId(str.getBytes()));
    }

    public static byte[] unmaskId(byte[] id) {
        int altered = id.length;
        for (int i = 0; i < id.length; ++i) {
            if (id[i] != 38) continue;
            --altered;
            ++i;
        }
        if (altered == id.length) {
            return id;
        }
        byte[] result = new byte[altered];
        altered = 0;
        for (int i = 0; i < id.length; ++i) {
            if (id[i] == 38) {
                if (id[i + 1] == 38) {
                    result[altered] = 38;
                } else if (id[i + 1] == 37) {
                    result[altered] = 47;
                } else {
                    throw new POAInternalError("error: forbidden byte sequence \"38" + id[i + 1] + "\" (unmaskId)");
                }
                ++i;
            } else {
                result[altered] = id[i];
            }
            ++altered;
        }
        return result;
    }
}

