/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.level2;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.security.level2.CredentialsImpl;
import org.jacorb.security.level2.KeyAndCert;
import org.jacorb.security.level2.SecAttributeManager;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.Security.AttributeType;
import org.omg.Security.AuthenticationStatus;
import org.omg.Security.ExtensibleFamily;
import org.omg.Security.InvocationCredentialsType;
import org.omg.Security.OpaqueHolder;
import org.omg.Security.SecAttribute;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.CredentialsHolder;
import org.omg.SecurityLevel2.PrincipalAuthenticator;

public class SunJssePrincipalAuthenticatorImpl
extends LocalObject
implements PrincipalAuthenticator {
    private Logger logger = Debug.getNamedLogger("jacorb.security.jsse");

    @Override
    public int[] get_supported_authen_methods(String mechanism) {
        return new int[]{0};
    }

    @Override
    public AuthenticationStatus authenticate(int method, String mechanism, String security_name, byte[] auth_data, SecAttribute[] privileges, CredentialsHolder creds, OpaqueHolder continuation_data, OpaqueHolder auth_specific_data) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("starting authentication");
        }
        try {
            String alias;
            String storePassphrase;
            this.registerProvider();
            String keyStoreLocation = Environment.getProperty("jacorb.security.keystore");
            if (keyStoreLocation == null) {
                System.out.print("Please enter key store file name: ");
                keyStoreLocation = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            if ((storePassphrase = Environment.getProperty("jacorb.security.keystore_password")) == null) {
                System.out.print("Please enter store pass phrase: ");
                storePassphrase = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            if ((alias = security_name) == null) {
                System.out.print("Please enter alias  name: ");
                alias = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            String password = null;
            if (auth_data == null) {
                System.out.print("Please enter password: ");
                password = new BufferedReader(new InputStreamReader(System.in)).readLine();
            } else {
                password = new String(auth_data);
            }
            if (keyStoreLocation == null || storePassphrase == null || alias == null || password == null) {
                return AuthenticationStatus.SecAuthFailure;
            }
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(keyStoreLocation), storePassphrase.toCharArray());
            Certificate[] cert_chain = keyStore.getCertificateChain(alias);
            if (cert_chain == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("No keys found in keystore for alias \"" + alias + "\"!");
                }
                if (Environment.getProperty("jacorb.security.default_user") != null && this.logger.isErrorEnabled()) {
                    this.logger.error("Please check property \"jacorb.security.default_user\"");
                }
                return AuthenticationStatus.SecAuthFailure;
            }
            PrivateKey priv_key = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            KeyAndCert k_a_c = new KeyAndCert(priv_key, cert_chain);
            AttributeType type = new AttributeType(new ExtensibleFamily(0, 1), 2);
            SecAttributeManager attrib_mgr = SecAttributeManager.getInstance();
            SecAttribute attrib = attrib_mgr.createAttribute(k_a_c, type);
            CredentialsImpl credsImpl = new CredentialsImpl(new SecAttribute[]{attrib}, AuthenticationStatus.SecAuthSuccess, InvocationCredentialsType.SecOwnCredentials);
            creds.value = credsImpl;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("authentication succesfull");
            }
            return AuthenticationStatus.SecAuthSuccess;
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception: " + e.getMessage());
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("authentication failed");
            }
            return AuthenticationStatus.SecAuthFailure;
        }
    }

    @Override
    public AuthenticationStatus continue_authentication(byte[] response_data, Credentials creds, OpaqueHolder continuation_data, OpaqueHolder auth_specific_data) {
        throw new NO_IMPLEMENT();
    }

    private void registerProvider() {
    }
}

