/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.KDebug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.util.Properties;

public class DatabaseHeader {
    protected Properties properties;
    private boolean compatible = false;
    protected static final KDebug db = new KDebug("DatabaseHeader");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseHeader(String string) {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new BufferedInputStream(new FileInputStream(string));
            this.compatible = DatabaseHeader.readString(filterInputStream, 4).equals("OTBU");
            if (!this.compatible) {
                if (db.on()) {
                    db.println("db header doesn't contain OTBU");
                }
                return;
            }
            if (!DatabaseHeader.readString(filterInputStream, 2).equals("01")) {
                this.compatible = false;
                if (db.on()) {
                    db.println("db version isn't equal to 01");
                }
                return;
            }
            String string2 = DatabaseHeader.readString(filterInputStream, 6);
            string2 = DatabaseHeader.readString(filterInputStream, Integer.parseInt(string2));
            if (db.on()) {
                db.println("properties=" + string2);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
            this.properties = new Properties();
            this.properties.load(byteArrayInputStream);
        }
        catch (Exception exception) {
            this.compatible = false;
            if (DatabaseHeader.db.on) {
                KDebug.printStackTrace(exception);
            }
        }
        finally {
            block25: {
                if (filterInputStream != null) {
                    try {
                        filterInputStream.close();
                    }
                    catch (Exception exception) {
                        if (!DatabaseHeader.db.on) break block25;
                        KDebug.printStackTrace(exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileWithHeader(String string) {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new BufferedInputStream(new FileInputStream(string));
            boolean bl = DatabaseHeader.readString(filterInputStream, 4).equals("OTBU");
            return bl;
        }
        catch (Exception exception) {
            if (DatabaseHeader.db.on) {
                KDebug.printStackTrace(exception);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            block13: {
                if (filterInputStream != null) {
                    try {
                        filterInputStream.close();
                    }
                    catch (Exception exception) {
                        if (!DatabaseHeader.db.on) break block13;
                        KDebug.printStackTrace(exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stripHeader(String string) throws Exception {
        String string2;
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            File file = File.createTempFile("ctc", null);
            string2 = file.getCanonicalPath();
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            if (!DatabaseHeader.readString(bufferedInputStream, 4).equals("OTBU")) {
                throw new Exception("The database format is invalid.");
            }
            if (!DatabaseHeader.readString(bufferedInputStream, 2).equals("01")) {
                throw new Exception("The database format is invalid.");
            }
            String string3 = DatabaseHeader.readString(bufferedInputStream, 6);
            bufferedInputStream.skip(Integer.parseInt(string3));
            while ((n = bufferedInputStream.read()) >= 0) {
                ((BufferedOutputStream)filterOutputStream).write(n);
            }
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
        return string2;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public String getNeType() {
        return this.getProperty("Info.NeType");
    }

    public boolean isNeTypeCompatible(String string) {
        String string2 = this.getNeType();
        return string2 != null ? string2.equals(string) : false;
    }

    public boolean isSwVersionCompatible(String string) {
        if (string.length() != 5 || string.charAt(2) != '.') {
            return false;
        }
        String string2 = this.getProperty("Ne.Software-Version");
        if (string2 != null) {
            String string3 = string2.substring(0, 5);
            return string3.substring(0, 4).equals(string.substring(0, 4)) ? true : string.compareTo(string3) >= 0;
        }
        return false;
    }

    public boolean isSecureDB() {
        String string = this.getProperty("Ne.Secure-Mode");
        return string != null && (string.equals("Y") || string.equals("L"));
    }

    public boolean isSecureLockedDB() {
        String string = this.getProperty("Ne.Secure-Mode");
        return string != null && string.equals("L");
    }

    public boolean isSameSwVersion(String string) {
        int n = string.length();
        int n2 = n >= 5 ? 5 : n - 1;
        String string2 = this.getProperty("Ne.Software-Version");
        return string2 != null ? string.equals(string2.substring(0, n2)) : false;
    }

    public boolean isSameNodeName(String string) {
        String string2 = this.getProperty("Ne.Node-Name");
        return string2 != null ? string2.equals(string) : false;
    }

    public String getProperty(String string) {
        if (db.on()) {
            db.println("getProperty: Property=" + string + " Value=" + this.properties.getProperty(string));
        }
        return this.properties.getProperty(string);
    }

    private static String readString(FilterInputStream filterInputStream, int n) throws Exception {
        byte[] byArray = new byte[n];
        if (filterInputStream.read(byArray, 0, n) > 0) {
            return new String(byArray);
        }
        throw new Exception("The database header is invalid.");
    }
}

