/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.DebugManager;
import cerent.util.Preferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class DebugWindow
extends JFrame
implements ActionListener,
WindowListener,
MouseListener {
    private PrintStream writer;
    private DebugManager dbm;
    private JTextArea area = new JTextArea(20, 80);
    private JComboBox input = new JComboBox();
    private JCheckBox addDiagCB = new JCheckBox("Add Diagnostic Dump");
    private JCheckBox addExceptCB = new JCheckBox("Add Exceptions Dump");
    private ComboBoxEditor editor = this.input.getEditor();
    private JButton clearButton = new JButton("Clear");
    private JButton saveButton = new JButton("Save...");
    private ScrollerWriter sw = new ScrollerWriter();
    private ScrollerDispatcher scrollerd = new ScrollerDispatcher();
    private int hiWater;
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem itemBufferSize = new JMenuItem("");
    private JMenuItem itemMore = new JMenuItem("Double buffer size");
    private JMenuItem itemLess = new JMenuItem("Half buffer size");
    private JCheckBoxMenuItem itemBootDB;
    private JCheckBoxMenuItem itemScroll = new JCheckBoxMenuItem("Auto Scroll", true);
    private static String debugWindowName = "CTC Debug Window";
    private static final String BOOT_DEBUG_NAME = "boot.debug.name";
    private static DebugWindow _instance;
    private static final String PREF_CTC = "ctc.dbgwin";
    private static final String PREF_PATH = "ctc";
    private static final String PREF_BOOT_DEBUG = "boot.debug";
    private static final String PREF_X = "x";
    private static final int DEFAULT_X = 20;
    private static final String PREF_Y = "y";
    private static final int DEFAULT_Y = 20;
    private static final String PREF_W = "w";
    private static final int DEFAULT_W = 640;
    private static final String PREF_H = "h";
    private static final int DEFAULT_H = 425;
    private static final String PREF_HIWATER = "hiwater";
    private static final int DEFAULT_HIWATER = 32000;
    private static final int MIN_HIWATER = 1000;
    private static final int SCROLL_TIMER = 500;

    private DebugWindow(String string) {
        super(string);
        this.dbm = DebugManager.instance();
        this.writer = new PrintStream(new DbgOutputStream());
        this.dbm.addPrintStream(this.writer);
        Container container = this.getContentPane();
        JScrollPane jScrollPane = new JScrollPane(this.area);
        jScrollPane.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        container.setLayout(new BorderLayout());
        container.add(jScrollPane);
        container.add((Component)this.input, "North");
        this.area.setEditable(false);
        this.input.setEditable(true);
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Save Options: "));
        box.add(this.addDiagCB);
        box.add(this.addExceptCB);
        box.add(Box.createHorizontalGlue());
        box.add(this.saveButton);
        box.add(Box.createVerticalStrut(40));
        box.add(this.clearButton);
        box.add(Box.createHorizontalGlue());
        container.add((Component)box, "South");
        this.clearButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.area.setFont(new Font("Monospaced", 0, 12));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        this.editor.addActionListener(this);
        this.area.setBackground(new Color(240, 240, 255));
        Preferences preferences = Preferences.instance();
        this.setBufferSize(preferences.getInt(PREF_CTC, PREF_HIWATER, 32000));
        boolean bl = preferences.getBoolean(PREF_PATH, PREF_BOOT_DEBUG, false);
        this.itemBootDB = new JCheckBoxMenuItem("Boot Debug", bl);
        this.addMenuItem(this.itemBufferSize);
        this.popup.addSeparator();
        this.addMenuItem(this.itemScroll);
        this.addMenuItem(this.itemMore);
        this.addMenuItem(this.itemLess);
        this.popup.addSeparator();
        this.addMenuItem(this.itemBootDB);
        this.initComboCommand();
        this.area.addMouseListener(this);
        this.scrollerd.start();
    }

    private void initComboCommand() {
        LinkedList linkedList = this.dbm.loadHistory();
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            this.input.insertItemAt(string, 0);
        }
    }

    private void addMenuItem(JMenuItem jMenuItem) {
        this.popup.add(jMenuItem);
        jMenuItem.addActionListener(this);
    }

    public static synchronized DebugWindow instance() {
        if (_instance == null) {
            if (Preferences.instance().propertyExist(PREF_PATH, BOOT_DEBUG_NAME)) {
                debugWindowName = debugWindowName.concat(" : " + Preferences.instance().getProperty(PREF_PATH, BOOT_DEBUG_NAME, ""));
            }
            _instance = new DebugWindow(debugWindowName);
        }
        return _instance;
    }

    private void output(String string) {
        this.sw.output(string);
    }

    private void output(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        this.output(stringBuffer.toString());
    }

    private void output(byte[] byArray, int n, int n2) {
        this.output(new String(byArray, n, n2));
    }

    @Override
    public synchronized void dispose() {
        this.dbm.removePrintStream(this.writer);
        this.scrollerd.dispose();
        super.dispose();
        _instance = null;
    }

    public static void main(String[] stringArray) {
        DebugWindow debugWindow = DebugWindow.instance();
        debugWindow.display();
    }

    private void setBufferSize(int n) {
        if (n < 1000) {
            n = 1000;
        }
        this.hiWater = n;
        this.itemBufferSize.setText("Max Buffer Size=" + this.hiWater + " lines");
    }

    public void display() {
        this.pack();
        try {
            Preferences preferences = Preferences.instance();
            int n = preferences.getInt(PREF_CTC, PREF_X, 20);
            int n2 = preferences.getInt(PREF_CTC, PREF_Y, 20);
            int n3 = preferences.getInt(PREF_CTC, PREF_W, 640);
            int n4 = preferences.getInt(PREF_CTC, PREF_H, 425);
            Dimension dimension = this.getSize();
            if (n3 == 0) {
                n3 = dimension.width;
            }
            if (n4 == 0) {
                n4 = dimension.height;
            }
            this.setBounds(n, n2, n3, n4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.editor.getEditorComponent()) {
            String string = (String)this.editor.getItem();
            this.editor.setItem("");
            String string2 = (String)this.input.getItemAt(0);
            if (string2 == null || !string2.equals(string)) {
                this.input.insertItemAt(string, 0);
                this.input.setSelectedIndex(0);
            }
            this.output(string + "\n");
            this.dbm.exec(string);
        } else if (object == this.clearButton) {
            JTextArea jTextArea = this.area;
            synchronized (jTextArea) {
                this.area.setText("");
            }
        } else if (object == this.saveButton) {
            this.save();
        } else if (object == this.itemMore) {
            this.setBufferSize(this.hiWater * 2);
        } else if (object == this.itemLess) {
            this.setBufferSize(this.hiWater / 2);
        } else if (object == this.itemBootDB) {
            Preferences.instance().setBoolean(PREF_PATH, PREF_BOOT_DEBUG, this.itemBootDB.isSelected());
        }
        this.input.requestFocus();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.input.requestFocus();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        Preferences preferences = Preferences.instance();
        Rectangle rectangle = this.getBounds();
        preferences.setInt(PREF_CTC, PREF_X, rectangle.x);
        preferences.setInt(PREF_CTC, PREF_Y, rectangle.y);
        preferences.setInt(PREF_CTC, PREF_W, rectangle.width);
        preferences.setInt(PREF_CTC, PREF_H, rectangle.height);
        preferences.setInt(PREF_CTC, PREF_HIWATER, this.hiWater);
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.input.requestFocus();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public PrintStream getWriter() {
        return this.writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        Object object;
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        String string = jFileChooser.getSelectedFile().getAbsolutePath();
        try {
            JDialog jDialog;
            Container container = jFileChooser.getTopLevelAncestor();
            if (container instanceof JDialog && (jDialog = (JDialog)container) != null) {
                jDialog.getContentPane().removeAll();
                jDialog.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = 2;
        if (file.exists()) {
            object = new Object[]{"Overwrite", "Append", "Cancel"};
            n2 = JOptionPane.showOptionDialog(this, "File " + string + " already exists.\n" + "Do you want to replace it?", "Saving Debug Log", -1, 3, null, (Object[])object, object[2]);
            if (n2 == 2) {
                return;
            }
        }
        object = null;
        try {
            object = n2 == 1 ? new PrintStream(new FileOutputStream(string, true)) : new PrintStream(new FileOutputStream(string, false));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            long l = System.currentTimeMillis();
            String string2 = simpleDateFormat.format(new Date(l));
            ((PrintStream)object).println("######################################");
            ((PrintStream)object).println("#   " + string2 + "              #");
            ((PrintStream)object).println("######################################");
            this.dbm.removePrintStream(this.writer);
            this.dbm.addPrintStream((PrintStream)object, false);
            if (this.addDiagCB.isSelected()) {
                this.dbm.getRoot().dumpVitalMessages();
                this.dbm.getRoot().dumpDiag();
            }
            if (this.addExceptCB.isSelected()) {
                boolean bl = this.dbm.getExcToSysOut();
                if (bl) {
                    this.dbm.setExcToSysOut(false);
                }
                this.dbm.getRoot().dumpExceptions();
                this.dbm.setExcToSysOut(bl);
            }
            JTextArea jTextArea = this.area;
            synchronized (jTextArea) {
                ((PrintStream)object).println(this.area.getText());
            }
            ((PrintStream)object).flush();
            this.dbm.removePrintStream((PrintStream)object);
            this.dbm.addPrintStream(this.writer, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Unable to save to " + string + "\n" + fileNotFoundException.getMessage(), "Error Saving", 0);
            DebugManager.printStackTrace(fileNotFoundException);
        }
        finally {
            if (object != null) {
                ((PrintStream)object).close();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.displayPopup(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.displayPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.displayPopup(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void displayPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popup.show(this.area, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class DbgOutputStream
    extends OutputStream {
        DbgOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            DebugWindow.this.output((char)n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            DebugWindow.this.output(byArray, n, n2);
        }
    }

    class ScrollerDispatcher
    extends Thread {
        private boolean disposed;

        ScrollerDispatcher() {
            super("DebugWindow-Scroller");
            this.disposed = false;
        }

        @Override
        public void run() {
            while (!this.disposed) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                DebugWindow.this.sw.forceScroll();
            }
        }

        void dispose() {
            this.disposed = true;
        }
    }

    class ScrollerWriter
    implements Runnable {
        private Rectangle visible = new Rectangle(1, 1);
        private boolean invokeLaterQueued = false;
        private boolean scrollRequest = false;

        ScrollerWriter() {
        }

        void forceScroll() {
            if (this.scrollRequest) {
                if (!this.invokeLaterQueued) {
                    this.invokeLaterQueued = true;
                    SwingUtilities.invokeLater(this);
                }
                this.scrollRequest = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void output(String string) {
            JTextArea jTextArea = DebugWindow.this.area;
            synchronized (jTextArea) {
                DebugWindow.this.area.append(string);
            }
            this.scrollRequest = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JTextArea jTextArea = DebugWindow.this.area;
            synchronized (jTextArea) {
                if (DebugWindow.this.area.getLineCount() > DebugWindow.this.hiWater) {
                    try {
                        int n = DebugWindow.this.area.getLineEndOffset(DebugWindow.this.hiWater / 2);
                        DebugWindow.this.area.replaceRange("--- cut ---\n", 0, n);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                if (DebugWindow.this.itemScroll.isSelected()) {
                    this.visible.setLocation(0, DebugWindow.this.area.getHeight() - 1);
                    DebugWindow.this.area.scrollRectToVisible(this.visible);
                }
            }
            this.invokeLaterQueued = false;
        }
    }
}

