/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.EID;
import cerent.util.IPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.MsgMgr;
import cerent.util.WID;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class KErrorMsg {
    private static final boolean headless = Boolean.getBoolean("java.awt.headless");
    private static final String FATAL_ICON_STR = "/images/icons/fatal_error32.gif";
    private static final String WARNING_ICON_STR = "/images/icons/warning32.gif";
    protected static final KDebug db = new KDebug("ErrorMsg");
    public static ImageIcon FATAL_ICON;
    public static ImageIcon WARNING_ICON;

    protected KErrorMsg() {
    }

    public static String getString(EID eID) {
        return eID.getComposedMessage();
    }

    public static String getString(EID eID, Object object) {
        Object[] objectArray = new Object[]{object};
        return KErrorMsg.getString(eID, objectArray);
    }

    public static String getString(EID eID, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return KErrorMsg.getString(eID, objectArray);
    }

    public static String getString(EID eID, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return KErrorMsg.getString(eID, objectArray);
    }

    public static String getString(EID eID, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return KErrorMsg.getString(eID, objectArray);
    }

    public static String getString(EID eID, Object[] objectArray) {
        return KErrorMsg.buildMsg(eID, objectArray);
    }

    public static void displayError(Component component, EID eID) {
        KErrorMsg.displayError(component, eID, true);
    }

    public static void displayError(Component component, EID eID, boolean bl) {
        String string = eID.getComposedMessage();
        KErrorMsg.showErrorMsg(component, string, bl);
    }

    public static void displayError(Component component, EID eID, Object object) {
        KErrorMsg.displayError(component, eID, object, true);
    }

    public static void displayError(Component component, EID eID, Object object, boolean bl) {
        Object[] objectArray = new Object[]{object};
        KErrorMsg.displayError(component, eID, objectArray, bl);
    }

    public static void displayError(Component component, EID eID, Object[] objectArray) {
        KErrorMsg.displayError(component, eID, objectArray, true);
    }

    public static void displayError(Component component, EID eID, Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            String string = KErrorMsg.buildMsg(eID, objectArray);
            KErrorMsg.showErrorMsg(component, string, bl);
        } else {
            KErrorMsg.displayError(component, eID, bl);
        }
    }

    public static void displayWarning(Component component, WID wID) {
        String string = wID.getComposedMessage();
        KErrorMsg.showWarningMsg(component, string);
    }

    public static void displayWarning(Component component, WID wID, Object object) {
        Object[] objectArray = new Object[]{object};
        KErrorMsg.displayWarning(component, wID, objectArray);
    }

    public static void displayWarning(Component component, WID wID, Object[] objectArray) {
        if (objectArray != null) {
            String string = KErrorMsg.buildMsg(wID, objectArray);
            KErrorMsg.showWarningMsg(component, string);
        } else {
            KErrorMsg.displayWarning(component, wID);
        }
    }

    private static void showErrorMsg(Component component, String string, boolean bl) {
        KErrorMsg.showMsg(component, string, true, bl);
    }

    private static void showErrorMsg(Component component, String string) {
        KErrorMsg.showMsg(component, string, true, true);
    }

    private static void showWarningMsg(Component component, String string) {
        KErrorMsg.showMsg(component, string, false, true);
    }

    private static void showMsg(final Component component, final String string, final boolean bl, final boolean bl2) {
        if (string == null || headless) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            KErrorMsg.showMessageDialog(component, string, bl, bl2);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        KErrorMsg.showMessageDialog(component, string, bl, bl2);
                    }
                });
            }
            catch (Exception exception) {
                KDebug.printStackTrace(exception);
            }
        }
    }

    private static void showMessageDialog(Component component, String string, boolean bl, boolean bl2) {
        String string2;
        String string3;
        int n;
        ImageIcon imageIcon;
        if (bl) {
            if (FATAL_ICON == null) {
                FATAL_ICON = new ImageIcon(KErrorMsg.class.getResource(FATAL_ICON_STR));
            }
            imageIcon = FATAL_ICON;
            n = 0;
            string3 = "Error";
        } else {
            if (WARNING_ICON == null) {
                WARNING_ICON = new ImageIcon(KErrorMsg.class.getResource(WARNING_ICON_STR));
            }
            imageIcon = WARNING_ICON;
            n = 2;
            string3 = "Warning";
        }
        int n2 = 0;
        int n3 = 0;
        String string4 = string2 = bl2 ? IPAddressTranslator.instance().translateIPsVirtualToActual(string) : string;
        while ((n2 = string2.indexOf(10, n2)) != -1) {
            ++n2;
            ++n3;
        }
        if (n3 > 10 || n3 == 0 && string2.length() >= 80) {
            JTextArea jTextArea = new JTextArea(string2);
            jTextArea.setEditable(false);
            jTextArea.setText(string2);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setPreferredSize(new Dimension(200, 150));
            JOptionPane.showMessageDialog(component, jScrollPane, string3, n, imageIcon);
        } else {
            JOptionPane.showMessageDialog(component, string2, string3, n, imageIcon);
        }
    }

    protected static String buildMsg(EID eID, Object[] objectArray) {
        String string = eID.getComposedMessage();
        return KErrorMsg.buildMsg(string, objectArray);
    }

    public static String buildMsg(String string, Object[] objectArray) {
        if (string == null) {
            return null;
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(MsgMgr.currentLocale);
        messageFormat.applyPattern(string);
        return messageFormat.format(objectArray);
    }
}

