/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.orb;

import cerent.util.KDebug;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedProfile;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;

public class SecurityTicketInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static Map clients = Collections.synchronizedMap(new HashMap());
    private static SecurityTicketInterceptor _instance = null;
    private KDebug db = new KDebug("SecurityTicketInterceptor");
    private ORB orb;

    public static boolean addServiceContext(int n, byte[] byArray, Object object) {
        clients.put(object, new ServiceContext(n, byArray));
        return true;
    }

    public static boolean removeServiceContext(int n, byte[] byArray, Object object) {
        if (clients.containsKey(object)) {
            clients.remove(object);
            return true;
        }
        return false;
    }

    public static SecurityTicketInterceptor instance() {
        if (_instance == null) {
            _instance = new SecurityTicketInterceptor();
        }
        return _instance;
    }

    private SecurityTicketInterceptor() {
    }

    public void init(ORB oRB) {
        this.orb = oRB;
    }

    private String getHost(byte[] byArray) {
        OutputStream outputStream = this.orb.create_output_stream();
        outputStream.write_octet_array(byArray, 0, byArray.length);
        InputStream inputStream = outputStream.create_input_stream();
        ProfileBody_1_0 profileBody_1_0 = ProfileBody_1_0Helper.read((InputStream)inputStream);
        return profileBody_1_0.host;
    }

    private String contextDataToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0xFF & byArray[i];
            if (n < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n));
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        TaggedProfile taggedProfile = clientRequestInfo.effective_profile();
        if (taggedProfile.tag == 0) {
            String string = this.getHost(taggedProfile.profile_data);
            if (string != null) {
                ServiceContext serviceContext = (ServiceContext)clients.get(string);
                if (serviceContext != null) {
                    try {
                        clientRequestInfo.add_request_service_context(serviceContext, false);
                    }
                    catch (BAD_INV_ORDER bAD_INV_ORDER) {
                        ServiceContext serviceContext2 = clientRequestInfo.get_request_service_context(serviceContext.context_id);
                        if (!Arrays.equals(serviceContext2.context_data, serviceContext.context_data)) {
                            if (this.db.isSevereEnabled()) {
                                this.db.severe("Security ticket service context exists and has a different security ticket.");
                                this.db.severe("context.context_data = " + this.contextDataToString(serviceContext.context_data));
                                this.db.severe("context.context_data = " + this.contextDataToString(serviceContext2.context_data));
                                KDebug.printStackTrace(bAD_INV_ORDER);
                                clientRequestInfo.add_request_service_context(serviceContext, true);
                            }
                        } else if (this.db.isSevereEnabled()) {
                            this.db.severe("Security ticket has already been added");
                            KDebug.printStackTrace(bAD_INV_ORDER);
                        }
                    }
                } else if (this.db.on()) {
                    this.db.println("send_reqeust: null service context");
                }
            } else if (this.db.on()) {
                this.db.println("send_request: null host");
            }
        } else if (this.db.on()) {
            this.db.println("send_request: profile not TAG_INTERNET_IOP");
        }
        if (this.db.on()) {
            this.db.println("<<send_request>>");
            if (clientRequestInfo.target() instanceof ObjectImpl) {
                this.db.println("    target = " + ((ObjectImpl)clientRequestInfo.target())._ids()[0]);
            } else {
                this.db.println("    local target = " + clientRequestInfo.target().toString());
            }
            this.db.println("    operation = " + clientRequestInfo.operation());
        }
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
        if (this.db.on()) {
            this.db.println("<<send_request>>");
            if (clientRequestInfo.target() instanceof ObjectImpl) {
                this.db.println("    target = " + ((ObjectImpl)clientRequestInfo.target())._ids()[0]);
            } else {
                this.db.println("    local target = " + clientRequestInfo.target().toString());
            }
            this.db.println("    operation = " + clientRequestInfo.operation());
        }
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
        if (this.db.on()) {
            this.db.println("<<receive_reply>>");
            if (clientRequestInfo.target() instanceof ObjectImpl) {
                this.db.println("    target = " + ((ObjectImpl)clientRequestInfo.target())._ids()[0]);
            } else {
                this.db.println("    local target = " + clientRequestInfo.target().toString());
            }
            this.db.println("    operation = " + clientRequestInfo.operation());
        }
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (this.db.on()) {
            this.db.println("<<receive_exception>>");
            if (clientRequestInfo.target() instanceof ObjectImpl) {
                this.db.println("    target = " + ((ObjectImpl)clientRequestInfo.target())._ids()[0]);
            } else {
                this.db.println("    local target = " + clientRequestInfo.target().toString());
            }
            this.db.println("    operation = " + clientRequestInfo.operation());
        }
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (this.db.on()) {
            this.db.println("<<receive_other>>");
            if (clientRequestInfo.target() instanceof ObjectImpl) {
                this.db.println("    target = " + ((ObjectImpl)clientRequestInfo.target())._ids()[0]);
            } else {
                this.db.println("    local target = " + clientRequestInfo.target().toString());
            }
            this.db.println("    operation = " + clientRequestInfo.operation());
        }
    }

    public String name() {
        return "SecurityTicketInterceptor";
    }

    public void destroy() {
    }
}

