/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.CtcSslFactory;
import cerent.util.IIPAddressTranslator;
import cerent.util.IPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.proxy.CtcBinding;
import cerent.util.proxy.CtcProxy;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.Sckfwd;
import cerent.util.proxy.SckfwdClient;
import cerent.util.proxy.SckfwdIo;
import cerent.util.proxy.SckfwdRequestReply;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class CtcServerProxy {
    private static final KDebug _debug = new KDebug(CtcProxyFactory.getDebug(), "CtcServerProxy");
    private InetAddress _targetHost;
    private int _targetPort;
    private ServerSocket _socket;
    private boolean _expired;
    private HashMap<InetAddress, CtcBinding> _bindings;
    private ArrayList _queue;
    private Thread _acceptor;
    private boolean _secure;

    public CtcServerProxy(InetAddress inetAddress, int n, boolean bl) throws IOException, UnknownHostException {
        this._targetHost = inetAddress;
        this._secure = bl;
        this._socket = new ServerSocket(n, 50, InetAddress.getByName("0.0.0.0"));
        this._targetPort = this._socket.getLocalPort();
        this._expired = false;
        this._bindings = new HashMap();
        this._queue = new ArrayList();
        this._acceptor = new Thread((Runnable)new AcceptorV3(), "AcceptorV3:" + this);
        this._acceptor.start();
    }

    public CtcProxy accept(InetAddress inetAddress) throws IOException {
        CtcProxy ctcProxy;
        SckfwdClient sckfwdClient = CtcProxyFactory.proxyFor(inetAddress);
        if (sckfwdClient == null) {
            block6: {
                try {
                    Sckfwd sckfwd = CtcProxyFactory.getServer(inetAddress);
                    ctcProxy = new CtcProxy(inetAddress, this._targetHost, this._targetPort, null, sckfwd, sckfwd.getLocalHost(), this._targetPort);
                    if (_debug.on()) {
                        _debug.println("direct accept NAT(ok): " + ctcProxy);
                    }
                }
                catch (IOException iOException) {
                    ctcProxy = new CtcProxy(inetAddress, this._targetHost, this._targetPort, null, null, CtcProxyFactory.bindAddress(this._targetHost), this._targetPort);
                    if (!_debug.on()) break block6;
                    _debug.println("direct accept NAT(not-ok): " + ctcProxy);
                }
            }
            CtcProxyFactory.addProxy(ctcProxy);
        } else {
            ctcProxy = this.accept(sckfwdClient.getServer().getHost(), inetAddress);
        }
        if (this._secure) {
            ctcProxy.setSecure(true);
        }
        return ctcProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CtcProxy accept(InetAddress inetAddress, InetAddress inetAddress2) throws IOException {
        HashMap<InetAddress, CtcBinding> hashMap = this._bindings;
        synchronized (hashMap) {
            CtcProxy ctcProxy;
            CtcBinding ctcBinding = this._bindings.get(inetAddress);
            if (ctcBinding == null) {
                ctcBinding = new CtcBinding(inetAddress);
                this._bindings.put(inetAddress, ctcBinding);
            }
            if ((ctcProxy = ctcBinding.get(inetAddress2)) != null && ctcProxy.expired()) {
                ctcBinding.remove(inetAddress2);
                ctcProxy = null;
            }
            if (ctcProxy == null) {
                Object object2;
                Sckfwd sckfwd = CtcProxyFactory.getServer(inetAddress);
                if (sckfwd.proxiesReusable()) {
                    object2 = ctcBinding.any();
                    if (object2 == null) {
                        SckfwdRequestReply object3 = sckfwd.bind(this._targetHost, this._targetPort);
                        ctcProxy = new CtcProxy(inetAddress2, this._targetHost, this._targetPort, null, sckfwd, object3.getHost(), object3.getPort());
                        if (_debug.on()) {
                            _debug.println("proxy accept new binding: " + ctcProxy);
                        }
                    } else {
                        ctcProxy = new CtcProxy(inetAddress2, this._targetHost, this._targetPort, (CtcProxy)object2);
                        if (_debug.on()) {
                            _debug.println("proxy accept old binding: " + ctcProxy);
                        }
                    }
                } else {
                    object2 = sckfwd.createIo();
                    ((SckfwdIo)object2).writeBind(sckfwd.getLocalHost(), this._targetPort);
                    SckfwdRequestReply sckfwdRequestReply = new SckfwdRequestReply((SckfwdIo)object2);
                    ctcProxy = new CtcProxy(inetAddress2, this._targetHost, this._targetPort, (SckfwdIo)object2, sckfwd, sckfwdRequestReply.getHost(), sckfwdRequestReply.getPort());
                    new Thread((Runnable)new AcceptorV5(ctcProxy), "AcceptorV5:" + ctcProxy).start();
                    if (_debug.on()) {
                        _debug.println("proxy accept binding: " + ctcProxy);
                    }
                }
                for (CtcBinding ctcBinding2 : this._bindings.values()) {
                    ctcBinding2.remove(inetAddress2);
                }
                ctcBinding.put(inetAddress2, ctcProxy);
                CtcProxyFactory.addProxy(ctcProxy);
            }
            if (this._secure) {
                ctcProxy.setSecure(true);
            }
            return ctcProxy;
        }
    }

    int removeAssociatedServerProxyBindings(CtcProxy ctcProxy) throws UnknownHostException {
        if (!ctcProxy.isSelfProxying()) {
            return 0;
        }
        String string = ctcProxy.getHost();
        IIPAddressTranslator iIPAddressTranslator = IPAddressTranslator.instance();
        IPAddressTranslator.instance();
        InetAddress inetAddress = iIPAddressTranslator.getVirtualAddress(string, 0);
        return this.removeAssociatedServerProxyBindings(string, inetAddress);
    }

    int removeAssociatedServerProxyBindings(Sckfwd sckfwd) throws UnknownHostException {
        InetAddress inetAddress = sckfwd.getHost();
        String string = inetAddress.getHostAddress();
        InetAddress inetAddress2 = IPAddressTranslator.instance().getActualAddress(string);
        String string2 = inetAddress2 == null ? string : inetAddress2.getHostAddress();
        return this.removeAssociatedServerProxyBindings(string2, inetAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeAssociatedServerProxyBindings(String string, InetAddress inetAddress) throws UnknownHostException {
        int n = 0;
        String string2 = inetAddress.getHostAddress();
        HashMap<InetAddress, CtcBinding> hashMap = this._bindings;
        synchronized (hashMap) {
            CtcBinding ctcBinding = this._bindings.get(inetAddress);
            if (_debug.on()) {
                _debug.println("considering server proxy binding removal for binding: " + ctcBinding);
            }
            if (ctcBinding != null) {
                Iterator<InetAddress> iterator = this._bindings.keySet().iterator();
                while (iterator.hasNext()) {
                    InetAddress inetAddress2 = iterator.next();
                    CtcProxy ctcProxy = ctcBinding.get(inetAddress2);
                    if (ctcProxy == null) continue;
                    InetAddress inetAddress3 = ctcProxy.getBindHost();
                    if (!string.equals(ctcProxy.getHost()) && (inetAddress3 == null || !inetAddress.equals(inetAddress3))) continue;
                    ++n;
                    iterator.remove();
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(Object object) {
        ArrayList arrayList = this._queue;
        synchronized (arrayList) {
            this._queue.add(object);
            this._queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object dequeue() throws IOException {
        ArrayList arrayList = this._queue;
        synchronized (arrayList) {
            while (this._queue.size() == 0) {
                try {
                    this._queue.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException.getMessage());
                }
            }
            return this._queue.remove(0);
        }
    }

    public Socket accept() throws IOException {
        Object object = this.dequeue();
        if (object instanceof Socket) {
            if (_debug.on()) {
                _debug.println("xxx accept(): got a " + object);
            }
            return (Socket)object;
        }
        if (object instanceof IOException) {
            if (_debug.on()) {
                _debug.println("xxx accept(): got an " + object);
            }
            throw (IOException)object;
        }
        if (_debug.on()) {
            _debug.println("xxx accept(): bad entry in queue " + object);
        }
        throw new IOException("Invalid type in accept queue.");
    }

    public boolean expired() {
        return this._expired;
    }

    public void expire() {
        this._expired = true;
    }

    public void close() throws IOException {
        this.expire();
        Thread thread = this._acceptor;
        if (thread != null) {
            this._acceptor = null;
            thread.interrupt();
        }
        this._socket.close();
        this._socket = null;
    }

    public InetAddress getHost() {
        return this._targetHost;
    }

    public int getPort() {
        return this._targetPort;
    }

    public String getKey() {
        return Integer.toString(this._targetPort);
    }

    public ServerSocket getSocket() {
        return this._socket;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        for (CtcBinding ctcBinding : this._bindings.values()) {
            if (stringBuffer.length() > 1) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(ctcBinding.toString());
        }
        stringBuffer.append(") <- ");
        stringBuffer.append(CtcProxyFactory.key(this._targetHost, this._targetPort));
        return stringBuffer.toString();
    }

    private class AcceptorV3
    implements Runnable {
        private AcceptorV3() {
        }

        @Override
        public void run() {
            if (_debug.on()) {
                _debug.println("xxx AcceptorV3(" + CtcServerProxy.this + ") started");
            }
            while (CtcServerProxy.this._acceptor != null) {
                try {
                    if (_debug.on()) {
                        _debug.println("xxx AcceptorV3: waiting for connection");
                    }
                    Socket socket = CtcServerProxy.this._socket.accept();
                    if (CtcServerProxy.this._secure) {
                        socket = CtcSslFactory.getSSLSocketFactory().createSocket(socket, socket.getInetAddress().toString(), socket.getPort(), true);
                    }
                    if (_debug.on()) {
                        _debug.println("xxx AcceptorV3: enqueuing " + socket);
                    }
                    socket.setSoTimeout(0);
                    CtcServerProxy.this.enqueue(socket);
                }
                catch (IOException iOException) {
                    if (_debug.on()) {
                        _debug.println("xxx AcceptorV3: enqueuing " + iOException);
                    }
                    CtcServerProxy.this.enqueue(iOException);
                }
            }
            if (_debug.on()) {
                _debug.println("xxx AcceptorV3(" + CtcServerProxy.this + ") stopped");
            }
        }
    }

    private class AcceptorV5
    implements Runnable {
        private CtcProxy _proxy;

        AcceptorV5(CtcProxy ctcProxy) {
            this._proxy = ctcProxy;
        }

        private void fail(Exception exception) {
            block3: {
                if (_debug.on()) {
                    _debug.println("xxx AcceptorV5: no req reply " + exception);
                }
                try {
                    this._proxy.getIo().close();
                }
                catch (IOException iOException) {
                    if (!_debug.on()) break block3;
                    _debug.println("xxx AcceptorV5: close " + iOException);
                }
            }
        }

        @Override
        public void run() {
            int n = CtcProxyFactory.readTimeout();
            int n2 = n > 0 ? CtcProxyFactory.acceptTimeout() / n : 1;
            int n3 = 0;
            if (_debug.on()) {
                _debug.println("xxx AcceptorV5(" + this._proxy + ") started");
            }
            while (CtcServerProxy.this._acceptor != null) {
                try {
                    if (_debug.on()) {
                        _debug.println("xxx AcceptorV5: reading reply " + this._proxy);
                    }
                    SckfwdRequestReply sckfwdRequestReply = new SckfwdRequestReply(this._proxy.getIo());
                    if (_debug.on()) {
                        _debug.println("xxx AcceptorV5: request reply " + sckfwdRequestReply);
                        _debug.println("xxx AcceptorV5: enqueuing " + this._proxy);
                    }
                    Socket socket = this._proxy.getSocket();
                    socket.setSoTimeout(0);
                    CtcServerProxy.this.enqueue(socket);
                    break;
                }
                catch (InterruptedIOException interruptedIOException) {
                    ++n3;
                    if (_debug.on()) {
                        _debug.println("xxx AcceptorV5(" + this._proxy + ") " + n3 + " of " + n2 + " timeouts");
                    }
                    if (n3 < n2) continue;
                    this.fail(interruptedIOException);
                    CtcServerProxy.this.enqueue(interruptedIOException);
                    break;
                }
                catch (IOException iOException) {
                    this.fail(iOException);
                    CtcServerProxy.this.enqueue(iOException);
                    break;
                }
            }
            if (_debug.on()) {
                _debug.println("xxx AcceptorV5(" + this._proxy + ") stopped");
            }
        }
    }
}

