/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.KDebug;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.SckfwdDisallowedException;
import cerent.util.proxy.SckfwdException;
import cerent.util.proxy.SckfwdExpiredException;
import cerent.util.proxy.SckfwdFailedException;
import cerent.util.proxy.SckfwdRefusedException;
import cerent.util.proxy.SckfwdUnreachableHostException;
import cerent.util.proxy.SckfwdUnreachableNetException;
import cerent.util.proxy.SckfwdUnsupportedAddressException;
import cerent.util.proxy.SckfwdUnsupportedCommandException;
import com.cisco.sot.SotSocketFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.Socket;

class SckfwdIo {
    private static SotSocketFactory _socketFactory = new SotSocketFactory();
    private InetAddress _host;
    private int _port;
    private boolean _connAttempted = false;
    private Socket _socket;
    private InputStream _is;
    private OutputStream _os;
    private int _version;
    private int _connectTimeout = CtcProxyFactory.connectTimeout();
    private IOException _connectException = null;
    private static final KDebug _debug = CtcProxyFactory.getDebug();

    SckfwdIo(int n, InetAddress inetAddress, int n2) throws IOException {
        this._host = inetAddress;
        this._port = n2;
        this._version = n;
    }

    void setConnectTimeout(int n) {
        this._connectTimeout = n;
    }

    private void connectIfNeeded() throws IOException {
        if (!this._connAttempted) {
            this._connAttempted = true;
            try {
                this._socket = _socketFactory.createSocket(this._host, this._port, this._connectTimeout);
                this._socket.setSoTimeout(CtcProxyFactory.readTimeout());
                this._is = this._socket.getInputStream();
                this._os = this._socket.getOutputStream();
            }
            catch (IOException iOException) {
                this._connectException = iOException;
                KDebug kDebug = CtcProxyFactory.getDebug();
                if (kDebug.on()) {
                    kDebug.println("connectIfNeeded failed");
                    KDebug.printStackTrace(iOException);
                }
                throw iOException;
            }
        } else if (this._connectException != null) {
            throw this._connectException;
        }
    }

    void close() throws IOException {
        IOException iOException;
        block12: {
            block11: {
                block10: {
                    iOException = null;
                    if (this._is != null) {
                        try {
                            this._is.close();
                        }
                        catch (IOException iOException2) {
                            if (iOException == null) break block10;
                            iOException = iOException2;
                        }
                    }
                }
                if (this._os != null) {
                    try {
                        this._os.close();
                    }
                    catch (IOException iOException3) {
                        if (iOException == null) break block11;
                        iOException = iOException3;
                    }
                }
            }
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException iOException4) {
                    if (iOException == null) break block12;
                    iOException = iOException4;
                }
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    int available() throws IOException {
        this.connectIfNeeded();
        return this._is.available();
    }

    int skip(int n) throws IOException {
        this.connectIfNeeded();
        byte[] byArray = new byte[n];
        return this.readBlock(byArray, 0, n);
    }

    IOException protocolError(String string) {
        return new IOException(string);
    }

    IOException protocolError(int n, int n2) {
        return this.protocolError("read failed: expected=" + n + " read=" + n2);
    }

    IOException protocolError(int n, int n2, int n3, int n4) {
        return this.protocolError("Send version " + n + " is incompatible with " + "reply version " + n2 + ". code=" + n3 + " avail=" + n4);
    }

    SckfwdException requestException(int n) {
        SckfwdException sckfwdException;
        switch (n) {
            case 1: {
                sckfwdException = new SckfwdFailedException();
                break;
            }
            case 2: {
                sckfwdException = new SckfwdDisallowedException();
                break;
            }
            case 3: {
                sckfwdException = new SckfwdUnreachableNetException();
                break;
            }
            case 4: {
                sckfwdException = new SckfwdUnreachableHostException();
                break;
            }
            case 5: {
                sckfwdException = new SckfwdRefusedException();
                break;
            }
            case 6: {
                sckfwdException = new SckfwdExpiredException();
                break;
            }
            case 7: {
                sckfwdException = new SckfwdUnsupportedCommandException();
                break;
            }
            case 8: {
                sckfwdException = new SckfwdUnsupportedAddressException();
                break;
            }
            default: {
                sckfwdException = new SckfwdException(n);
            }
        }
        return sckfwdException;
    }

    int readByte() throws IOException {
        this.connectIfNeeded();
        int n = 0;
        byte[] byArray = new byte[1];
        int n2 = this.readBlock(byArray, 0, byArray.length);
        if (n2 != byArray.length) {
            if (_debug.on()) {
                KDebug.printStackTrace(new Exception());
            }
            throw this.protocolError(byArray.length, n2);
        }
        n = byArray[0] & 0xFF;
        return n;
    }

    int readShort() throws IOException {
        this.connectIfNeeded();
        int n = 0;
        byte[] byArray = new byte[2];
        int n2 = this.readBlock(byArray, 0, byArray.length);
        if (n2 != byArray.length) {
            if (_debug.on()) {
                KDebug.printStackTrace(new Exception());
            }
            throw this.protocolError(byArray.length, n2);
        }
        for (int i = 0; i < 2; ++i) {
            n |= (byArray[1 - i] & 0xFF) << i * 8;
        }
        return n;
    }

    int readInt() throws IOException {
        this.connectIfNeeded();
        int n = 0;
        byte[] byArray = new byte[4];
        int n2 = this.readBlock(byArray, 0, byArray.length);
        if (n2 != byArray.length) {
            if (_debug.on()) {
                KDebug.printStackTrace(new Exception());
            }
            throw this.protocolError(byArray.length, n2);
        }
        for (int i = 0; i < 4; ++i) {
            n |= (byArray[3 - i] & 0xFF) << i * 8;
        }
        return n;
    }

    InetAddress readIp(byte[] byArray) throws IOException {
        this.connectIfNeeded();
        int n = this.readBlock(byArray, 0, byArray.length);
        if (n != byArray.length) {
            if (_debug.on()) {
                KDebug.printStackTrace(new Exception());
            }
            throw this.protocolError(byArray.length, n);
        }
        return InetAddress.getByAddress(null, byArray);
    }

    private int readBlock(byte[] byArray, int n, int n2) {
        int n3;
        block6: {
            int n4 = 0;
            int n5 = n;
            n3 = 0;
            try {
                while (n2 > 0) {
                    n4 = this._is.read(byArray, n5, n2);
                    if (n4 < 0) {
                        if (_debug.on()) {
                            KDebug.printStackTrace(new Exception("EOF reached, before reading " + n2 + " more bytes"));
                        }
                        if (n3 == 0) {
                            n3 = n4;
                        }
                        break;
                    }
                    n3 += n4;
                    n5 += n4;
                    n2 -= n4;
                }
            }
            catch (Exception exception) {
                if (!_debug.on()) break block6;
                KDebug.printStackTrace(exception);
            }
        }
        return n3;
    }

    InetAddress readAddress(int n) throws IOException {
        this.connectIfNeeded();
        switch (n) {
            case 1: {
                return this.readIp(new byte[4]);
            }
            case 3: {
                this.skip(this.available());
                throw this.protocolError("Domain name addresses not implemented");
            }
            case 4: {
                return this.readIp(new byte[16]);
            }
        }
        this.skip(this.available());
        throw this.protocolError("invalid address type (" + n + ")");
    }

    private static void writeByte(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        outputStream.write(byArray, 0, byArray.length);
    }

    private static void writeShort(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[1 - i] = (byte)(n >>> i * 8);
        }
        outputStream.write(byArray, 0, byArray.length);
    }

    private static void writeInt(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[3 - i] = (byte)(n >>> i * 8);
        }
        outputStream.write(byArray, 0, byArray.length);
    }

    private static void writeAddress(OutputStream outputStream, InetAddress inetAddress) throws IOException {
        byte[] byArray = inetAddress.getAddress();
        if (inetAddress instanceof Inet4Address) {
            SckfwdIo.writeByte(outputStream, 1);
        } else {
            SckfwdIo.writeByte(outputStream, 4);
        }
        outputStream.write(byArray, 0, byArray.length);
    }

    private static void writeString(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes();
        SckfwdIo.writeByte(outputStream, byArray.length);
        outputStream.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeMethods(int[] nArray) throws IOException {
        this.connectIfNeeded();
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            SckfwdIo.writeByte(byteArrayOutputStream, this.getVersion());
            SckfwdIo.writeByte(byteArrayOutputStream, nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                SckfwdIo.writeByte(byteArrayOutputStream, nArray[i]);
            }
            byteArrayOutputStream.writeTo(this._os);
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeUidPwd(String string, String string2) throws IOException {
        this.connectIfNeeded();
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            SckfwdIo.writeByte(byteArrayOutputStream, this.getVersion());
            SckfwdIo.writeString(byteArrayOutputStream, string);
            SckfwdIo.writeString(byteArrayOutputStream, string2);
            byteArrayOutputStream.writeTo(this._os);
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequest(int n, InetAddress inetAddress, int n2) throws IOException {
        this.connectIfNeeded();
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            SckfwdIo.writeByte(byteArrayOutputStream, this.getVersion());
            SckfwdIo.writeByte(byteArrayOutputStream, n);
            SckfwdIo.writeByte(byteArrayOutputStream, 0);
            SckfwdIo.writeAddress(byteArrayOutputStream, inetAddress);
            SckfwdIo.writeShort(byteArrayOutputStream, n2);
            byteArrayOutputStream.writeTo(this._os);
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }

    void writeConnect(InetAddress inetAddress, int n) throws IOException {
        this.writeRequest(1, inetAddress, n);
    }

    void writeBind(InetAddress inetAddress, int n) throws IOException {
        this.writeRequest(2, inetAddress, n);
    }

    private static InetAddress myAddress() throws IOException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (inetAddress instanceof Inet4Address) {
            return inetAddress;
        }
        return InetAddress.getByName("0.0.0.0");
    }

    void writeWhoami() throws IOException {
        this.writeRequest(4, SckfwdIo.myAddress(), 0);
    }

    void writeClients() throws IOException {
        this.writeRequest(5, SckfwdIo.myAddress(), 0);
    }

    void writeTopology() throws IOException {
        this.writeRequest(6, SckfwdIo.myAddress(), 0);
    }

    void writeReset(InetAddress inetAddress, int n) throws IOException {
        this.writeRequest(8, inetAddress, n);
    }

    Socket getSocket() throws IOException {
        this.connectIfNeeded();
        return this._socket;
    }

    int getVersion() {
        return this._version;
    }

    void setVersion(int n) {
        this._version = n;
    }
}

