/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.IPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.Sckfwd;
import cerent.util.proxy.SckfwdClient;
import cerent.util.proxy.SckfwdIo;
import cerent.util.proxy.SckfwdReply;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

class SckfwdTopologyReply
extends SckfwdReply
implements Comparable {
    private InetAddress _server;
    private InetAddress _sckRealHost;
    private int _usage;
    private ArrayList<SckfwdClient> _clients;
    private static final KDebug _debug = new KDebug(CtcProxyFactory.getDebug(), "SckfwdTopologyReply");

    SckfwdTopologyReply(Sckfwd sckfwd, SckfwdIo sckfwdIo) throws IOException {
        int n;
        int n2;
        int n3;
        InetAddress inetAddress;
        int n4;
        this.readVersion(sckfwdIo);
        this._sckRealHost = sckfwd.getRealHost();
        int n5 = sckfwdIo.readByte();
        if (n5 != 0) {
            sckfwdIo.skip(sckfwdIo.available());
            throw sckfwdIo.requestException(n5);
        }
        int n6 = sckfwdIo.readByte();
        if (n6 != 0) {
            sckfwdIo.skip(sckfwdIo.available());
            throw sckfwdIo.protocolError("reserved byte (" + n6 + ") not zero");
        }
        int n7 = sckfwdIo.readByte();
        this._server = sckfwdIo.readAddress(n7);
        int n8 = sckfwdIo.readByte();
        if (n8 != 1 && n8 != 2 && n8 != 3) {
            sckfwdIo.skip(sckfwdIo.available());
            throw sckfwdIo.protocolError("topology version (" + n8 + ") not supported");
        }
        this._usage = sckfwdIo.readShort();
        this._clients = new ArrayList();
        int n9 = sckfwdIo.readShort();
        for (n4 = 0; n4 < n9; ++n4) {
            inetAddress = sckfwdIo.readAddress(n7);
            n3 = CtcProxyFactory.getSizeInBits(inetAddress);
            n2 = sckfwdIo.readByte();
            n = sckfwdIo.readShort();
            int n10 = 0;
            if (n8 == 3) {
                InetAddress inetAddress2 = sckfwdIo.readAddress(4);
                n10 = sckfwdIo.readInt();
                if (_debug.on()) {
                    _debug.println("SckfwdTopologyReply - IPv6 address: " + inetAddress2.getHostName() + " nodeId: " + Integer.toHexString(n10));
                }
                if (n10 != 0 && !inetAddress2.equals(InetAddress.getByName("0:0:0:0:0:0:0:0")) && n2 != 0) {
                    InetAddress inetAddress3 = null;
                    if (n == 0 && (n2 == 20 || n2 == 21)) {
                        if (_debug.on()) {
                            _debug.println("SckfwdTopologyReply: Virtual mapping for nodeID already exists");
                        }
                    } else if (IPAddressTranslator.instance().findVirtualAddress(inetAddress2) != null) {
                        if (_debug.on()) {
                            _debug.println("SckfwdTopologyReply: Virtual mapping for IPv6 already exists");
                        }
                        inetAddress3 = IPAddressTranslator.instance().getVirtualAddress(inetAddress2, n10);
                    } else {
                        inetAddress3 = inetAddress2.getHostAddress().compareTo(this._sckRealHost.getHostAddress()) == 0 ? IPAddressTranslator.instance().getVirtualAddress(inetAddress2, n10) : IPAddressTranslator.instance().getVirtualAddress(inetAddress, n10);
                    }
                    if (inetAddress3 != null) {
                        IPAddressTranslator.instance().updateIPv6Address(inetAddress3, n10, inetAddress2);
                    }
                }
            }
            this._clients.add(new SckfwdClient(sckfwd, inetAddress, null, n3, n, n2, n10));
        }
        if (n8 == 2 || n8 == 3) {
            n9 = sckfwdIo.readShort();
            for (n4 = 0; n4 < n9; ++n4) {
                inetAddress = sckfwdIo.readAddress(n7);
                n3 = sckfwdIo.readShort();
                n2 = sckfwdIo.readByte();
                n = sckfwdIo.readShort();
                this._clients.add(new SckfwdClient(sckfwd, inetAddress, null, n3, n, n2, 0));
            }
        }
        Collections.sort(this._clients);
    }

    InetAddress getServer() {
        return this._server;
    }

    int getUsage() {
        return this._usage;
    }

    ArrayList<SckfwdClient> clients() {
        return (ArrayList)this._clients.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#<topology");
        for (SckfwdClient sckfwdClient : this._clients) {
            stringBuffer.append(" ");
            stringBuffer.append(sckfwdClient.toString());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        if (object instanceof SckfwdTopologyReply) {
            int n;
            SckfwdTopologyReply sckfwdTopologyReply = (SckfwdTopologyReply)object;
            int n2 = 0;
            int n3 = this._clients.size();
            if (n3 == (n = sckfwdTopologyReply._clients.size())) {
                Iterator<SckfwdClient> iterator = this._clients.iterator();
                Iterator<SckfwdClient> iterator2 = sckfwdTopologyReply._clients.iterator();
                while (iterator.hasNext() && iterator2.hasNext() && (n2 = iterator.next().compareTo(iterator2.next())) == 0) {
                }
            } else if (n3 > n) {
                n2 = 1;
            } else if (n3 < n) {
                n2 = -1;
            }
            return n2;
        }
        return 1;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this._clients.hashCode();
    }
}

