/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.version.Ngrp;
import com.cisco.ctc.core.CoreException;
import com.cisco.ctc.core.INgrp;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class NgrpFactory {
    static final String JAR_BUILD_INFORMATION_SECTION = "Build-version";
    static final String JAR_BUILD_INFORMATION_VERSION = "Implementation-version";
    static final String NGRP_MAJOR_RLS = "NGRP-Major-Release";
    static final String NGRP_MAINT_RLS = "NGRP-Maintenance-Release";
    static final String NGRP_INTERIM_VER = "NGRP-Interim-Version-Number";
    static final String NGRP_MAJOR_REBUILD_DES = "NGRP-Major-Rebuild-Designator";
    static final String NGRP_MAJOR_TECH_RLS_DES = "NGRP-Technology-Release-Designator";
    static final String NGRP_REBUILD_DES = "NGRP-Rebuild-Designator";
    static final String UNKNOWN = "???";

    private NgrpFactory() {
    }

    public static INgrp createNgrp(Manifest manifest, String string) throws CoreException {
        Attributes attributes = manifest.getAttributes(JAR_BUILD_INFORMATION_SECTION);
        Attributes attributes2 = manifest.getMainAttributes();
        String string2 = attributes2.getValue(Attributes.Name.SPECIFICATION_TITLE);
        String string3 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        return NgrpFactory.getNgrpFromAttr(string2, attributes, attributes2, string3, string);
    }

    public static Ngrp getNgrpFromAttr(String string, Attributes attributes, Attributes attributes2, String string2, String string3) throws AttrNotPresentException {
        String string4 = NgrpFactory.getAttribute(attributes, NGRP_MAJOR_RLS);
        String string5 = NgrpFactory.getAttribute(attributes, NGRP_MAINT_RLS);
        String string6 = NgrpFactory.getAttribute(attributes, NGRP_INTERIM_VER);
        String string7 = NgrpFactory.getAttribute(attributes, NGRP_MAJOR_REBUILD_DES);
        String string8 = NgrpFactory.getAttribute(attributes, NGRP_MAJOR_TECH_RLS_DES);
        String string9 = NgrpFactory.getAttribute(attributes, NGRP_REBUILD_DES);
        String string10 = attributes2.getValue(Attributes.Name.SPECIFICATION_VERSION);
        if (string10 != null && string10.equals("1.0")) {
            int n;
            string10 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            int n2 = n = string10 == null ? -1 : string10.indexOf("-");
            if (n > 0) {
                string10 = string10.substring(n + 1) + "-XXXX-00.00";
            }
        }
        String string11 = attributes2.getValue(Attributes.Name.MAIN_CLASS);
        String string12 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        return new Ngrp(string4, string5, string6, string7, string8, string9, string2, string10, string, string3, string11, string12);
    }

    public static String getAttribute(Attributes attributes, String string) throws AttrNotPresentException {
        if (attributes == null) {
            return UNKNOWN;
        }
        Attributes.Name name = new Attributes.Name(string);
        if (!attributes.containsKey(name)) {
            throw new AttrNotPresentException(string);
        }
        return attributes.getValue(name);
    }

    public static class AttrNotPresentException
    extends CoreException {
        AttrNotPresentException() {
            this(NgrpFactory.UNKNOWN);
        }

        AttrNotPresentException(String string) {
            super("The attribute " + string + " was not found in the manifest.");
        }
    }
}

