/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import cerent.util.DebugManager;
import cerent.util.KDebug;
import com.cisco.ctc.core.CLURL;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.NETypeEnum;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeMap;

public class CLURLFactory {
    protected static final ICoreVersionUtil cvu = CoreVersionUtil.instance();
    private static CLURLFactory instance;
    private static ICoreVersionUtil vutil;
    private TreeMap<CLURL, URL[]> map = new TreeMap();
    private static final KDebug db;

    public static CLURLFactory instance() {
        return instance;
    }

    public URL[] getClassPaths(CLURL cLURL) {
        URL[] uRLArray = this.map.get(cLURL);
        return uRLArray;
    }

    private CLURLFactory() throws MalformedURLException, IOException {
        this.init();
    }

    private void init() throws MalformedURLException, IOException {
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if (!string.startsWith("ctc.clurl")) continue;
            String string2 = System.getProperty(string);
            this.addCLURL(string, string2);
        }
    }

    private void addCLURL(String string, String string2) throws MalformedURLException, IOException {
        ClassLoaderEnum classLoaderEnum = ClassLoaderEnum.getClassLoaderEnumByCLURL(string);
        NETypeEnum nETypeEnum = NETypeEnum.NE_DONT_CARE;
        if (classLoaderEnum.equals((Object)ClassLoaderEnum.SYSTEM)) {
            return;
        }
        if (classLoaderEnum != null) {
            Object object;
            Comparable comparable = null;
            if (classLoaderEnum == ClassLoaderEnum.ELE) {
                try {
                    comparable = cvu.createCLURLVersionOrdinal(string);
                }
                catch (NumberFormatException numberFormatException) {
                    db.println("error: invalid ELE clurl config: " + string + ". Property setting must be: ctc.clurlELE<netype>-MM.mm[bb]={ELE urls}");
                    throw numberFormatException;
                }
                object = classLoaderEnum.clurlPrefix;
                String string3 = string.substring(((String)object).length());
                nETypeEnum = vutil.isUnifiedEle(comparable) ? NETypeEnum.NE_DONT_CARE : NETypeEnum.getType(string3);
            }
            object = string2.split(";");
            for (int i = 0; i < ((String[])object).length; ++i) {
                Object object2 = object[i];
                if (!((String)object2).endsWith(".jar") && !((String)object2).endsWith("/")) {
                    object2 = (String)object2 + "/";
                }
                object[i] = object2;
            }
            try {
                CLURL cLURL = new CLURL(classLoaderEnum, nETypeEnum, comparable, (String[])object);
                if (db.on()) {
                    db.println("adding clurl config for CL: " + (Object)((Object)classLoaderEnum) + ": " + string2);
                }
                this.map.put(cLURL, CLURLFactory.toURLs((String[])object));
            }
            catch (MalformedURLException malformedURLException) {
                db.println("problem with clurl: " + string + "=" + string2);
                KDebug.printStackTrace(malformedURLException);
                throw malformedURLException;
            }
            catch (IOException iOException) {
                db.println("problem with clurl: " + string + "=" + string2);
                KDebug.printStackTrace(iOException);
                throw iOException;
            }
        }
    }

    private static final URL[] toURLs(String[] stringArray) throws MalformedURLException, IOException {
        int n = stringArray == null ? 0 : stringArray.length;
        URL[] uRLArray = new URL[n];
        for (int i = 0; i < n; ++i) {
            uRLArray[i] = CLURLFactory.toURL(stringArray[i]);
        }
        return uRLArray;
    }

    private static final URL toURL(String string) throws MalformedURLException, IOException {
        URL uRL = new URL(string);
        File file = new File(uRL.getFile());
        if (!file.exists()) {
            db.println("warning: clurl URL: " + string + " does not exist");
        }
        return uRL;
    }

    static {
        vutil = CoreVersionUtil.instance();
        try {
            DebugManager.instance();
            db = new KDebug("CLURLFactory");
            instance = new CLURLFactory();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

