/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import com.cisco.ctc.core.AbstractClassPathExtender;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.INameVersion;
import com.cisco.ctc.core.NameVersion;
import com.cisco.ctc.core.cache.CacheManager;
import com.cisco.ctc.core.cache.ICacheManager;
import java.io.File;
import java.security.AccessControlException;

public class LauncherClassPathExtender
extends AbstractClassPathExtender {
    public static final Class ME = LauncherClassPathExtender.class;
    private static final ICacheManager cm = CacheManager.instance();
    private static final NameVersion orbNv = new NameVersion("ORB", "j5_0213_07");
    private static NameVersion[] openFusionAddons = new NameVersion[]{new NameVersion("fusion"), new NameVersion("log4j"), new NameVersion("hsqldb"), new NameVersion("connector"), new NameVersion("avalon-framework")};
    private static NameVersion jviewsNv = new NameVersion("jviews", "8_1_1");
    private static NameVersion jviewsClassNv = new NameVersion("jviews-framework-all", "8_1_1");
    private static final NameVersion[] classBasedNvs = new NameVersion[]{jviewsClassNv, new NameVersion("jviews-diagrammer", "8_1_1"), new NameVersion("jhall", "2_0_0_1"), new NameVersion("cwitools", "1_1"), new NameVersion("jIde", "2_4_6"), new NameVersion("xerces", "2_5", null, 2)};
    private static final NameVersion[] nvs = new NameVersion[]{jviewsNv, new NameVersion("jhall", "2_0_0_1"), new NameVersion("cwitools", "1_1"), new NameVersion("jIde", "2_4_6"), new NameVersion("xerces", "2_5", null, 2)};

    private static NameVersion getORBClassPath(ClassLoader classLoader) {
        String string = null;
        try {
            string = System.getProperty("org.omg.CORBA.ORBClass");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        boolean bl = false;
        if (string != null) {
            try {
                classLoader.loadClass(string);
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            bl = classLoader.getResource("org/jacorb/orb/CDRInputStream.class") != null;
        }
        return bl ? null : orbNv;
    }

    private boolean dirOk(File file, String string) {
        boolean bl = false;
        if (!file.exists()) {
            db.println(string + file + " does not exist");
        } else if (!file.isDirectory()) {
            db.println(string + file + " is not a directory");
        } else {
            bl = true;
        }
        return bl;
    }

    private NameVersion[] determineNvs() {
        if (cm.retrieve(jviewsNv) == null && cm.retrieve(jviewsClassNv) != null) {
            return classBasedNvs;
        }
        return nvs;
    }

    @Override
    public INameVersion[] getClassPath(ClassLoader classLoader) {
        File file;
        NameVersion[] nameVersionArray = null;
        NameVersion nameVersion = LauncherClassPathExtender.getORBClassPath(classLoader);
        INameVersion[] iNameVersionArray = this.determineNvs();
        if (nameVersion != null && CoreConstants.OPENFUSION_LIB_DIR != null && this.dirOk(file = new File(CoreConstants.OPENFUSION_LIB_DIR), "Error: Openfusion lib dir: ")) {
            nameVersionArray = new NameVersion[openFusionAddons.length + 1];
            nameVersionArray[0] = nameVersion;
            System.arraycopy(openFusionAddons, 0, nameVersionArray, 1, openFusionAddons.length);
        }
        if (nameVersionArray != null) {
            return this.getUniqueClassPath(classLoader, iNameVersionArray, nameVersionArray);
        }
        if (nameVersion != null) {
            return this.getUniqueClassPath(classLoader, iNameVersionArray, nameVersion);
        }
        return this.getUniqueClassPath(classLoader, iNameVersionArray, new INameVersion[0]);
    }
}

