/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.download;

import cerent.util.KDebug;
import com.cisco.ctc.core.download.AbstractTransferer;
import com.cisco.ctc.core.download.AbstractUnpacker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;

public class FilePack200Unpacker
extends AbstractUnpacker {
    protected File fileIn;
    protected File fileOut;
    protected InputStream is;
    protected JarOutputStream jos;
    protected static KDebug db = new KDebug("FilePack200Unpacker");

    public FilePack200Unpacker(InputStream inputStream, File file) {
        this(inputStream, file, db);
    }

    public FilePack200Unpacker(InputStream inputStream, File file, KDebug kDebug) {
        this(file, kDebug);
        this.is = inputStream;
    }

    public FilePack200Unpacker(File file) {
        this(file, db);
    }

    public FilePack200Unpacker(File file, KDebug kDebug) {
        this((File)null, file, kDebug);
    }

    public FilePack200Unpacker(File file, File file2) {
        this(file, file2, db);
    }

    public FilePack200Unpacker(File file, File file2, KDebug kDebug) {
        super(kDebug);
        this.fileIn = file;
        this.fileOut = file2;
    }

    public JarOutputStream getJarOutputStream() {
        return this.jos;
    }

    @Override
    public InputStream preTransferInput(Object object) throws IOException {
        this.checkPreTransferInputState();
        if (object instanceof File) {
            File file = (File)object;
            this.fileInSize = file.length();
            this.is = new FileInputStream(file);
        } else if (object instanceof InputStream) {
            this.is = (InputStream)object;
        } else if (object == null && this.is == null) {
            this.fileInSize = this.fileIn.length();
            this.is = new FileInputStream(this.fileIn);
        } else if (this.is == null || object != null) {
            throw new IllegalArgumentException("cannot handle arg: " + (object == null ? "null" : object.getClass().getName()));
        }
        return this.is;
    }

    @Override
    public OutputStream preTransferOutput(Object object) throws IOException {
        this.checkPreTransferOutputState();
        FileOutputStream fileOutputStream = new FileOutputStream(this.fileOut);
        this.jos = new JarOutputStream(fileOutputStream);
        return this.getJarOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTransfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        block24: {
            this.checkStartTransferState();
            AbstractTransferer.ThreadHolder threadHolder = this.getThreadHolder();
            try {
                AbstractTransferer.ThreadHolder threadHolder2 = threadHolder;
                synchronized (threadHolder2) {
                    threadHolder.unsynchronizedSetThread(Thread.currentThread());
                }
                if (db.on()) {
                    db.println("Pack 200 unpacking..." + this.is.getClass().getName());
                }
                if (this.is != null) {
                    this.getUnpacker().unpack(this.is, this.jos);
                } else {
                    this.getUnpacker().unpack(this.fileIn, this.jos);
                }
                threadHolder2 = threadHolder;
                synchronized (threadHolder2) {
                    threadHolder.unsynchronizedSetThread(null);
                }
            }
            catch (IOException iOException) {
                db.println("got Pack200 IO exception: " + iOException.getClass().getName());
                if (this.abort) {
                    this.aborted = true;
                    break block24;
                }
                throw iOException;
            }
            finally {
                AbstractTransferer.ThreadHolder threadHolder3 = threadHolder;
                synchronized (threadHolder3) {
                    threadHolder.unsynchronizedSetThread(null);
                }
            }
        }
    }

    @Override
    public void endTransfer(Object object) throws IOException {
        this.checkEndTransferState();
        this.jos.close();
    }
}

