/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.download;

import java.util.Locale;

public class JarTransferEnum {
    public static final String NONE_SUFFIX = "";
    public static final String JAR_SUFFIX = "jar";
    public static final String GZIP_SUFFIX = "jgz";
    public static final String PACK200_ONLY_SUFFIX = "jp2";
    public static final String PACK200_AND_GZIP_SUFFIX = "j2z";
    private static final Type[] PREFERRED_TYPES = new Type[]{Type.PACK200_AND_GZIP, Type.GZIP_ONLY, Type.GZIP_ONLY_WITH_NE_TYPE, Type.JAR};
    private static final Type[] CORE_PREFERRED_TYPES = new Type[]{Type.PACK200_AND_GZIP, Type.GZIP_ONLY, Type.GZIP_ONLY_WITH_NE_TYPE, Type.JAR_NO_NETYPE};
    private static final Type[] CORE_NO_COMPRESSION_PREFERRED_TYPES = new Type[]{Type.JAR_NO_NETYPE};

    private JarTransferEnum() {
    }

    public static Type getTypeByUri(String string) {
        if (string == null) {
            return Type.NONE;
        }
        if ((string = string.toLowerCase(Locale.ENGLISH)).endsWith(PACK200_AND_GZIP_SUFFIX)) {
            return Type.PACK200_AND_GZIP;
        }
        if (string.endsWith(PACK200_ONLY_SUFFIX)) {
            return Type.PACK200_ONLY;
        }
        if (string.endsWith(GZIP_SUFFIX)) {
            return Type.GZIP_ONLY;
        }
        if (string.endsWith(JAR_SUFFIX)) {
            return Type.JAR;
        }
        return Type.NONE;
    }

    public static Type[] getPreferredTypes() {
        return PREFERRED_TYPES;
    }

    public static Type[] getCoreNoCompressionPreferredTypes() {
        return CORE_NO_COMPRESSION_PREFERRED_TYPES;
    }

    public static Type[] getCoreCompressionPreferredTypes() {
        return CORE_PREFERRED_TYPES;
    }

    public static enum Type {
        NONE(""),
        JAR("jar", true),
        JAR_NO_NETYPE("jar"),
        GZIP_ONLY("jgz"),
        GZIP_ONLY_WITH_NE_TYPE("jgz", true),
        PACK200_ONLY("jp2"),
        PACK200_AND_GZIP("j2z");

        public final String uriSuffix;
        public final boolean neTypePartOfJarName;

        private Type(String string2) {
            this(string2, false);
        }

        private Type(String string2, boolean bl) {
            this.uriSuffix = string2;
            this.neTypePartOfJarName = bl;
        }
    }
}

