/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.launcher;

import cerent.util.BuildInfo;
import cerent.util.CtcRuntime;
import cerent.util.KDebug;
import com.cisco.ctc.core.ClassLoaderManager;
import com.cisco.ctc.core.INgrp;
import com.cisco.ctc.core.launcher.Launcher;
import com.cisco.ctc.core.launcher.LocalLauncherAttributesPane;
import com.cisco.ctc.ui.CUESLoginWindow;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;

public class LocalLauncher
extends CUESLoginWindow
implements ActionListener {
    private static final String APPLICATION_ICON = "/images/icons/CTC_icon.gif";
    private static final String PROD_NAME = "CTC Launcher";
    private Thread launchThread;
    private Timer threadTerminationTimer;
    private ThrowableHolder launchThreadExceptionHolder;
    private long elapsedThreadTime;
    private long prevThreadTime;
    private static boolean launchDirect = false;
    private static String nodeName = null;
    private static String ctcVersion = null;
    private static Launcher.CtcVersionSelection selectedMode = Launcher.CtcVersionSelection.LATEST_VERSION;
    private LocalLauncherAttributesPane localAttributesPane = null;
    private LocalLauncherWindowContainer windowContainer = null;
    private final KDebug db = new KDebug("LocalLauncher");

    public static void main(String[] stringArray) {
        try {
            LocalLauncher.parseParameters(stringArray);
            Launcher.init();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            LocalLauncher.errorDialog(iOException.getMessage());
            System.exit(1);
        }
        String string = BuildInfo.getShortVersionString();
        INgrp iNgrp = ClassLoaderManager.instance().getSystemNgrp();
        Date date = iNgrp.getRebuildDateAsDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String string2 = "2000-" + calendar.get(1);
        LocalLauncher localLauncher = new LocalLauncher(string, string2);
        localLauncher.showWindow();
        localLauncher.initLauncher();
    }

    private static String[] showUsage(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Usage: " + string + " <-latest|-sameasnode|-help|> [-Dpi=vi]... <login node>");
        arrayList.add("where possible options include:");
        arrayList.add("  -latest - use latest core version available in cache");
        arrayList.add("  -sameasnode - use core version same as the login node");
        arrayList.add("  -help - show usage");
        arrayList.add("  -Dprop=value - system property setting");
        return arrayList.toArray(new String[0]);
    }

    private static void parseParameters(String[] stringArray) {
        if (stringArray.length <= 0) {
            return;
        }
        for (String string : stringArray) {
            String string2;
            int n;
            if (!(string = string.trim()).startsWith("-", 0)) {
                nodeName = string;
                continue;
            }
            if (string.equals("-h") || string.equals("-help")) {
                String[] stringArray2;
                boolean bl = CtcRuntime.isWinNT;
                for (String string3 : stringArray2 = LocalLauncher.showUsage(bl ? "StartCtc.exe" : "StartCtc")) {
                    System.err.println(string3);
                }
                JOptionPane.showMessageDialog(null, stringArray2, "Usage", 1);
                System.exit(0);
                continue;
            }
            if (string.equals("-latest")) {
                selectedMode = Launcher.CtcVersionSelection.LATEST_VERSION;
                continue;
            }
            if (string.equals("-sameasnode")) {
                selectedMode = Launcher.CtcVersionSelection.LOGIN_NODE_VERSION;
                continue;
            }
            if (!string.startsWith("-D") || (n = (string2 = string.substring(2)).indexOf("=")) < 0) continue;
            System.setProperty(string2.substring(0, n), string2.substring(n + 1));
            JOptionPane.showMessageDialog(null, "System prop setting: " + string2.substring(0, n) + " = " + string2.substring(n + 1), "FYI", 1);
        }
        launchDirect = nodeName != null;
    }

    public LocalLauncher(String string, String string2) {
        super(new Object(), PROD_NAME, APPLICATION_ICON, PROD_NAME, string, string2);
        this.initLocalAttributePane();
    }

    @Override
    protected void initAttributePane() {
    }

    protected void initLocalAttributePane() {
        this.localAttributesPane = new LocalLauncherAttributesPane(this);
        this.add(this.localAttributesPane);
    }

    private void initLauncher() {
        this.localAttributesPane.loadPreferences();
        this.localAttributesPane.initCbCtcVersion();
        this.localAttributesPane.setAttributeEnabled();
        if (launchDirect) {
            this.prepareLaunchCTC();
        }
    }

    public void showWindow() {
        this.windowContainer = new LocalLauncherWindowContainer(PROD_NAME, APPLICATION_ICON);
        this.windowContainer.add(this);
        this.windowContainer.setSize(this.getPreferredSize());
        this.setCenter(this.windowContainer);
        this.windowContainer.setVisible(!launchDirect);
        this.windowContainer.getRootPane().setDefaultButton(this.localAttributesPane.getDefaultButton());
    }

    public void processClosed(WindowEvent windowEvent) {
        this.windowContainer.dispose();
        System.exit(0);
    }

    public JRadioButton getUseIPRef() {
        return this.localAttributesPane.getUseIPRef();
    }

    public JRadioButton getUseTL1Ref() {
        return this.localAttributesPane.getUseTL1Ref();
    }

    public JComboBox getLoginNodeRef() {
        return this.localAttributesPane.getLoginNodeRef();
    }

    public JButton getSettingRef() {
        return this.localAttributesPane.getSettingRef();
    }

    public JButton getLaunchCTCRef() {
        return this.localAttributesPane.getLaunchCTCRef();
    }

    public JButton getCancelRef() {
        return this.localAttributesPane.getCancelRef();
    }

    @Override
    protected Border createDefaultBorder() {
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        WINDOW_DIM.setSize(555, 395);
        return WINDOW_DIM;
    }

    @Override
    public Dimension getProductNameDimension() {
        PROD_NAME_DIM.setSize(175, LocalLauncherAttributesPane.ATTR_PANE_DIM.height);
        return PROD_NAME_DIM;
    }

    @Override
    public Dimension getPhotoDimension() {
        PHOTO_AREA_DIM.setSize(100, LocalLauncherAttributesPane.ATTR_PANE_DIM.height);
        return PHOTO_AREA_DIM;
    }

    public Thread getLaunchThread() {
        return this.launchThread;
    }

    public void prepareLaunchCTC() {
        this.launchThreadExceptionHolder = new ThrowableHolder();
        this.launchThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (LocalLauncher.this.db.on()) {
                    LocalLauncher.this.db.println("async launching CTC...");
                }
                try {
                    LocalLauncher.this.launchCTC();
                }
                catch (Throwable throwable) {
                    ((LocalLauncher)LocalLauncher.this).launchThreadExceptionHolder.t = throwable;
                }
            }
        });
        if (this.db.on()) {
            this.db.println("starting async launch of CTC");
        }
        this.launchThread.start();
        this.threadTerminationTimer = new Timer(500, this);
        this.threadTerminationTimer.start();
        this.prevThreadTime = System.currentTimeMillis();
        this.elapsedThreadTime = 0L;
        this.getLaunchCTCRef().setEnabled(false);
        this.getLoginNodeRef().setEnabled(false);
    }

    public String getNode() {
        if (nodeName == null && this.getUseIPRef().isSelected()) {
            nodeName = (String)this.getLoginNodeRef().getSelectedItem();
        }
        return nodeName;
    }

    public void launchCTC() {
        try {
            String string = null;
            Process process = null;
            if (this.getUseTL1Ref().isSelected()) {
                if (this.db.on()) {
                    this.db.println("launching using Socket over TL1 option \tMode: " + (Object)((Object)this.getCtcVersionSelectionMode()));
                }
                process = Launcher.instance().launchCtc(this.windowContainer, this.getCtcVersionSelectionMode());
            } else {
                string = this.getNode();
                if (this.db.on()) {
                    this.db.println("launching node: " + string + "\tMode: " + (Object)((Object)this.getCtcVersionSelectionMode()));
                }
                process = Launcher.instance().launchCtc(this.windowContainer, this.getCtcVersionSelectionMode(), string, null, this.getSelectedCtcVersion());
            }
            if (process != null) {
                if (string != null) {
                    final String string2 = string;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LocalLauncher.this.getLoginNodeRef().removeItem(string2);
                            LocalLauncher.this.getLoginNodeRef().insertItemAt(string2, 0);
                            LocalLauncher.this.getLoginNodeRef().setSelectedIndex(0);
                        }
                    });
                }
                this.processClosed(null);
            }
        }
        catch (ConnectException connectException) {
            connectException.printStackTrace();
            LocalLauncher.errorDialog("Node '" + this.getNode() + "' is either invalid or not reachable.\nPlease verify and try again.");
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            LocalLauncher.errorDialog("Node '" + this.getNode() + "' is either invalid or not reachable.\nPlease verify and try again.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LocalLauncher.errorDialog(exception.getMessage());
        }
        nodeName = null;
    }

    private Launcher.CtcVersionSelection getCtcVersionSelectionMode() {
        if (!launchDirect) {
            LocalLauncherAttributesPane localLauncherAttributesPane = this.localAttributesPane;
            selectedMode = localLauncherAttributesPane.getCtcVersionSelectionMode();
        }
        return selectedMode;
    }

    private Comparable getSelectedCtcVersion() {
        LocalLauncherAttributesPane localLauncherAttributesPane = this.localAttributesPane;
        return localLauncherAttributesPane.getSelectedCtcVersion();
    }

    private static void errorDialog(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.launchThread != null && object == this.threadTerminationTimer) {
            if (!this.launchThread.isAlive()) {
                String string;
                if (this.db.on()) {
                    string = "TL1";
                    if (!this.getUseTL1Ref().isSelected()) {
                        string = (String)this.getLoginNodeRef().getSelectedItem();
                    }
                    this.db.println("Launch thread to " + string + " terminated...");
                }
                this.launchThread = null;
                this.threadTerminationTimer.stop();
                this.threadTerminationTimer = null;
                string = (String)this.getLoginNodeRef().getEditor().getItem();
                this.getLaunchCTCRef().setEnabled(string.length() > 0);
                this.getLoginNodeRef().setEnabled(true);
                if (this.launchThreadExceptionHolder.t != null) {
                    KDebug.printStackTrace(this.launchThreadExceptionHolder.t);
                }
            } else {
                long l = System.currentTimeMillis();
                this.elapsedThreadTime += l - this.prevThreadTime;
                this.prevThreadTime = l;
                if (this.elapsedThreadTime > 600000L) {
                    this.threadTerminationTimer.stop();
                    this.threadTerminationTimer = null;
                    this.launchThread.interrupt();
                    this.launchThread = null;
                    String string = (String)this.getLoginNodeRef().getEditor().getItem();
                    this.getLaunchCTCRef().setEnabled(string.length() > 0);
                    this.getLoginNodeRef().setEnabled(true);
                }
            }
        }
        this.localAttributesPane.setAttributeEnabled();
    }

    protected class LocalLauncherWindowContainer
    extends CUESLoginWindow.CUESLoginWindowContainer {
        public LocalLauncherWindowContainer(String string, String string2) {
            super(string, string2);
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            LocalLauncher.this.processClosed(windowEvent);
        }
    }

    private static class ThrowableHolder {
        public Throwable t;

        private ThrowableHolder() {
        }
    }
}

