/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import com.cisco.sot.DelegatingSocket;
import com.cisco.sot.LimitXpSocketsUtil;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;

public class LimitXpSocket
extends DelegatingSocket {
    public static boolean isNeededForThisOs() {
        return LimitXpSocketsUtil.isNeededForThisOs();
    }

    public LimitXpSocket(Socket socket) {
        super(socket);
    }

    @Override
    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    @Override
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        long l = System.currentTimeMillis();
        IOException iOException = null;
        LimitXpSocketsUtil.IntHolder intHolder = LimitXpSocketsUtil.acquireConnectResource(socketAddress, n);
        long l2 = System.currentTimeMillis();
        try {
            super.connect(socketAddress, n);
        }
        catch (IOException iOException2) {
            if (LimitXpSocketsUtil.db.isFinestEnabled()) {
                LimitXpSocketsUtil.db.finest("IOException on: " + socketAddress);
                LimitXpSocketsUtil.Debug.printStackTrace(iOException2);
            }
            iOException = iOException2;
        }
        LimitXpSocketsUtil.releaseConnectResource(intHolder, socketAddress, n);
        long l3 = System.currentTimeMillis();
        LimitXpSocketsUtil.db.reportElapsedTimes(iOException, l, l2, l3);
        if (iOException != null) {
            throw iOException;
        }
    }
}

