/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ANS;

import java.util.ArrayList;
import java.util.List;

public class ANSNode {
    private static final String SEPARATOR = ".";
    private boolean dirty = false;
    protected final String name;
    private boolean isFail = false;
    private ANSNode parent = null;
    private final List<ANSNode> children;
    private final String[] myPath;

    public ANSNode(String string) {
        this(string, null, new ArrayList<ANSNode>(), new String[]{string});
    }

    public ANSNode(String string, String[] stringArray) {
        this(string, null, new ArrayList<ANSNode>(), stringArray);
    }

    public ANSNode(String string, ANSNode aNSNode) {
        this(string, aNSNode, new ArrayList<ANSNode>(), new String[]{string});
    }

    public ANSNode(String string, ANSNode aNSNode, String[] stringArray) {
        this(string, aNSNode, new ArrayList<ANSNode>(), stringArray);
    }

    public ANSNode(String string, ANSNode aNSNode, ArrayList<ANSNode> arrayList, String[] stringArray) {
        this.name = string;
        this.parent = aNSNode;
        this.children = arrayList;
        this.myPath = stringArray;
    }

    public final String getName() {
        return this.name;
    }

    public final String getFullName() {
        if (this.parent == null) {
            return this.name;
        }
        if (this.isLeaf()) {
            return this.parent.getFullName();
        }
        if (this.parent.getParent() == null) {
            return this.name;
        }
        return this.parent.getFullName() + SEPARATOR + this.name;
    }

    public final String[] getFullPath() {
        return this.myPath;
    }

    public final ANSNode getParent() {
        return this.parent;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void setDirty() {
        if (!this.dirty) {
            this.dirty = true;
            if (this.parent != null) {
                this.parent.setDirty();
            }
        }
    }

    public final void resetDirty() {
        if (this.dirty) {
            this.dirty = false;
            for (ANSNode aNSNode : this.children) {
                aNSNode.resetDirty();
            }
        }
    }

    protected final void recalcDirty() {
        this.dirty = false;
        for (ANSNode aNSNode : this.children) {
            if (!aNSNode.isDirty()) continue;
            this.setDirty();
        }
        if (this.parent != null && !this.dirty) {
            this.parent.recalcDirty();
        }
    }

    public final void makeClean() {
        this.dirty = false;
    }

    public final boolean isFail() {
        return this.isFail;
    }

    public final void setFail(boolean bl) {
        this.isFail = bl;
        if (this.parent != null && bl) {
            this.parent.setFail(true);
        }
    }

    public final void setParent(ANSNode aNSNode) {
        this.parent = aNSNode;
    }

    public final ANSNode[] getChildren() {
        return this.children.toArray(new ANSNode[0]);
    }

    public final ANSNode getChildOfKey(String string) {
        for (ANSNode aNSNode : this.children) {
            if (!aNSNode.getName().equals(string)) continue;
            return aNSNode;
        }
        return null;
    }

    public final void addChild(ANSNode aNSNode) {
        this.children.add(aNSNode);
        aNSNode.setParent(this);
    }

    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        return "NODE: " + this.getName();
    }

    public static String makeFullName(List<String> list) {
        return ANSNode.makeFullName(list.toArray(new String[0]));
    }

    protected static String makeFullName(String[] stringArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n > 0 && stringArray.length > 0) {
            stringBuilder.append(stringArray[0]);
            for (int i = 1; i < n && i < stringArray.length; ++i) {
                stringBuilder.append(SEPARATOR);
                stringBuilder.append(stringArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    public static String makeFullName(String[] stringArray) {
        return ANSNode.makeFullName(stringArray, stringArray.length);
    }

    private static String repeat(char c, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + c;
        }
        return string;
    }

    private void getTreeString(int n, StringBuilder stringBuilder) {
        stringBuilder.append(ANSNode.repeat(' ', n));
        stringBuilder.append(this.toString());
        stringBuilder.append("\n");
        for (ANSNode aNSNode : this.children) {
            aNSNode.getTreeString(n + 2, stringBuilder);
        }
    }

    public String getTreeString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nANS tree:\n");
        this.getTreeString(0, stringBuilder);
        return stringBuilder.toString();
    }
}

