/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.AiciModule;
import cerent.cms.idl.Equipment.eAiciExtAlarms;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xInvalidData;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xWrongEquipmentType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AicModuleModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import org.omg.CORBA.UserException;

public class AiciModuleModel
extends AicModuleModel {
    public static final int STATION_NUMBER_LENGTH = 4;
    private PortMode portMode;
    private StationNumber stationNumber;
    private ExtensionAlarm extAlarm;
    private NodeModelDelegate nmd;

    public AiciModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2);
        this.db = nodeModelDelegate.getChildDebug(AiciModuleModel.class);
        this.index = n;
        this.nmd = nodeModelDelegate;
        this.portMode = new PortMode(nodeModelDelegate, "AiciModuleModel.PortMode");
        this.stationNumber = new StationNumber("AiciModuleModel.stationNumber");
        this.extAlarm = new ExtensionAlarm("AiciModuleModel.extAlarm");
    }

    public void setInputOutputPortMode(boolean bl) throws EMCProvisionError {
        block3: {
            try {
                this.portMode.set(new Boolean(bl));
            }
            catch (xProvisionError xProvisionError2) {
                throw new EMCProvisionError(xProvisionError2, this.nmd.getPlatform());
            }
            catch (UserException userException) {
                if (!this.db.on) break block3;
                this.db.print("setInputOutputPortMode: " + (Object)((Object)userException));
            }
        }
    }

    public boolean getInputOutputPortMode() {
        try {
            return (Boolean)this.portMode.get();
        }
        catch (UserException userException) {
            if (this.db.on) {
                this.db.print("getInputOutputPortMode: " + (Object)((Object)userException));
            }
            return false;
        }
    }

    public void setStationNumber(String string) throws AbstractCmsIOException {
        block4: {
            StringBuffer stringBuffer = new StringBuffer();
            int n = string.length();
            if (n < 4) {
                for (int i = 0; i < 4 - n; ++i) {
                    stringBuffer.append("0");
                }
            }
            stringBuffer.append(string);
            try {
                this.stationNumber.set(stringBuffer.toString());
            }
            catch (UserException userException) {
                if (!this.db.on) break block4;
                this.db.print("setStationNumber: " + (Object)((Object)userException));
            }
        }
    }

    public String getStationNumber() throws AbstractCmsIOException {
        try {
            return (String)this.stationNumber.get();
        }
        catch (UserException userException) {
            if (this.db.on) {
                this.db.print("getStationNumber: " + (Object)((Object)userException));
            }
            return null;
        }
    }

    public void setExtAlarmUsage(eAiciExtAlarms eAiciExtAlarms2) throws EMCProvisionError, AbstractCmsIOException {
        block3: {
            try {
                this.extAlarm.set(eAiciExtAlarms2);
            }
            catch (xProvisionError xProvisionError2) {
                throw new EMCProvisionError(xProvisionError2, this.nmd.getPlatform());
            }
            catch (UserException userException) {
                if (!this.db.on) break block3;
                this.db.print("setExtAlarmUsage: " + (Object)((Object)userException));
            }
        }
    }

    public eAiciExtAlarms getExtAlarmUsage() throws AbstractCmsIOException {
        try {
            return (eAiciExtAlarms)this.extAlarm.get();
        }
        catch (UserException userException) {
            if (this.db.on) {
                this.db.print("getExtAlarmUsage: " + (Object)((Object)userException));
            }
            return null;
        }
    }

    @Override
    protected boolean needNotify() {
        return this.getExtAlarmUsage() != eAiciExtAlarms.AICI_DEFAULT;
    }

    @Override
    public String toString() {
        return "Aici" + super.toString();
    }

    private AiciModule getAiciModuleRef() {
        return this.getNodeModelDelegate().getIorRepository().getAiciModuleRef();
    }

    class ExtensionAlarm
    extends NonCachedValue {
        public ExtensionAlarm(String string) {
            super(AiciModuleModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment {
            if (AiciModuleModel.this.db.on()) {
                AiciModuleModel.this.db.println("ExtensionAlarm.setValue(" + ((eAiciExtAlarms)object).value() + ")");
            }
            AiciModuleModel.this.getAiciModuleRef().setExtAlarmUsage(AiciModuleModel.this.entityIndex, (eAiciExtAlarms)object);
        }

        @Override
        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment {
            eAiciExtAlarms eAiciExtAlarms2 = AiciModuleModel.this.getAiciModuleRef().extAlarmUsage(AiciModuleModel.this.entityIndex);
            if (AiciModuleModel.this.db.on()) {
                AiciModuleModel.this.db.println("ExtensionAlarm.getValue(" + eAiciExtAlarms2.value() + ")");
            }
            return eAiciExtAlarms2;
        }
    }

    class PortMode
    extends NonCachedValue {
        public PortMode(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment {
            if (AiciModuleModel.this.db.on()) {
                AiciModuleModel.this.db.println("PortMode.setValue(" + object + ")");
            }
            AiciModuleModel.this.getAiciModuleRef().setInputOutputPortMode(AiciModuleModel.this.entityIndex, (Boolean)object);
        }

        @Override
        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment {
            return new Boolean(AiciModuleModel.this.getAiciModuleRef().getInputOutputPortMode(AiciModuleModel.this.entityIndex));
        }
    }

    class StationNumber
    extends NonCachedValue {
        public StationNumber(String string) {
            super(AiciModuleModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws xInvalidData, xWrongEquipmentType, xNoSuchEquipment {
            if (AiciModuleModel.this.db.on()) {
                AiciModuleModel.this.db.println("StationNumber.setValue(" + object + ")");
            }
            AiciModuleModel.this.getAiciModuleRef().setStationNum(AiciModuleModel.this.entityIndex, (String)object);
        }

        @Override
        protected Object getValue() throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment {
            String string = AiciModuleModel.this.getAiciModuleRef().stationNum(AiciModuleModel.this.entityIndex);
            if (AiciModuleModel.this.db.on()) {
                AiciModuleModel.this.db.println("StationNumber.getValue(" + string + ")");
            }
            return string;
        }
    }
}

