/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.fv.IFvSlotModel;
import cerent.cms.idl.Equipment.ChassisModule;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.idl.Equipment.eMultishelfLanConfig;
import cerent.cms.idl.Equipment.sMultishelfEthConfig;
import cerent.cms.idl.Equipment.sShelfInfo;
import cerent.cms.idl.Equipment.sShelfInfoSubset;
import cerent.cms.idl.Equipment.xAlreadyLocked;
import cerent.cms.idl.Equipment.xBusy;
import cerent.cms.idl.Equipment.xDuplexLocked;
import cerent.cms.idl.Equipment.xDuplexUnlocked;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.Equipment.xInvalidData;
import cerent.cms.idl.Equipment.xInvalidState;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.Equipment.xProtectActive;
import cerent.cms.idl.Equipment.xProtectFailedOrMissing;
import cerent.cms.idl.Equipment.xProtectLocked;
import cerent.cms.idl.Equipment.xWorkingFailedOrMissing;
import cerent.cms.idl.Equipment.xWorkingLocked;
import cerent.cms.idl.Equipment.xWrongEquipmentType;
import cerent.cms.idl.Node.sPwrMonVoltage;
import cerent.cms.idl.Node.sVoltageInfo;
import cerent.cms.idl.Node.xInvalidOperation;
import cerent.cms.idl.Node.xPwrMonInvalidHi;
import cerent.cms.idl.Node.xPwrMonInvalidInc;
import cerent.cms.idl.Node.xPwrMonInvalidLo;
import cerent.cms.idl.Node.xPwrMonOrderError;
import cerent.cms.idl.Node.xPwrMonSavLimits;
import cerent.cms.idl.OnsError.eProvDataError;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractSlotPolicy;
import cerent.cms.model.AlreadyLocked;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.ChassisPolicy;
import cerent.cms.model.DuplexLocked;
import cerent.cms.model.DuplexUnlocked;
import cerent.cms.model.DwdmApcModels;
import cerent.cms.model.DwdmOpticalSetupModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EnvAlarmTable;
import cerent.cms.model.EtherBridgeModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IAlarmModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.ITermConnectionModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.InvalidState;
import cerent.cms.model.IorRepository;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.ProtectActive;
import cerent.cms.model.ProtectFailedOrMissing;
import cerent.cms.model.ProtectLocked;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.PwrMonInvalidHi;
import cerent.cms.model.PwrMonInvalidInc;
import cerent.cms.model.PwrMonInvalidLo;
import cerent.cms.model.PwrMonOrderError;
import cerent.cms.model.PwrMonSavLimits;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.ShelfInfo;
import cerent.cms.model.ShelfInfoFactory;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.model.WorkingFailedOrMissing;
import cerent.cms.model.WorkingLocked;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.ElementEventStore;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.IEventStore;
import cerent.cms.model.nedefaults.DefaultsManager;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import com.cisco.ctc454.model.SlotPolicy;
import com.cisco.ctcutsXsdh.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.omg.CORBA.UserException;

public class ChassisModel
extends MfgEntityModel
implements IChassisModel {
    private SynchronizationModel syncModel;
    private EnvAlarmTable envModel;
    private IsPowerMonitorSupported isPowerMonitorSupportedCv;
    private PowerMonitor powerMonitorNcv;
    private ShelfInfoCV shelfInfoCv;
    private ChassisType chassisType;
    private EthConfig ethConfigNcv;
    private ScMultishelf scMultishelfNcv;
    private NcMultishelf ncMultishelfNcv;
    private DisableMultishelf disableMultishelfNcv;
    private UnprovisionChassis unprovisionNcv;
    private TestLamp testLamp;
    private ChassisTemp chassisTempNcv;
    private ChassisVoltage chassisVoltageNcv;
    private AlarmDryContactModeForTNC alarmDryContactModeForTNC;

    public ChassisModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, null);
        this.setDebug(nodeModelDelegate.getDebug().getChildDebug("Chassis" + this.getShelfId()));
        this.syncModel = null;
        this.envModel = null;
        this.isPowerMonitorSupportedCv = new IsPowerMonitorSupported(nodeModelDelegate, "ChassisModel.isPowerMonitorSupported");
        this.powerMonitorNcv = new PowerMonitor(nodeModelDelegate, "ChassisModel.powerMonitor");
        this.shelfInfoCv = new ShelfInfoCV(nodeModelDelegate, "ChassisModel.shelfInfo");
        this.chassisType = new ChassisType(nodeModelDelegate, "ChassisModel.chassisType");
        this.ethConfigNcv = new EthConfig(nodeModelDelegate, "ChassisModel.ethConfig");
        this.unprovisionNcv = new UnprovisionChassis(nodeModelDelegate, "ChassisModel.UnprovisionChassis");
        this.ncMultishelfNcv = new NcMultishelf(nodeModelDelegate, "ChassisModel.enableMultishelfAsNc");
        this.scMultishelfNcv = new ScMultishelf(nodeModelDelegate, "ChassisModel.enableMultishelfAsSc");
        this.disableMultishelfNcv = new DisableMultishelf(nodeModelDelegate, "ChassisModel.disableMultishelf");
        this.chassisTempNcv = new ChassisTemp(nodeModelDelegate, "ChassisModel.chassisTemp");
        this.chassisVoltageNcv = new ChassisVoltage(nodeModelDelegate, "ChassiModel.chassisVoltage");
        this.testLamp = new TestLamp(nodeModelDelegate, "ChassisModel.testLamp");
        this.alarmDryContactModeForTNC = new AlarmDryContactModeForTNC(nodeModelDelegate, "ChassisModel.alarmDryContactModeForTNC");
    }

    @Override
    protected void updateLocal() {
        Exception exception = this.updateCV(this.shelfInfoCv);
        if (exception != null) {
            this.db.println("updateLocal caught " + exception);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.isPowerMonitorSupportedCv.update();
        this.chassisType.update();
        this.setChanged();
        super.updateLocal();
    }

    @Override
    public void dispose() {
        Exception exception = this.disposeCV(this.shelfInfoCv);
        exception = this.disposeCV(this.chassisType);
        exception = this.disposeModel(this.syncModel);
        exception = this.disposeEnvModel(this.envModel);
        if (exception != null) {
            this.db.println("dispose caught " + exception);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
        Exception exception = this.destroyModel(this.syncModel);
        if (exception != null) {
            this.db.println("destroy caught " + exception);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.db.on()) {
            this.db.println("init(): synchronizationModel.init()");
        }
        this.getSyncModel().init();
        if (!this.getPlatform().is600()) {
            if (this.db.on()) {
                this.db.println("init(): etherBridgeModel.init()");
            }
            ((EtherBridgeModel)this.getEtherBridgeModel()).init();
        }
        if (this.db.on()) {
            this.db.println("init(): envAlarmTable.init()");
        }
        this.getEnvAlarmTable().init();
    }

    @Override
    public int getShelfId() {
        return this.getShelfId(this.isMultishelf());
    }

    @Override
    public int getShelfIndex() {
        return this.getEntityIndex();
    }

    @Override
    public int getShelfId(boolean bl) {
        return bl ? this.getPositionInParent() : 1;
    }

    @Override
    public void setShelfId(int n) throws ProvisionError {
        throw new EMCProvisionError(eProvDataError.FAIL_SHELF_ID_PROVISION, this.getPlatform());
    }

    @Override
    public ShelfInfo getShelfInfo() {
        try {
            sShelfInfo sShelfInfo2;
            block4: {
                sShelfInfo2 = (sShelfInfo)this.shelfInfoCv.get();
                try {
                    sShelfInfoSubset sShelfInfoSubset2 = ChassisModels.getInstance(this.getNodeModelDelegate()).getShelfInfoForChassis(this);
                    sShelfInfo2.position = sShelfInfoSubset2.position;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            return ShelfInfoFactory.getShelfInfo(sShelfInfo2, this, this.isMultishelf());
        }
        catch (UserException userException) {
            throw this.doUnknown("getShelfInfo", userException);
        }
    }

    @Override
    public int getChassisType() {
        try {
            eEqType eEqType2 = (eEqType)this.chassisType.get();
            return eEqType2.value();
        }
        catch (UserException userException) {
            throw this.doUnknown("getChassisType", userException);
        }
    }

    @Override
    public int getMaxPhysicalSlots() {
        if (this.isM6Chassis()) {
            return 8;
        }
        if (this.isM2Chassis()) {
            return 3;
        }
        if (this.is454Chassis()) {
            return 17;
        }
        if (this.isM15Chassis()) {
            return 17;
        }
        return 0;
    }

    @Override
    public short getRackNumber() {
        try {
            sShelfInfoSubset sShelfInfoSubset2 = ChassisModels.getInstance(this.getNodeModelDelegate()).getShelfInfoForChassis(this);
            return sShelfInfoSubset2.position.rackNumber;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return 1;
        }
    }

    @Override
    public short getRackPosition() {
        try {
            sShelfInfoSubset sShelfInfoSubset2 = ChassisModels.getInstance(this.getNodeModelDelegate()).getShelfInfoForChassis(this);
            return sShelfInfoSubset2.position.positionInRack;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return 1;
        }
    }

    @Override
    public String getRackLocation() {
        if (this.node.isMultishelf()) {
            StringBuilder stringBuilder = new StringBuilder();
            short s = this.getRackNumber();
            if (s != 0) {
                stringBuilder.append("[R");
                stringBuilder.append(s);
                stringBuilder.append(",P");
                stringBuilder.append(this.getRackPosition());
                stringBuilder.append("]");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public short getRUOccupied() {
        return ChassisPolicy.getChassisHeight(this.getEqTypeEnum());
    }

    @Override
    public void setEthConfig(eMultishelfLanConfig eMultishelfLanConfig2, short s, short s2) throws ProvisionError, ResourceInUse {
        try {
            sMultishelfEthConfig sMultishelfEthConfig2 = new sMultishelfEthConfig();
            sMultishelfEthConfig2.lanConfig = eMultishelfLanConfig2;
            sMultishelfEthConfig2.publicVlanId = s;
            sMultishelfEthConfig2.internalVlanId = s2;
            this.ethConfigNcv.set(sMultishelfEthConfig2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getPlatform());
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setMultishelfLanConfig", userException);
        }
    }

    @Override
    public void disableMultishelf() throws ProvisionError, ResourceInUse, NotSupportedOnEquipment {
        if (this.getShelfInfo().getShelfRole() == ShelfInfo.IShelfRole.SHELF_ROLE_SC) {
            throw new EMCProvisionError(eProvDataError.MS_DISABLE_NOT_ALLOWED, new String[]{"It must be disabled using the LCD."}, this.getPlatform());
        }
        try {
            this.disableMultishelfNcv.set();
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment(xNotSupportedOnEquipment2.message);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, "Multishelf is not enabled on this node!", this.getPlatform());
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw this.doUnknown("disableMultishelf", userException);
        }
    }

    @Override
    public void enableMultishelfAsSc(short s) throws ProvisionError, NotSupportedOnEquipment, InvalidData {
        try {
            this.scMultishelfNcv.set(new Short(s));
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment(xNotSupportedOnEquipment2.message);
        }
        catch (xInvalidData xInvalidData2) {
            throw new InvalidData((UserException)xInvalidData2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, "This shelf is already in SC mode.", this.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setMultishelfAsSc", userException);
        }
    }

    public void testChassisLamp() throws ProtectFailedOrMissing, WorkingFailedOrMissing, AlreadyLocked, ProtectLocked, WorkingLocked, ProtectActive, InvalidState, DuplexLocked, DuplexUnlocked, ProvisionError, Busy {
        try {
            if (this.db.on()) {
                this.db.println("doCommand(): " + EnumStrings.getStrings((Object)eModuleOp.TEST_LEDS) + " for " + Integer.toHexString(this.getEntityIndex()));
            }
            this.testLamp.set(eModuleOp.TEST_LEDS);
        }
        catch (xProtectFailedOrMissing xProtectFailedOrMissing2) {
            throw new ProtectFailedOrMissing((UserException)xProtectFailedOrMissing2);
        }
        catch (xWorkingFailedOrMissing xWorkingFailedOrMissing2) {
            throw new WorkingFailedOrMissing((UserException)xWorkingFailedOrMissing2);
        }
        catch (xAlreadyLocked xAlreadyLocked2) {
            throw new AlreadyLocked((UserException)xAlreadyLocked2);
        }
        catch (xProtectLocked xProtectLocked2) {
            throw new ProtectLocked((UserException)xProtectLocked2);
        }
        catch (xWorkingLocked xWorkingLocked2) {
            throw new WorkingLocked((UserException)xWorkingLocked2);
        }
        catch (xProtectActive xProtectActive2) {
            throw new ProtectActive((UserException)xProtectActive2);
        }
        catch (xInvalidState xInvalidState2) {
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (xDuplexLocked xDuplexLocked2) {
            throw new DuplexLocked((UserException)xDuplexLocked2);
        }
        catch (xDuplexUnlocked xDuplexUnlocked2) {
            throw new DuplexUnlocked((UserException)xDuplexUnlocked2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getPlatform());
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (UserException userException) {
            throw this.doUnknown("doCommand", userException);
        }
    }

    @Override
    public void enableMultishelfAsNc(eMultishelfLanConfig eMultishelfLanConfig2, short s, short s2) throws ProvisionError, NotSupportedOnEquipment {
        try {
            sMultishelfEthConfig sMultishelfEthConfig2 = new sMultishelfEthConfig();
            sMultishelfEthConfig2.lanConfig = eMultishelfLanConfig2;
            sMultishelfEthConfig2.publicVlanId = s;
            sMultishelfEthConfig2.internalVlanId = s2;
            this.ncMultishelfNcv.set(sMultishelfEthConfig2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment(xNotSupportedOnEquipment2.message);
        }
        catch (xProvisionError xProvisionError2) {
            switch (xProvisionError2.dataError.value()) {
                case 71: {
                    throw new EMCProvisionError(xProvisionError2, "This shelf is already in NC mode!", this.getPlatform());
                }
            }
            throw new EMCProvisionError(xProvisionError2, this.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setMultishelfAsNc", userException);
        }
    }

    @Override
    public void unprovision() throws ProvisionError, ResourceInUse {
        try {
            this.unprovisionNcv.set();
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getPlatform());
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw this.doUnknown("unprovisionShelf", userException);
        }
    }

    @Override
    public SynchronizationModel getSyncModel() {
        if (this.syncModel == null) {
            this.syncModel = new SynchronizationModel(this);
        }
        return this.syncModel;
    }

    public IEtherBridgeModel getEtherBridgeModel() {
        return this.node.getEtherBridgeModel();
    }

    @Override
    public OhConnectionModelsDelegate getOhConnectionModels() {
        return (OhConnectionModelsDelegate)this.node.getOhConnectionModels();
    }

    @Override
    public ElementModelsDelegate getElementModels() {
        return this.node.getElementModelsDelegate();
    }

    @Override
    public EntityTableModel getEntityTableModel() {
        return this.node.getEntityTableModel();
    }

    public IEntityTableModel getEntityTable() {
        return this.getEntityTableModel();
    }

    public EnvAlarmTable getEnvAlarmTable() {
        if (this.envModel == null) {
            this.envModel = new EnvAlarmTable(this);
        }
        return this.envModel;
    }

    public DwdmOpticalSetupModel getDwdmOpticalSetupModel() {
        return this.node.getDwdmOpticalSetupModel();
    }

    public DwdmApcModels getDwdmApcModels() {
        return this.node.getDwdmApcModels();
    }

    @Override
    public ITermConnectionModel getSdccTermConnectionModel() {
        return this.node.getSdccTermConnectionModel();
    }

    @Override
    public ITermConnectionModel getLdccTermConnectionModel() {
        return this.node.getLdccTermConnectionModel();
    }

    @Override
    public ITermConnectionModel getGccTermConnectionModel() {
        return this.node.getGccTermConnectionModel();
    }

    @Override
    public ITermConnectionModel getOscTermConnectionModel() {
        return this.node.getOscTermConnectionModel();
    }

    @Override
    public IPlatform getPlatform() {
        int n = this.getChassisType();
        if (n == 335) {
            com.cisco.ctcutsX.Platform platform = (com.cisco.ctcutsX.Platform)com.cisco.ctcutsX.Platform.instance();
            platform.setM6();
            return platform;
        }
        if (n == 336) {
            Platform platform = (Platform)Platform.instance();
            platform.setM6();
            return platform;
        }
        if (n == 333) {
            com.cisco.ctcutsX.Platform platform = (com.cisco.ctcutsX.Platform)com.cisco.ctcutsX.Platform.instance();
            platform.setM2();
            return platform;
        }
        if (n == 334) {
            Platform platform = (Platform)Platform.instance();
            platform.setM2();
            return platform;
        }
        if (n == 20) {
            return com.cisco.ctc454.Platform.instance();
        }
        if (n == 71) {
            return com.cisco.ctc455.Platform.instance();
        }
        return this.node.getPlatform();
    }

    @Override
    public AbstractSlotPolicy getSlotPolicy() {
        int n = this.getChassisType();
        if (n == 335 || n == 333) {
            return new com.cisco.ctcutsX.model.SlotPolicy(this.node);
        }
        if (n == 336 || n == 334) {
            return new com.cisco.ctcutsXsdh.model.SlotPolicy(this.node);
        }
        if (n == 20) {
            return new SlotPolicy(this.node);
        }
        if (n == 71) {
            return new com.cisco.ctc455.model.SlotPolicy(this.node);
        }
        return this.node.getSlotPolicy();
    }

    @Override
    public EventDispatcher getDispatcher() {
        return this.node.getDispatcher();
    }

    public IorRepository getIorRepository() {
        return this.node.getIorRepository();
    }

    @Override
    public TDMTerminology getTDMTerminology() {
        return this.node.getTDMTerminology();
    }

    @Override
    public IAlarmModel getAlarmModel() {
        return this.node.getAlarmModel();
    }

    @Override
    public IConnectionModels getConnectionModels() {
        return this.node.getConnectionModels();
    }

    public DefaultsManager getDefaultsManager() {
        return this.node.getDefaultsManager();
    }

    @Override
    public ITdmProtocolType getTdmProtocolTypeObj() {
        return this.node.getTdmProtocolTypeObj();
    }

    @Override
    public IAlarmStore getShelfAlarmStore() {
        ElementAlarmStore elementAlarmStore = (ElementAlarmStore)this.getNodeModel().getElementAlarmStore();
        return this.isMultishelf() ? elementAlarmStore.getShelfAlarmStore(this.getShelfId()) : elementAlarmStore;
    }

    @Override
    public IEventStore getShelfEventStore() {
        ElementEventStore elementEventStore = (ElementEventStore)this.getNodeModel().getElementEventStore();
        return this.isMultishelf() ? elementEventStore.getShelfEventStore(this.getShelfId()) : elementEventStore;
    }

    @Override
    public boolean isPowerMonitorSupported() {
        try {
            return (Boolean)this.isPowerMonitorSupportedCv.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("isPowerMonitorSupported", userException);
        }
    }

    public Integer[] getChassisVoltages() {
        sVoltageInfo[] sVoltageInfoArray = null;
        try {
            sVoltageInfoArray = (sVoltageInfo[])this.chassisVoltageNcv.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getChassiVoltages", userException);
        }
        Integer[] integerArray = new Integer[sVoltageInfoArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            integerArray[i] = sVoltageInfoArray[i].mV;
        }
        return integerArray;
    }

    public Integer getChassisTemp() {
        try {
            return (Integer)this.chassisTempNcv.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("isPowerMonitorSupported", userException);
        }
    }

    @Override
    public sPwrMonVoltage getPowerMonitor() {
        try {
            return (sPwrMonVoltage)this.powerMonitorNcv.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getPowerMonitor", userException);
        }
    }

    @Override
    public void setPowerMonitor(sPwrMonVoltage sPwrMonVoltage2) throws AbstractCmsIOException, PwrMonOrderError, PwrMonInvalidHi, PwrMonInvalidLo, PwrMonInvalidInc, PwrMonSavLimits, NotSupportedOnEquipment, InvalidOperation {
        try {
            this.powerMonitorNcv.set(sPwrMonVoltage2);
        }
        catch (xPwrMonOrderError xPwrMonOrderError2) {
            throw new PwrMonOrderError(xPwrMonOrderError2);
        }
        catch (xPwrMonInvalidHi xPwrMonInvalidHi2) {
            throw new PwrMonInvalidHi(xPwrMonInvalidHi2);
        }
        catch (xPwrMonInvalidLo xPwrMonInvalidLo2) {
            throw new PwrMonInvalidLo(xPwrMonInvalidLo2);
        }
        catch (xPwrMonInvalidInc xPwrMonInvalidInc2) {
            throw new PwrMonInvalidInc(xPwrMonInvalidInc2);
        }
        catch (xPwrMonSavLimits xPwrMonSavLimits2) {
            throw new PwrMonSavLimits(xPwrMonSavLimits2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (xInvalidOperation xInvalidOperation2) {
            throw new InvalidOperation("This platform does not support power monitoring.");
        }
        catch (UserException userException) {
            throw this.doUnknown("setPowerMonitor", userException);
        }
    }

    @Override
    public String toString() {
        return "ChassisModel[" + this.toShortString() + "]";
    }

    @Override
    public String getEqTypeName() {
        return this.isMultishelf() ? this.getShelfInfo().getShelfRole().toString() : super.getEqTypeName();
    }

    @Override
    public String getShelfTypeName() {
        return super.getEqTypeName();
    }

    @Override
    public int getShelfType() {
        return super.getEqType();
    }

    public boolean isMultishelf() {
        return this.getNodeModelDelegate().isMultishelf();
    }

    @Override
    public List getProvAlarmEntities() {
        ArrayList arrayList = new ArrayList();
        this.getModuleModels(arrayList);
        arrayList.addAll(this.getDescendantsOfClassType(1));
        if (this.getNodeModelDelegate().getPlatform().isFanTrayAlarmable()) {
            arrayList.addAll(this.getDescendantsOfClassType(4));
        }
        return arrayList;
    }

    private List getModuleModels(List list) {
        list.addAll(this.getDescendantsOfClassType(6));
        ArrayList arrayList = new ArrayList(list);
        for (EntityModel entityModel : arrayList) {
            if (entityModel instanceof ModuleModel && !(entityModel instanceof PassiveModuleModel)) continue;
            list.remove(entityModel);
        }
        return list;
    }

    @Override
    public List getCardsProvAlarmEntities() {
        ArrayList arrayList = new ArrayList();
        this.getModuleModels(arrayList);
        if (this.getNodeModelDelegate().getPlatform().isFanTrayAlarmable()) {
            arrayList.addAll(this.getDescendantsOfClassType(4));
        }
        return arrayList;
    }

    @Override
    public List getMultiShelfProvAlarmEntities() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getDescendantsOfClassType(1));
        return arrayList;
    }

    @Override
    public Observable[] getProvAlarmObservables() {
        List list = this.getDescendantsOfClassType(2);
        List list2 = this.getDescendantsOfClassType(7);
        list.addAll(list2);
        return list.toArray(new Observable[list.size()]);
    }

    @Override
    public Observable[] getMultiShelfProvAlarmObservables() {
        List list = this.getDescendantsOfClassType(1);
        return list.toArray(new Observable[list.size()]);
    }

    public void setInputOutputPortMode(boolean bl) throws EMCProvisionError {
        block3: {
            try {
                this.alarmDryContactModeForTNC.set(new Boolean(bl));
            }
            catch (xProvisionError xProvisionError2) {
                throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
            }
            catch (UserException userException) {
                if (!this.db.on) break block3;
                this.db.print("setInputOutputPortMode: " + (Object)((Object)userException));
            }
        }
    }

    public boolean getInputOutputPortMode() {
        try {
            return (Boolean)this.alarmDryContactModeForTNC.get();
        }
        catch (UserException userException) {
            if (this.db.on) {
                this.db.print("getInputOutputPortMode: " + (Object)((Object)userException));
            }
            return false;
        }
    }

    @Override
    public Boolean getSuppressAlarmsFlag() {
        return new Boolean(this.getSuppressAlarms());
    }

    private Exception disposeEnvModel(EnvAlarmTable envAlarmTable) {
        try {
            if (envAlarmTable != null) {
                envAlarmTable.dispose();
            }
        }
        catch (Exception exception) {
            this.db.println("Exception occurred while trying to dispose " + envAlarmTable);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return exception;
        }
        return null;
    }

    int eventIndexBase() {
        return this.getEntityIndex() - 1;
    }

    @Override
    public boolean hasActiveTCC2P() {
        boolean bl = false;
        EntityTableModel entityTableModel = this.getEntityTableModel();
        if (entityTableModel != null) {
            bl = entityTableModel.hasActiveTCC2P(this.getShelfId());
        }
        return bl;
    }

    @Override
    public boolean hasStandbyTCC2P() {
        boolean bl = false;
        EntityTableModel entityTableModel = this.getEntityTableModel();
        if (entityTableModel != null) {
            bl = entityTableModel.hasStandbyTCC2P(this.getShelfId());
        }
        return bl;
    }

    @Override
    public boolean hasCAP2() {
        boolean bl = false;
        EntityTableModel entityTableModel = this.getEntityTableModel();
        if (entityTableModel != null) {
            bl = entityTableModel.hasCAP2(this.getShelfId());
        }
        return bl;
    }

    private ChassisModule getChassisModuleRef() {
        return this.getNodeModelDelegate().getIorRepository().getChassisModuleRef();
    }

    @Override
    public ChassisModel getChassisModel() {
        return this;
    }

    @Override
    public boolean isM2Chassis() {
        return this.getChassisType() == 333 || this.getChassisType() == 334;
    }

    @Override
    public boolean isM15Chassis() {
        return this.getChassisType() == 337 || this.getChassisType() == 338;
    }

    @Override
    public boolean is454Chassis() {
        return this.getChassisType() == 20 || this.getChassisType() == 71;
    }

    @Override
    public boolean isUTSChassis() {
        return this.isM6Chassis() || this.isM2Chassis();
    }

    @Override
    public boolean isM6Chassis() {
        return this.getChassisType() == 335 || this.getChassisType() == 336;
    }

    public List<IFvSlotModel> getListOfSlots() {
        return this.getChildren();
    }

    class AlarmDryContactModeForTNC
    extends NonCachedValue {
        public AlarmDryContactModeForTNC(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment {
            if (ChassisModel.this.db.on()) {
                ChassisModel.this.db.println("PortMode.setValue(" + object + ")");
            }
            ChassisModel.this.getChassisModuleRef().setInputOutputPortMode(ChassisModel.this.entityIndex, (Boolean)object);
        }

        @Override
        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment {
            return new Boolean(ChassisModel.this.getChassisModuleRef().getInputOutputPortMode(ChassisModel.this.entityIndex));
        }
    }

    private class ChassisTemp
    extends NonCachedValue {
        public ChassisTemp(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchEquipment, xWrongEquipmentType, xNotSupportedOnEquipment {
            return ChassisModel.this.getChassisModuleRef().getTemp(ChassisModel.this.entityIndex);
        }
    }

    private class ChassisType
    extends CachedValue {
        public ChassisType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchEquipment, xWrongEquipmentType {
            ChassisModel.this.db.fine("ChassisType.getValue");
            return ChassisModel.this.getChassisModuleRef().getChassisType(ChassisModel.this.entityIndex);
        }

        public Object outer() {
            return ChassisModel.this;
        }
    }

    private class ChassisVoltage
    extends NonCachedValue {
        public ChassisVoltage(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchEquipment, xWrongEquipmentType, xNotSupportedOnEquipment {
            return ChassisModel.this.getChassisModuleRef().getPowerVoltage(ChassisModel.this.entityIndex);
        }
    }

    private class DisableMultishelf
    extends NonCachedValue {
        public DisableMultishelf(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue() throws xNoSuchEquipment, xWrongEquipmentType, xProvisionError, xNotSupportedOnEquipment, xInUse {
            ChassisModel.this.db.fine("DisableMultishelf.setValue");
            ChassisModel.this.getChassisModuleRef().disableMultishelf(ChassisModel.this.entityIndex);
        }
    }

    private class EthConfig
    extends NonCachedValue {
        public EthConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xNoSuchEquipment, xWrongEquipmentType, xProvisionError, xNotSupportedOnEquipment, xInUse {
            ChassisModel.this.db.fine("LanConfig.setValue");
            ChassisModel.this.getChassisModuleRef().setMultishelfLanConfig(ChassisModel.this.entityIndex, (sMultishelfEthConfig)object);
        }
    }

    private class IsPowerMonitorSupported
    extends CachedValue {
        public IsPowerMonitorSupported(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchEquipment, xWrongEquipmentType {
            if (ChassisModel.this.db.on()) {
                ChassisModel.this.db.println("IsPowerMonitorSupported.getValue");
            }
            return new Boolean(ChassisModel.this.getChassisModuleRef().isPwrMonSupported(ChassisModel.this.entityIndex));
        }
    }

    private class NcMultishelf
    extends NonCachedValue {
        public NcMultishelf(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xNoSuchEquipment, xWrongEquipmentType, xProvisionError, xNotSupportedOnEquipment {
            ChassisModel.this.db.fine("NcMultishelf.setValue");
            ChassisModel.this.getChassisModuleRef().enableMultishelfAsNc(ChassisModel.this.entityIndex, (sMultishelfEthConfig)object);
        }
    }

    private class PowerMonitor
    extends NonCachedValue {
        public PowerMonitor(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xNoSuchEquipment, xWrongEquipmentType, xPwrMonSavLimits, xPwrMonOrderError, xPwrMonInvalidHi, xPwrMonInvalidLo, xPwrMonInvalidInc, xNotSupportedOnEquipment {
            if (ChassisModel.this.db.on()) {
                ChassisModel.this.db.println("PowerMonitor.setValue");
            }
            ChassisModel.this.getChassisModuleRef().setPwrMonValues(ChassisModel.this.entityIndex, (sPwrMonVoltage)object);
        }

        @Override
        protected Object getValue() throws xNoSuchEquipment, xWrongEquipmentType, xNotSupportedOnEquipment {
            if (ChassisModel.this.db.on()) {
                ChassisModel.this.db.println("PowerMonitor.getValue");
            }
            return ChassisModel.this.getChassisModuleRef().getPwrMonValues(ChassisModel.this.entityIndex);
        }
    }

    private class ScMultishelf
    extends NonCachedValue {
        public ScMultishelf(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xNoSuchEquipment, xWrongEquipmentType, xProvisionError, xNotSupportedOnEquipment, xInvalidData {
            ChassisModel.this.db.fine("ScMultishelf.setValue");
            ChassisModel.this.getChassisModuleRef().enableMultishelfAsSc(ChassisModel.this.entityIndex, (Short)object);
        }
    }

    private class ShelfInfoCV
    extends CachedValue {
        public ShelfInfoCV(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchEquipment, xWrongEquipmentType {
            ChassisModel.this.db.fine("ShelfInfoCV.getValue");
            return ChassisModel.this.getChassisModuleRef().getShelfInfo(ChassisModel.this.entityIndex);
        }

        public Object outer() {
            return ChassisModel.this;
        }
    }

    private class TestLamp
    extends NonCachedValue {
        public TestLamp(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xNoSuchEquipment, xWrongEquipmentType, UserException {
            ChassisModel.this.getChassisModuleRef().doLampTestOnAllCards(ChassisModel.this.entityIndex);
        }
    }

    private class UnprovisionChassis
    extends NonCachedValue {
        public UnprovisionChassis(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue() throws xNoSuchEquipment, xWrongEquipmentType, xProvisionError, xInUse {
            ChassisModel.this.db.fine("unprovision");
            ChassisModel.this.getChassisModuleRef().unprovision(ChassisModel.this.entityIndex);
        }
    }
}

