/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class CtcTimeZone
extends SimpleTimeZone {
    private boolean inDST;
    private boolean DisableDST;
    private int rawOffset;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int startTimeMode;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int endTimeMode;
    private int dstSavingsOffset;
    private int oldstartMonth;
    private int oldstartDay;
    private int oldstartDayOfWeek;
    private int oldstartTime;
    private int oldendMonth;
    private int oldendDay;
    private int oldendDayOfWeek;
    private int oldendTime;
    private int oldstSavingsOffset;
    private String timezoneID;
    private String standTzAbbrevCode;
    private String standTzAbbrevDef;
    private String dstTzAbbrevCode;
    private String dstTzAbbrevDef;
    private String menuText;
    private static String DATE_TIME_TIMEZONE = "MM/dd/yy HH:mm:ss zz";
    private static String TIME_TIMEZONE = "HH:mm:ss zz";
    private DateFormatSymbols dateFormatSymbols = null;

    public CtcTimeZone(int n, String string) {
        super(n, string);
        this.timezoneID = string;
        this.setID(this.timezoneID);
        this.rawOffset = n;
        this.inDST = false;
        this.standTzAbbrevCode = "";
        this.standTzAbbrevDef = "";
        this.dstTzAbbrevCode = "";
        this.dstTzAbbrevDef = "";
        this.menuText = "Menu text was not set.";
        this.DisableDST = false;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CtcTimeZone)) {
            return false;
        }
        CtcTimeZone ctcTimeZone = (CtcTimeZone)object;
        return this.getID().equals(ctcTimeZone.getID()) && this.hasSameRules(ctcTimeZone);
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (!(timeZone instanceof CtcTimeZone)) {
            return false;
        }
        CtcTimeZone ctcTimeZone = (CtcTimeZone)timeZone;
        return this.rawOffset == ctcTimeZone.rawOffset && this.inDST == ctcTimeZone.inDST && (!this.inDST || this.dstSavingsOffset == ctcTimeZone.dstSavingsOffset && this.startMonth == ctcTimeZone.startMonth && this.startDay == ctcTimeZone.startDay && this.startDayOfWeek == ctcTimeZone.startDayOfWeek && this.startTime == ctcTimeZone.startTime && this.startTimeMode == ctcTimeZone.startTimeMode && this.endMonth == ctcTimeZone.endMonth && this.endDay == ctcTimeZone.endDay && this.endDayOfWeek == ctcTimeZone.endDayOfWeek && this.endTime == ctcTimeZone.endTime && this.endTimeMode == ctcTimeZone.endTimeMode);
    }

    @Override
    public String toString() {
        return this.menuText;
    }

    public void setStdTzAbbreviation(String string) {
        this.standTzAbbrevCode = string;
    }

    public void setDstTzAbbreviation(String string) {
        this.dstTzAbbrevCode = string;
    }

    public void setStdTzAbbrevDef(String string) {
        this.standTzAbbrevDef = string;
    }

    public void setDstTzAbbrevDef(String string) {
        this.dstTzAbbrevDef = string;
    }

    public void setMenuText(String string) {
        this.menuText = string;
    }

    @Override
    public void setStartRule(int n, int n2, int n3, int n4) {
        super.setStartRule(n, n2, n3, n4);
        this.startMonth = n;
        this.startDay = n2;
        this.startDayOfWeek = n3;
        this.startTime = n4;
    }

    @Override
    public void setEndRule(int n, int n2, int n3, int n4) {
        super.setEndRule(n, n2, n3, n4);
        this.endMonth = n;
        this.endDay = n2;
        this.endDayOfWeek = n3;
        this.endTime = n4;
    }

    @Override
    public void setDSTSavings(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The DST value is invalid.");
        }
        super.setDSTSavings(n);
        this.dstSavingsOffset = n;
    }

    public void DisableDST(boolean bl) {
        if (bl) {
            this.DisableDST = true;
            this.oldstartMonth = this.startMonth;
            this.oldstartDay = this.startDay;
            this.oldstartDayOfWeek = this.startDayOfWeek;
            this.oldstartTime = this.startTime;
            this.oldendMonth = this.endMonth;
            this.oldendDay = this.endDay;
            this.oldendDayOfWeek = this.endDayOfWeek;
            this.oldendTime = this.endTime;
            this.oldstSavingsOffset = this.dstSavingsOffset;
            super.setEndRule(0, 0, 0, 0);
            super.setStartRule(0, 0, 0, 0);
        } else if (this.DisableDST && !bl) {
            this.DisableDST = false;
            super.setEndRule(this.oldendMonth, this.oldendDay, this.oldendDayOfWeek, this.oldendTime);
            super.setStartRule(this.oldstartMonth, this.oldstartDay, this.oldstartDayOfWeek, this.oldstartTime);
            super.setDSTSavings(this.oldstSavingsOffset);
        }
    }

    public boolean isDSTDisabled() {
        return this.DisableDST;
    }

    @Override
    public int getDSTSavings() {
        return this.dstSavingsOffset;
    }

    public String getTimeZoneID() {
        return this.timezoneID;
    }

    public String getDstStartRules() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.startMonth <= 0) {
            stringBuffer.append(Integer.toString(this.startMonth));
        } else {
            stringBuffer.append(Integer.toString(this.startMonth + 1));
        }
        stringBuffer.append(".");
        if (this.startDayOfWeek == 0) {
            stringBuffer.append("00");
            stringBuffer.append(".");
            stringBuffer.append(Integer.toString(this.startDay));
        } else if (this.startDay < 0) {
            stringBuffer.append("5");
        } else if (this.startDay > 0 && this.startDay < 8) {
            stringBuffer.append("1");
        } else if (this.startDay > 7 && this.startDay < 15) {
            stringBuffer.append("2");
        } else if (this.startDay > 14 && this.startDay < 22) {
            stringBuffer.append("3");
        } else if (this.startDay > 21 && this.startDay < 29) {
            stringBuffer.append("4");
        } else if (this.startDay > 28) {
            stringBuffer.append("5");
        } else {
            stringBuffer.append(Integer.toString(this.startDay));
        }
        if (this.startDayOfWeek != 0) {
            stringBuffer.append(".");
            stringBuffer.append(Integer.toString(Math.abs(this.startDayOfWeek) - 1));
        }
        stringBuffer.append(".");
        stringBuffer.append(Integer.toString(this.startTime / 3600000));
        stringBuffer.append(".");
        stringBuffer.append(Integer.toString((int)(((float)this.startTime / 3600000.0f - (float)(this.startTime / 3600000)) * 60.0f)));
        return stringBuffer.toString();
    }

    public String getDstEndRules() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.endMonth <= 0) {
            stringBuffer.append(Integer.toString(this.endMonth));
        } else {
            stringBuffer.append(Integer.toString(this.endMonth + 1));
        }
        stringBuffer.append(".");
        if (this.endDayOfWeek == 0) {
            stringBuffer.append("00");
            stringBuffer.append(".");
            stringBuffer.append(Integer.toString(this.endDay));
        } else if (this.endDay < 0) {
            stringBuffer.append("5");
        } else if (this.endDay > 0 && this.endDay < 8) {
            stringBuffer.append("1");
        } else if (this.endDay > 7 && this.endDay < 15) {
            stringBuffer.append("2");
        } else if (this.endDay > 14 && this.endDay < 22) {
            stringBuffer.append("3");
        } else if (this.endDay > 21 && this.endDay < 29) {
            stringBuffer.append("4");
        } else if (this.endDay > 28) {
            stringBuffer.append("5");
        } else {
            stringBuffer.append(Integer.toString(this.endDay));
        }
        if (this.endDayOfWeek != 0) {
            stringBuffer.append(".");
            stringBuffer.append(Integer.toString(Math.abs(this.endDayOfWeek) - 1));
        }
        stringBuffer.append(".");
        stringBuffer.append(Integer.toString(this.endTime / 3600000));
        stringBuffer.append(".");
        stringBuffer.append(Integer.toString((int)(((float)this.endTime / 3600000.0f - (float)(this.endTime / 3600000)) * 60.0f)));
        return stringBuffer.toString();
    }

    public String getStandTzName() {
        return this.standTzAbbrevCode;
    }

    public String getDstTzName() {
        return this.dstTzAbbrevCode;
    }

    public String getStandTzAbbreviation() {
        int n = 0;
        n = this.standTzAbbrevCode.indexOf("_");
        if (n > 0) {
            return this.standTzAbbrevCode.substring(0, n);
        }
        return this.standTzAbbrevCode;
    }

    public String getDstTzAbbreviation() {
        int n = 0;
        if (this.dstTzAbbrevCode.length() < 1) {
            return new String();
        }
        n = this.dstTzAbbrevCode.indexOf("_");
        if (n > 0) {
            return this.dstTzAbbrevCode.substring(0, n);
        }
        return this.dstTzAbbrevCode;
    }

    public String getTzAbbreviation(boolean bl) {
        if (bl && !this.DisableDST) {
            return this.getDstTzAbbreviation();
        }
        return this.getStandTzAbbreviation();
    }

    public String getTzAbbreviationDef(boolean bl) {
        if (bl && !this.DisableDST) {
            return this.dstTzAbbrevDef;
        }
        return this.standTzAbbrevDef;
    }

    @Override
    public String getDisplayName(boolean bl, int n, Locale locale) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("The style " + n + " is invalid.");
        }
        String string = n == 1 ? this.getTzAbbreviationDef(bl) : this.getTzAbbreviation(bl);
        if (string == null || string.length() < 3) {
            string = super.getDisplayName(bl, n, locale);
        }
        return string;
    }

    public SimpleDateFormat getDateTimeFormatter(int n, int n2) {
        SimpleDateFormat simpleDateFormat = null;
        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateTimeInstance(n, n2);
        simpleDateFormat = this.dateFormatSymbols != null ? new SimpleDateFormat(simpleDateFormat2.toPattern(), this.dateFormatSymbols) : new SimpleDateFormat(simpleDateFormat2.toPattern());
        simpleDateFormat.setTimeZone(this);
        return simpleDateFormat;
    }

    public SimpleDateFormat getDateTimeFormatter() {
        SimpleDateFormat simpleDateFormat = null;
        simpleDateFormat = this.dateFormatSymbols != null ? new SimpleDateFormat(DATE_TIME_TIMEZONE, this.dateFormatSymbols) : new SimpleDateFormat(DATE_TIME_TIMEZONE);
        simpleDateFormat.setTimeZone(this);
        return simpleDateFormat;
    }

    public SimpleDateFormat getTimeFormatter() {
        SimpleDateFormat simpleDateFormat = null;
        simpleDateFormat = this.dateFormatSymbols != null ? new SimpleDateFormat(TIME_TIMEZONE, this.dateFormatSymbols) : new SimpleDateFormat(TIME_TIMEZONE);
        simpleDateFormat.setTimeZone(this);
        return simpleDateFormat;
    }

    public void initDateFormatSymbols() {
        try {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
            DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
            String[][] stringArray = dateFormatSymbols.getZoneStrings();
            int n = stringArray.length;
            boolean bl = false;
            for (int i = 0; !bl && i < n; ++i) {
                if (!stringArray[i][0].equals(this.timezoneID) || !stringArray[i][2].equals(this.getStandTzAbbreviation())) continue;
                bl = true;
            }
            if (!bl) {
                String[][] stringArray2 = new String[1][5];
                String[] stringArray3 = new String[]{this.timezoneID, this.standTzAbbrevDef, this.getStandTzAbbreviation(), this.dstTzAbbrevDef, this.getDstTzAbbreviation()};
                stringArray2[0] = stringArray3;
                dateFormatSymbols.setZoneStrings(stringArray2);
                this.dateFormatSymbols = (DateFormatSymbols)dateFormatSymbols.clone();
                return;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.dateFormatSymbols = null;
            return;
        }
    }
}

