/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractCtxModuleModel;
import cerent.cms.model.BbeSlot;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitType;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123PortModel;
import cerent.cms.model.EntityContainer;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.IDs1Retiming;
import cerent.cms.model.IDs1Timing;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PathTraceInfo;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.WbeSlot;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CtxClModuleModel
extends AbstractCtxModuleModel
implements IDs1Timing,
IDs1Retiming {
    public CtxClModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2);
    }

    @Override
    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        InterfaceModel[] interfaceModelArray = null;
        if (eEqType2 == null) {
            interfaceModelArray = super.getLineModels(eEqType2);
        } else {
            PortModel[] portModelArray = this.getPortModels(eEqType2);
            if (this.db.on()) {
                this.db.println("Found " + portModelArray.length + " ports");
            }
            switch (eEqType2.value()) {
                case 32: 
                case 34: {
                    if (this.db.on()) {
                        this.db.println("Finding lines for Ds123 ports...");
                    }
                    interfaceModelArray = new Ds123LineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (Ds123LineModel)portModelArray[i].getInterfaceModel();
                    }
                    break;
                }
                case 28: 
                case 29: 
                case 31: {
                    if (this.db.on()) {
                        this.db.println("Finding lines for Tdm ports...");
                    }
                    interfaceModelArray = new TdmLineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (TdmLineModel)portModelArray[i].getInterfaceModel();
                    }
                    break;
                }
                default: {
                    this.db.println("Could not get lines for CTX Card!");
                    if (!this.db.on()) break;
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return interfaceModelArray == null ? new InterfaceModel[]{} : interfaceModelArray;
    }

    @Override
    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        if (eEqType2 == null) {
            portModelArray = super.getPortModels(eEqType2);
        } else {
            List list = this.getDescendantsOfType(eEqType2);
            switch (eEqType2.value()) {
                case 32: 
                case 34: {
                    portModelArray = list.toArray(new Ds123PortModel[list.size()]);
                    break;
                }
                case 28: 
                case 29: 
                case 31: {
                    portModelArray = list.toArray(new TdmPortModel[list.size()]);
                    break;
                }
                default: {
                    this.db.println("Could not get ports for CTX Card!");
                    if (!this.db.on()) break;
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public Ds123LineModel[] getDs1Lines() {
        return (Ds123LineModel[])this.getLineModels(eEqType.DS1_VT_MAPPED);
    }

    public Ds123LineModel[] getDs3Lines() {
        return (Ds123LineModel[])this.getLineModels(eEqType.DS3);
    }

    public EnvAlarmModel[] getAlarmInput() {
        List list = this.getEnvModels(eEqType.ENVIRONMENT_ALARM);
        return list.toArray(new EnvAlarmModel[list.size()]);
    }

    public EnvControlModel[] getControlOutput() {
        List list = this.getEnvModels(eEqType.ENVIRONMENT_CONTROL);
        return list.toArray(new EnvControlModel[list.size()]);
    }

    public TdmLineModel[] getEc1Lines() {
        return (TdmLineModel[])this.getLineModels(eEqType.EC1_PORT);
    }

    private List getEnvModels(eEqType eEqType2) {
        List list = this.getDescendantsOfType(eEqType2);
        return list;
    }

    @Override
    public List getPortsInGroup(IPortModel iPortModel, int n, int n2) {
        boolean bl = CircuitType.getCircuitType((int)n).isLoCircuitType();
        List list = null;
        int n3 = iPortModel.getEqType();
        list = !bl && n3 == 34 ? this.getDescendantsOfEqType(n3) : super.getPortsInGroup(iPortModel, n, n2);
        return list == null ? new ArrayList() : list;
    }

    @Override
    protected IPortModel getPortModelForHoPath(IEntityModel iEntityModel, IHoNum iHoNum) {
        return (IPortModel)iEntityModel;
    }

    @Override
    protected IPortModel getPortModelForLoPath(IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum) {
        return this.getPortByNumberAndType(eEqType.DS1_VT_MAPPED, new int[]{iLoNum.getIdlFlatNum()});
    }

    @Override
    public boolean isComboModule() {
        return true;
    }

    @Override
    boolean isPortNumUnique(int n) {
        switch (n) {
            case 28: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    public BbeSlot getBbeSlot() throws CmsNoSuchEntityException {
        return (BbeSlot)this.getSlot(eEqType.BBE_SLOT);
    }

    public WbeSlot getWbeSlot() throws CmsNoSuchEntityException {
        return (WbeSlot)this.getSlot(eEqType.WBE_SLOT);
    }

    private EntityContainer getSlot(eEqType eEqType2) throws CmsNoSuchEntityException {
        List list = this.getChildrenOfType(eEqType2);
        if (list.size() != 1) {
            this.db.println("Found " + list.size() + " Slots!");
            throw new CmsNoSuchEntityException("The wrong number of slots was returned.");
        }
        return (EntityContainer)list.get(0);
    }

    @Override
    public boolean supportsTermLoopbackAis(IPortModel iPortModel) {
        return !(iPortModel instanceof TdmPortModel) || !((TdmPortModel)iPortModel).isOptical();
    }

    @Override
    public PathTraceInfo[] getJ1PathTraceInfo() throws CTCUserException {
        ArrayList<PathTraceInfo> arrayList = new ArrayList<PathTraceInfo>();
        PathTraceInfo[] pathTraceInfoArray = this.getJ1PathTraceInfo(this.getDs1Lines());
        arrayList.addAll(Arrays.asList(pathTraceInfoArray));
        pathTraceInfoArray = this.getJ1PathTraceInfo(this.getDs3Lines());
        arrayList.addAll(Arrays.asList(pathTraceInfoArray));
        pathTraceInfoArray = this.getJ1PathTraceInfo(this.getEc1Lines());
        arrayList.addAll(Arrays.asList(pathTraceInfoArray));
        pathTraceInfoArray = this.getJ1PathTraceInfo(this.getOpticalLines());
        arrayList.addAll(Arrays.asList(pathTraceInfoArray));
        return arrayList.toArray(new PathTraceInfo[arrayList.size()]);
    }

    @Override
    public boolean supportsDs1Timing() {
        return true;
    }

    @Override
    public boolean supportsDs1Retiming() {
        return true;
    }

    @Override
    public boolean supportsPhysicalAlarm() {
        return true;
    }

    @Override
    public boolean allowsMediumTypeProvisioning() {
        return false;
    }
}

