/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.util.BuildInfo;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DownloadChecker {
    private static final SDebug db = new SDebug("DownloadChecker");
    private static final String CERENT_454 = "Cerent 454";
    private static final String CISCO_15454 = "Cisco 15454";
    private static final String CISCO_15327 = "Cisco 15327";
    private static final String CISCO_15454SDH = "Cisco 15454SDH";
    private static final String CISCO_15600 = "Cisco 15600";
    private static final String CISCO_15310 = "Cisco 15310";
    private static final String CISCO_15600SDH = "Cisco 15600SDH";
    private static final String CISCO_15310MA = "Cisco 15310MA";
    private static final String CISCO_15310MASDH = "Cisco 15310MASDH";
    private String packageType = "";
    private String fullVersion = "";
    private String version = "";
    private String filename = "";
    private String platformType = "";
    private ArrayList fileNames = null;
    public static final String PREF_PATH = "ctc";
    private static final String PREF_SONET_SDH_DOWNLOADENABLED = "sonetSdhDownloadEnable";
    private int sonetSdhDownloadEnable = 0;
    private static final String PREF_MSPP_UTS_DOWNLOADENABLED = "msppUtsDownloadEnable";
    private int msppUtsDownloadEnable = 0;

    public DownloadChecker(String string) throws Exception {
        this.filename = string;
        FilterInputStream filterInputStream = null;
        byte[] byArray = new byte[100];
        try {
            filterInputStream = new BufferedInputStream(new FileInputStream(string));
            if (filterInputStream.read(byArray, 0, byArray.length) > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray));
                this.packageType = stringTokenizer.nextToken("!");
                stringTokenizer.nextToken(":");
                int n = Integer.parseInt(stringTokenizer.nextToken(";").substring(1)) + 1;
                stringTokenizer.nextToken(":");
                this.fullVersion = stringTokenizer.nextToken(";");
                this.version = this.fullVersion.indexOf("DEV") != -1 ? this.fullVersion : this.fullVersion.substring(1, 6);
                this.fullVersion = BuildInfo.sanitize(this.fullVersion.substring(1, this.fullVersion.length()));
                if (db.on()) {
                    db.println("NE type: " + this.packageType);
                }
                if (db.on()) {
                    db.println("Full version: " + this.fullVersion);
                }
                if (db.on()) {
                    db.println("Version: " + this.version);
                }
                if (!(this.packageType.equals(CERENT_454) || this.packageType.equals(CISCO_15454) || this.packageType.equals(CISCO_15454SDH) || this.packageType.equals(CISCO_15327) || this.packageType.equals(CISCO_15600) || this.packageType.equals(CISCO_15600SDH) || this.packageType.equals(CISCO_15310) || this.packageType.equals(CISCO_15310MA) || this.packageType.equals(CISCO_15310MASDH))) {
                    throw new Exception("The file " + string + " is not a valid package.");
                }
                this.setPlatformTypeFromFile(n, string);
                if (db.on()) {
                    db.println("platformType: " + this.getPlatformType());
                }
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            throw new Exception("The file " + string + " is not a valid package.");
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getPlatformType() {
        return this.platformType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPlatformTypeFromFile(int n, String string) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.filename));
            String string2 = null;
            this.fileNames = new ArrayList();
            for (int i = 0; i < n && (string2 = bufferedReader.readLine()) != null; ++i) {
                if (!string2.startsWith("filename")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(new String(string2));
                stringTokenizer.nextToken("=");
                String string3 = stringTokenizer.nextToken(";");
                this.fileNames.add(string3.substring(2, string3.length() - 1));
            }
            this.platformType = this.fileNames.contains("ELEMSPP.jar") ? "MSPP" : (this.fileNames.contains("ELEUTS.jar") ? "MSTP_UTS" : (this.fileNames.contains("ELEMSTP.jar") ? "MSTP_LITE" : "Unknown"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (db.on()) {
                fileNotFoundException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            if (db.on()) {
                iOException.printStackTrace();
            }
        }
        finally {
            block20: {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    if (!db.on()) break block20;
                    iOException.printStackTrace();
                }
            }
        }
    }

    public boolean isCompatible(INodeModel iNodeModel) {
        boolean bl = this.isCompatibleNeType(iNodeModel);
        if (!bl) {
            block9: {
                try {
                    if (db.on()) {
                        db.println(iNodeModel.getName() + " is not a " + this.packageType);
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block9;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            return bl;
        }
        try {
            if (this.version.indexOf("DEV") != -1) {
                return true;
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
        bl = this.isCompatibleWithNodeTCC(iNodeModel);
        if (!bl) {
            return bl;
        }
        return true;
    }

    private boolean isCompatibleWithNodeTCC(INodeModel iNodeModel) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        int n = 1;
        try {
            ArrayList arrayList = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF) ? iNodeModel.getMfgData(n) : iNodeModel.getMfgData();
            for (String string : arrayList) {
                if (string == null) continue;
                if (string.equals("TCC")) {
                    bl = true;
                    continue;
                }
                if (string.equals("TCC+")) {
                    bl2 = true;
                    continue;
                }
                if (string.equals("TCCI")) {
                    bl3 = true;
                    continue;
                }
                if (string.equals("TCC2")) {
                    bl4 = true;
                    continue;
                }
                if (string.equals("TCC2P")) {
                    bl5 = true;
                    continue;
                }
                if (string.equals("TCC2PE")) {
                    bl6 = true;
                    continue;
                }
                if (string.equals("TCC3")) {
                    bl7 = true;
                    continue;
                }
                if (string.equals("TSC") || string.equals("15600-TSC")) {
                    bl8 = true;
                    continue;
                }
                if (string.equals("CTX-2500")) {
                    bl9 = true;
                    continue;
                }
                if (!string.equals("TNC")) continue;
                bl10 = true;
            }
            if (DownloadChecker.db.on) {
                db.println("isCompatibleWithNodeTCC :: hasTCC = " + bl + " hasTCCPlus = " + bl2 + " hasTCCI = " + bl3 + " hasTCC2 = " + bl4 + " hasTCC3 = " + bl7 + " hasTSC = " + bl8 + " hasCTX = " + bl9 + " hasTNC = " + bl10 + " hasTCC2P = " + bl5 + " hasTCC2PE = " + bl6);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return true;
        }
        if (this.version.compareTo("09.30") >= 0 && (this.getNodeType(iNodeModel).equals("15454") || this.getNodeType(iNodeModel).equals("15454SDH")) && (this.getPlatformType().equals("MSTP_UTS") ? !this.hasCompatibleTCCsForMSTP_UTS(bl, bl2, bl3, bl4, bl5, bl6, bl7) : this.getPlatformType().equals("MSTP_LITE") && !this.hasCompatibleTCCsForMSTP_LITE(bl, bl2, bl3, bl4, bl5, bl6, bl7))) {
            return false;
        }
        if (!this.hasCompatibleTCCs(bl, bl2, bl3, bl4, bl7)) {
            return false;
        }
        boolean bl11 = iNodeModel.getTdmProtocolTypeObj().isSdh();
        if (bl11) {
            if (db.on()) {
                db.println("SDH : " + bl3 + " " + bl2 + " " + bl4 + " " + bl7);
            }
            return bl3 || bl2 || bl4 || bl7 || bl8 || bl9 || bl10;
        }
        if (this.version.compareTo("02.30") >= 0 && bl) {
            block30: {
                try {
                    if (DownloadChecker.db.on) {
                        db.println(iNodeModel.getName() + " requires TCC+");
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block30;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            return false;
        }
        if (this.version.compareTo("02.20") < 0 && (bl2 || bl4 || bl7)) {
            block31: {
                try {
                    if (DownloadChecker.db.on) {
                        db.println(iNodeModel.getName() + " requires TCC");
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block31;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            return false;
        }
        if (this.version.compareTo("04.00") < 0 && (bl4 || bl7)) {
            block32: {
                try {
                    if (DownloadChecker.db.on) {
                        db.println(iNodeModel.getName() + "requires TCCPlus");
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block32;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            return false;
        }
        return true;
    }

    private String getNodeType(INodeModel iNodeModel) {
        String string = null;
        try {
            string = iNodeModel.getNeType();
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            string = "unknown";
        }
        return string;
    }

    private boolean isCompatibleNeType(INodeModel iNodeModel) {
        String string = this.getNodeType(iNodeModel);
        Preferences preferences = Preferences.instance();
        this.sonetSdhDownloadEnable = preferences.getInt(PREF_PATH, PREF_SONET_SDH_DOWNLOADENABLED, 0);
        this.msppUtsDownloadEnable = preferences.getInt(PREF_PATH, PREF_MSPP_UTS_DOWNLOADENABLED, 0);
        if (string.equals("15454") && (this.packageType.equals(CERENT_454) || this.packageType.equals(CISCO_15454))) {
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.PACKAGE_SPLIT)) {
                if (this.version.compareTo("09.20") >= 0) {
                    if (iNodeModel.isMspp() && this.getPlatformType().equals("MSPP")) {
                        return true;
                    }
                    if ((iNodeModel.isMstpUts() || iNodeModel.isMstpLite()) && (this.getPlatformType().equals("MSTP_UTS") || this.getPlatformType().equals("MSTP_LITE"))) {
                        return true;
                    }
                    return this.msppUtsDownloadEnable == 1;
                }
                if (iNodeModel.hasSubtendedUtsChassis()) {
                    return false;
                }
            }
            return true;
        }
        if (string.equals("15327") && this.packageType.equals(CISCO_15327)) {
            return true;
        }
        if (string.equals("15454SDH") && this.packageType.equals(CISCO_15454SDH)) {
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.PACKAGE_SPLIT)) {
                if (this.version.compareTo("09.20") >= 0) {
                    if (iNodeModel.isMspp() && this.getPlatformType().equals("MSPP")) {
                        return true;
                    }
                    if ((iNodeModel.isMstpUts() || iNodeModel.isMstpLite()) && (this.getPlatformType().equals("MSTP_UTS") || this.getPlatformType().equals("MSTP_LITE"))) {
                        return true;
                    }
                    return this.msppUtsDownloadEnable == 1;
                }
                if (iNodeModel.hasSubtendedUtsChassis()) {
                    return false;
                }
            }
            return true;
        }
        if (string.equals("15600") && this.packageType.equals(CISCO_15600)) {
            return true;
        }
        if (string.equals("15600SDH") && this.packageType.equals(CISCO_15600SDH)) {
            return true;
        }
        if (string.equals("15310CL") && this.packageType.equals(CISCO_15310)) {
            return true;
        }
        if (string.equals("15310MA") && this.packageType.equals(CISCO_15310MA)) {
            return true;
        }
        if (string.equals("15310MASDH") && this.packageType.equals(CISCO_15310MASDH)) {
            return true;
        }
        if ((string.equals("M6") || string.equals("M2")) && (this.packageType.equals(CISCO_15454) || this.packageType.equals(CERENT_454)) && (this.version.compareTo("09.30") >= 0 ? this.getPlatformType().equals("MSTP_UTS") : this.getPlatformType().equals("MSTP_UTS") || this.getPlatformType().equals("MSTP_LITE"))) {
            return true;
        }
        if ((string.equals("M6SDH") || string.equals("M2SDH")) && this.packageType.equals(CISCO_15454SDH) && (this.version.compareTo("09.30") >= 0 ? this.getPlatformType().equals("MSTP_UTS") : this.getPlatformType().equals("MSTP_UTS") || this.getPlatformType().equals("MSTP_LITE"))) {
            return true;
        }
        if (this.sonetSdhDownloadEnable == 1 && (string.equals("15310MASDH") || string.equals("15310MA")) && (this.packageType.equals(CISCO_15310MASDH) || this.packageType.equals(CISCO_15310MA))) {
            return true;
        }
        if ((string.equals("M6") || string.equals("M2") || string.equals("M6SDH") || string.equals("M2SDH")) && this.sonetSdhDownloadEnable == 1 && (this.packageType.equals(CISCO_15454) || this.packageType.equals(CISCO_15454SDH) || this.packageType.equals(CERENT_454))) {
            if (this.version.compareTo("09.30") >= 0) {
                if (this.getPlatformType().equals("MSTP_UTS")) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean isCompatibleByMsppUtsDownloadEnable(INodeModel iNodeModel) {
        if (iNodeModel != null) {
            String string;
            Preferences preferences = Preferences.instance();
            this.msppUtsDownloadEnable = preferences.getInt(PREF_PATH, PREF_MSPP_UTS_DOWNLOADENABLED, 0);
            try {
                string = iNodeModel.getNeType();
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                string = "unknown";
            }
            if (string.equals("15454") && (this.packageType.equals(CERENT_454) || this.packageType.equals(CISCO_15454))) {
                if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.PACKAGE_SPLIT) && this.version.compareTo("09.20") >= 0) {
                    if (iNodeModel.isMspp() && this.getPlatformType().equals("MSPP")) {
                        return false;
                    }
                    if ((iNodeModel.isMstpUts() || iNodeModel.isMstpLite()) && (this.getPlatformType().equals("MSTP_UTS") || this.getPlatformType().equals("MSTP_LITE"))) {
                        return false;
                    }
                    return this.msppUtsDownloadEnable == 1;
                }
                return false;
            }
            if (string.equals("15454SDH") && this.packageType.equals(CISCO_15454SDH)) {
                if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.PACKAGE_SPLIT) && this.version.compareTo("09.20") >= 0) {
                    if (iNodeModel.isMspp() && this.getPlatformType().equals("MSPP")) {
                        return false;
                    }
                    if ((iNodeModel.isMstpUts() || iNodeModel.isMstpLite()) && (this.getPlatformType().equals("MSTP_UTS") || this.getPlatformType().equals("MSTP_LITE"))) {
                        return false;
                    }
                    return this.msppUtsDownloadEnable == 1;
                }
                return false;
            }
        }
        return false;
    }

    public boolean hasCompatibleTCCs(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        boolean bl6 = true;
        if (bl) {
            if (bl2 || bl3 || bl4 || bl5) {
                bl6 = false;
            }
        } else if (bl2) {
            if (bl3 || bl4 || bl5) {
                bl6 = false;
            }
        } else if (bl3 && (bl4 || bl5)) {
            bl6 = false;
        }
        return bl6;
    }

    private boolean hasCompatibleTCCsForMSTP_UTS(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        if (bl || bl2 || bl3 || bl4 || bl5 || bl6) {
            return false;
        }
        return bl7;
    }

    private boolean hasCompatibleTCCsForMSTP_LITE(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        if (bl || bl2 || bl3 || bl4 || bl5 || bl6) {
            return true;
        }
        if (bl7) {
            return false;
        }
        return false;
    }

    public String getFullVersion() {
        return this.fullVersion;
    }

    public String getVersion() {
        return this.version;
    }
}

