/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class DwdmLineUpdate
extends ModuleModelUpdate {
    private AbstractDwdmLineModel[] _dwdmModels;
    private InterfaceModel[] _payloadModels;
    private DwdmCliLineModel[] _clientModels;
    private AbstractDwdmLineModel[] _otuModels;
    private DwdmTrkLineModel[] _trunkModels;
    private TdmLineModel[] _tdmModels;
    private AbstractDwdmLineModel[] _tdmDwdmModels;
    private FcmrLineModel[] _fcmrModels;
    private EtherLineModel[] _etherModels;
    private AbstractDwdmLineModel[] _otnSupportModels;
    private TdmLineModel[] _wisModels;

    public DwdmLineUpdate(DwdmCliLineModel[] dwdmCliLineModelArray, AbstractDwdmLineModel[] abstractDwdmLineModelArray, InterfaceModel[] interfaceModelArray, DwdmTrkLineModel[] dwdmTrkLineModelArray, TdmLineModel[] tdmLineModelArray, IPortContainer iPortContainer) {
        this(dwdmCliLineModelArray, abstractDwdmLineModelArray, interfaceModelArray, dwdmTrkLineModelArray, iPortContainer);
        this._wisModels = tdmLineModelArray;
    }

    public DwdmLineUpdate(DwdmCliLineModel[] dwdmCliLineModelArray, AbstractDwdmLineModel[] abstractDwdmLineModelArray, InterfaceModel[] interfaceModelArray, DwdmTrkLineModel[] dwdmTrkLineModelArray, IPortContainer iPortContainer) {
        super(dwdmCliLineModelArray, iPortContainer);
        Serializable serializable;
        this._clientModels = dwdmCliLineModelArray;
        this._trunkModels = dwdmTrkLineModelArray;
        this._payloadModels = interfaceModelArray;
        this._otuModels = abstractDwdmLineModelArray;
        this._wisModels = new TdmLineModel[0];
        int n = dwdmCliLineModelArray.length;
        int n2 = dwdmTrkLineModelArray.length;
        int n3 = abstractDwdmLineModelArray.length;
        this._dwdmModels = new AbstractDwdmLineModel[n + n2 + n3];
        System.arraycopy(dwdmCliLineModelArray, 0, this._dwdmModels, 0, n);
        System.arraycopy(abstractDwdmLineModelArray, 0, this._dwdmModels, n, n3);
        System.arraycopy(dwdmTrkLineModelArray, 0, this._dwdmModels, n + n3, n2);
        try {
            if (this._dwdmModels.length > 0) {
                serializable = (DwdmModuleModel)this._dwdmModels[0].getModuleModel();
                ((DwdmModuleModel)serializable).sortLineModels(this._dwdmModels);
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        serializable = new ArrayList();
        for (int i = 0; i < this._dwdmModels.length; ++i) {
            try {
                if (!this._dwdmModels[i].isOTNSupported()) continue;
                serializable.add(this._dwdmModels[i]);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        this._otnSupportModels = serializable.toArray(new AbstractDwdmLineModel[0]);
        if (iPortContainer != null && (iPortContainer.getModuleModel().getEqType() == 293 || iPortContainer.getModuleModel().getEqType() == 300 || iPortContainer.getModuleModel().getEqType() == 301 || iPortContainer.getModuleModel().getEqType() == 356 || iPortContainer.getModuleModel().getEqType() == 358)) {
            ArrayList<DwdmTrkLineModel> arrayList = new ArrayList<DwdmTrkLineModel>(Arrays.asList(dwdmTrkLineModelArray));
            ArrayList<DwdmTrkLineModel> arrayList2 = new ArrayList<DwdmTrkLineModel>();
            for (DwdmTrkLineModel dwdmTrkLineModel : arrayList) {
                try {
                    if (!dwdmTrkLineModel.isClient()) continue;
                    arrayList2.add(dwdmTrkLineModel);
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            arrayList.removeAll(arrayList2);
            this._trunkModels = arrayList.toArray(new DwdmTrkLineModel[0]);
        }
    }

    public AbstractDwdmLineModel[] getDwdmLineModels() {
        return this._dwdmModels;
    }

    public DwdmCliLineModel[] getDwdmCliLineModels() {
        return this._clientModels;
    }

    public AbstractDwdmLineModel[] getDwdmOTNSupportLineModels() {
        return this._otnSupportModels;
    }

    public AbstractDwdmLineModel[] getDwdmOTULineModels() {
        return this._otuModels;
    }

    public DwdmTrkLineModel[] getDwdmTrkLineModels() {
        return this._trunkModels;
    }

    public AbstractDwdmLineModel[] getTdmDwdmLineModels() {
        if (this._tdmDwdmModels == null) {
            this._tdmDwdmModels = DwdmModuleModel.getTdmDwdmLineModels(this._dwdmModels);
        }
        return this._tdmDwdmModels;
    }

    public TdmLineModel[] getTdmLineModels() {
        if (this._tdmModels == null) {
            ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>();
            if (this._payloadModels != null) {
                for (int i = 0; i < this._payloadModels.length; ++i) {
                    if (!(this._payloadModels[i] instanceof TdmLineModel)) continue;
                    arrayList.add(this._payloadModels[i]);
                }
            }
            this._tdmModels = arrayList.toArray(new TdmLineModel[arrayList.size()]);
        }
        return this._tdmModels;
    }

    public FcmrLineModel[] getFcmrLineModels() {
        if (this._fcmrModels == null) {
            ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>();
            if (this._payloadModels != null) {
                for (int i = 0; i < this._payloadModels.length; ++i) {
                    if (!(this._payloadModels[i] instanceof FcmrLineModel)) continue;
                    arrayList.add(this._payloadModels[i]);
                }
            }
            this._fcmrModels = arrayList.toArray(new FcmrLineModel[arrayList.size()]);
        }
        return this._fcmrModels;
    }

    public InterfaceModel[] getPayloadLineModels() {
        return this._payloadModels;
    }

    public EtherLineModel[] getEtherLineModel() {
        if (this._etherModels == null) {
            ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>();
            if (this._payloadModels != null) {
                for (int i = 0; i < this._payloadModels.length; ++i) {
                    if (!(this._payloadModels[i] instanceof EtherLineModel)) continue;
                    arrayList.add(this._payloadModels[i]);
                }
            }
            this._etherModels = arrayList.toArray(new EtherLineModel[arrayList.size()]);
        }
        return this._etherModels;
    }

    public TdmLineModel[] getWisLineModels() {
        return this._wisModels;
    }
}

