/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.idl.If.xAlsConfigError;
import cerent.cms.idl.OnsError.eProvDataError;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.Optics.xProvisioningError;
import cerent.cms.model.AdminState;
import cerent.cms.model.ProvisionError;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

public class EMCProvisionError
extends ProvisionError {
    private static final String UnableAllocateMore = "- The cross-connect is unable to allocate more ";
    private static final SDebug db = new SDebug("EMCProvisionError");

    private static Object[] setMsgArgs(String[] stringArray, String[] stringArray2) {
        Object[] objectArray = stringArray2;
        if (stringArray != null && stringArray2 != null) {
            int n = Math.min(stringArray.length, stringArray2.length);
            System.arraycopy(stringArray, 0, objectArray, 0, n);
        }
        return objectArray;
    }

    private static Object[] getEIDAndMessageArgs(eProvDataError eProvDataError2, String[] stringArray, IPlatform iPlatform) {
        EID eID = null;
        Object[] objectArray = null;
        TDMTerminology tDMTerminology = iPlatform.getTDMTerminology();
        String string = "";
        switch (eProvDataError2.value()) {
            case 0: {
                eID = EMC.EID_GENERIC_PROV_ERROR;
                break;
            }
            case 1: {
                eID = EMC.EID_NO_PARENT_ENTITY;
                break;
            }
            case 2: {
                eID = EMC.EID_NO_PARENT_PPM;
                break;
            }
            case 3: {
                eID = EMC.EID_UNSUPPORTED_EQTYPE;
                break;
            }
            case 282: {
                eID = EMC.EID_CH_GROUP_DENY_SINGLE_PORT_SETTING;
                break;
            }
            case 4: {
                eID = EMC.EID_INVALID_PPM_PORT;
                break;
            }
            case 5: {
                eID = EMC.EID_PORT_ADMIN_STATE_PARAM_2;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"Trunk port", AdminState.getAdminTermIS(tDMTerminology)});
                break;
            }
            case 6: {
                eID = EMC.EID_HAS_REGENERATION;
                break;
            }
            case 7: {
                eID = EMC.EID_OUT_OF_MEMORY;
                break;
            }
            case 380: {
                eID = EMC.EID_FAPS_NOT_DISABLED;
                break;
            }
            case 8: {
                eID = EMC.EID_GENERIC_PROV_ERROR;
                break;
            }
            case 9: {
                eID = EMC.EID_PORT_ADMIN_STATE_PARAM_2;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"Port", AdminState.getAdminTermIS(tDMTerminology)});
                break;
            }
            case 10: {
                eID = EMC.EID_PORT_PRESENT;
                break;
            }
            case 11: {
                eID = EMC.EID_USED_AS_CLOCK_SOURCE;
                break;
            }
            case 263: {
                eID = EMC.EID_MVR_SVLAN_SET_ON_ENABLE;
                break;
            }
            case 12: {
                if (iPlatform.supportsDWDM()) {
                    eID = EMC.EID_DCC_GCC_PRESENT;
                    break;
                }
                eID = EMC.EID_DCC_PRESENT;
                break;
            }
            case 13: {
                eID = EMC.EID_CANNOT_DELETE_PARAM;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"", "because one or more circuits or PPCs are provisioned on it"});
                break;
            }
            case 346: {
                eID = EMC.EID_CH_GRP_PORT_WITH_SVLAN_SETTINGS;
                break;
            }
            case 315: {
                eID = EMC.EID_CFM_ENABLED;
                break;
            }
            case 14: {
                eID = EMC.EID_HAS_PROTECTION;
                break;
            }
            case 15: {
                eID = EMC.EID_HAS_OVERHEAD_CIRCUIT;
                break;
            }
            case 16: {
                eID = EMC.EID_INVALID_OTN_MODE;
                break;
            }
            case 17: {
                eID = EMC.EID_PORT_IN_LOOPBACK;
                break;
            }
            case 376: {
                eID = EMC.EID_CHGRP_PORT_ALS_NOT_DISABLED;
                break;
            }
            case 387: {
                eID = EMC.EID_MAX_QINQ_RULES_REACHED;
                break;
            }
            case 394: {
                eID = EMC.EID_MAX_QINQ_XTL_RULES_REACHED;
                break;
            }
            case 388: {
                eID = EMC.EID_MAX_QINQ_MVR_RULES_REACHED;
                break;
            }
            case 389: {
                eID = EMC.EID_MAX_QINQ_COS_RULES_RAECHED;
                break;
            }
            case 390: {
                eID = EMC.EID_MAX_QINQ_XLTE_ADD_RULES_RAECHED;
                break;
            }
            case 381: {
                eID = EMC.EID_CHGRP_PORT_IN_LOOPBACK;
                break;
            }
            case 391: {
                eID = EMC.EID_FLOW_CTRL_NOT_SUPPORTED_ON_BUNDLED_PORT;
                break;
            }
            case 392: {
                eID = EMC.EID_STORM_CTRL_NOT_SUPPORTED_ON_BUNDLED_PORT;
                break;
            }
            case 59: {
                eID = EMC.EID_PORT_ADMIN_STATE_PARAM_2;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"Client port", "not " + AdminState.getAdminTermDSBLD(tDMTerminology)});
                break;
            }
            case 18: {
                eID = EMC.EID_PORT_ADMIN_STATE_PARAM_2;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"Trunk port", "not " + AdminState.getAdminTermDSBLD(tDMTerminology)});
                break;
            }
            case 19: {
                eID = EMC.EID_PORT_ADMIN_STATE_PARAM_2;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"Protect trunk port", AdminState.getAdminTermIS(tDMTerminology)});
                break;
            }
            case 20: {
                db.severe("eProvDataError.INVALID_ALS_MODE is using a generic error message");
                eID = EMC.EID_GENERIC_PROV_ERROR;
                break;
            }
            case 21: {
                eID = EMC.EID_INVALID_REVERTIVE_TIME_RANGE;
                break;
            }
            case 22: {
                db.severe("eProvDataError.ENTITY_NOT_FOUND is using a generic error message");
                eID = EMC.EID_GENERIC_PROV_ERROR;
                break;
            }
            case 23: {
                eID = EMC.EID_UNSUPPORTED_OPERATION;
                break;
            }
            case 24: {
                eID = EMC.EID_GENERIC_PROV_ERROR;
                break;
            }
            case 25: {
                eID = EMC.EID_INVALID_CONFIG_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"Consult documentation for further details"});
                break;
            }
            case 36: {
                eID = EMC.EID_EQPT_FAILED_OR_MISSING;
                break;
            }
            case 284: {
                eID = EMC.EID_AUTO_SQUELCH_INCOMP_ONE_PLUS_ONE_L2;
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                db.severe("eProvDataError #" + eProvDataError2.value() + " is using a generic error message");
                eID = EMC.EID_GENERIC_PROV_ERROR;
                break;
            }
            case 34: {
                eID = EMC.EID_DELETE_PORT_INVALID_INDEX;
                break;
            }
            case 39: {
                eID = EMC.EID_WRONG_INPUT;
                break;
            }
            case 41: {
                eID = EMC.EID_WRONG_PROTECTION_SLOT;
                break;
            }
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                eID = EMC.EID_GENERIC_PROV_ERROR;
                break;
            }
            case 46: {
                eID = EMC.EID_CHANGE_CARD_MODE_ERROR;
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: {
                db.severe("eProvDataError #" + eProvDataError2.value() + " is using a generic error message");
                eID = EMC.EID_GENERIC_PROV_ERROR;
                break;
            }
            case 63: {
                eID = EMC.EID_INVALID_AIS_SQUELCH_MODE;
                break;
            }
            case 64: {
                db.severe("eProvDataError.FAULT_STATE is using a generic error message");
                eID = EMC.EID_GENERIC_PROV_ERROR;
                break;
            }
            case 65: {
                eID = EMC.EID_NO_REBOOT_DURING_SWDL;
                break;
            }
            case 66: {
                eID = EMC.EID_TRUNK_SECTION_TRACE_ENABLED;
                break;
            }
            case 67: {
                eID = EMC.EID_NO_CHANGE_ERROR_PARAM_1;
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                db.severe("eProvDataError #" + eProvDataError2.value() + " is using a generic error message");
                eID = EMC.EID_GENERIC_PROV_ERROR;
                break;
            }
            case 71: {
                eID = EMC.EID_NO_CHANGE_ERROR_PARAM_1;
                break;
            }
            case 72: {
                eID = EMC.EID_INVALID_MS_LAN_CONFIG;
                break;
            }
            case 73: {
                eID = EMC.EID_INVALID_CARD_TYPE;
                break;
            }
            case 385: {
                eID = EMC.EID_CHGRP_MAX_NUM_PORT_REACHED;
                break;
            }
            case 350: {
                eID = EMC.EID_IGMP_NOT_APPLICABLE_CHGRP_EFM;
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                db.severe("eProvDataError #" + eProvDataError2.value() + " is using a generic error message");
                eID = EMC.EID_GENERIC_PROV_ERROR;
                break;
            }
            case 78: {
                eID = EMC.EID_RATE_CARD_MODE_INCOMPATIBLE;
                break;
            }
            case 80: {
                eID = EMC.REQUIRE_TRANSPARENT_MODE;
                break;
            }
            case 79: {
                eID = EMC.EID_MS_DISABLE_NOT_ALLOWED_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"The shelf is in use."});
                break;
            }
            case 136: {
                eID = EMC.BLSR_NOT_LOCKED_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{tDMTerminology.getRingTerms(1)});
                break;
            }
            case 203: {
                eID = EMC.SERVER_TRAIL_NOT_SUPPORTED;
                break;
            }
            case 137: {
                eID = EMC.SERVER_TRAIL_PRESENT;
                break;
            }
            case 100: {
                eID = EMC.EID_DHCP_INVALID_HOST_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"This address is reserved for internal communication"});
                break;
            }
            case 135: {
                eID = EMC.EID_FAIL_SHELF_ID_PROVISION;
                break;
            }
            case 122: {
                string = tDMTerminology.getVirtualContainerTerm(0);
                eID = CEMC.EID_FAIL_WIZARD_VALIDATION_PARAM_1;
                objectArray = new Object[]{UnableAllocateMore + string + " matrixes.\n", "- New circuits must be created using available bandwidth, or existing\n  circuits will need to be moved or deleted to free up more bandwidth.\n"};
                break;
            }
            case 123: {
                eID = CEMC.EID_FAIL_WIZARD_VALIDATION_PARAM_1;
                objectArray = new Object[]{"- The cross-connect is unable to allocate more VCn or TUG3 matrix ports.\n", "- New circuits must be created using available bandwidth, or existing\n  circuits will need to be moved or deleted to free up more bandwidth.\n"};
                break;
            }
            case 124: {
                string = tDMTerminology.getVirtualContainerTerm(4);
                eID = CEMC.EID_FAIL_WIZARD_VALIDATION_PARAM_1;
                objectArray = new Object[]{UnableAllocateMore + string + " matrix ports.\n", "- New circuits must be created using available bandwidth from\n  an existing " + string + " matrix port.\n"};
                break;
            }
            case 125: {
                string = tDMTerminology.getVirtualContainerTerm(3);
                eID = CEMC.EID_FAIL_WIZARD_VALIDATION_PARAM_1;
                objectArray = new Object[]{UnableAllocateMore + string + " matrix ports.\n", "- New circuits must be created using available bandwidth from\n  an existing " + string + " matrix port.\n"};
                break;
            }
            case 126: {
                string = tDMTerminology.getVirtualContainerTerm(1);
                eID = CEMC.EID_FAIL_WIZARD_VALIDATION_PARAM_1;
                objectArray = new Object[]{UnableAllocateMore + string + ".\n", "- All available " + string + " are in use.\n"};
                break;
            }
            case 127: {
                string = tDMTerminology.getVirtualContainerTerm(4);
                eID = CEMC.EID_FAIL_WIZARD_VALIDATION_PARAM_1;
                objectArray = new Object[]{UnableAllocateMore + string + ".\n", "- All available " + string + " are in use.\n"};
                break;
            }
            case 128: {
                string = tDMTerminology.getVirtualContainerTerm(3);
                eID = CEMC.EID_FAIL_WIZARD_VALIDATION_PARAM_1;
                objectArray = new Object[]{UnableAllocateMore + string + ".\n", "- All available " + string + " are in use.\n"};
                break;
            }
            case 152: {
                eID = CEMC.EID_ILLEGAL_PASSWORD_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"The password must contain at least 1 number, \n1 letter & 1 TL1 special character (+ # %)."});
                break;
            }
            case 153: {
                eID = CEMC.EID_ILLEGAL_PASSWORD_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"The password must contain at least 1 number, \n1 letter & 1 special character."});
                break;
            }
            case 154: {
                eID = CEMC.EID_ILLEGAL_PASSWORD_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"The password must contain at least two of each of the following character types: uppercase, lowercase,  and TL1 special characters (+ # %)."});
                break;
            }
            case 155: {
                eID = CEMC.EID_ILLEGAL_PASSWORD_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"The password must contain at least two of each of the following character types: uppercase, lowercase,  and special characters."});
                break;
            }
            case 161: {
                eID = CEMC.EID_ILLEGAL_PASSWORD_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"An invalid character was used in the password."});
                break;
            }
            case 156: {
                eID = CEMC.EID_ILLEGAL_PASSWORD_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"The password is too short."});
                break;
            }
            case 157: {
                eID = CEMC.EID_ILLEGAL_PASSWORD_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"The password is too long."});
                break;
            }
            case 159: {
                eID = CEMC.EID_ILLEGAL_PASSWORD_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"The password may not contain the reverse of the user ID."});
                break;
            }
            case 158: {
                eID = CEMC.EID_ILLEGAL_PASSWORD_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"The password may not contain user ID."});
                break;
            }
            case 160: {
                eID = CEMC.EID_ILLEGAL_PASSWORD_PARAM_1;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"The password contains too many identical consecutive characters."});
                break;
            }
            case 171: {
                eID = EMC.EID_NO_INTERLINK_PORT;
                break;
            }
            case 172: {
                if (stringArray != null && stringArray.length > 0 && stringArray[0].equals("port")) {
                    eID = EMC.EID_CANNOT_DELETE_PARAM;
                    objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"", "because it is part of an ADM peer group"});
                    break;
                }
                if (stringArray != null && stringArray.length > 0 && stringArray[0].equals("interlink")) {
                    eID = EMC.EID_PROVISION_WRONG_ILK_STATE_CHG;
                    break;
                }
                eID = EMC.EID_HAS_PEER_GROUP;
                break;
            }
            case 173: {
                eID = EMC.EID_NOT_IN_PEER_GROUP;
                break;
            }
            case 175: {
                eID = EMC.EID_INVALID_ETHER_DUPLEX;
                break;
            }
            case 176: {
                eID = EMC.EID_INVALID_ETHER_COMMITTED_RATE;
                break;
            }
            case 177: {
                eID = EMC.EID_INVALID_ETHER_SPEED;
                break;
            }
            case 178: {
                eID = EMC.EID_INVALID_ETHER_MTU;
                break;
            }
            case 179: {
                eID = EMC.EID_INVALID_ETHER_MTU_FLOW_CONTROL;
                break;
            }
            case 180: {
                eID = EMC.EID_INVALID_ETHER_NI_MODE;
                break;
            }
            case 181: {
                eID = EMC.EID_INVALID_ETHER_COS_VALUE;
                break;
            }
            case 182: {
                eID = EMC.EID_INVALID_ETHER_TYPE;
                break;
            }
            case 183: {
                eID = EMC.EID_INVALID_ETHER_BUFFER_SIZE;
                break;
            }
            case 184: {
                eID = EMC.EID_INVALID_ETHER_QOS;
                break;
            }
            case 185: {
                eID = EMC.EID_INVALID_ETHER_QINQ_MODE;
                break;
            }
            case 186: {
                eID = EMC.EID_UNSUPPORTED_STP_STATE;
                break;
            }
            case 187: {
                eID = EMC.EID_DATA_MAX_NUM_EXCEEDED;
                break;
            }
            case 188: {
                eID = EMC.EID_INVALID_VLAN;
                break;
            }
            case 189: {
                eID = EMC.EID_INVALID_VLAN_REMAPPING;
                break;
            }
            case 384: {
                eID = EMC.EID_QINQ_RULE_NOT_SUPPORTED;
                break;
            }
            case 190: {
                eID = EMC.EID_DUPLICATED_VLAN;
                break;
            }
            case 191: {
                eID = EMC.EID_VLAN_OUT_OF_RANGE;
                break;
            }
            case 192: {
                eID = EMC.EID_INVALID_VLAN_NAME;
                break;
            }
            case 193: {
                eID = EMC.EID_TOO_MANY_PROTECTED_VLANS;
                break;
            }
            case 237: {
                eID = EMC.EID_TOO_MANY_XLT_VLANS_WITH_MVR;
                break;
            }
            case 238: {
                eID = EMC.EID_TOO_MANY_IGMP_ENABLED;
                break;
            }
            case 349: {
                eID = EMC.EID_IGMP_ALREADY_ENABLED_ON_SVLAN;
                break;
            }
            case 348: {
                eID = EMC.EID_IGMP_ALREADY_ENABLED_ON_CVLAN;
                break;
            }
            case 283: {
                eID = EMC.EID_NOT_USABLE_MVR_SVLAN;
                break;
            }
            case 285: {
                eID = CEMC.EID_LI_INCOMPATIBLE_WITH_ONE_PLUS_ONE;
                break;
            }
            case 194: {
                eID = EMC.EID_VLAN_IN_USE;
                break;
            }
            case 121: {
                eID = EMC.EID_INVALID_ADMIN_STATE;
                break;
            }
            case 386: {
                eID = EMC.EID_BUNDLED_PORT_INVALID_ADMIN_STATE;
                break;
            }
            case 214: {
                eID = EMC.EID_INVALID_PROT_ADMIN_STATE;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{AdminState.getAdminTermDSBLD(tDMTerminology)});
                break;
            }
            case 169: {
                eID = EMC.HAS_LMP_DATA_LINK;
                break;
            }
            case 201: {
                eID = EMC.HAS_NO_CONNECTION;
                break;
            }
            case 162: {
                eID = EMC.EID_PORT_ADMIN_STATE_IN_SERVICE;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{AdminState.getAdminTermIS(tDMTerminology)});
                break;
            }
            case 167: {
                eID = EMC.EID_NO_SUCHINTERFACE;
                break;
            }
            case 117: {
                eID = EMC.EID_NOT_1PLUS1_OPTIMIZED;
                break;
            }
            case 205: {
                eID = EMC.EID_SSM_UNSUPPORTED_IN_SDH_MODE;
                break;
            }
            case 206: {
                eID = EMC.EID_SSM_SUPPORTED_ON_ESF_DS1;
                break;
            }
            case 207: {
                eID = EMC.EID_SEND_DNU_DNU_FF_MUTUALLY_EXCLUSIVE;
                break;
            }
            case 204: {
                eID = EMC.EID_TERMINATION_IN_USE;
                break;
            }
            case 209: {
                eID = EMC.EID_WRONG_PPM_PRESENCE;
                break;
            }
            case 170: {
                eID = EMC.INVALID_RPR_STATION;
                break;
            }
            case 210: {
                eID = EMC.EID_CARD_TOO_BIG;
                break;
            }
            case 212: {
                eID = EMC.EID_BELONG_TO_CONNECTION;
                break;
            }
            case 196: {
                eID = EMC.EID_INVALID_WAVE_LENGTH_CONFIG;
                break;
            }
            case 103: {
                eID = EMC.EID_EQPT_FAILED_OR_MISSING;
                break;
            }
            case 143: {
                eID = EMC.EID_INVALID_SERVER_TRAIL_PATH;
                break;
            }
            case 149: {
                eID = EMC.EID_INVALID_SERVER_TRAIL_PATH;
                break;
            }
            case 138: {
                eID = EMC.EID_DCC_PRESENT;
                break;
            }
            case 141: 
            case 142: {
                eID = EMC.EID_COULD_NOT_GEN_UNIQUE_ID;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"A Server Trail already exists in the node matching the ID and the other attributes requested."});
                break;
            }
            case 144: {
                eID = EMC.EID_SERVER_TRAIL_CROSSES_PORT_BOUNDARY;
                break;
            }
            case 146: 
            case 147: {
                eID = EMC.EID_SERVER_TRAIL_EXISTS;
                break;
            }
            case 218: {
                eID = EMC.EID_USERDEF_ENVALM_IN_USE;
                break;
            }
            case 219: {
                eID = EMC.EID_EXCEED_MAX_USERDEF_ENVALM;
                break;
            }
            case 221: {
                eID = EMC.EID_NOT_HARDCODED_ENVALM_DEL;
                break;
            }
            case 220: {
                eID = EMC.EID_USERDEF_ENVALM_NOT_FOUND;
                break;
            }
            case 217: {
                eID = EMC.EID_USERDEF_ENVALM_PRESENT;
                break;
            }
            case 241: {
                eID = EMC.EID_IPV6_OSPF_MANDATORY_DISABLE;
                break;
            }
            case 242: {
                eID = EMC.EID_IPV6_RIP_MANDATORY_DISABLE;
                break;
            }
            case 243: {
                eID = EMC.EID_IPV6_SOCKS_MANDATORY_ENABLE;
                break;
            }
            case 251: {
                eID = EMC.EID_INVALID_COS_QINQ_MAPPING;
                break;
            }
            case 253: {
                eID = EMC.EID_SHELF_MISMATCH;
                break;
            }
            case 254: {
                eID = EMC.EID_INVALID_TERMINATION;
                break;
            }
            case 255: {
                eID = EMC.EID_OVERHEAD_NOT_SUPP;
                break;
            }
            case 256: {
                eID = EMC.EID_NO_PATCHCORD;
                break;
            }
            case 257: {
                eID = EMC.EID_VL_ON_SAME_PATH;
                break;
            }
            case 258: {
                eID = EMC.EID_CANNOT_CREATE_OV;
                break;
            }
            case 259: {
                eID = EMC.EID_PROTECT_PORT;
                break;
            }
            case 260: {
                eID = EMC.EID_ACTIVE_PORT;
                break;
            }
            case 231: {
                eID = EMC.EID_MISSING_L2_INT_PATCH;
                break;
            }
            case 250: {
                eID = EMC.EID_INVALID_L2_PROT_AIS_ACTION;
                break;
            }
            case 261: {
                eID = EMC.EID_IPV6_ACCESS_CANNOT_BE_DISABLED_IPV4_DISABLED;
                break;
            }
            case 262: {
                eID = EMC.EID_MULTISHELF_CANNOT_BE_ENABLED_IPV4_DISABLED;
                break;
            }
            case 361: {
                eID = EMC.EID_NO_SUCH_SERVER_TRAIL_EXISTS;
                objectArray = EMCProvisionError.setMsgArgs(stringArray, new String[]{"A Server Trail with the requested ID and old peer IP address does not exist"});
                break;
            }
            case 275: {
                eID = EMC.EID_ETH_OSC_MAX;
                break;
            }
            case 300: {
                eID = EMC.EID_REP_PORT_IS_NOT_EDGE;
                break;
            }
            case 295: {
                eID = EMC.EID_REP_VLB_ENABLED;
                break;
            }
            case 294: {
                eID = EMC.EID_REP_VLB_NOT_ENABLED;
                break;
            }
            case 286: {
                eID = EMC.EID_SEGEMENT_MAX_LIMIT_EXCEEDED_ON_EQPT;
                break;
            }
            case 287: {
                eID = EMC.EID_SEGMENT_EAST_WEST_EXISTS;
                break;
            }
            case 290: {
                eID = EMC.EID_INVALID_SEGMENT_ID;
                break;
            }
            case 291: {
                eID = EMC.EID_REP_PORTID_NOT_EXISTS;
                break;
            }
            case 292: {
                eID = EMC.EID_INVALID_TRIGGER_DELAY;
                break;
            }
            case 293: {
                eID = EMC.EID_PORT_NOT_ASSOCIATED_TO_SEGMENT;
                break;
            }
            case 299: {
                eID = EMC.EID_PORT_ASSOCIATED_TO_SEGMENT;
                break;
            }
            case 296: {
                eID = EMC.EID_REP_STCN_ENABLED;
                break;
            }
            case 297: {
                eID = EMC.EID_REP_STCN_NOT_ENABLED;
                break;
            }
            case 301: {
                eID = EMC.EID_NOT_A_REP_PORT;
                break;
            }
            case 302: {
                eID = EMC.EID_SAME_INTERFACE;
                break;
            }
            case 289: {
                eID = EMC.EID_PORT_TYPE_INCOMPATIBLE;
                break;
            }
            case 298: {
                eID = EMC.EID_REP_ENABLED;
                break;
            }
            case 305: {
                eID = EMC.EID_NOT_ON_SAME_SLOT;
                break;
            }
            case 303: {
                eID = EMC.EID_SAME_SEGMENT;
                break;
            }
            case 304: {
                eID = EMC.EID_STCN_PORT_IN_SEGMENT;
                break;
            }
            case 306: {
                eID = EMC.EID_REP_VLB_TRIGGER_FAILED;
                break;
            }
            case 325: {
                eID = EMC.EID_MEP_MIP_CONFIGURED;
                break;
            }
            case 317: {
                eID = CEMC.EID_MA_DOMAIN_ASSOCIATED;
                break;
            }
            case 327: {
                eID = CEMC.EID_EXCEEDED_MAX_MA_PROFILE;
                break;
            }
            case 316: {
                eID = CEMC.EID_MA_PROFILE_EXISTS;
                break;
            }
            case 330: {
                eID = CEMC.EID_PROFILE_NOT_FOUND;
                break;
            }
            case 337: {
                eID = EMC.EID_MA_DOMAIN_NAME_PAIR_EXISTS;
                break;
            }
            case 335: {
                eID = EMC.EID_LI_CONFIGURED_ON_PORT;
                break;
            }
            case 329: {
                eID = CEMC.EID_DOMAIN_NOT_FOUND;
                break;
            }
            case 319: {
                eID = CEMC.EID_EXCEEDED_MAX_DOMAIN_PER_CARD;
                break;
            }
            case 323: {
                eID = CEMC.EID_DOMAIN_NAME_EXIST;
                break;
            }
            case 334: {
                eID = EMC.EID_MPID_LEVEL_VLAN_PAIR_EXISTS;
                break;
            }
            case 339: {
                eID = EMC.EID_VLAN_DOMAIN_PAIR_EXISTS;
                break;
            }
            case 340: {
                eID = EMC.EID_MEP_AT_HIGHER_SAME_LEVEL;
                break;
            }
            case 336: {
                eID = EMC.EID_VLAN_NOT_CONFIGURED_ONPORT;
                break;
            }
            case 343: {
                eID = EMC.EID_EXCEEDED_MAX_MIP;
                break;
            }
            case 341: {
                eID = EMC.EID_MIP_PRESENT;
                break;
            }
            case 324: {
                eID = EMC.EID_MEP_ASSOCIATED;
                break;
            }
            case 342: {
                eID = EMC.EID_MIP_PRESENT;
                break;
            }
            case 333: {
                eID = EMC.EID_MIP_AT_SAME_SMALLER_LEVEL;
                break;
            }
            case 326: {
                eID = EMC.EID_EXCEEDED_MAX_MEP;
                break;
            }
            case 332: {
                eID = EMC.EID_NO_ENTRY_IN_MAPPING_TABLE;
                break;
            }
            case 321: {
                eID = EMC.EID_EXCEEDED_MAX_ATTACH;
                break;
            }
            case 320: {
                eID = EMC.EID_EXCEEDED_MAX_LEN;
                break;
            }
            case 331: {
                eID = EMC.EID_VLAN_LEVEL_PAIR_EXISTS;
                break;
            }
            case 318: {
                eID = EMC.EID_NO_MA_DOMIAN_ASSOCIATION;
                break;
            }
            case 208: {
                eID = EMC.EID_ENTITY_ALREADY_IN_USE;
                break;
            }
            case 309: {
                eID = EMC.EID_CFM_COMMAND_CANCEL_FAILED;
                break;
            }
            case 308: {
                eID = EMC.EID_CFM_COMMAND_RUNNING;
                break;
            }
            case 307: {
                eID = EMC.EID_CFM_COMMAND_NOT_RUNNING;
                break;
            }
            case 311: {
                eID = EMC.EID_CFM_COMMAND_ID_INVALID;
                break;
            }
            case 310: {
                eID = EMC.EID_CFM_COMMAND_TYPE_INVALID;
                break;
            }
            case 313: {
                eID = EMC.EID_CFM_NOT_ENABLED;
                break;
            }
            case 314: {
                eID = EMC.EID_CARD_CFM_NOT_ENABLED;
                break;
            }
            case 328: {
                eID = EMC.EID_EXCEEDED_MAX_CFM_LI_VLAN_LIMIT;
                break;
            }
            case 312: {
                eID = EMC.EID_MAC_SECURITY_ENABLED;
                break;
            }
            case 358: {
                eID = EMC.EID_FRR_INVALID_TRIGGER_WINDOW;
                break;
            }
            case 359: {
                eID = EMC.EID_FRR_INVALID_REVERT_WINDOW;
                break;
            }
            case 360: {
                eID = EMC.EID_FRR_INCOMPATIBLE_THRESHOLD;
                break;
            }
            case 367: {
                eID = EMC.EID_HAS_UDC_VOIP;
                break;
            }
            case 277: {
                eID = EMC.EOAM_EFM_NOT_ENABLED;
                break;
            }
            case 279: {
                eID = EMC.EID_EOAM_EFM_PASSIVE_MODE;
                break;
            }
            case 278: {
                eID = EMC.EOAM_EFM_ENABLED;
                break;
            }
            case 280: {
                eID = EMC.EID_PORT_OOS_DSBLD;
                break;
            }
            case 368: {
                eID = EMC.EID_MAX_CVLAN_RANGES;
                break;
            }
            case 148: {
                eID = CEMC.EID_NOT_SUPPORTED_ON_PROTECT_ENTITY;
                break;
            }
            case 372: {
                eID = EMC.EID_STANDBY_NOT_READY;
                break;
            }
            case 373: {
                eID = EMC.EID_ONGOING_DATABASE_OPER;
                break;
            }
            case 371: {
                eID = EMC.EID_HAS_PATCHCORD_OR_SIDE;
                break;
            }
            case 197: {
                eID = EMC.EID_UNSUPPORTED_WAVE_LENGTH;
                break;
            }
            case 382: {
                eID = EMC.EID_NOT_CONSISTENT_OVERCLOCK_STATE;
                break;
            }
            case 383: {
                eID = EMC.EID_ERROR_CREATING_LOG_PORT;
                break;
            }
            case 211: {
                eID = EMC.EID_FRP_PROTECTION_ENABLED;
                break;
            }
            case 393: {
                eID = EMC.EID_INVALID_ODU_TRANS;
                break;
            }
            default: {
                db.severe("eProvDataError #" + eProvDataError2.value() + " is using a generic error message");
                eID = EMC.EID_GENERIC_PROV_ERROR;
            }
        }
        return new Object[]{eID, objectArray};
    }

    private static Object[] getEIDAndMessageArgs(xAlsConfigError xAlsConfigError2, String[] stringArray, IPlatform iPlatform) {
        EID eID = EMC.EID_GENERIC_PROV_ERROR;
        Object var4_4 = null;
        TDMTerminology tDMTerminology = iPlatform.getTDMTerminology();
        switch (xAlsConfigError2.dataError.value()) {
            case 1: {
                eID = EMC.EID_PROTECT_LINE_NOT_PROV;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                eID = EMC.EID_INVALID_ALS_RECOVERY_INT;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                eID = EMC.EID_INVALID_ALS_RECOVERY_PULSE_WIDTH;
                break;
            }
            case 0: 
            case 8: {
                eID = EMC.EID_UNSUPPORTED_ALS_MODE;
                break;
            }
            case 9: {
                eID = EMC.EID_HAS_PROTECTION;
            }
        }
        return new Object[]{eID, var4_4};
    }

    private static Object[] getEIDAndMessageArgs(xProvisioningError xProvisioningError2, String[] stringArray) {
        EID eID = EMC.EID_GENERIC_PROV_ERROR;
        String[] stringArray2 = null;
        switch (xProvisioningError2.errorCode.value()) {
            case 5: {
                eID = EMC.EID_LOW_GREATER_THAN_HIGH;
                stringArray2 = new String[]{EMC.EID_LOW_GREATER_THAN_HIGH.getMessage()};
                break;
            }
            case 3: {
                eID = EMC.EID_VALUE_OUT_OF_RANGE;
                stringArray2 = new String[]{EMC.EID_VALUE_OUT_OF_RANGE.getMessage()};
            }
        }
        return new Object[]{eID, stringArray2};
    }

    private EMCProvisionError(Object[] objectArray) {
        super((EID)objectArray[0], (Object[])objectArray[1]);
    }

    public EMCProvisionError(xProvisionError xProvisionError2, IPlatform iPlatform) {
        this(EMCProvisionError.getEIDAndMessageArgs(xProvisionError2.dataError, null, iPlatform));
    }

    public EMCProvisionError(xProvisionError xProvisionError2, String[] stringArray, IPlatform iPlatform) {
        this(EMCProvisionError.getEIDAndMessageArgs(xProvisionError2.dataError, stringArray, iPlatform));
    }

    public EMCProvisionError(xProvisionError xProvisionError2, String string, IPlatform iPlatform) {
        this(xProvisionError2.dataError, new String[]{string}, iPlatform);
    }

    public EMCProvisionError(eProvDataError eProvDataError2, IPlatform iPlatform) {
        this(eProvDataError2, null, iPlatform);
    }

    public EMCProvisionError(eProvDataError eProvDataError2, String[] stringArray, IPlatform iPlatform) {
        this(EMCProvisionError.getEIDAndMessageArgs(eProvDataError2, stringArray, iPlatform));
    }

    public EMCProvisionError(xAlsConfigError xAlsConfigError2, IPlatform iPlatform) {
        this(EMCProvisionError.getEIDAndMessageArgs(xAlsConfigError2, null, iPlatform));
    }

    public EMCProvisionError(xAlsConfigError xAlsConfigError2, String[] stringArray, IPlatform iPlatform) {
        this(EMCProvisionError.getEIDAndMessageArgs(xAlsConfigError2, stringArray, iPlatform));
    }

    public EMCProvisionError(xAlsConfigError xAlsConfigError2, String string, IPlatform iPlatform) {
        this(xAlsConfigError2, new String[]{string}, iPlatform);
    }

    public EMCProvisionError(xProvisioningError xProvisioningError2) {
        this(EMCProvisionError.getEIDAndMessageArgs(xProvisioningError2, null));
    }
}

