/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.EtherMedia.eGigEtherOptics;
import cerent.cms.idl.EtherMedia.eTransponderMode;
import cerent.cms.idl.EtherMedia.sGmacLineAdminInfo_4_01;
import cerent.cms.idl.EtherMedia.sGmacLineInfo;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.HdGePortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.SDebug;
import cerent.util.UObservable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public class HdGeModuleModel
extends ModuleModel {
    private TransponderChangeNotifier transponderChangeNotifier;
    private GBICChangeNotifier gbicChangeNotifier;

    public HdGeModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(HdGeModuleModel.class));
        this.index = n;
        this.transponderChangeNotifier = new TransponderChangeNotifier();
        this.gbicChangeNotifier = new GBICChangeNotifier();
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose() called.");
        }
        this.transponderChangeNotifier.dispose();
        this.gbicChangeNotifier.dispose();
        if (this.db.on()) {
            this.db.println("dispose() complete.");
        }
        super.dispose();
    }

    @Override
    public List getConnectionsList() {
        LinkedList linkedList = new LinkedList();
        HdGePortModel[] hdGePortModelArray = null;
        hdGePortModelArray = this.getHdGeChildren();
        if (hdGePortModelArray != null) {
            linkedList = new LinkedList();
            for (int i = 0; i < hdGePortModelArray.length; ++i) {
                List list = hdGePortModelArray[i].getConnectionsList();
                if (list == null) continue;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    linkedList.add(iterator.next());
                }
            }
        }
        return linkedList;
    }

    public HdGePortModel[] getHdGeChildren() {
        return this.getChildren().toArray(new HdGePortModel[0]);
    }

    @Override
    public String toString() {
        return "HdGe" + super.toString();
    }

    public boolean isBoxster() {
        String string = this.getMfgData().extraInfo;
        return string.indexOf("2.5G=Y") != -1;
    }

    public boolean isTransponder() {
        boolean bl;
        block3: {
            HdGePortModel[] hdGePortModelArray = this.getHdGeChildren();
            bl = false;
            try {
                for (int i = 0; i < hdGePortModelArray.length && !bl; ++i) {
                    bl = hdGePortModelArray[i].getHdGeLineModel().isTransponder();
                }
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!this.db.on()) break block3;
                this.db.println("HdGeLineModel not found in InterfacesModels.");
            }
        }
        return bl;
    }

    public TransponderChangeNotifier getTransponderChangeNotifier() {
        this.transponderChangeNotifier.init();
        return this.transponderChangeNotifier;
    }

    public GBICChangeNotifier getGBICChangeNotifier() {
        this.gbicChangeNotifier.init();
        return this.gbicChangeNotifier;
    }

    @Override
    public String getEqTypeName() {
        if (this.getEqType() != 62) {
            return super.getEqTypeName();
        }
        String string = "G1000";
        if (this.isTransponder()) {
            string = string + " (TXP)";
        }
        return string;
    }

    public InterfaceModel[] getLines() {
        HdGePortModel[] hdGePortModelArray = this.getHdGeChildren();
        HdGeLineModel[] hdGeLineModelArray = new HdGeLineModel[hdGePortModelArray.length];
        for (int i = 0; i < hdGePortModelArray.length; ++i) {
            hdGeLineModelArray[i] = hdGePortModelArray[i].getHdGeLineModel();
        }
        return hdGeLineModelArray;
    }

    public class GBICChangeNotifier
    extends UObservable
    implements Observer {
        private HdGePortModel[] ports;
        private HdGeLineModel[] observedLines;
        private Map gbicData;
        private boolean inited = false;
        private sGmacLineInfo lineInfo;

        public void init() {
            if (!this.inited) {
                this.gbicData = new HashMap();
                this.ports = HdGeModuleModel.this.getHdGeChildren();
                this.observedLines = new HdGeLineModel[this.ports.length];
                for (int i = 0; i < this.ports.length; ++i) {
                    this.observedLines[i] = this.ports[i].getHdGeLineModel();
                    this.observedLines[i].addObserver(this);
                    try {
                        this.lineInfo = this.observedLines[i].getGmacLineInfo();
                        this.gbicData.put(new Integer(i), this.lineInfo.opticsType);
                        continue;
                    }
                    catch (CTCUserException cTCUserException) {
                        if (HdGeModuleModel.this.db.on()) {
                            SDebug.printStackTrace((Throwable)cTCUserException);
                        }
                        return;
                    }
                }
            }
            this.inited = true;
            if (HdGeModuleModel.this.db.on()) {
                HdGeModuleModel.this.db.println("GBIC observer inited.");
                HdGeModuleModel.this.db.println(this.gbicData());
            }
        }

        private String gbicData() {
            StringBuffer stringBuffer = new StringBuffer();
            for (Object k : this.gbicData.keySet()) {
                stringBuffer.append("Port " + k + " has GBIC " + ((eGigEtherOptics)this.gbicData.get(k)).value() + "\n");
            }
            return stringBuffer.toString();
        }

        public Map getCurrentGBICs() {
            if (this.inited) {
                return new HashMap(this.gbicData);
            }
            return new HashMap();
        }

        public void dispose() {
            if (HdGeModuleModel.this.db.on()) {
                HdGeModuleModel.this.db.println("GBICChangeNotifier.dispose() called.");
            }
            if (this.inited) {
                for (int i = 0; i < this.observedLines.length; ++i) {
                    if (this.observedLines[i] == null) continue;
                    this.observedLines[i].deleteObserver(this);
                }
            }
            this.gbicData = null;
            this.ports = null;
            this.observedLines = null;
            this.inited = false;
        }

        @Override
        public void update(Observable observable, Object object) {
            if (observable instanceof HdGeLineModel && object.equals(ModelUpdateType.CHANGED)) {
                this.findChange();
            }
        }

        private void findChange() {
            HashMap<Integer, eGigEtherOptics> hashMap = new HashMap<Integer, eGigEtherOptics>();
            for (int i = 0; i < this.observedLines.length; ++i) {
                try {
                    this.lineInfo = this.observedLines[i].getGmacLineInfo();
                    hashMap.put(new Integer(i), this.lineInfo.opticsType);
                    continue;
                }
                catch (CTCUserException cTCUserException) {
                    if (!HdGeModuleModel.this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
            }
            if (!((Object)hashMap).equals(this.gbicData)) {
                this.gbicData = hashMap;
                this.notifyObservers(new HashMap(this.gbicData));
                if (HdGeModuleModel.this.db.on()) {
                    HdGeModuleModel.this.db.println(this.gbicData());
                }
            }
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }
    }

    public class TransponderChangeNotifier
    extends UObservable
    implements Observer {
        private HdGePortModel[] observedPorts;
        private sGmacLineAdminInfo_4_01[] currentRawTransponderSettings;
        private Set currentTransponderSettings;
        private boolean inited = false;
        private Collection message;

        public void init() {
            if (!this.inited) {
                this.currentTransponderSettings = new HashSet();
                this.observedPorts = HdGeModuleModel.this.getHdGeChildren();
                this.currentRawTransponderSettings = new sGmacLineAdminInfo_4_01[this.observedPorts.length];
                HdGeLineModel hdGeLineModel = null;
                for (int i = 0; i < this.observedPorts.length; ++i) {
                    try {
                        hdGeLineModel = this.getHdGeLineModel(i);
                        if (hdGeLineModel == null) continue;
                        hdGeLineModel.addObserver(this);
                        this.currentRawTransponderSettings[i] = hdGeLineModel.getGmacLineAdminInfo_4_01();
                        this.currentTransponderSettings.add(new sGmacLineAdminInfo_4_01_Key(hdGeLineModel.getIndex(), this.currentRawTransponderSettings[i]));
                        continue;
                    }
                    catch (CTCUserException cTCUserException) {
                        if (HdGeModuleModel.this.db.on()) {
                            SDebug.printStackTrace((Throwable)cTCUserException);
                        }
                        return;
                    }
                }
                this.eliminateDuplicates();
            }
            this.inited = true;
        }

        public sGmacLineAdminInfo_4_01[] getCurrentTransponderSettings() {
            return this.currentRawTransponderSettings;
        }

        public void dispose() {
            if (HdGeModuleModel.this.db.on()) {
                HdGeModuleModel.this.db.println("TransponderChangeNotifier.dispose() called.");
            }
            if (this.inited) {
                HdGeLineModel hdGeLineModel = null;
                for (int i = 0; i < this.observedPorts.length; ++i) {
                    hdGeLineModel = this.getHdGeLineModel(i);
                    if (hdGeLineModel != null) {
                        hdGeLineModel.deleteObserver(this);
                    }
                    this.observedPorts[i] = null;
                    this.currentRawTransponderSettings[i] = null;
                }
            }
            this.currentTransponderSettings = null;
            this.observedPorts = null;
            this.inited = false;
        }

        @Override
        public synchronized void update(Observable observable, Object object) {
            if (observable instanceof HdGeLineModel && object.equals(ModelUpdateType.CHANGED)) {
                this.findChange();
            }
        }

        private HdGeLineModel getHdGeLineModel(int n) {
            HdGeLineModel hdGeLineModel;
            block3: {
                hdGeLineModel = null;
                try {
                    if (n >= 0 && n < this.observedPorts.length && this.observedPorts[n] != null) {
                        hdGeLineModel = this.observedPorts[n].getHdGeLineModel();
                    }
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                    if (!HdGeModuleModel.this.db.on()) break block3;
                    HdGeModuleModel.this.db.println("HdGeLineModel not found in InterfacesModels.");
                }
            }
            return hdGeLineModel;
        }

        private void findChange() {
            HashSet<sGmacLineAdminInfo_4_01_Key> hashSet = new HashSet<sGmacLineAdminInfo_4_01_Key>();
            HdGeLineModel hdGeLineModel = null;
            for (int i = 0; i < this.observedPorts.length; ++i) {
                try {
                    hdGeLineModel = this.getHdGeLineModel(i);
                    if (hdGeLineModel == null) continue;
                    this.currentRawTransponderSettings[i] = hdGeLineModel.getGmacLineAdminInfo_4_01();
                    hashSet.add(new sGmacLineAdminInfo_4_01_Key(hdGeLineModel.getIndex(), this.currentRawTransponderSettings[i]));
                    continue;
                }
                catch (CTCUserException cTCUserException) {
                    if (!HdGeModuleModel.this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
            }
            if (!((Object)hashSet).equals(this.currentTransponderSettings)) {
                this.currentTransponderSettings = hashSet;
                this.eliminateDuplicates();
                this.notifyObservers(this.message);
            }
        }

        private void eliminateDuplicates() {
            HashSet hashSet = new HashSet(this.currentTransponderSettings);
            this.message = new ArrayList();
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            Iterator iterator = hashSet.iterator();
            sGmacLineAdminInfo_4_01_Key sGmacLineAdminInfo_4_01_Key2 = null;
            Integer n = null;
            while (iterator.hasNext()) {
                sGmacLineAdminInfo_4_01_Key2 = (sGmacLineAdminInfo_4_01_Key)iterator.next();
                Integer n2 = new Integer(sGmacLineAdminInfo_4_01_Key2.getIndex());
                n = new Integer(sGmacLineAdminInfo_4_01_Key2.getValue().transpondingInterface);
                if (hashSet2.contains(n2) || hashSet2.contains(n)) {
                    iterator.remove();
                    continue;
                }
                hashSet2.add(n2);
                hashSet2.add(n);
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.message.add(iterator.next());
            }
        }

        public Collection getCurrentTransponderPairingsWithoutDuplicates() {
            return new ArrayList(this.message);
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }
    }

    public static class sGmacLineAdminInfo_4_01_Key {
        public sGmacLineAdminInfo_4_01 value;
        public int ifIndex;
        public int transpondingInterface;
        public eTransponderMode mode;

        public sGmacLineAdminInfo_4_01_Key(int n, sGmacLineAdminInfo_4_01 sGmacLineAdminInfo_4_012) {
            this.value = sGmacLineAdminInfo_4_012;
            if (sGmacLineAdminInfo_4_012.mode == eTransponderMode.TRANSPONDER_NONE) {
                sGmacLineAdminInfo_4_012.transpondingInterface = n;
            }
            this.transpondingInterface = this.value.transpondingInterface;
            this.mode = this.value.mode;
            this.ifIndex = n;
        }

        public int getIndex() {
            return this.ifIndex;
        }

        public sGmacLineAdminInfo_4_01 getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object instanceof sGmacLineAdminInfo_4_01_Key) {
                sGmacLineAdminInfo_4_01_Key sGmacLineAdminInfo_4_01_Key2 = (sGmacLineAdminInfo_4_01_Key)object;
                return sGmacLineAdminInfo_4_01_Key2.transpondingInterface == this.transpondingInterface && sGmacLineAdminInfo_4_01_Key2.mode.equals(this.mode) && sGmacLineAdminInfo_4_01_Key2.ifIndex == this.ifIndex;
            }
            return false;
        }

        public int hashCode() {
            return 5 * this.ifIndex + 17 * this.transpondingInterface + 37 * this.mode.hashCode();
        }

        public String toString() {
            return "Port " + this.ifIndex + " is in tranponder mode with port " + this.transpondingInterface + " in mode " + this.mode.value();
        }
    }
}

