/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractPersistableModelState;
import cerent.cms.model.DeletionToken;
import cerent.cms.model.IModelPersistenceConstants;
import cerent.cms.model.LRUManager;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.PersistableModel;
import cerent.cms.model.PersistenceException;
import cerent.cms.model.StateBatchInfo;
import cerent.util.ISequenceNumberConstants;
import cerent.util.SDebug;

public class InterfaceLRUHandler
extends LRUManager.AbstractLRUObjectHandler {
    static final int BATCH_SIZE = IModelPersistenceConstants.BATCH_SIZE;
    private static final Long UNINITIALIZED_SEQ_NUM_OBJ = ISequenceNumberConstants.UNINITIALIZED_SEQ_NUM_OBJ;
    private static NodeSingletonFactory<InterfaceLRUHandler> sfactory = new NodeSingletonFactory<InterfaceLRUHandler>(InterfaceLRUHandler.class);
    private StateBatchInfo[] batch = new StateBatchInfo[BATCH_SIZE];
    private int batchIndex;
    private static SDebug db = new SDebug("InterfaceLRUHandler");

    private InterfaceLRUHandler(NodeModelDelegate nodeModelDelegate) {
        this();
    }

    private InterfaceLRUHandler() {
        for (int i = 0; i < this.batch.length; ++i) {
            this.batch[i] = new StateBatchInfo();
        }
    }

    public static InterfaceLRUHandler instance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    @Override
    public int handleLRUObject(Object object, Long l) {
        if (object == null) {
            if (l != UNINITIALIZED_SEQ_NUM_OBJ) {
                db.println("warning: handleLRUObject was passed a null");
                SDebug.printStackTrace((Throwable)new Exception());
                return 1;
            }
            if (db.isFinerEnabled()) {
                db.finer("got the 'end of LRU management cycle' signal");
            }
            this.processBatchIfNeeded(null);
            return 0;
        }
        int n = 0;
        if (object instanceof AbstractPersistableModelState) {
            AbstractPersistableModelState abstractPersistableModelState = (AbstractPersistableModelState)object;
            PersistableModel persistableModel = abstractPersistableModelState.getModel();
            if (persistableModel != null) {
                int n2 = persistableModel.getModelType(abstractPersistableModelState);
                if (db.on()) {
                    db.println("preparing to flush: " + abstractPersistableModelState.displayid() + " - " + n2 + "/" + (l == UNINITIALIZED_SEQ_NUM_OBJ ? "uninit" : l.toString()));
                }
                StateBatchInfo stateBatchInfo = this.batch[this.batchIndex];
                stateBatchInfo.init(n2, l, persistableModel);
                this.processBatchIfNeeded(stateBatchInfo);
            } else if (db.on()) {
                db.println("disassociated IF model state: " + abstractPersistableModelState.displayid());
            }
        } else if (object instanceof DeletionToken) {
            this.processBatchIfNeeded(null);
            DeletionToken deletionToken = (DeletionToken)object;
            try {
                deletionToken.delete();
            }
            catch (PersistenceException persistenceException) {
                if (db.on()) {
                    db.println("deletion error: " + persistenceException.getMessage() + " for " + deletionToken);
                }
            }
        } else if (object != null && db.on()) {
            db.println("attempting to handle unknown type: " + object.getClass().getName());
        }
        return n;
    }

    private void processBatchIfNeeded(StateBatchInfo stateBatchInfo) {
        if (stateBatchInfo != null && this.batchIndex < this.batch.length) {
            ++this.batchIndex;
        }
        if (stateBatchInfo == null && this.batchIndex > 0 || this.batchIndex == this.batch.length) {
            int n;
            if (db.on()) {
                n = 0;
                for (int i = 0; i < this.batch.length; ++i) {
                    if (this.batch[i].doSkip) continue;
                    ++n;
                }
                db.println("batch of size: " + n + " flushed");
            }
            PersistableModel.batchFlush(this.batch);
            for (n = 0; n < this.batchIndex; ++n) {
                this.batch[n].clear();
            }
            this.batchIndex = 0;
        }
    }
}

