/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.IFvServiceState;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eEdAdminStateCmd;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.eProtectionRole;
import cerent.cms.idl.Common.eReach;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Common.sStsInfo;
import cerent.cms.idl.Dwdm.Client;
import cerent.cms.idl.Dwdm.General;
import cerent.cms.idl.Dwdm.eClientOpticsVariant;
import cerent.cms.idl.Dwdm.sLaserThresholds;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.If.eALSMode;
import cerent.cms.idl.If.eIfType;
import cerent.cms.idl.If.eLaserStatus;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.idl.If.eOSRIStatus;
import cerent.cms.idl.If.sALSAttributes;
import cerent.cms.idl.If.sIfAttributes;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.sOctetStats;
import cerent.cms.idl.If.sOpticsCurrentValues;
import cerent.cms.idl.If.sOpticsPmStats;
import cerent.cms.idl.If.sPacketStats;
import cerent.cms.idl.If.xAlsConfigError;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xInvalidALSMode;
import cerent.cms.idl.If.xInvalidSoakTime;
import cerent.cms.idl.If.xInvalidState;
import cerent.cms.idl.If.xLoopbackActive;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xSyncProvBusy;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.SonetMedia.sVtInfo;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractPersistableModelState;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ExternalInitializationRequired;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModelPersistenceStrategy;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.ISlotNumAccessor;
import cerent.cms.model.ISupportsOpticsProvExtModel;
import cerent.cms.model.ITdmHoModel;
import cerent.cms.model.ITdmLoModel;
import cerent.cms.model.InterfaceAttrs;
import cerent.cms.model.InterfaceLRUHandler;
import cerent.cms.model.InterfaceModelTypeUtil;
import cerent.cms.model.InterfaceModels;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidALSMode;
import cerent.cms.model.InvalidSoakTime;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LRUManager;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PersistableModel;
import cerent.cms.model.PersistenceException;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.SingleStateTypePersistableModel;
import cerent.cms.model.SlotModel;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.util.ComparisonUtil;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.id.INetwideModelTypeIdentity;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public abstract class InterfaceModel
extends SingleStateTypePersistableModel
implements IFvInterfaceModel,
IInterfaceModel,
ISlotNumAccessor,
Comparable {
    static final String SYNCPROV_ERROR_MSG = "Cannot change configuration. The port is used as the system clock source by manual/force switch.";
    static final short NO_SLOT = -1;
    static final short NO_SHELF = -1;
    private short slotNum = (short)-1;
    private short shelfNum = (short)-1;
    private AbstractPersistableModelState attrs;
    private CurrentlyActive currentlyActive;
    private ProtectionRole protectionRole;
    private CurrentValuesForTNC currentValuesForTNC;
    private ALSAttributesforTNC alsAttrsforTNC;
    private LaserStatus laserStatus;
    protected static final int HIGHERS_EVALED_BIT_INDEX = PersistableModel.getLowestStateBitIndexAvailable();
    protected static final int LOWERS_EVALED_BIT_INDEX = HIGHERS_EVALED_BIT_INDEX + 1;
    private static final int[] IntArrayTemplate = new int[0];
    private int ifIndex;
    private AdminState adminState;
    private CoordinatedMaintState coordinatedMaintState;
    private AinsSoakTime soakTime;
    private AinsSoakTimeCountdown soakTimeLeft;
    private OctetStats octetStats;
    private PacketStats packetStats;
    protected NodeModelDelegate node;
    private String dbName;
    private String _stringStart;
    private String _stringEnd;
    private String _indexString;
    private EventDispatcher _dispatcher;
    private RestartLaser restartLaser;
    private LaserTCAThresholdsForTNC laserTCAThresholdsForTNC;
    private LaserAlmThresholdsForTNC laserAlmThresholdsforTNC;
    private OSRI osri;
    private OpticsStatsForTNC opticsStatsForTNC;
    private DownstreamAis downstreamAis;
    private eIfType _ifType;
    private String _descr;
    private static final float ALS_PULSE_WIDTH = 10.0f;

    public InterfaceModel(NodeModelDelegate nodeModelDelegate, int n, SDebug sDebug) {
        this(nodeModelDelegate, n, null, sDebug);
    }

    public InterfaceModel(NodeModelDelegate nodeModelDelegate, int n) {
        this(nodeModelDelegate, n, null, nodeModelDelegate.getChildDebug(InterfaceModel.class));
    }

    public InterfaceModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2, SDebug sDebug) {
        super(sDebug);
        this.node = nodeModelDelegate;
        this.dbName = nodeModelDelegate.dbName();
        this.ifIndex = n;
        this._indexString = Integer.toHexString(n);
        this._dispatcher = nodeModelDelegate.getDispatcher();
        this._stringStart = null;
        this._stringEnd = null;
        super.init0();
        this.adminState = new AdminState(nodeModelDelegate, "InterfaceModel.adminState");
        this.soakTime = new AinsSoakTime(nodeModelDelegate, "InterfaceModel.soakTime");
        this.soakTimeLeft = new AinsSoakTimeCountdown(nodeModelDelegate, "InterfaceModel.soakTimeLeft");
        this.octetStats = new OctetStats(nodeModelDelegate, "InterfaceModel.octetStats");
        this.packetStats = new PacketStats(nodeModelDelegate, "InterfaceModel.packetStats");
        this.restartLaser = new RestartLaser("restartLaser", nodeModelDelegate);
        this.downstreamAis = new DownstreamAis(nodeModelDelegate, "InterfaceModel.downstreamAis");
        this.currentlyActive = new CurrentlyActive(nodeModelDelegate, "InterfaceModel::currentlyActive");
        this.protectionRole = new ProtectionRole(nodeModelDelegate, "InterfaceModel::getLineProtectionRole");
        this.laserAlmThresholdsforTNC = new LaserAlmThresholdsForTNC("InterfaceModel.laserAlmThresholdsforTNC", nodeModelDelegate);
        this.laserTCAThresholdsForTNC = new LaserTCAThresholdsForTNC("InterfaceModel.laserTCAThresholdsForTNC", nodeModelDelegate);
        this.osri = new OSRI(nodeModelDelegate, "InterfaceModel.osri");
        this.alsAttrsforTNC = new ALSAttributesforTNC(nodeModelDelegate, "InterfaceModel.alsAttrsforTNC");
        this.laserStatus = new LaserStatus(nodeModelDelegate, "InterfaceModel.LaserStatus");
        this.currentValuesForTNC = new CurrentValuesForTNC(nodeModelDelegate, "InterfaceMode.currentValuesForTNC");
        this.opticsStatsForTNC = new OpticsStatsForTNC("InterfaceModel.opticsStatsForTNC", nodeModelDelegate);
        this.coordinatedMaintState = new CoordinatedMaintState(nodeModelDelegate, "InterfaceModel::setCoordinateMaintState");
        if (this._dispatcher != null) {
            this._dispatcher.addObserver(ObjectType.ObjectInterface, this.getIndex(), (Observer)this);
        }
        if (this.db.on) {
            this.db.println(this.dbName + "constructor: exit");
        }
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    @Override
    public int getIndex() {
        return this.ifIndex;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.node;
    }

    public void addHigherLayerModel(IInterfaceModel iInterfaceModel) {
    }

    public InterfaceModel[] getHigherLayerModels() {
        return this.getModelsFromIndexes(this.getHigherLayerIndexes_new());
    }

    public IInterfaceModel[] getHigherLayerModelsForNet() {
        return this.getModelsFromIndexes(this.getHigherLayerIndexes_new());
    }

    protected int[] getHigherLayerIndexes() throws NoSuchInterface {
        try {
            int[] nArray = (int[])this.getHigherLayerIndexesCV().get();
            if (this.db.on()) {
                this.db.println("getHigherLayerIndexes(): [for " + this._indexString + "]higherLayerIndexes.length = " + nArray.length);
                if (nArray.length > 0) {
                    String string = "    ";
                    string = string + Integer.toHexString(nArray[0]);
                    for (int i = 1; i < nArray.length; ++i) {
                        string = string + ", " + Integer.toHexString(nArray[i]);
                    }
                    this.db.println(string);
                }
            }
            return nArray;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getHigherLayerIndexes", userException);
        }
    }

    public sLaserThresholds getOpticsTCAThresholdsForTNC(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            return (sLaserThresholds)this.laserTCAThresholdsForTNC.get(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsTCAThresholds", userException);
        }
    }

    public void setOpticsTCAThresholdsForTNC(sLaserThresholds sLaserThresholds2, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{sLaserThresholds2, eIntervalType2};
            this.laserTCAThresholdsForTNC.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOpticsTCAThresholds", userException);
        }
    }

    public sLaserThresholds getOpticsAlmThresholdsForTNC() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            return (sLaserThresholds)this.laserAlmThresholdsforTNC.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsTCAThresholds", userException);
        }
    }

    public void setOpticsAlmThresholdsForTNC(sLaserThresholds sLaserThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.laserAlmThresholdsforTNC.set(sLaserThresholds2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOpticsTCAThresholds", userException);
        }
    }

    public int[] getHigherLayerIndexes_new() {
        int[] nArray = IntArrayTemplate;
        try {
            nArray = this.getHigherLayerIndexes();
        }
        catch (NoSuchInterface noSuchInterface) {
            // empty catch block
        }
        return nArray;
    }

    public int[] getLowerLayerIndexes_new() {
        int[] nArray = IntArrayTemplate;
        try {
            nArray = this.getLowerLayerIndexes();
        }
        catch (NoSuchInterface noSuchInterface) {
            // empty catch block
        }
        return nArray;
    }

    private void setLowerLayerIndexes_new(int[] nArray, long l) {
        this.getLowerLayerIndexesCV().setValueExternally(nArray, l);
    }

    private void setHigherLayerIndexes_new(int[] nArray, long l) {
        this.getHigherLayerIndexesCV().setValueExternally(nArray, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getHigherLayerModels(Collection collection, IModel iModel) {
        Object object;
        TreeSet<InterfaceModel> treeSet = new TreeSet<InterfaceModel>();
        List<InterfaceModel> list = null;
        if (collection == null) {
            return treeSet;
        }
        if (iModel == null || !iModel.getClass().getClassLoader().equals(InterfaceModel.class.getClassLoader())) {
            String string = "non-conformant lock object: " + iModel + " attempted. Must be an instance of an IModel from the desired NMD";
            throw new IllegalArgumentException(string);
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)iModel.getNodeModel();
        Object object2 = object = nodeModelDelegate.getIfModels().getNeHigherLayerModelsLock();
        synchronized (object2) {
            for (Object e : collection) {
                if (!(e instanceof InterfaceModel)) continue;
                list = Arrays.asList(((InterfaceModel)e).getHigherLayerModels());
                treeSet.addAll(list);
            }
        }
        return treeSet;
    }

    public IFvInterfaceModel[] getTheHigherLayerModels() {
        InterfaceModel[] interfaceModelArray = this.getHigherLayerModels();
        IFvInterfaceModel[] iFvInterfaceModelArray = new IFvInterfaceModel[interfaceModelArray.length];
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            iFvInterfaceModelArray[i] = interfaceModelArray[i];
        }
        return iFvInterfaceModelArray;
    }

    public static Collection getHigherLayerModels(InterfaceModel[] interfaceModelArray, int n, IModel iModel) {
        Collection<Object> collection = new TreeSet();
        if (iModel == null || !iModel.getClass().getClassLoader().equals(InterfaceModel.class.getClassLoader())) {
            String string = "non-conformant lock object: " + iModel + " attempted. Must be an instance of an IModel from the desired NMD";
            throw new IllegalArgumentException(string);
        }
        if (interfaceModelArray != null) {
            collection = Arrays.asList(interfaceModelArray);
            for (int i = 0; i < n && collection.size() > 0; ++i) {
                collection = InterfaceModel.getHigherLayerModels(collection, iModel);
            }
        }
        return collection;
    }

    public InterfaceModel[] getLowerLayerModels() {
        return this.getModelsFromIndexes(this.getLowerLayerIndexes_new());
    }

    public IInterfaceModel[] getLowerLayerModelsForNet() {
        return this.getModelsFromIndexes(this.getLowerLayerIndexes_new());
    }

    public InterfaceModel getFirstLowerLayerModels() {
        InterfaceModel[] interfaceModelArray = this.getLowerLayerModels();
        if (interfaceModelArray != null && interfaceModelArray.length > 0) {
            return interfaceModelArray[0];
        }
        return null;
    }

    protected int[] getLowerLayerIndexes() throws NoSuchInterface {
        try {
            int[] nArray = (int[])this.getLowerLayerIndexesCV().get();
            if (this.db.on()) {
                this.db.println("getLowerLayerIndexes(): [for " + this._indexString + "]lowerLayerIndexes.length = " + nArray.length);
                if (nArray.length > 0) {
                    String string = "    ";
                    string = string + Integer.toHexString(nArray[0]);
                    for (int i = 1; i < nArray.length; ++i) {
                        string = string + ", " + Integer.toHexString(nArray[i]);
                    }
                    this.db.println(string);
                }
                this.db.println("");
            }
            return nArray;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getLowerLayerIndexes", userException);
        }
    }

    private InterfaceModel getIfModel(int n) throws NoSuchInterface {
        return this.getNodeModelDelegate().getIfModels().getInterfaceModel(n);
    }

    private InterfaceModel[] getModelsFromIndexes(int[] nArray) {
        ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>();
        for (int i = 0; i < nArray.length; ++i) {
            try {
                InterfaceModel interfaceModel = this.getIfModel(nArray[i]);
                if (interfaceModel == null) continue;
                arrayList.add(interfaceModel);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                this.db.println("In getModelsFromIndexes, can't find indexes[" + i + "] = " + nArray[i]);
            }
        }
        return arrayList.toArray(new InterfaceModel[arrayList.size()]);
    }

    public String getAlias() throws NoSuchInterface {
        try {
            return (String)this.getAliasCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAlias", userException);
        }
    }

    public void setAlias(String string) throws NoSuchInterface {
        try {
            this.getAliasCV().set(string);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setAlias", userException);
        }
    }

    public sInterface getInfo() throws NoSuchInterface {
        try {
            return (sInterface)this.getInfoCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getInfo", userException);
        }
    }

    public eAdminState getAdminStateEnum() throws NoSuchInterface {
        return this.getInfo().adminState;
    }

    public sServiceState getServiceState() throws NoSuchInterface {
        return this.getInfo().serviceState;
    }

    public IServiceState getServiceSt() throws NoSuchInterface {
        return ServiceStateFactory.getServiceState(this.getServiceState());
    }

    public IFvServiceState getIFvServiceState() throws NoSuchInterface {
        return this.getServiceSt();
    }

    public int getAdminState() throws NoSuchInterface {
        eAdminState eAdminState2 = this.getAdminStateEnum();
        return eAdminState2 == null ? -1 : eAdminState2.value();
    }

    public int getSoakTime() throws NoSuchInterface {
        return this.getInfo().ainsSoakTime;
    }

    public boolean getFacLoopbackAis() throws NoSuchInterface {
        return this.getInfo().facLoopbackAIS;
    }

    public void setFacLoopbackAis(boolean bl) throws NoSuchInterface, LoopbackActive, UnsupportedOperation {
        try {
            Object[] objectArray = new Object[]{eLoopback.from_int(2), new Boolean(bl)};
            this.downstreamAis.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xLoopbackActive xLoopbackActive2) {
            throw new LoopbackActive((UserException)xLoopbackActive2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setFacLoopbackAis", userException);
        }
    }

    public boolean getTermLoopbackAis() throws NoSuchInterface {
        return this.getInfo().termLoopbackAIS;
    }

    public void setTermLoopbackAis(boolean bl) throws NoSuchInterface, LoopbackActive, UnsupportedOperation {
        try {
            Object[] objectArray = new Object[]{eLoopback.from_int(1), new Boolean(bl)};
            this.downstreamAis.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xLoopbackActive xLoopbackActive2) {
            throw new LoopbackActive((UserException)xLoopbackActive2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setTermLoopbackAis", userException);
        }
    }

    public void setAdminState(eAdminState eAdminState2) throws NoSuchInterface, LoopbackActive, UnsupportedOperation, SyncProvError, InvalidState, ProvisionError {
        try {
            eAdminState eAdminState3 = eAdminState2;
            this.adminState.set(eAdminState3);
        }
        catch (xLoopbackActive xLoopbackActive2) {
            throw new LoopbackActive((UserException)xLoopbackActive2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xSyncProvBusy xSyncProvBusy2) {
            throw new SyncProvError(SYNCPROV_ERROR_MSG);
        }
        catch (xInvalidState xInvalidState2) {
            String string = this.node.getTDMTerminology().getTermForAdminState(this.getAdminState());
            String string2 = this.node.getTDMTerminology().getTermForAdminState(eAdminState2.value());
            throw new InvalidState("You cannot change the Admin State from " + string + " to " + string2 + ".");
        }
        catch (xProvisionError xProvisionError2) {
            ModuleModel moduleModel = null;
            try {
                moduleModel = this.getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
            if (moduleModel != null && moduleModel instanceof DwdmModuleModel && ((DwdmModuleModel)moduleModel).isADMCard()) {
                throw new EMCProvisionError(xProvisionError2, "interlink", this.node.getPlatform());
            }
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setAdminState", userException);
        }
    }

    public void setCoordinateMaintState(boolean bl) throws NoSuchInterface, UnsupportedOperation {
        try {
            this.coordinatedMaintState.set(new Object[]{new Integer(this.getIndex()), new Boolean(bl)});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setCoordinateMaintState", userException);
        }
    }

    public void setAdminState(int n) throws NoSuchInterface, LoopbackActive, UnsupportedOperation, SyncProvError, InvalidState, ProvisionError {
        this.setAdminState(eAdminState.from_int(n));
    }

    public void setSoakTime(int n) throws InvalidSoakTime {
        try {
            Integer n2 = new Integer(n);
            this.soakTime.set(n2);
        }
        catch (xInvalidSoakTime xInvalidSoakTime2) {
            throw new InvalidSoakTime((UserException)xInvalidSoakTime2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSoakTime", userException);
        }
    }

    public short getSoakCountdownTime() throws NoSuchInterface, UnsupportedOperation, InvalidState {
        try {
            Short s = (Short)this.soakTimeLeft.get();
            return s;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xInvalidState xInvalidState2) {
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSoakCountdownTime", userException);
        }
    }

    public void setInService(boolean bl) throws NoSuchInterface {
        throw new NoSuchInterface((UserException)new xNoSuchInterface());
    }

    public sOctetStats getOctetStats() throws NoSuchInterface, UnsupportedOperation {
        try {
            return (sOctetStats)this.octetStats.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOctetStats", userException);
        }
    }

    public sPacketStats getPacketStats() throws NoSuchInterface, UnsupportedOperation {
        try {
            return (sPacketStats)this.packetStats.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPacketStats", userException);
        }
    }

    public int compareTo(Object object) {
        return ComparisonUtil.compare((int)this.getIndex(), (int)((InterfaceModel)object).getIndex());
    }

    private void updateHigherLayer() {
        this.getHigherLayerIndexesCV().update();
    }

    private void updateLowerLayer() {
        this.getLowerLayerIndexesCV().update();
    }

    @Override
    protected void updateLocal(long l) {
        this.getInterfaceAttrs().update(l);
        if (this.db.on()) {
            this.db.println("updateLocal(): will notifyObservers(CHANGED)");
        }
        this.currentlyActive.update();
        this.protectionRole.update();
        this.coordinatedMaintState.update();
        this.setChanged();
        super.updateLocal(l);
    }

    protected void updateAttributes(ArrayList arrayList, long l) {
        this.getInterfaceAttrs().updateAttributes(arrayList, l);
    }

    @Override
    protected final void updateLocal() {
    }

    protected void updateStructure(long l) throws NoSuchInterface {
        this.updateHigherStructure(l);
        this.updateLowerStructure(l);
        if (this.hasChanged()) {
            if (this.db.on()) {
                this.db.println("updateStructure(): Will notifyObservers(ADDED)");
            }
            this.notifyObservers(ModelUpdateType.ADDED);
        }
    }

    public void updateLayerIndexes() {
        this.getHigherLayerIndexesCV().update();
        this.getLowerLayerIndexesCV().update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHigherStructure(long l) throws NoSuchInterface {
        int[] nArray = null;
        int[] nArray2 = null;
        InterfaceModel interfaceModel = this;
        synchronized (interfaceModel) {
            nArray = this.getHigherLayerIndexes();
            this.getHigherLayerIndexesCV().update();
            nArray2 = this.getHigherLayerIndexes();
        }
        this.updateLayerStructure(nArray, nArray2, l, true);
        this.getInterfaceAttrs().update(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLowerStructure(long l) throws NoSuchInterface {
        int[] nArray = null;
        int[] nArray2 = null;
        InterfaceModel interfaceModel = this;
        synchronized (interfaceModel) {
            nArray = this.getLowerLayerIndexes();
            this.getLowerLayerIndexesCV().update();
            nArray2 = this.getLowerLayerIndexes();
        }
        this.updateLayerStructure(nArray, nArray2, l, false);
        this.getInterfaceAttrs().update(l);
    }

    private void doDebugInfo(String string, Iterator iterator) {
        if (this.db.on()) {
            String string2 = "updateLayerStructure() for " + this._indexString + "'s " + string + " list:";
            if (iterator.hasNext()) {
                string2 = string2 + "    ";
                string2 = string2 + Integer.toHexString((Integer)iterator.next());
                while (iterator.hasNext()) {
                    string2 = string2 + ", ";
                    string2 = string2 + Integer.toHexString((Integer)iterator.next());
                }
            }
            this.db.println(string2);
            this.db.println("");
        }
    }

    protected boolean isAssocEvaled(int n) {
        int n2 = PersistableModel.getLowestStateBitIndexAvailable();
        return this.isStateBit(n, n2);
    }

    protected void setAssocEvaled(int n, boolean bl) {
        int n2 = PersistableModel.getLowestStateBitIndexAvailable();
        this.setStateBit(n, n2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLayerStructure(int[] nArray, int[] nArray2, long l, boolean bl) throws NoSuchInterface {
        int n;
        int n2;
        int n3 = n2 = bl ? HIGHERS_EVALED_BIT_INDEX : LOWERS_EVALED_BIT_INDEX;
        if (this.db.on()) {
            this.db.print("updateLayerStructure for if: " + this.getIndex() + " - old indicies: ");
            for (n = 0; n < nArray.length; ++n) {
                if (n > 0) {
                    this.db.print(", ");
                }
                this.db.print(Integer.toString(nArray[n]));
            }
            this.db.println(" - new indicies: ");
            for (n = 0; n < nArray2.length; ++n) {
                if (n > 0) {
                    this.db.print(", ");
                }
                this.db.print(Integer.toString(nArray2[n]));
            }
            this.db.println("");
        }
        Arrays.sort(nArray);
        Arrays.sort(nArray2);
        n = Arrays.equals(nArray, nArray2);
        boolean bl2 = this.isAssocEvaled(n2);
        if (n == 0 || !bl2) {
            InterfaceModel interfaceModel;
            int n4;
            int n5;
            int[] nArray3 = InterfaceModel.diffOf(nArray2, nArray);
            int[] nArray4 = InterfaceModel.diffOf(nArray, nArray2);
            if (nArray4.length > 0) {
                for (n5 = 0; n5 < nArray4.length; ++n5) {
                    n4 = nArray4[n5];
                    if (this.db.on()) {
                        this.db.println("DELETING Interface#" + Integer.toHexString(n4));
                    }
                    if ((interfaceModel = this.getNodeModelDelegate().getIfModels().findInterfaceModelInCache(n4)) == null) continue;
                    interfaceModel.delete(l);
                }
            }
            n5 = 0;
            if (nArray3.length > 0 || !bl2) {
                n4 = bl2 ? 0 : nArray.length;
                n5 = nArray3.length + n4;
                this.setAssocEvaled(n2, true);
                boolean bl3 = this.db.on();
                if (bl3) {
                    this.db.println("updateLayerStructure for " + (bl ? "highers" : "lowers") + " on IF " + this.getIndex() + " - added len: " + nArray3.length + " old len: " + n4);
                }
                for (int i = 0; i < n5; ++i) {
                    int n6;
                    int n7 = n6 = i >= n4 ? nArray3[i - n4] : nArray[i];
                    if (bl3) {
                        this.db.println("updateLayerStructure - processing adds on IF " + this.getIndex() + " - added index: " + n6);
                    }
                    if (this.db.on()) {
                        this.db.println("ADDING Interface#" + Integer.toHexString(n6));
                    }
                    InterfaceModel interfaceModel2 = interfaceModel = this.getNodeModelDelegate().getIfModels().getInterfaceModel(n6, l);
                    synchronized (interfaceModel2) {
                        interfaceModel.setSlotNum(this.getSlotNum());
                    }
                    interfaceModel.updateHigherLayer();
                    interfaceModel.getHigherLayerIndexes();
                    interfaceModel.updateLowerLayer();
                    interfaceModel.getLowerLayerIndexes();
                }
            }
            if (n5 > 0) {
                this.setChanged();
            }
        }
    }

    private static int[] diffOf(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray.length == 0) {
            return new int[0];
        }
        if (nArray2 == null || nArray2.length == 0) {
            return nArray;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length && n2 < nArray2.length) {
            if (nArray[n3] != nArray2[n2]) {
                if (nArray[n3] < nArray2[n2]) {
                    ++n;
                    ++n3;
                    continue;
                }
                ++n2;
                continue;
            }
            ++n2;
            ++n3;
        }
        if (n3 < nArray.length) {
            n += nArray.length - n3;
        }
        int[] nArray3 = new int[n];
        int n4 = 0;
        if (n > 0) {
            n2 = 0;
            n3 = 0;
            while (n3 < nArray.length && n2 < nArray2.length) {
                if (nArray[n3] != nArray2[n2]) {
                    if (nArray[n3] < nArray2[n2]) {
                        nArray3[n4++] = nArray[n3++];
                        continue;
                    }
                    ++n2;
                    continue;
                }
                ++n2;
                ++n3;
            }
        }
        if (n3 < nArray.length) {
            while (n3 < nArray.length) {
                nArray3[n4++] = nArray[n3];
                ++n3;
            }
        }
        return nArray3;
    }

    private void attemptToSetSlotNum(int n) {
        try {
            if (this.db.on()) {
                this.db.println("attempting to setSlotNum...");
            }
            NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
            EntityTableModel entityTableModel = nodeModelDelegate.getEntityTableModel();
            ModuleModel moduleModel = (ModuleModel)entityTableModel.getEntityModelByIndex(n);
            short s = (short)moduleModel.getParent().getPositionInParent();
            this.setSlotNum(s);
            if (this.db.on()) {
                this.db.display("setSlotNum set to: " + s);
            }
        }
        catch (Exception exception) {
            this.db.display("update setSlotNum failed: " + exception);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n;
            long l;
            Object object2;
            if (object instanceof ObjectMessageInfo) {
                object2 = (ObjectMessageInfo)object;
                l = ((ObjectMessageInfo)object2).getUpdateSeqNum();
                if (l == 0L) {
                    l = -1L;
                }
                n = ((ObjectMessageInfo)object2).getUpdateType();
                if (this.slotNum == -1) {
                    int n2 = ((ObjectMessageInfo)object2).getModuleIndex();
                    this.attemptToSetSlotNum(n2);
                } else if (this.db.on()) {
                    this.db.display("slotNum: " + this.slotNum + " " + InterfaceModel._getPersistType() + " " + this.getClass().getName());
                }
            } else {
                n = (Integer)object;
                l = -1L;
            }
            if (this.db.on()) {
                this.db.println("update(): this=" + this.toString() + ", From=" + observable + ", arg=" + EnumStrings.getStrings(eUpdateType.class)[n]);
            }
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println("update(): this DELETED");
                    }
                    this.delete(l);
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println("update(): this CHANGED");
                    }
                    if (object instanceof ObjectMessageInfo) {
                        object2 = ((ObjectMessageInfo)object).getChangedValues();
                        if (((ArrayList)object2).isEmpty()) {
                            this.updateLocal(l);
                            break;
                        }
                        this.updateAttributes((ArrayList)object2, l);
                        this.setChanged();
                        this.notifyObservers(ModelUpdateType.CHANGED);
                        break;
                    }
                    this.updateLocal(l);
                    break;
                }
                case 2: {
                    if (this.db.on()) {
                        this.db.println("update(): STRUCTURE CHANGED");
                    }
                    try {
                        this.updateStructure(l);
                    }
                    catch (Exception exception) {
                        this.db.println("Caught exception in update");
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                default: {
                    if (this.db.on()) {
                        this.db.println("update(): UNKNOWN NE UPDATE TYPE" + n);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    @Override
    public void dispose() {
        int n = this.getModelType(InterfaceModel._getPersistType());
        if (this._dispatcher != null) {
            this._dispatcher.deleteObserver(ObjectType.ObjectInterface, this.getIndex(), (Observer)this);
        }
        this.currentlyActive.dispose();
        this.protectionRole.dispose();
        this.coordinatedMaintState.dispose();
        this.dispose(n);
    }

    @Override
    public void destroy() {
        int n = this.getModelType(InterfaceModel._getPersistType());
        super.destroy();
        this.destroy(n);
    }

    public void delete() {
        this.delete(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(long l) {
        HashSet<InterfaceModel> hashSet = new HashSet<InterfaceModel>();
        Object object = this;
        synchronized (object) {
            this.deleteAllState(InterfaceAttrs.class, l);
            int[] nArray = this.getHigherLayerIndexes_new();
            for (int i = 0; i < nArray.length; ++i) {
                try {
                    InterfaceModel interfaceModel = this.getIfModel(nArray[i]);
                    interfaceModel.updateLowerLayer();
                    interfaceModel.getLowerLayerIndexes_new();
                    hashSet.add(interfaceModel);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (!this.db.on()) continue;
                    this.db.println("Caught NoSuchInterface in delete");
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            int[] nArray2 = this.getLowerLayerIndexes_new();
            for (int i = 0; i < nArray2.length; ++i) {
                try {
                    InterfaceModel interfaceModel = this.getIfModel(nArray2[i]);
                    interfaceModel.updateHigherLayer();
                    interfaceModel.getHigherLayerIndexes_new();
                    hashSet.add(interfaceModel);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (!this.db.on()) continue;
                    this.db.println("Caught NoSuchInterface in delete");
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            this.getNodeModelDelegate().getIfModels().remove(this);
            this.destroy();
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            ((Observable)object.next()).notifyObservers(ModelUpdateType.ADDED);
        }
    }

    public synchronized void deleteAll() {
        if (this.db.on()) {
            this.db.println("deleteAll(): " + this._indexString + " before delete()");
        }
        this.delete();
    }

    public IPortModel getPort() throws AbstractCmsNoSuchEntityException {
        return this.getPortModel();
    }

    public IPortModel getPortModel() throws AbstractCmsNoSuchEntityException {
        try {
            return (PortModel)this.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(this.getIndex());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            InterfaceModel interfaceModel = this.getFirstLowerLayerModels();
            if (interfaceModel == null) {
                if (this.db.on()) {
                    this.db.println("getPortModel: No PortModel and no lower interface of " + this);
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                throw abstractCmsNoSuchEntityException;
            }
            if (this.db.on()) {
                this.db.println("call getPortModel on the lower interface of " + this);
            }
            return interfaceModel.getPortModel();
        }
        catch (Exception exception) {
            this.db.println("Caught exception in InterfaceModel::getPortModel()");
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public ModuleModel getModuleModel() throws AbstractCmsNoSuchEntityException {
        PortModel portModel = (PortModel)this.getPortModel();
        return portModel == null ? null : (ModuleModel)portModel.getModuleModel();
    }

    public List getConnectionsList() {
        return new LinkedList();
    }

    public String toString() {
        if (this._stringStart == null) {
            int n;
            String string = this.getClass().getName();
            String string2 = string.substring((n = string.lastIndexOf(46)) + 1);
            int n2 = string2.lastIndexOf("Model");
            String string3 = n2 > -1 ? string2.substring(0, n2) : string2;
            this._stringStart = string3 + "[" + this._indexString + ", ";
        }
        return this._stringStart + this.getStringEnd();
    }

    private String getStringEnd() {
        if (this._stringEnd == null) {
            if (this._ifType == null) {
                try {
                    sInterface sInterface2 = this.getInfo();
                    this._ifType = sInterface2.ifType;
                    this._descr = sInterface2.descr;
                }
                catch (Exception exception) {
                    this.db.finer("Caught " + exception.toString() + " in " + "InterfaceModel.getStringEnd...");
                    if (this.db.isFinestEnabled()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    return "UNKNOWN, UNKNOWN]";
                }
            }
            this._stringEnd = EnumStrings.getStrings(this._ifType.getClass())[this._ifType.value()] + ", " + this._descr + "]";
        }
        return this._stringEnd;
    }

    public void setAttributes(sIfAttributes sIfAttributes2, long l) {
        this.setHigherLayerIndexes_new(sIfAttributes2.higherLayer, l);
        this.setLowerLayerIndexes_new(sIfAttributes2.lowerLayer, l);
        this.getHigherLayerIndexesCV().setValueExternally(sIfAttributes2.higherLayer, l);
        this.getLowerLayerIndexesCV().setValueExternally(sIfAttributes2.lowerLayer, l);
        this.getInfoCV().setValueExternally(sIfAttributes2.info, l);
        this.getAliasCV().setValueExternally(sIfAttributes2.alias, l);
    }

    public void setAttributes(sIfAttributes sIfAttributes2) {
        this.setAttributes(sIfAttributes2, -1L);
    }

    cerent.cms.idl.If.General getIfRef() {
        return this.getNodeModelDelegate().getIorRepository().getIfRef();
    }

    private General getDwdmRefForTNC() {
        return this.getDwdmCliRefForTNC();
    }

    private Client getDwdmCliRefForTNC() {
        return this.getNodeModelDelegate().getIorRepository().getDwdmCliRef();
    }

    public ElementModel getElementModel() throws AbstractCmsNoSuchElementException {
        return this.getNodeModelDelegate().getElementModelsDelegate().getElementModel(this.getIndex());
    }

    public IElementModel getElementModelForInterface() throws AbstractCmsNoSuchElementException {
        return this.getNodeModelDelegate().getElementModelsDelegate().getElementModel(this.getIndex());
    }

    public boolean isCurrentlyActive() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            return (Boolean)this.currentlyActive.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("isCurrentlyActive", userException);
        }
    }

    public int getProtectionRole() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            return ((eProtectionRole)this.protectionRole.get()).value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getProtectionRole", userException);
        }
    }

    protected UNKNOWN doUnknown(String string, UserException userException) {
        this.db.println("Caught unexpected exception in " + string);
        return new UNKNOWN("Caught unexpected exception in " + string + " : " + (Object)((Object)userException));
    }

    public int getNumberOfCircuitInterfaces() throws NoSuchInterface {
        int n = 0;
        eIfType eIfType2 = this.getInfo().ifType;
        if (eIfType2 == eIfType.SONET_VT) {
            ++n;
        } else {
            this.updateLayerIndexes();
            int[] nArray = this.getHigherLayerIndexes();
            InterfaceModels interfaceModels = this.getNodeModelDelegate().getIfModels();
            int n2 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                InterfaceModel interfaceModel = interfaceModels.getInterfaceModel(nArray[i]);
                if (eIfType2 == eIfType.SONET_PATH) {
                    n2 += interfaceModel.getNumberOfCircuitInterfaces();
                    continue;
                }
                n += interfaceModel.getNumberOfCircuitInterfaces();
            }
            if (eIfType2 == eIfType.SONET_PATH) {
                n = n2 == 0 ? ++n : (n += n2);
            }
        }
        return n;
    }

    public boolean hasCircuitInterfaces() throws NoSuchInterface {
        return this.getNumberOfCircuitInterfaces() > 0;
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) throws ExternalInitializationRequired {
        Object object = null;
        if (nodeModelDelegate.isCtcInCtmMode()) {
            throw new ExternalInitializationRequired("The interface(s) with the index " + n + " require initialization.");
        }
        try {
            EntityTableModel entityTableModel = (EntityTableModel)nodeModelDelegate.getEntityTable();
            IEntityModel[] iEntityModelArray = nodeModelDelegate.getChassisModels();
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                Serializable serializable;
                EntityModel entityModel = (EntityModel)iEntityModelArray[i];
                IEntityModel iEntityModel = (IEntityModel)entityModel.getChildrenOfType(eClass.BACKPLANE).get(0);
                int n2 = iEntityModel.getChildren().size();
                InterfaceModels interfaceModels = nodeModelDelegate.getIfModels();
                boolean bl = false;
                block3: for (int j = 1; !bl && j <= n2; ++j) {
                    ModuleModel moduleModel;
                    serializable = (SlotModel)entityTableModel.getEntityModelBySlot((IChassisModel)((Object)entityModel), j);
                    if (((EntityModel)serializable).getEqTypeEnum() != eEqType.IO_SLOT || (moduleModel = (ModuleModel)entityTableModel.getModule((IChassisModel)((Object)entityModel), j)) == null) continue;
                    InterfaceModel[] interfaceModelArray = interfaceModels.getAllInterfaceModels(moduleModel);
                    for (int k = 0; k < interfaceModelArray.length; ++k) {
                        InterfaceModel interfaceModel = interfaceModelArray[k];
                        if (interfaceModel.getIndex() != n) continue;
                        object = interfaceModel;
                        bl = true;
                        continue block3;
                    }
                }
                if (object == null) continue;
                serializable = object.getClass();
                boolean bl2 = false;
                while (!serializable.equals(Model.class)) {
                    if (serializable.equals(clazz)) {
                        bl2 = true;
                        break;
                    }
                    serializable = ((Class)serializable).getSuperclass();
                }
                if (bl2) continue;
                object = null;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public InterfaceModel getHighestParent() {
        InterfaceModel interfaceModel = this.getFirstLowerLayerModels();
        if (interfaceModel == null) {
            return this;
        }
        InterfaceModel interfaceModel2 = this;
        while (interfaceModel != null) {
            interfaceModel2 = interfaceModel;
            interfaceModel = interfaceModel2.getFirstLowerLayerModels();
        }
        return interfaceModel2;
    }

    protected void handleIfModelInterconnect() {
        try {
            if (this.slotNum == -1) {
                this.slotNum = this.getModuleModel().getSlotNum();
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
    }

    public List getForceHoLoRefresh() {
        return this.forceHoLoRefresh();
    }

    public List forceHoLoRefresh() {
        Set set;
        this.logHoLoCount();
        Set set2 = this.getHighestNonHoLos();
        HashSet hashSet = new HashSet();
        int n = 0;
        while ((set = InterfaceModel.diff(set2, hashSet)).size() > 0) {
            ++n;
            for (InterfaceModel interfaceModel : set) {
                try {
                    interfaceModel.updateStructure(-1L);
                }
                catch (NoSuchInterface noSuchInterface) {}
            }
            hashSet.clear();
            hashSet.addAll(set2);
            set2 = this.getAllHigherInterfaces();
        }
        List list = InterfaceModel.getHoLos(set2);
        if (this.db.on()) {
            String string = "new HO/LO cnts for " + this.getClass().getName() + " " + this.getIndex();
            InterfaceModel.logHoLoCount(this.db, string, list);
        }
        return list;
    }

    public InterfaceModel getForceHoLoRefresh(int n) throws AbstractCmsNoSuchEntityException {
        return this.forceHoLoRefresh(n);
    }

    public InterfaceModel forceHoLoRefresh(int n) throws AbstractCmsNoSuchEntityException {
        InterfaceModel interfaceModel = null;
        List list = this.forceHoLoRefresh();
        Iterator iterator = list.iterator();
        IPortModel iPortModel = this.getPortModel();
        while (interfaceModel == null && iterator.hasNext()) {
            int n2;
            InterfaceModel interfaceModel2 = (InterfaceModel)iterator.next();
            if (!(interfaceModel2 instanceof ITdmHoModel)) continue;
            try {
                n2 = interfaceModel2.getInfo().muxIndex;
            }
            catch (NoSuchInterface noSuchInterface) {
                continue;
            }
            if (n2 != 0 && n2 != n) continue;
            interfaceModel = interfaceModel2;
        }
        return interfaceModel;
    }

    protected Set getHighestNonHoLos() {
        boolean bl;
        Set set = new HashSet();
        HashSet<InterfaceModel> hashSet = new HashSet<InterfaceModel>();
        hashSet.add(this);
        InterfaceModel interfaceModel = null;
        do {
            Iterator iterator;
            if (!(bl = (iterator = (set = InterfaceModel.getHighers(hashSet)).iterator()).hasNext() ? (interfaceModel = (InterfaceModel)iterator.next()) != null && !InterfaceModel.isHoOrLo(interfaceModel) : false)) continue;
            hashSet.clear();
            hashSet.addAll(set);
        } while (bl);
        return hashSet;
    }

    protected Set getAllHigherInterfaces() {
        HashSet<InterfaceModel> hashSet = new HashSet<InterfaceModel>();
        hashSet.add(this);
        Set<InterfaceModel> set = new HashSet<InterfaceModel>();
        set.add(this);
        while ((set = InterfaceModel.getHighers(set)).size() > 0) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    protected void logHoLoCount() {
        if (!this.db.on()) {
            return;
        }
        Set set = this.getAllHigherInterfaces();
        String string = "HO/LO cnts for " + this.getClass().getName() + " " + this.getIndex();
        InterfaceModel.logHoLoCount(this.db, string, set);
    }

    protected static void logHoLoCount(SDebug sDebug, String string, Collection collection) {
        if (!sDebug.on()) {
            return;
        }
        List list = InterfaceModel.getHoLos(collection);
        int n = 0;
        int n2 = 0;
        for (InterfaceModel interfaceModel : list) {
            if (interfaceModel instanceof ITdmHoModel) {
                ++n;
                continue;
            }
            if (!(interfaceModel instanceof ITdmLoModel)) continue;
            ++n2;
        }
        sDebug.println(string);
        sDebug.println("HO cnt: " + n + " LO cnt: " + n2);
    }

    protected static List getHoLos(Collection collection) {
        LinkedList<InterfaceModel> linkedList = new LinkedList<InterfaceModel>();
        for (InterfaceModel interfaceModel : collection) {
            if (!InterfaceModel.isHoOrLo(interfaceModel)) continue;
            linkedList.add(interfaceModel);
        }
        return linkedList;
    }

    protected static boolean isHoOrLo(IInterfaceModel iInterfaceModel) {
        return iInterfaceModel instanceof ITdmHoModel || iInterfaceModel instanceof ITdmLoModel;
    }

    protected static Set getHighers(Set set) {
        HashSet hashSet = new HashSet();
        for (InterfaceModel interfaceModel : set) {
            InterfaceModel.addAll(hashSet, interfaceModel.getHigherLayerModels());
        }
        return hashSet;
    }

    protected static void addAll(Set set, InterfaceModel[] interfaceModelArray) {
        int n = interfaceModelArray.length;
        for (int i = 0; i < n; ++i) {
            set.add(interfaceModelArray[i]);
        }
    }

    protected static Set diff(Set set, Set set2) {
        HashSet hashSet = new HashSet(set);
        hashSet.removeAll(set2);
        return hashSet;
    }

    public boolean isAlsSettable() {
        try {
            return this.isALSSupported();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return false;
        }
    }

    public boolean isALSSupported() throws NoSuchInterface {
        boolean bl = false;
        try {
            bl = (Boolean)this.getIsALSSupportedCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("isALSSupported", userException);
        }
        this.db.fine("isALSSupported returns " + bl);
        return bl;
    }

    public void setALSMode(int n) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.getAlsModeCV().set(eALSMode.from_int(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xAlsConfigError xAlsConfigError2) {
            throw new EMCProvisionError(xAlsConfigError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setALSMode", userException);
        }
    }

    public void setALSModeEnum(eALSMode eALSMode2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        this.setALSMode(eALSMode2.value());
    }

    public int getALSMode() throws NoSuchInterface, WrongInterfaceType {
        int n = 0;
        try {
            n = ((eALSMode)this.getAlsModeCV().get()).value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getALSMode", userException);
        }
        return n;
    }

    public eALSMode getALSModeEnum() throws NoSuchInterface, WrongInterfaceType {
        return eALSMode.from_int(this.getALSMode());
    }

    public void setALSRecoveryInterval(short s) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.getAlsRecoveryIntCV().set(new Short(s));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xAlsConfigError xAlsConfigError2) {
            throw new EMCProvisionError(xAlsConfigError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setALSRecoveryInterval", userException);
        }
    }

    public short getALSRecoveryInterval() throws NoSuchInterface, WrongInterfaceType {
        short s = 0;
        try {
            s = (Short)this.getAlsRecoveryIntCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getALSRecoveryInterval", userException);
        }
        return s;
    }

    public void setALSRecoveryPulseWidth(float f) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.getAlsPulseWidthCV().set(new Short((short)Math.round(f * 10.0f)));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xAlsConfigError xAlsConfigError2) {
            throw new EMCProvisionError(xAlsConfigError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setALSRecoveryPulseWidth", userException);
        }
    }

    public float getALSRecoveryPulseWidth() throws NoSuchInterface, WrongInterfaceType {
        float f = 0.0f;
        try {
            f = (float)((Short)this.getAlsPulseWidthCV().get()).shortValue() / 10.0f;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getALSRecoveryPulseWidth", userException);
        }
        return f;
    }

    public boolean hasLaserBeenShutdown() throws NoSuchInterface, WrongInterfaceType {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = this.getLaserStatus().equals(eLaserStatus.OFF);
            }
            catch (InternalCommError internalCommError) {
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)internalCommError);
            }
        }
        this.db.fine("hasLaserBeenShutdown returns " + bl);
        return bl;
    }

    public void setOSRIStatus(eOSRIStatus eOSRIStatus2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, FeatureUnsupported {
        try {
            this.osri.set(eOSRIStatus2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOSRIStatus", userException);
        }
    }

    public void clearOpticsStatsForTNC(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            this.opticsStatsForTNC.set(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearOpticsStatsForTNC", userException);
        }
    }

    public void restartLaser() throws NoSuchInterface, WrongInterfaceType, InvalidALSMode, ConfigError {
        try {
            this.restartLaser.set(Boolean.TRUE);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInvalidALSMode xInvalidALSMode2) {
            throw new InvalidALSMode((UserException)xInvalidALSMode2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xAlsConfigError xAlsConfigError2) {
            throw new ConfigError((UserException)xAlsConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("restartLaser", userException);
        }
        this.db.fine("restartLaser returns (void)");
    }

    public sOpticsCurrentValues getOpticsCurrentValuesForTNC() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        try {
            return (sOpticsCurrentValues)this.currentValuesForTNC.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsCurrentValuesForTNC", userException);
        }
    }

    public sOpticsPmStats getOpticsStatsForTNC(eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = eIntervalType2;
            objectArray[1] = new Short(s);
            sOpticsPmStats sOpticsPmStats2 = (sOpticsPmStats)this.opticsStatsForTNC.get(objectArray);
            return sOpticsPmStats2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsStatsForTNC", userException);
        }
    }

    public sALSAttributes getALSAttributesforTNC() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            sALSAttributes sALSAttributes2 = (sALSAttributes)this.alsAttrsforTNC.get();
            return sALSAttributes2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsStatsForTNC", userException);
        }
    }

    public eLaserStatus getLaserStatus() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            eLaserStatus eLaserStatus2 = (eLaserStatus)this.laserStatus.get();
            return eLaserStatus2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getLaserStatus", userException);
        }
    }

    public IInterfaceModel getHoIfModelFromMemberId(short s) {
        Integer n;
        block10: {
            IPortModel iPortModel;
            sStsInfo sStsInfo2;
            block9: {
                sStsInfo2 = new sStsInfo();
                iPortModel = null;
                try {
                    iPortModel = this.getPort();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) break block9;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            if (iPortModel == null) {
                return null;
            }
            sStsInfo2.index = ((PortModel)iPortModel).getIndex();
            sStsInfo2.sts = s;
            n = null;
            try {
                n = this.getNodeModelDelegate().getIfModels().getSTSIndex(sStsInfo2);
            }
            catch (NoSuchInterface noSuchInterface) {
                this.db.println("Caught NoSuchInterface in getHoIfModelFromMemberId");
                if (!this.db.on()) break block10;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        if (n == null) {
            return null;
        }
        try {
            return this.getNodeModelDelegate().getIfModels().getInterfaceModel(n);
        }
        catch (NoSuchInterface noSuchInterface) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            return null;
        }
    }

    public IInterfaceModel getLoIfModelFromMemberId(short s) {
        Integer n;
        block12: {
            IPortModel iPortModel;
            sVtInfo sVtInfo2;
            block11: {
                sVtInfo2 = new sVtInfo();
                iPortModel = null;
                try {
                    iPortModel = this.getPort();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) break block11;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            if (iPortModel == null) {
                return null;
            }
            sVtInfo2.index = iPortModel.getIndex();
            sVtInfo2.sts = s;
            sVtInfo2.group = 0;
            sVtInfo2.vt = 0;
            n = null;
            try {
                n = this.getNodeModelDelegate().getIfModels().getVTIndex(sVtInfo2);
            }
            catch (NoSuchInterface noSuchInterface) {
                this.db.println("Caught NoSuchInterface in getLoIfModelFromMemberId");
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.db.println("Caught UnsupportedOperation in getLoIfModelFromMemberId");
                if (!this.db.on()) break block12;
                SDebug.printStackTrace((Throwable)unsupportedOperation);
            }
        }
        if (n == null) {
            return null;
        }
        try {
            return this.getNodeModelDelegate().getIfModels().getInterfaceModel(n);
        }
        catch (NoSuchInterface noSuchInterface) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            return null;
        }
    }

    public boolean supportsAutoALS() {
        return true;
    }

    @Override
    public final short getSlotNum() {
        return this.slotNum;
    }

    public boolean supportsTxPower() {
        return true;
    }

    public boolean supportsLaserBias() {
        return true;
    }

    public InterfaceModel getInterfaceModel() {
        return this;
    }

    public final short getShelfNum() {
        block3: {
            if (this.shelfNum == -1) {
                try {
                    EntityModel entityModel = (EntityModel)this.node.getEntityTableModel().getEntityModelByIndex(this.ifIndex & 0xFFFFF000);
                    this.shelfNum = (short)entityModel.getChassis().getShelfId();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) break block3;
                    this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getShelfNum");
                }
            }
        }
        return this.shelfNum;
    }

    private InterfaceAttrs getInterfaceAttrs() {
        int n = InterfaceModel._getPersistType();
        int n2 = -1;
        if (this.slotNum != -1) {
            n2 = this.getModelType(n);
        }
        return (InterfaceAttrs)this.retrieveAttrs(n2, n);
    }

    private CachedValue getAliasCV() {
        return this.getInterfaceAttrs().getAlias();
    }

    private CachedValue getInfoCV() {
        return this.getInterfaceAttrs().getInfo();
    }

    private CachedValue getHigherLayerIndexesCV() {
        return this.getInterfaceAttrs().getHigherLayerIndexes();
    }

    private CachedValue getLowerLayerIndexesCV() {
        return this.getInterfaceAttrs().getLowerLayerIndexes();
    }

    private CachedValue getIsALSSupportedCV() {
        return this.getInterfaceAttrs().getIsALSSupported();
    }

    private CachedValue getAlsModeCV() {
        return this.getInterfaceAttrs().getAlsMode();
    }

    private CachedValue getAlsRecoveryIntCV() {
        return this.getInterfaceAttrs().getAlsRecoveryInt();
    }

    private CachedValue getAlsPulseWidthCV() {
        return this.getInterfaceAttrs().getAlsPulseWidth();
    }

    private static Class _me() {
        return InterfaceModel.class;
    }

    @Override
    protected Class state(int n) {
        Class clazz = null;
        if (n != InterfaceModel._getPersistType()) {
            throw new IllegalArgumentException("state error: unrecognized persistType: " + n);
        }
        clazz = InterfaceModel._state();
        return clazz;
    }

    private static Class _state() {
        return InterfaceAttrs.class;
    }

    public static Field[] getAttrFields(Class clazz) {
        return InterfaceModel.getAttrsFields(clazz, InterfaceModel._me(), InterfaceModel._state());
    }

    @Override
    protected final int getPersistTypeFromModelType(int n) {
        int n2 = InterfaceModelTypeUtil.partition(n);
        return n2;
    }

    @Override
    protected final LRUManager.LRUObjectHandler getHandler() {
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        return InterfaceLRUHandler.instance(nodeModelDelegate);
    }

    @Override
    protected final int getModelType(int n) {
        return this._getModelType(n);
    }

    private int _getModelType(int n) {
        ModuleModel moduleModel = null;
        int n2 = -1;
        if (this.slotNum != -1) {
            n2 = ModuleModel.getModelType(this.slotNum, n);
        } else {
            try {
                int n3;
                moduleModel = this.getModuleModel();
                int n4 = n3 = moduleModel != null ? moduleModel.getParent().getPositionInParent() : -1;
                if (n3 != -1) {
                    this.setSlotNum((short)n3);
                    n2 = ModuleModel.getModelType((short)n3, n);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return n2;
    }

    protected static final INetwideModelTypeIdentity getModelTypeId(NodeModelDelegate nodeModelDelegate, short s, int n) {
        INetwideModelTypeIdentity iNetwideModelTypeIdentity = null;
        if (s != -1) {
            iNetwideModelTypeIdentity = ModuleModel.getNetwideModelTypeIdentity(nodeModelDelegate, s, n);
        }
        return iNetwideModelTypeIdentity;
    }

    final synchronized void setSlotNum(short s) {
        if (this.slotNum == -1 && s >= 0) {
            this.slotNum = s;
        }
    }

    private static int _getPersistType() {
        return InterfaceAttrs.getCookie();
    }

    @Override
    protected final boolean canBePersisted(int n) {
        return this.slotNum != -1;
    }

    @Override
    protected AbstractPersistableModelState createInitialStateValue(int n) {
        if (n == -1 || n == InterfaceModel._getPersistType()) {
            return this.createInitialStateValue(InterfaceModel._state());
        }
        return null;
    }

    @Override
    protected AbstractPersistableModelState getAttrsField(int n) {
        AbstractPersistableModelState abstractPersistableModelState = null;
        if (n == InterfaceModel._getPersistType()) {
            abstractPersistableModelState = this.attrs;
        }
        return abstractPersistableModelState;
    }

    public int getAttrFieldsInMemory(int n) {
        boolean bl;
        boolean bl2 = bl = this.attrs != null;
        if (bl) {
            n |= 1 << InterfaceModel._getPersistType();
        }
        return n;
    }

    @Override
    protected void setAttrsField(AbstractPersistableModelState abstractPersistableModelState, int n) {
        if (n == InterfaceModel._getPersistType() || abstractPersistableModelState instanceof InterfaceAttrs) {
            this.attrs = abstractPersistableModelState;
        } else if (n == -1 && abstractPersistableModelState == null) {
            if (this.attrs != null) {
                this.attrs.linkModel(null);
            }
            this.attrs = abstractPersistableModelState;
        }
    }

    @Override
    void allAttributesIndicateWriteAccess(long l) {
        this.getInterfaceAttrs().indicateWriteAccess(l);
    }

    @Override
    public void dumpAccessCounts(AbstractPersistableModelState abstractPersistableModelState) {
        if (this.db.on()) {
            this.db.display(abstractPersistableModelState.prettyPrintAccessCounts(this.displayid() + " access counts - "));
        }
    }

    static List getListOfModelIndiciesForSlot(INodeModel iNodeModel, short s, int n) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)iNodeModel;
        IModelPersistenceStrategy iModelPersistenceStrategy = nodeModelDelegate.getModelPersistenceStrategy(InterfaceModel.class);
        INetwideModelTypeIdentity iNetwideModelTypeIdentity = InterfaceModel.getModelTypeId(nodeModelDelegate, s, n);
        List list = null;
        try {
            list = iModelPersistenceStrategy.retrieveModelIndicies(iNetwideModelTypeIdentity);
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        return list;
    }

    public sLaserThresholds getDefaultOpticsThresholdsForTNC(eIntervalType eIntervalType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        eEqType eEqType3 = ((PortModel)this.getPortModel()).getEqTypeEnum();
        eClientOpticsVariant eClientOpticsVariant2 = eClientOpticsVariant.DEFAULT_CLIENT_OPTICS;
        eReach eReach2 = eReach.from_int(0);
        if (this instanceof ISupportsOpticsProvExtModel) {
            IOpticsProvExtModel iOpticsProvExtModel = ((ISupportsOpticsProvExtModel)((Object)this)).getOpticsProvExtModel();
            eReach2 = iOpticsProvExtModel.getLineReach();
        }
        if (this.db.on()) {
            this.db.println(" get Client Defaults:\n\t eqType  = " + eEqType2.value() + "\n\t portType = " + eEqType3.value() + "\n\t thrVar = " + eClientOpticsVariant2.value() + "\n\t reach = " + eReach2.value() + "\n\t intervalType = " + eIntervalType2.value());
        }
        if (eReach2.value() == 0) {
            if (this.db.on()) {
                this.db.println(" get Client Defaults: Reach not set, returning null");
            }
            return null;
        }
        return neDefaultsModel.getDefClientOpticsThr(eEqType2, eEqType3, eClientOpticsVariant2, eReach2, eIntervalType2);
    }

    protected static int getLowestStateBitIndexAvailable() {
        return LOWERS_EVALED_BIT_INDEX + 1;
    }

    public IFvPortModel getThePortModel() throws AbstractCmsNoSuchEntityException {
        return this.getPortModel();
    }

    public int getExpectedWaveLength() throws NoSuchInterface, WrongInterfaceType {
        throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GETEXPECTED_WAVELENGTH), null);
    }

    public int getActualPower() throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, InternalCommError {
        return 0;
    }

    public int[] getCurrentPmPower() throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, InternalCommError {
        return new int[0];
    }

    private class ALSAttributesforTNC
    extends NonCachedValue {
        public ALSAttributesforTNC(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            sALSAttributes sALSAttributes2 = InterfaceModel.this.getIfRef().getALSAttributes(InterfaceModel.this.getIndex());
            return sALSAttributes2;
        }
    }

    class AdminState
    extends NonCachedValue {
        public AdminState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xNoSuchInterface, xLoopbackActive, xUnsupportedOperation, xSyncProvBusy, xInvalidState, xProvisionError {
            eAdminState eAdminState2 = (eAdminState)object;
            if (InterfaceModel.this.db.on()) {
                InterfaceModel.this.db.println("Info.setValue(adminState:" + eAdminState2.value() + ")");
            }
            InterfaceModel.this.getIfRef().setAdminState(InterfaceModel.this.getIndex(), eAdminState2, eEdAdminStateCmd.EDSTATE_ED);
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }

    class AinsSoakTime
    extends NonCachedValue {
        public AinsSoakTime(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            int n = (Integer)object;
            if (InterfaceModel.this.db.on()) {
                InterfaceModel.this.db.println("Info.setValue(soakTime:" + n + ")");
            }
            InterfaceModel.this.getIfRef().setAinsSoakTime(InterfaceModel.this.getIndex(), (short)n);
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }

    class AinsSoakTimeCountdown
    extends NonCachedValue {
        public AinsSoakTimeCountdown(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            short s = InterfaceModel.this.getIfRef().getAinsSoakTimeCountdown(InterfaceModel.this.getIndex());
            return new Short(s);
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }

    private class CoordinatedMaintState
    extends CachedValue {
        public CoordinatedMaintState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xNoSuchInterface, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            boolean bl = (Boolean)objectArray[1];
            InterfaceModel.this.getIfRef().setCoordinateMaintState(n, bl);
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }

    private class CurrentValuesForTNC
    extends NonCachedValue {
        public CurrentValuesForTNC(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface, xInternalCommError, xUnsupportedOperation {
            return InterfaceModel.this.getIfRef().getOpticsCurrentValues(InterfaceModel.this.getIndex());
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }

    private class CurrentlyActive
    extends CachedValue {
        public CurrentlyActive(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            return new Boolean(this.node.getIorRepository().getIfRef().getLineCurrentlyActive(InterfaceModel.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) {
        }

        @Override
        protected Object cloneValue() {
            return new Boolean((Boolean)this.value);
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }

    class DownstreamAis
    extends NonCachedValue {
        public DownstreamAis(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xNoSuchInterface, xLoopbackActive, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[1];
            if (InterfaceModel.this.db.on()) {
                InterfaceModel.this.db.println("DownstreamAis.setValue(sendAis:" + bl + ")");
            }
            InterfaceModel.this.getIfRef().setLoopbackAIS(InterfaceModel.this.getIndex(), (eLoopback)objectArray[0], bl);
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }

    private class LaserAlmThresholdsForTNC
    extends NonCachedValue {
        public LaserAlmThresholdsForTNC(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            sLaserThresholds sLaserThresholds2 = InterfaceModel.this.getDwdmRefForTNC().getOpticsAlmThresholds(InterfaceModel.this.getIndex());
            return sLaserThresholds2;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            InterfaceModel.this.getDwdmRefForTNC().setOpticsAlmThresholds(InterfaceModel.this.getIndex(), (sLaserThresholds)object);
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }

    private class LaserStatus
    extends NonCachedValue {
        public LaserStatus(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation, xInternalCommError {
            eLaserStatus eLaserStatus2 = InterfaceModel.this.getIfRef().getLaserStatus(InterfaceModel.this.getIndex());
            return eLaserStatus2;
        }
    }

    private class LaserTCAThresholdsForTNC
    extends NonCachedValue {
        public LaserTCAThresholdsForTNC(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            sLaserThresholds sLaserThresholds2 = InterfaceModel.this.getDwdmRefForTNC().getOpticsTCAThresholds(InterfaceModel.this.getIndex(), (eIntervalType)object);
            return sLaserThresholds2;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            InterfaceModel.this.getDwdmRefForTNC().setOpticsTCAThresholds(InterfaceModel.this.getIndex(), (sLaserThresholds)objectArray[0], (eIntervalType)objectArray[1]);
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }

    private class OSRI
    extends NonCachedValue {
        public OSRI(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            InterfaceModel.this.getIfRef().setOSRI(InterfaceModel.this.getIndex(), (eOSRIStatus)object);
        }
    }

    private class OctetStats
    extends NonCachedValue {
        public OctetStats(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return InterfaceModel.this.getIfRef().getOctetStats(InterfaceModel.this.getIndex());
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }

    private class OpticsStatsForTNC
    extends NonCachedValue {
        public OpticsStatsForTNC(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xInternalCommError, xNoSuchInterface, xUnsupportedOperation {
            InterfaceModel.this.getIfRef().clearOpticsStats(InterfaceModel.this.getIndex(), (eIntervalType)object);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xInternalCommError, xNoSuchInterface, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            short s = (Short)objectArray[1];
            sOpticsPmStats sOpticsPmStats2 = InterfaceModel.this.getIfRef().getOpticsStats(InterfaceModel.this.getIndex(), (eIntervalType)objectArray[0], s);
            return sOpticsPmStats2;
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }

    private class PacketStats
    extends NonCachedValue {
        public PacketStats(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return InterfaceModel.this.getIfRef().getPacketStats(InterfaceModel.this.getIndex());
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }

    private class ProtectionRole
    extends CachedValue {
        public ProtectionRole(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            return this.node.getIorRepository().getIfRef().getLineProtectionRole(InterfaceModel.this.getIndex());
        }

        @Override
        protected void setValue(Object object) {
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }

    private class RestartLaser
    extends NonCachedValue {
        public RestartLaser(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            InterfaceModel.this.getIfRef().restartLaser(InterfaceModel.this.getIndex());
        }

        public Object outer() {
            return InterfaceModel.this;
        }
    }
}

