/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.Attribute;
import cerent.cms.model.IChassisModel;

public class LANAccessMode
extends Attribute {
    public static final int _DCC_ONLY = 0;
    public static final int _BACKPLANE_ONLY = 1;
    public static final int _FRONT_ONLY = 2;
    public static final int _FRONT_BACKPLANE = 3;
    public static final LANAccessMode DCC_ONLY = new LANAccessMode(0, "No LAN Access");
    public static final LANAccessMode BACKPLANE_ONLY = new LANAccessMode(1, "Backplane Only");
    public static final LANAccessMode FRONT_ONLY = new LANAccessMode(2, "Front Only");
    public static final LANAccessMode FRONT_BACKPLANE = new LANAccessMode(3, "Front & Backplane");
    public static final LANAccessMode EMS_ONLY = new LANAccessMode(1, "EMS Only");
    public static final LANAccessMode FRONT_CRAFT = new LANAccessMode(2, "Front & Craft");
    public static final LANAccessMode FRONT_CRAFT_EMS = new LANAccessMode(3, "Front Craft & EMS");
    public static final LANAccessMode FRONT_EMS = new LANAccessMode(3, "Front & EMS");

    protected LANAccessMode(int n, String string) {
        super(string, n);
    }

    public int value() {
        return this.getIntValue();
    }

    public boolean isFrontLANAccessEnabled() {
        return this.getIntValue() == 2 || this.getIntValue() == 3;
    }

    public boolean isBackLANAccessEnabled() {
        return this.getIntValue() == 1 || this.getIntValue() == 3;
    }

    public static LANAccessMode from_int(int n, IChassisModel iChassisModel) {
        boolean bl = iChassisModel.isM6Chassis();
        boolean bl2 = iChassisModel.isM2Chassis();
        switch (n) {
            case 0: {
                return DCC_ONLY;
            }
            case 1: {
                if (bl2 || bl) {
                    return EMS_ONLY;
                }
                return BACKPLANE_ONLY;
            }
            case 2: {
                if (bl) {
                    return FRONT_CRAFT;
                }
                return FRONT_ONLY;
            }
            case 3: {
                if (bl) {
                    return FRONT_CRAFT_EMS;
                }
                if (bl2) {
                    return FRONT_EMS;
                }
                return FRONT_BACKPLANE;
            }
        }
        throw new IllegalArgumentException("" + n);
    }

    public static LANAccessMode from_string(String string) {
        if (string.equals(DCC_ONLY.toString())) {
            return DCC_ONLY;
        }
        if (string.equals(BACKPLANE_ONLY.toString())) {
            return BACKPLANE_ONLY;
        }
        if (string.equals(FRONT_ONLY.toString())) {
            return FRONT_ONLY;
        }
        if (string.equals(FRONT_BACKPLANE.toString())) {
            return FRONT_BACKPLANE;
        }
        if (string.equals(EMS_ONLY.toString())) {
            return EMS_ONLY;
        }
        if (string.equals(FRONT_CRAFT.toString())) {
            return FRONT_CRAFT;
        }
        if (string.equals(FRONT_CRAFT_EMS.toString())) {
            return FRONT_CRAFT_EMS;
        }
        if (string.equals(FRONT_EMS.toString())) {
            return FRONT_EMS;
        }
        throw new IllegalArgumentException(string);
    }

    public boolean transitionMayDisconnect(LANAccessMode lANAccessMode) {
        boolean bl = false;
        if (this.value() != lANAccessMode.value() && lANAccessMode.value() != 3) {
            bl = true;
        }
        return bl;
    }
}

