/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Lmp.General;
import cerent.cms.idl.Lmp.eControlChannelOperationalState;
import cerent.cms.idl.Lmp.sControlChannelAttrsEx;
import cerent.cms.idl.Lmp.sControlChannelRespEx;
import cerent.cms.idl.Lmp.xLmpException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.ILmpCtrlChannelModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IpAddr;
import cerent.cms.model.LmpCtrlChannelModels;
import cerent.cms.model.LmpException;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.cms.ui.shelf.lmp.NodeTypeWrapper;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LmpCtrlChannelModel
extends Model
implements ILmpCtrlChannelModel {
    private static final ObjectType _eventType = ObjectType.ObjectControlChannelList;
    private NodeModelDelegate _nmd;
    private LmpCtrlChannelModels _models;
    private EventDispatcher _dispatcher;
    private Value _value;

    LmpCtrlChannelModel(NodeModelDelegate nodeModelDelegate, LmpCtrlChannelModels lmpCtrlChannelModels, int n) {
        super(nodeModelDelegate.getChildDebug(LmpCtrlChannelModel.class));
        this._nmd = nodeModelDelegate;
        this._models = lmpCtrlChannelModels;
        this._dispatcher = null;
        this.index = n;
        this._value = new Value(this._nmd, "Lmp::ControlChannel" + Integer.toHexString(n));
    }

    General getLmpMgrRef() {
        return this._nmd.getIorRepository().getLmpMgrRef();
    }

    @Override
    public INodeModel getNodeModel() {
        return this._nmd;
    }

    public void init() {
        if (this._dispatcher == null) {
            this._dispatcher = this._nmd.getDispatcher();
        }
        if (this._dispatcher != null) {
            this._dispatcher.addObserver(_eventType, this.index, (Observer)this);
        }
        this._value.init();
        if (this.db.on()) {
            this.db.println("init(" + this + ")");
        }
        super.init0();
    }

    @Override
    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(" + this + ")");
        }
        this._value.update();
        this.setChanged();
        super.updateLocal();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("update(" + this + ", arg=" + object + ", from=" + observable + ")");
        }
        if (observable instanceof CmsObservable && object instanceof ObjectMessageInfo) {
            ObjectMessageInfo objectMessageInfo = (ObjectMessageInfo)object;
            switch (objectMessageInfo.getUpdateType()) {
                case 2: {
                    break;
                }
                case 1: {
                    this.updateLocal();
                    break;
                }
                case 0: {
                    this._models.deleted(this);
                }
            }
        }
    }

    @Override
    public void dispose() {
        if (this._dispatcher != null) {
            this._dispatcher.deleteObserver(_eventType, this.index, (Observer)this);
            this._dispatcher = null;
        }
        this._value.dispose();
        if (this.db.on()) {
            this.db.println("dispose(" + this + ")");
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy(" + this + ")");
        }
        super.destroy();
    }

    private sControlChannelRespEx get() throws LmpException {
        try {
            return (sControlChannelRespEx)this._value.get();
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "get", userException);
        }
    }

    public void set(sControlChannelAttrsEx sControlChannelAttrsEx2) throws LmpException {
        try {
            this._value.set(sControlChannelAttrsEx2);
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "set", userException);
        }
    }

    public eAdminState getAdminState() throws LmpException {
        return this.get().attrs.admin_status;
    }

    public int getLocalPortId() throws LmpException {
        return this.get().attrs.ifIndex;
    }

    public int getLocalCtrlChannelId() throws LmpException {
        return this.get().local_id;
    }

    public IIpAddr getIRemoteNodeId() throws LmpException {
        return new IpAddr(this.getRemoteNodeId().addr);
    }

    public IIpAddr getIRemoteNodeIpAddress() throws Exception {
        return new IpAddr(this.getRemoteNodeIpAddress().addr);
    }

    public sIpAddr getRemoteNodeId() throws LmpException {
        return this.get().attrs.remote_ne;
    }

    public sIpAddr getRemoteNodeIpAddress() throws LmpException {
        return this.get().attrs.remote_ip;
    }

    public int getRemoteCtrlChannelId() throws LmpException {
        return this.get().remote_id;
    }

    public NodeTypeWrapper getRemoteNodeType() throws LmpException {
        return NodeTypeWrapper.getWrapperById(this.get().attrs.neType.value());
    }

    public boolean isRemoteCrs() throws LmpException {
        return this.get().attrs.neType.value() == 9;
    }

    public int getHello() throws LmpException {
        return this.get().attrs.requested_hello & 0xFFFF;
    }

    public int getHelloMin() throws LmpException {
        return this.get().attrs.hello_min & 0xFFFF;
    }

    public int getHelloMax() throws LmpException {
        return this.get().attrs.hello_max & 0xFFFF;
    }

    public int getHelloAct() throws LmpException {
        return this.get().actual_hello & 0xFFFF;
    }

    public int getHelloDead() throws LmpException {
        return this.get().attrs.requested_hello_dead & 0xFFFF;
    }

    public int getHelloDeadMin() throws LmpException {
        return this.get().attrs.hello_dead_min & 0xFFFF;
    }

    public int getHelloDeadMax() throws LmpException {
        return this.get().attrs.hello_dead_max & 0xFFFF;
    }

    public int getHelloDeadAct() throws LmpException {
        return this.get().actual_hello_dead & 0xFFFF;
    }

    public eControlChannelOperationalState getOperationalState() throws LmpException {
        return this.get().operational_status;
    }

    public int getIOperationalState() throws LmpException {
        return this.getOperationalState().value();
    }

    public String toString() {
        return "LmpCtrlChannel#" + this.index;
    }

    private class Value
    extends CachedValue {
        public Value(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xLmpException {
            sControlChannelRespEx sControlChannelRespEx2 = LmpCtrlChannelModel.this.getLmpMgrRef().getControlChannelEx(LmpCtrlChannelModel.this.getIndex());
            return sControlChannelRespEx2;
        }

        @Override
        protected void setValue(Object object) throws xLmpException {
            LmpCtrlChannelModel.this.getLmpMgrRef().setControlChannelEx(LmpCtrlChannelModel.this.getIndex(), (sControlChannelAttrsEx)object);
            LmpCtrlChannelModel.this._value.update();
        }

        public Object outer() {
            return LmpCtrlChannelModel.this;
        }
    }
}

