/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.EtherL2Media.sMAProfile;
import cerent.cms.idl.EtherL2Media.sMIP;
import cerent.cms.model.IMAProfileInfo;
import cerent.cms.model.MIPInfo;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;

public class MIPInfoFactory {
    private MIPInfoFactory() {
    }

    public static MIPInfo[] getMIPModels(sMIP[] sMIPArray, XPL2ModuleModel xPL2ModuleModel) {
        if (sMIPArray == null) {
            return null;
        }
        MIPInfo[] mIPInfoArray = new MIPInfo[sMIPArray.length];
        for (int i = 0; i < sMIPArray.length; ++i) {
            mIPInfoArray[i] = MIPInfoFactory.getMIPModelFromMIP(sMIPArray[i], xPL2ModuleModel);
        }
        return mIPInfoArray;
    }

    public static sMAProfile getMAProfile(IMAProfileInfo iMAProfileInfo) {
        return new sMAProfile(iMAProfileInfo.getMAName(), iMAProfileInfo.getVlanId(), iMAProfileInfo.getCCEnabled());
    }

    public static sMIP getMIPFromMIPModel(MIPInfo mIPInfo) {
        sMIP sMIP2 = new sMIP();
        sMIP2.level = (short)mIPInfo.getLevel();
        sMIP2.portindex = mIPInfo.getLineModel().getLayer2LineModel().getIndex();
        sMIP2.svlanId = (short)mIPInfo.getFirst();
        return sMIP2;
    }

    private static MIPInfo getMIPModelFromMIP(sMIP sMIP2, XPL2ModuleModel xPL2ModuleModel) {
        MIPInfo mIPInfo = new MIPInfo(MIPInfoFactory.getLineModelFromL2Index(sMIP2.portindex, xPL2ModuleModel), sMIP2.svlanId, sMIP2.level);
        return mIPInfo;
    }

    private static XPL2LineModel getLineModelFromL2Index(int n, XPL2ModuleModel xPL2ModuleModel) {
        XPL2LineModel[] xPL2LineModelArray = xPL2ModuleModel.getXPL2EtherLines();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            if (xPL2LineModelArray[i].getLayer2LineModel().getIndex() != n) continue;
            return xPL2LineModelArray[i];
        }
        return null;
    }
}

