/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IModel;
import cerent.cms.model.IModelReplacement;
import cerent.cms.model.IfModelTypeSignature;
import cerent.cms.model.ReadResolveModelEnum;
import cerent.cms.model.ReadResolveModelStrategyMap;
import cerent.util.EnumStrings;
import cerent.util.IMetrics;
import cerent.util.IReadResolveStrategy;
import cerent.util.InetUtil;
import cerent.util.LogLevel;
import cerent.util.PerformanceMetrics;
import cerent.util.Preferences;
import cerent.util.ReadResolveCategoryEnum;
import cerent.util.SDebug;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ModelReplacement
implements IModelReplacement,
Externalizable {
    private static final long serialVersionUID = -523531446979572252L;
    private static final String[] catEnums = EnumStrings.getStrings(ReadResolveCategoryEnum.class);
    private static final Comparable[] catEnumRange = EnumStrings.getRange(ReadResolveCategoryEnum.class);
    private static final Integer _catEnumLowIndex = (Integer)catEnumRange[0];
    private static final int catEnumLowIndex = _catEnumLowIndex;
    private static final String[] modelEnums = EnumStrings.getStrings(ReadResolveModelEnum.class);
    private static final Comparable[] modelEnumRange = EnumStrings.getRange(ReadResolveModelEnum.class);
    private static final Integer _modelEnumLowIndex = (Integer)modelEnumRange[0];
    private static final int modelEnumLowIndex = _modelEnumLowIndex;
    private int rrCat;
    private int rrModelEnum;
    private int nodeId;
    private int modelIndex;
    private int ipAddr;
    private String strategyKey;
    private IfModelTypeSignature signature;
    protected static Debug db = new Debug("ModelReplacement");

    public int getCategory() {
        return this.rrCat;
    }

    public String getCategoryEnumName() {
        int n = this.getCategory();
        int n2 = n - catEnumLowIndex;
        if (n2 < 0 || n2 >= catEnums.length) {
            return Integer.toString(n);
        }
        return catEnums[n2];
    }

    public int getModelEnum() {
        return this.rrModelEnum;
    }

    public String getModelEnumName() {
        int n = this.getModelEnum();
        int n2 = n - modelEnumLowIndex;
        if (n2 < 0 || n2 >= modelEnums.length) {
            return Integer.toString(n);
        }
        return modelEnums[n2];
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public int getIpAddr() {
        return this.ipAddr;
    }

    public String getStrategyKey() {
        return this.strategyKey;
    }

    public IfModelTypeSignature getSignature() {
        return this.signature;
    }

    public void setModelReplacement(Class clazz, int n, int n2, int n3, int n4, String string, IfModelTypeSignature ifModelTypeSignature, int n5) {
        this.rrCat = n;
        this.rrModelEnum = n2;
        this.nodeId = n3;
        this.modelIndex = n4;
        this.strategyKey = string;
        this.signature = ifModelTypeSignature;
        this.ipAddr = n5;
        if (ifModelTypeSignature == null) {
            NullPointerException nullPointerException = new NullPointerException("ERROR: attempt to create/set an MR: " + this + " w/ a null signature for class: " + clazz + "(" + (clazz == null ? "" : clazz.getName()) + ")");
            db.logMessage(nullPointerException.getMessage(), LogLevel.OFF);
            db.logMessage(ModelReplacement.printStackTrace2String(nullPointerException), LogLevel.OFF);
            throw nullPointerException;
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (db.isFinerEnabled()) {
            db.finer("ModelReplacement writeExternal enter");
        }
        long l = 0L;
        IMetrics iMetrics = PerformanceMetrics.getInstance().getMetrics("ModelReplacement.writeExternal", IMetrics.modelReplacementDb, LogLevel.FINER, true);
        if (db.isTimingEnabled()) {
            l = System.currentTimeMillis();
        }
        if (db.isFinestEnabled()) {
            db.finest(this.toString());
        }
        objectOutput.writeInt(this.rrCat);
        objectOutput.writeInt(this.rrModelEnum);
        objectOutput.writeInt(this.nodeId);
        objectOutput.writeInt(this.modelIndex);
        objectOutput.writeInt(this.ipAddr);
        objectOutput.writeObject(this.strategyKey);
        objectOutput.writeObject(this.signature);
        if (db.isFinerEnabled()) {
            db.finer("ModelReplacement writeExternal exit");
        }
        iMetrics.stop();
        if (db.isTimingEnabled()) {
            db.reportTiming(0, "ModelReplacement writeExternal signature " + this.signature, l, System.currentTimeMillis());
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        long l = 0L;
        IMetrics iMetrics = null;
        try {
            if (db.isFinerEnabled()) {
                db.finer("ModelReplacement readExternal enter");
            }
            iMetrics = PerformanceMetrics.getInstance().getMetrics("ModelReplacement.readExternal", IMetrics.modelReplacementDb, LogLevel.FINER, true);
            if (db.isTimingEnabled()) {
                l = System.currentTimeMillis();
            }
            this.rrCat = objectInput.readInt();
            this.rrModelEnum = objectInput.readInt();
            this.nodeId = objectInput.readInt();
            this.modelIndex = objectInput.readInt();
            this.ipAddr = objectInput.readInt();
            this.strategyKey = (String)objectInput.readObject();
            this.signature = (IfModelTypeSignature)objectInput.readObject();
            if (db.isFinerEnabled()) {
                db.finer("ModelReplacement readExternal exit");
            }
        }
        catch (IOException iOException) {
            db.logMessage(ModelReplacement.printStackTrace2String(iOException), LogLevel.OFF);
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            db.logMessage(ModelReplacement.printStackTrace2String(classNotFoundException), LogLevel.OFF);
            throw classNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            this.logRuntimeException(runtimeException, null);
            throw runtimeException;
        }
        finally {
            iMetrics.stop();
            if (db.isTimingEnabled()) {
                db.reportTiming(1, "ModelReplacement readExternal signature " + this.signature, l, System.currentTimeMillis());
            }
        }
    }

    public Object readResolve() throws ObjectStreamException {
        IModel iModel = null;
        IReadResolveStrategy iReadResolveStrategy = null;
        long l = 0L;
        IMetrics iMetrics = null;
        try {
            if (db.on()) {
                db.println("ModelReplacement readResolve enter");
            }
            if (db.isFinerEnabled()) {
                db.finer(this.toString());
            }
            iMetrics = PerformanceMetrics.getInstance().getMetrics("ModelReplacement.readResolve", IMetrics.modelReplacementDb, LogLevel.FINER, true);
            if (db.isTimingEnabled()) {
                l = System.currentTimeMillis();
            }
            ReadResolveModelEnum readResolveModelEnum = ReadResolveModelEnum.getReadCounterpart((ReadResolveModelEnum)ReadResolveModelEnum.from_int((int)this.rrModelEnum));
            ReadResolveModelStrategyMap readResolveModelStrategyMap = ReadResolveModelStrategyMap.getInstance();
            iReadResolveStrategy = readResolveModelStrategyMap.get(ReadResolveCategoryEnum.from_int((int)this.rrCat), readResolveModelEnum, this.strategyKey);
            if (iReadResolveStrategy == null) {
                if (db.on()) {
                    db.println("*** NOTE: All NET models MUST USE the RR Model Enum of MODEL_PROXY");
                    db.println("*** See the AbstractNodeModel.getReadResolveModelEnum() for details");
                }
                throw new NullPointerException("for rrModelEnum: " + this.rrModelEnum + ", StrategyKey: " + this.strategyKey + " no read-resolve strategy could be found for MR: " + this.toString());
            }
            iModel = (IModel)iReadResolveStrategy.readResolve((Object)this);
            if (iModel == null) {
                throw new NullPointerException("using rrStrategy: " + iReadResolveStrategy + " it erroneously returned a null replacement object for MR: " + this.toString());
            }
            if (db.on()) {
                db.println("ModelReplacement readResolve exit");
            }
        }
        catch (RuntimeException runtimeException) {
            this.logRuntimeException(runtimeException, iReadResolveStrategy);
            throw runtimeException;
        }
        finally {
            iMetrics.stop();
            if (db.isTimingEnabled()) {
                db.reportTiming(2, "ModelReplacement readResolve signature " + this.signature, l, System.currentTimeMillis());
            }
        }
        return iModel;
    }

    private void logRuntimeException(RuntimeException runtimeException, IReadResolveStrategy iReadResolveStrategy) {
        if (iReadResolveStrategy != null) {
            db.logMessage("got readResolve() error on ModelReplacement: (" + this + ") using strategy: " + iReadResolveStrategy + " impl. needs to be fixed. There is NOT a problem w/ the model replacement serialization S/W!", LogLevel.OFF);
        }
        db.logMessage(ModelReplacement.printStackTrace2String(runtimeException), LogLevel.OFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String printStackTrace2String(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        try {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return stringWriter == null ? "" : stringWriter.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof ModelReplacement) {
            ModelReplacement modelReplacement = (ModelReplacement)object;
            if (this.rrCat == modelReplacement.rrCat && this.rrModelEnum == modelReplacement.rrModelEnum && this.modelIndex == modelReplacement.modelIndex && this.ipAddr == modelReplacement.ipAddr && this.strategyKey.equals(modelReplacement.strategyKey)) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 17;
        n += this.rrCat * 17;
        n += this.rrModelEnum * 17;
        n += this.nodeId * 17;
        return n += this.ipAddr * 17;
    }

    public String toString() {
        String string = InetUtil.makeDottedString(this.ipAddr);
        return "ModelReplacement Object for: \n\t Node Id: " + this.nodeId + "\n" + "\t IP Address: " + string + "\n" + "\t Model Sign: " + this.signature + "\n" + "\t Model Index: " + this.modelIndex + "\n" + "\t Strategy Key: " + this.strategyKey + "\n" + "\t RR Model Enum: " + this.getModelEnumName() + "\n" + "\t RR Category Enum: " + this.getCategoryEnumName();
    }

    public static class Debug
    extends SDebug {
        public static final int WRITE_EXTERNAL_TIMING = 0;
        public static final int READ_EXTERNAL_TIMING = 1;
        public static final int READ_RESOLVE_TIMING = 2;
        private boolean isTimingEnabled = Preferences.instance().getBoolean("ctc", "modelreplacement.timing", false);
        private int[] numTimings = new int[3];
        private long[] cumTiming = new long[3];

        public Debug(String string) {
            super(string);
        }

        public boolean isTimingEnabled() {
            return this.isTimingEnabled;
        }

        public final void enableTiming() {
            if (!this.isTimingEnabled) {
                for (int i = 0; i < this.numTimings.length; ++i) {
                    this.numTimings[i] = 0;
                    this.cumTiming[i] = 0L;
                }
            }
            this.isTimingEnabled = true;
        }

        public final void disableTiming() {
            this.isTimingEnabled = false;
        }

        public final void showTiming() {
            this.println(Boolean.toString(this.isTimingEnabled));
        }

        public void reportTiming(int n, String string, long l, long l2) {
            int n2 = n;
            this.numTimings[n2] = this.numTimings[n2] + 1;
            long l3 = l2 - l;
            this.println(string + " in: " + l3 + " msecs");
            int n3 = n;
            this.cumTiming[n3] = this.cumTiming[n3] + l3;
        }

        public final void showTimingSummary() {
            for (int i = 0; i < this.numTimings.length; ++i) {
                this.println("" + this.numTimings[i] + " - type " + i + " events in " + this.cumTiming[i] + " msec total elapsed time");
            }
        }

        public final void showCL() throws Exception {
            this.println("" + ModelReplacement.class.getClassLoader());
        }
    }
}

