/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.OchTrailAdit;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.idl.SonetTopology.sOchTrailAditItem;
import cerent.cms.idl.SonetTopology.xNoSuchConnection;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.Connections;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OchTrailAditModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class OchTrailAdits
extends Connections
implements Observer {
    ConnectionModelsDelegate container;
    NodeModelDelegate node;
    GetConnectionObjIndex getConnectionObjIndex;
    GetOchTrailAditList getOchTrailAditList;
    GetOchTrailAditIndexes getOchTrailAditIndexes;
    GetOchTrailAditItem getOchTrailAditItem;
    private EventDispatcher dispatcher;
    private boolean isInitedRealState;
    private OchTrailAditDebug db;
    private static final String MY_DEBUG_KEY = "OchTrailAdits";

    public OchTrailAdits(ConnectionModelsDelegate connectionModelsDelegate) {
        this.container = connectionModelsDelegate;
        this.node = connectionModelsDelegate.node;
        this.db = new OchTrailAditDebug(this.node.db);
        this.getConnectionObjIndex = new GetConnectionObjIndex(this.node, "OchTrailAdits.getConnectionObjIndex");
        this.getOchTrailAditList = new GetOchTrailAditList(this.node, "OchTrailAdits.getOchTrailAditList");
        this.getOchTrailAditIndexes = new GetOchTrailAditIndexes(this.node, "OchTrailAdits.getOchTrailAditIndexes");
        this.getOchTrailAditItem = new GetOchTrailAditItem(this.node, "OchTrailAdits.getOchTrailAditItem");
        this.dispatcher = null;
    }

    private SonetFactory getSonetFactoryRef() {
        return this.container.getSonetFactoryRef();
    }

    public void init() {
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectOchTrailAditList, 0, (Observer)this);
        }
    }

    private synchronized void initReal() {
        this.isInitedRealState = true;
        this.discover(this.connectionModels);
        Iterator iterator = this.connectionModels.values().iterator();
        while (iterator.hasNext()) {
            ((OchTrailAditModel)iterator.next()).init();
        }
    }

    @Override
    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectOchncConnectionList, 0, (Observer)this);
        }
        this.isInitedRealState = false;
        super.dispose();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        int n = ((IObjectMessageInfo)object).getUpdateType();
        switch (n) {
            case 1: {
                if (this.db.on) {
                    this.db.println("Got a Changed Message for OchTrailAdits");
                }
                this.container.updateLocal();
                break;
            }
            case 2: {
                if (this.db.on) {
                    this.db.println("Got an UpdateStructure Message for OchTrailAdit");
                }
                if (!this.updateOchTrailAditStructure()) break;
                if (this.db.on) {
                    this.db.println("Going to notify about update");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.ADDED);
                break;
            }
            case 0: {
                break;
            }
            default: {
                String string = "Unknown update message (" + n + ") on OchTrailAdits";
                this.db.println(string);
                OchTrailAditDebug.printStackTrace((Throwable)new IllegalArgumentException(string));
            }
        }
    }

    public Collection getConnectionModels() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return this.connectionModels.values();
    }

    @Override
    protected boolean updateStructure() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return this.updateOchTrailAditStructure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OchTrailAditModel add(OchTrailAdit ochTrailAdit) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        OchTrailAditModel ochTrailAditModel = null;
        if (ochTrailAdit == null) {
            return null;
        }
        OchTrailAdits ochTrailAdits = this;
        synchronized (ochTrailAdits) {
            block12: {
                ochTrailAditModel = this.findOchTrailAditModel(ochTrailAdit);
                if (ochTrailAditModel == null) {
                    try {
                        Integer n;
                        block11: {
                            ochTrailAditModel = new OchTrailAditModel(this.node, ochTrailAdit, (Connections)this);
                            n = new Integer(ochTrailAditModel.getObjIndex());
                            try {
                                ochTrailAditModel.setAttributes(this.getOchTrailAditItem(n));
                            }
                            catch (xNoSuchConnection xNoSuchConnection2) {
                                if (!this.db.on) break block11;
                                this.db.println("Caught noSuchConnection ");
                                OchTrailAditDebug.printStackTrace((Throwable)((Object)xNoSuchConnection2));
                            }
                        }
                        ochTrailAditModel.init();
                        this.connectionModels.put(n, ochTrailAditModel);
                        this.setChanged();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (this.db.on()) {
                            this.db.println("Exception in add-OchTrailAdit " + (Object)((Object)abstractCmsIOException));
                            this.printStackTrace((Exception)((Object)abstractCmsIOException));
                        }
                        if (ochTrailAditModel == null) break block12;
                        ochTrailAditModel.dispose();
                        ochTrailAditModel = null;
                    }
                }
            }
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        return ochTrailAditModel;
    }

    public synchronized OchTrailAditModel findOchTrailAditModel(sCircuitId sCircuitId2) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return (OchTrailAditModel)this.findConnectionModel(this.connectionModels.values(), sCircuitId2);
    }

    private void discover(Map map) {
        sOchTrailAditItem[] sOchTrailAditItemArray = this.getOchTrailAditItems();
        if (sOchTrailAditItemArray == null) {
            this.db.println("Error in getting OchTrail Adits (null) ConnectionModels::discover");
            return;
        }
        for (int i = 0; i < sOchTrailAditItemArray.length; ++i) {
            if (sOchTrailAditItemArray[i] == null) continue;
            Integer n = new Integer(sOchTrailAditItemArray[i].objIndex);
            map.put(n, new OchTrailAditModel(this.node, sOchTrailAditItemArray[i], (Connections)this));
        }
    }

    private sOchTrailAditItem[] getOchTrailAditItems() {
        sOchTrailAditItem[] sOchTrailAditItemArray;
        try {
            sOchTrailAditItemArray = (sOchTrailAditItem[])this.getOchTrailAditList.get();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("Error in getting OchTrailAdits " + (Object)((Object)abstractCmsIOException));
            OchTrailAditDebug.printStackTrace((Throwable)abstractCmsIOException);
            return null;
        }
        catch (UserException userException) {
            OchTrailAditDebug.printStackTrace((Throwable)userException);
            return null;
        }
        return sOchTrailAditItemArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OchTrailAditModel findOchTrailAditModel(OchTrailAdit ochTrailAdit) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        Object var2_2 = null;
        if (ochTrailAdit != null) {
            try {
                OchTrailAdits ochTrailAdits = this;
                synchronized (ochTrailAdits) {
                    Serializable serializable2;
                    for (Serializable serializable2 : this.connectionModels.values()) {
                        if (!ochTrailAdit._is_equivalent(serializable2.getOchTrailAditRef())) continue;
                        if (this.db.on) {
                            this.db.println("Found OchTrailAdit using _is_equivalent");
                        }
                        return serializable2;
                    }
                    if (this.db.on) {
                        this.db.println("Cannot find OchTrailAdit using _is_equivalent");
                    }
                    serializable2 = (Integer)this.getConnectionObjIndex.get(ochTrailAdit);
                    var2_2 = this.connectionModels.get(serializable2);
                }
            }
            catch (UserException userException) {
                OchTrailAditDebug.printStackTrace((Throwable)userException);
            }
        }
        if (var2_2 == null && this.db.on()) {
            this.db.println("Could not find the OchTrailAdit in the cache ");
        }
        return var2_2;
    }

    private void discoverOchTrailAditItems(HashMap hashMap) {
        sOchTrailAditItem[] sOchTrailAditItemArray = this.getOchTrailAditItems();
        if (sOchTrailAditItemArray == null) {
            return;
        }
        for (int i = 0; i < sOchTrailAditItemArray.length; ++i) {
            hashMap.put(new Integer(sOchTrailAditItemArray[i].objIndex), sOchTrailAditItemArray[i]);
        }
    }

    private synchronized boolean updateOchTrailAditStructure() {
        Serializable serializable;
        Object object;
        if (this.db.on()) {
            this.db.println("Entry:: ConnectionModels::updateOchTrailAditStructure");
        }
        Collection collection = null;
        boolean bl = false;
        collection = this.getOchTrailAditIndexes();
        if (collection == null) {
            this.db.println("Got no OchTrailAditIndexes from Node .. returning ..");
            return bl;
        }
        Collection collection2 = OchTrailAdits.getAddedObjects(collection, this.connectionModels.keySet());
        Iterator iterator = collection2.iterator();
        if (collection2.size() > 0) {
            if (this.db.on()) {
                this.db.println("OchTrail Adit found # " + collection2.size());
            }
            while (iterator.hasNext()) {
                object = null;
                serializable = (Integer)iterator.next();
                try {
                    object = this.getOchTrailAditItem((Integer)serializable);
                }
                catch (xNoSuchConnection xNoSuchConnection2) {
                    if (!this.db.on) continue;
                    this.db.println("Caught xNoSuchConnection in OchTrailAdit updateSt..");
                    continue;
                }
                OchTrailAditModel ochTrailAditModel = new OchTrailAditModel(this.node, (sOchTrailAditItem)object, (Connections)this);
                ochTrailAditModel.init();
                this.connectionModels.put(serializable, ochTrailAditModel);
            }
            bl = true;
        }
        if ((object = OchTrailAdits.getDeletedObjects(collection, this.connectionModels.keySet())).size() > 0) {
            if (this.db.on()) {
                this.db.println("OchTrailAdit Deleted found # " + object.size());
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                serializable = (OchTrailAditModel)this.connectionModels.get(iterator.next());
                if (serializable == null) continue;
                ((ConnectionModel)serializable).delete();
            }
        }
        if (this.db.on()) {
            this.db.println("Exit:: ConnectionModels::updateOchTrailStructure");
        }
        return bl;
    }

    private Collection getOchTrailAditIndexes() {
        try {
            return this.toCollection((int[])this.getOchTrailAditIndexes.get());
        }
        catch (UserException userException) {
            OchTrailAditDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private sOchTrailAditItem getOchTrailAditItem(Integer n) throws xNoSuchConnection {
        try {
            return (sOchTrailAditItem)this.getOchTrailAditItem.get(n);
        }
        catch (xNoSuchConnection xNoSuchConnection2) {
            throw xNoSuchConnection2;
        }
        catch (UserException userException) {
            OchTrailAditDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private class GetConnectionObjIndex
    extends NonCachedValue {
        public GetConnectionObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        public Object getValue(Object object) throws UserException {
            int n = ((OchTrailAdit)object).objIndex();
            return new Integer(n);
        }
    }

    private class GetOchTrailAditIndexes
    extends NonCachedValue {
        public GetOchTrailAditIndexes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchTrailAdits.this.getSonetFactoryRef().getOchTrailAditIndexes();
        }
    }

    private class GetOchTrailAditItem
    extends NonCachedValue {
        public GetOchTrailAditItem(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            return OchTrailAdits.this.getSonetFactoryRef().getOchTrailAditItem((Integer)object);
        }
    }

    private class GetOchTrailAditList
    extends NonCachedValue {
        public GetOchTrailAditList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchTrailAdits.this.getSonetFactoryRef().getOchTrailAditList();
        }
    }

    public class OchTrailAditDebug
    extends SDebug {
        OchTrailAditDebug(SDebug sDebug) {
            super((KDebug)sDebug, OchTrailAdits.MY_DEBUG_KEY);
        }

        public final void update() {
            OchTrailAdits.this.updateOchTrailAditStructure();
        }

        public final void printConnections() {
            OchTrailAdits.this.db.println("Printing List of OchTrailAdits \n");
            OchTrailAdits.this.printConnectionString(this);
        }
    }
}

