/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Circuits.xInvalidCircuitName;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eEdAdminStateCmd;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.If.xInvalidState;
import cerent.cms.idl.SonetTopology.OchCcConnection;
import cerent.cms.idl.SonetTopology.eConnectionType;
import cerent.cms.idl.SonetTopology.sOchCcConnectionItem;
import cerent.cms.idl.SonetTopology.sOchCcPathDef;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.idl.SonetTopology.xConnectionInLoopback;
import cerent.cms.idl.SonetTopology.xTestAccessActive;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CloneHelper;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.Connections;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidState;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OchccPathDefModelFactory;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.TestAccessActive;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.UserException;

public class OchccConnectionModel
extends ConnectionModel
implements IOchccConnectionModel {
    private OchCcConnection connRef;
    private Paths paths = null;
    private ObjIndex objIndex;
    private Destroy destroy = null;
    private CircuitId circuitId;
    private ConnectionType connectionType;
    private AdminState adminState;
    private ServiceState serviceState;
    private ConnectionName connectionName = null;

    public OchccConnectionModel(NodeModelDelegate nodeModelDelegate, OchCcConnection ochCcConnection, Connections connections) {
        super(nodeModelDelegate, connections, nodeModelDelegate.getChildDebug(OchccConnectionModel.class));
        this.connRef = ochCcConnection;
        this.paths = new Paths(nodeModelDelegate, "OchccConnectionModel.paths");
        this.destroy = new Destroy(nodeModelDelegate, "OchccConnectionModel.destroy");
        this.objIndex = new ObjIndex(nodeModelDelegate, "OchccConnectionModel.objIndex");
        this.circuitId = new CircuitId(nodeModelDelegate, "OchccConnectionModel.circuitId");
        this.connectionType = new ConnectionType(nodeModelDelegate, "OchccConnectionModel.connectionType");
        this.adminState = new AdminState(nodeModelDelegate, "OchccConnectionModel.adminState");
        this.serviceState = new ServiceState(nodeModelDelegate, "OchccConnectionModel.serviceState");
        this.connectionName = new ConnectionName(nodeModelDelegate, "OchccConnectionModel.connectionName");
    }

    public OchccConnectionModel(NodeModelDelegate nodeModelDelegate, sOchCcConnectionItem sOchCcConnectionItem2, Connections connections) {
        this(nodeModelDelegate, sOchCcConnectionItem2.ochCcConn, connections);
        this.setAttributes(sOchCcConnectionItem2);
    }

    @Override
    public void init() {
        super.init();
    }

    public void setAttributes(sOchCcConnectionItem sOchCcConnectionItem2) {
        this.adminState.setValueExternally(sOchCcConnectionItem2.adminState);
        this.serviceState.setValueExternally(sOchCcConnectionItem2.serviceState);
        this.circuitId.setValueExternally(sOchCcConnectionItem2.circuitId);
        this.connectionName.setValueExternally(sOchCcConnectionItem2.name);
        this.connectionType.setValueExternally(sOchCcConnectionItem2.connectionType);
        this.objIndex.setValueExternally(new Integer(sOchCcConnectionItem2.objIndex));
        this.paths.setValueExternally(sOchCcConnectionItem2.paths);
    }

    @Override
    protected void updateLocal() {
        if (this.db.on) {
            this.db.println("OchccConnectionModel Update Local called:" + Integer.toHexString(this.index));
        }
        this.paths.update();
        this.adminState.update();
        this.serviceState.update();
        this.circuitId.update();
        this.connectionType.update();
        this.connectionName.update();
        this.setChanged();
        super.updateLocal();
    }

    @Override
    public void dispose() {
        this.adminState.dispose();
        this.serviceState.dispose();
        this.circuitId.dispose();
        this.connectionType.dispose();
        this.connectionName.dispose();
        this.paths.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.connRef = null;
    }

    public OchCcConnection getConnectionRef() {
        if (this.connRef == null) {
            throw new CmsObjectNotExistException(ErrorMsg.getString((EID)EMC.EID_ERROR_ACCESS_OCHCCCONNECTION));
        }
        return this.connRef;
    }

    public void localDestroy() throws Busy {
        try {
            this.destroy.get();
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (UserException userException) {
            this.db.println("OchccConnectionModel.destroy(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public ICircuitId getCircuitId() {
        try {
            sCircuitId sCircuitId2 = (sCircuitId)this.circuitId.get();
            return CircuitIdFactory.getICircuitId(sCircuitId2);
        }
        catch (UserException userException) {
            this.db.println("OchccConnectionModel.getCircuitId(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    public void setCircuitId(ICircuitId iCircuitId) {
        try {
            this.circuitId.set(CircuitIdFactory.getCircuitId(iCircuitId));
        }
        catch (UserException userException) {
            this.db.println("OchccConnectionModel.setCircuitId(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public int getConnectionType() {
        try {
            eConnectionType eConnectionType2 = (eConnectionType)this.connectionType.get();
            return eConnectionType2.value();
        }
        catch (UserException userException) {
            this.db.println("OchccConnectionModel.getConnectionType(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    @Override
    public String getConnectionName() {
        try {
            return (String)this.connectionName.get();
        }
        catch (UserException userException) {
            this.db.println("OchccConnectionModel.getConnectionName(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    public void setConnectionName(String string) throws InvalidCircuitName {
        try {
            this.connectionName.set(string);
        }
        catch (xInvalidCircuitName xInvalidCircuitName2) {
            throw new InvalidCircuitName((UserException)xInvalidCircuitName2);
        }
        catch (UserException userException) {
            this.db.println("OchccConnectionModel.setConnectioName(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public int getObjIndex() {
        try {
            return (Integer)this.objIndex.get();
        }
        catch (UserException userException) {
            this.db.println("OchccConnectionModel.getObjIndex(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    @Override
    public int getShelfId() {
        EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
        try {
            IEntityModel iEntityModel = entityTableModel.getEntityModelByIndex(this.getObjIndex());
            return iEntityModel.getShelfId();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.fine("no such entity for " + this.getObjIndex());
            return 1;
        }
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.ObjectOchCcConnection;
    }

    @Override
    public eAdminState getAdminStateEnum() throws AbstractCmsIOException {
        try {
            return (eAdminState)this.adminState.get();
        }
        catch (UserException userException) {
            this.db.severe("OchccConnectionModel.getAdminState(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    public void setAdminState(eAdminState eAdminState2) throws TestAccessActive, ConnectionInLoopback, AbstractCmsIOException, InvalidState {
        try {
            this.adminState.set(eAdminState2);
        }
        catch (xTestAccessActive xTestAccessActive2) {
            throw new TestAccessActive((UserException)xTestAccessActive2);
        }
        catch (xConnectionInLoopback xConnectionInLoopback2) {
            throw new ConnectionInLoopback((UserException)xConnectionInLoopback2);
        }
        catch (xInvalidState xInvalidState2) {
            this.db.println("OchccConnectionModel.setAdminState: state = " + eAdminState2.value());
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (UserException userException) {
            this.db.severe("OchccConnectionModel.setAdminState(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public int getServiceState() throws AbstractCmsIOException {
        try {
            return ServiceStateFactory.getServiceState((sServiceState)this.serviceState.get()).getType();
        }
        catch (UserException userException) {
            this.db.severe("OchccConnectionModel.getServiceState(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -2;
        }
    }

    public IOchccPathDefModel[] getPaths() {
        if (this.db.on()) {
            this.db.println("getPaths called on" + this);
        }
        IOchccPathDefModel[] iOchccPathDefModelArray = null;
        try {
            iOchccPathDefModelArray = (IOchccPathDefModel[])this.paths.get();
            if (this.db.on) {
                this.db.println("Paths(size=" + iOchccPathDefModelArray.length + ")= " + Arrays.asList(iOchccPathDefModelArray));
            }
        }
        catch (UserException userException) {
            this.db.println("OchccConnectionModel.getPaths(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
        return iOchccPathDefModelArray;
    }

    public List getPathList() {
        return Arrays.asList(this.getPaths());
    }

    public IOchTrailAditModel getAdit() {
        IOchTrailAditModel[] iOchTrailAditModelArray = this.getNodeModelDelegate().getConnectionModels().getOchTrailAditModels();
        IOchccPathDefModel[] iOchccPathDefModelArray = this.getPaths();
        for (int i = 0; i < iOchTrailAditModelArray.length; ++i) {
            IOchncPathDefModel[] iOchncPathDefModelArray;
            IOchTrailAditModel iOchTrailAditModel = iOchTrailAditModelArray[i];
            if (iOchTrailAditModel.getCircuitId().getUniquePart().getUniqueId() == 0 && iOchTrailAditModel.getCircuitId().getNodeId() != 0 || !this.arePathsMatching(iOchccPathDefModelArray, iOchncPathDefModelArray = iOchTrailAditModel.getPaths())) continue;
            return iOchTrailAditModel;
        }
        return null;
    }

    private boolean arePathsMatching(IOchccPathDefModel[] iOchccPathDefModelArray, IOchncPathDefModel[] iOchncPathDefModelArray) {
        for (int i = 0; i < iOchccPathDefModelArray.length; ++i) {
            for (int j = 0; j < iOchncPathDefModelArray.length; ++j) {
                if (iOchccPathDefModelArray[i].getPortEntityIdx() != iOchncPathDefModelArray[j].getPortEntityIdx()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void printString(SDebug sDebug) {
        IOchccPathDefModel[] iOchccPathDefModelArray = this.getPaths();
        sDebug.println("Connection Type " + EnumStrings.getStrings((Object)eConnectionType.TWOWAY)[this.getConnectionType()]);
        sDebug.println("CktName =  " + this.getConnectionName());
        sDebug.println("Observers are :");
        this.printObservers();
        sDebug.println("Number of Paths Are " + iOchccPathDefModelArray.length);
        for (int i = 0; i < iOchccPathDefModelArray.length; ++i) {
            sDebug.println("Path " + i + iOchccPathDefModelArray[i]);
        }
    }

    @Override
    public List getPortModels() {
        return new LinkedList();
    }

    public boolean inRoll() {
        return false;
    }

    @Override
    public boolean validateNewAdminState(int n) throws AbstractCmsIOException {
        return true;
    }

    private class AdminState
    extends CachedValue {
        public AdminState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchccConnectionModel.this.getConnectionRef().adminState();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            OchccConnectionModel.this.getConnectionRef().setAdminState((eAdminState)object, eEdAdminStateCmd.EDSTATE_ED);
        }

        @Override
        protected Object cloneValue() {
            return CloneHelper.clone((eAdminState)this.value);
        }
    }

    private class CircuitId
    extends CachedValue {
        public CircuitId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchccConnectionModel.this.getConnectionRef().circuitId();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            OchccConnectionModel.this.getConnectionRef().circuitId((sCircuitId)object);
        }
    }

    private class ConnectionName
    extends CachedValue {
        public ConnectionName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchccConnectionModel.this.getConnectionRef().getConnectionName();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            OchccConnectionModel.this.getConnectionRef().setConnectionName((String)object);
        }
    }

    private class ConnectionType
    extends CachedValue {
        public ConnectionType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchccConnectionModel.this.getConnectionRef().connectionType();
        }
    }

    private class Destroy
    extends NonCachedValue {
        public Destroy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            OchccConnectionModel.this.getConnectionRef().destroy();
            return null;
        }
    }

    private class ObjIndex
    extends CachedValue {
        public ObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            int n = OchccConnectionModel.this.getConnectionRef().objIndex();
            return new Integer(n);
        }
    }

    private class Paths
    extends CachedValue {
        public Paths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchccPathDefModelFactory.getIOchccPathDefArray(this.node, OchccConnectionModel.this.getConnectionRef().paths());
        }

        @Override
        public void setValueExternally(Object object) {
            super.setValueExternally(OchccPathDefModelFactory.getIOchccPathDefArray(this.node, (sOchCcPathDef[])object));
        }

        @Override
        protected Object cloneValue() {
            return CloneHelper.clone((IOchccPathDefModel[])this.value);
        }
    }

    private class ServiceState
    extends CachedValue {
        public ServiceState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchccConnectionModel.this.getConnectionRef().getServiceState();
        }

        @Override
        protected Object cloneValue() {
            return CloneHelper.clone((sServiceState)this.value);
        }
    }
}

