/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Circuits.xInvalidCircuitName;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eEdAdminStateCmd;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.If.xInvalidState;
import cerent.cms.idl.SonetTopology.OchncConnection;
import cerent.cms.idl.SonetTopology.eConnectionType;
import cerent.cms.idl.SonetTopology.sOchncConnectionItem;
import cerent.cms.idl.SonetTopology.sOchncPathDef;
import cerent.cms.idl.SonetTopology.sOchncPathDiagnosticItem;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.idl.SonetTopology.xConnectionInLoopback;
import cerent.cms.idl.SonetTopology.xTestAccessActive;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CloneHelper;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.Connections;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.IOchncPathDiagnosticItem;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidState;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OchncPathDefModelFactory;
import cerent.cms.model.OchncPathDiagnosticItem;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.TestAccessActive;
import cerent.cms.model.event.AttributeValue;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import org.omg.CORBA.UserException;

public class OchncConnectionModel
extends ConnectionModel
implements IOchncConnectionModel {
    private OchncConnection ochncConnectionRef;
    private ObjIndex objIndex;
    private Destroy destroy = null;
    private CircuitId circuitId;
    private ConnectionType connectionType;
    private AdminState adminState;
    private ServiceState serviceState;
    private Paths paths = null;
    private ConnectionName connectionName = null;
    private IsDcnConnection isDcnConnection;
    private DiagInfo diagInfo = null;
    private IsPartial isPartial = null;

    public OchncConnectionModel(NodeModelDelegate nodeModelDelegate, OchncConnection ochncConnection, Connections connections) {
        super(nodeModelDelegate, connections, nodeModelDelegate.getChildDebug(OchncConnectionModel.class));
        this.ochncConnectionRef = ochncConnection;
        this.destroy = new Destroy(nodeModelDelegate, "OchncConnectionModel.destroy");
        this.objIndex = new ObjIndex(nodeModelDelegate, "OchncConnectionModel.objIndex");
        this.circuitId = new CircuitId(nodeModelDelegate, "OchncConnectionModel.circuitId");
        this.connectionType = new ConnectionType(nodeModelDelegate, "OchncConnectionModel.connectionType");
        this.adminState = new AdminState(nodeModelDelegate, "OchncConnectionModel.adminState");
        this.serviceState = new ServiceState(nodeModelDelegate, "OchncConnectionModel.serviceState");
        this.paths = new Paths(nodeModelDelegate, "OchncConnectionModel.paths");
        this.connectionName = new ConnectionName(nodeModelDelegate, "OchncConnectionModel.connectionName");
        this.isDcnConnection = new IsDcnConnection(nodeModelDelegate, "OchncConnectionModel.isDcnConnection");
        this.diagInfo = new DiagInfo(nodeModelDelegate, "OchncConnectionModel.diagInfo");
        this.isPartial = new IsPartial(nodeModelDelegate, "OchncConnectionModel.isPartial");
    }

    public OchncConnectionModel(NodeModelDelegate nodeModelDelegate, sOchncConnectionItem sOchncConnectionItem2, Connections connections) {
        this(nodeModelDelegate, sOchncConnectionItem2.ochncConn, connections);
        this.setAttributes(sOchncConnectionItem2);
    }

    @Override
    public void init() {
        super.init();
    }

    public void setAttributes(sOchncConnectionItem sOchncConnectionItem2) {
        this.adminState.setValueExternally(sOchncConnectionItem2.adminState);
        this.serviceState.setValueExternally(sOchncConnectionItem2.serviceState);
        this.circuitId.setValueExternally(sOchncConnectionItem2.circuitId);
        this.connectionName.setValueExternally(sOchncConnectionItem2.name);
        this.connectionType.setValueExternally(sOchncConnectionItem2.connectionType);
        this.objIndex.setValueExternally(new Integer(sOchncConnectionItem2.objIndex));
        this.paths.setValueExternally(sOchncConnectionItem2.paths);
        this.isDcnConnection.setValueExternally(sOchncConnectionItem2.isDCN);
        this.isPartial.setValueExternally(sOchncConnectionItem2.isPartial);
    }

    @Override
    protected void updateLocal() {
        if (this.db.on) {
            this.db.println("OchncConnectionModel Update Local called:" + Integer.toHexString(this.index));
        }
        this.adminState.update();
        this.serviceState.update();
        this.circuitId.update();
        this.connectionType.update();
        this.paths.update();
        this.connectionName.update();
        this.isDcnConnection.update();
        this.isPartial.update();
        this.setChanged();
        super.updateLocal();
    }

    @Override
    public void dispose() {
        this.adminState.dispose();
        this.serviceState.dispose();
        this.circuitId.dispose();
        this.connectionType.dispose();
        this.paths.dispose();
        this.connectionName.dispose();
        this.isDcnConnection.dispose();
        this.isPartial.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.ochncConnectionRef = null;
    }

    public OchncConnection getConnectionRef() {
        if (this.ochncConnectionRef == null) {
            throw new CmsObjectNotExistException(ErrorMsg.getString((EID)EMC.EID_ERROR_ACCESS_OCHNCCONNECTION));
        }
        return this.ochncConnectionRef;
    }

    public IOchncPathDefModel[] getPaths() {
        if (this.db.on()) {
            this.db.println("getPaths called on" + this);
        }
        IOchncPathDefModel[] iOchncPathDefModelArray = null;
        try {
            iOchncPathDefModelArray = (IOchncPathDefModel[])this.paths.get();
            if (this.db.on) {
                this.db.println("Paths(size=" + iOchncPathDefModelArray.length + ")= " + Arrays.asList(iOchncPathDefModelArray));
            }
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.getPaths(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
        return iOchncPathDefModelArray;
    }

    public List getPathList() {
        return Arrays.asList(this.getPaths());
    }

    public void localDestroy() throws Busy {
        try {
            this.destroy.get();
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.destroy(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getOptDir() {
        return -1;
    }

    public int getOptChannel() {
        IOchncPathDefModel[] iOchncPathDefModelArray = this.getPaths();
        return iOchncPathDefModelArray[0].getOptChannel();
    }

    @Override
    public ICircuitId getCircuitId() {
        try {
            sCircuitId sCircuitId2 = (sCircuitId)this.circuitId.get();
            return CircuitIdFactory.getICircuitId(sCircuitId2);
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.getCircuitId(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    public String getConnectionName() {
        try {
            return (String)this.connectionName.get();
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.getConnactionName(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    public void setConnectionName(String string) throws InvalidCircuitName {
        try {
            this.connectionName.set(string);
        }
        catch (xInvalidCircuitName xInvalidCircuitName2) {
            throw new InvalidCircuitName((UserException)xInvalidCircuitName2);
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.setConnectionName(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public int getObjIndex() {
        try {
            return (Integer)this.objIndex.get();
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.getObjIndex(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    @Override
    public int getShelfId() {
        EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
        try {
            IEntityModel iEntityModel = entityTableModel.getEntityModelByIndex(this.getObjIndex());
            return iEntityModel.getShelfId();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.fine("no such entity for " + this.getObjIndex());
            return 1;
        }
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.ObjectOchncConnection;
    }

    @Override
    public void setCircuitId(ICircuitId iCircuitId) {
        try {
            this.circuitId.set(CircuitIdFactory.getCircuitId(iCircuitId));
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.setCircuitId(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public int getConnectionType() {
        try {
            eConnectionType eConnectionType2 = (eConnectionType)this.connectionType.get();
            return eConnectionType2.value();
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.getConnectionType(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    @Override
    public eAdminState getAdminStateEnum() throws AbstractCmsIOException {
        try {
            return (eAdminState)this.adminState.get();
        }
        catch (UserException userException) {
            this.db.severe("OchncConnectionModel: user exception in getAdminState");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    public void setAdminState(eAdminState eAdminState2) throws TestAccessActive, ConnectionInLoopback, AbstractCmsIOException, InvalidState {
        try {
            this.adminState.set(eAdminState2);
        }
        catch (xTestAccessActive xTestAccessActive2) {
            throw new TestAccessActive((UserException)xTestAccessActive2);
        }
        catch (xConnectionInLoopback xConnectionInLoopback2) {
            throw new ConnectionInLoopback((UserException)xConnectionInLoopback2);
        }
        catch (xInvalidState xInvalidState2) {
            this.db.println("OchncConnectionModel.setAdminState: state = " + eAdminState2.value());
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (UserException userException) {
            this.db.severe("OchncConnectionModel: user exception in setAdminState");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public int getServiceState() throws AbstractCmsIOException {
        try {
            return ServiceStateFactory.getServiceState((sServiceState)this.serviceState.get()).getType();
        }
        catch (UserException userException) {
            this.db.severe("OchncConnectionModel: user exception in getServiceState");
            SDebug.printStackTrace((Throwable)userException);
            return -2;
        }
    }

    public boolean isPartial() {
        try {
            return (Boolean)this.isPartial.get();
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.isPartial(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public boolean isDcnConnection() {
        try {
            return (Boolean)this.isDcnConnection.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getSideOutputEntityIdx", userException);
        }
    }

    public IOchncPathDiagnosticItem[] getDiagInfo() {
        try {
            sOchncPathDiagnosticItem[] sOchncPathDiagnosticItemArray = (sOchncPathDiagnosticItem[])this.diagInfo.get();
            if (sOchncPathDiagnosticItemArray != null) {
                IOchncPathDiagnosticItem[] iOchncPathDiagnosticItemArray = new IOchncPathDiagnosticItem[sOchncPathDiagnosticItemArray.length];
                for (int i = 0; i < sOchncPathDiagnosticItemArray.length; ++i) {
                    sOchncPathDiagnosticItem sOchncPathDiagnosticItem2 = sOchncPathDiagnosticItemArray[i];
                    iOchncPathDiagnosticItemArray[i] = new OchncPathDiagnosticItem(sOchncPathDiagnosticItem2.state.value(), sOchncPathDiagnosticItem2.portTargetIdx);
                }
                return iOchncPathDiagnosticItemArray;
            }
            return new IOchncPathDiagnosticItem[0];
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getDiagInfo", userException);
        }
    }

    @Override
    protected void printString(SDebug sDebug) {
        IOchncPathDefModel[] iOchncPathDefModelArray = this.getPaths();
        sDebug.println("Connection Type " + EnumStrings.getStrings((Object)eConnectionType.OCHNC_TWOWAY)[this.getConnectionType()]);
        sDebug.println("DCN connection =  " + (this.isDcnConnection() ? "Yes" : "No"));
        sDebug.println("CktName =  " + this.getConnectionName());
        sDebug.println("Observers are :");
        this.printObservers();
        sDebug.println("Number of Paths Are " + iOchncPathDefModelArray.length);
        for (int i = 0; i < iOchncPathDefModelArray.length; ++i) {
            sDebug.println("Path " + i + iOchncPathDefModelArray[i]);
        }
    }

    @Override
    public List getPortModels() {
        return new LinkedList();
    }

    public boolean inRoll() {
        return false;
    }

    @Override
    public boolean validateNewAdminState(int n) throws AbstractCmsIOException {
        return true;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 1: {
                    ArrayList arrayList;
                    if (this.db.on()) {
                        this.db.println("OchncConnectionModel update(): this CHANGED");
                    }
                    if ((arrayList = ((ObjectMessageInfo)object).getChangedValues()).isEmpty()) {
                        this.updateLocal();
                        break;
                    }
                    for (AttributeValue attributeValue : arrayList) {
                        switch (attributeValue.getName()) {
                            case 0: {
                                this.serviceState.setValueExternally(attributeValue.getValue());
                            }
                        }
                    }
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
                default: {
                    super.update(observable, object);
                }
            }
        }
    }

    private class AdminState
    extends CachedValue {
        public AdminState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchncConnectionModel.this.getConnectionRef().adminState();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            OchncConnectionModel.this.getConnectionRef().setAdminState((eAdminState)object, eEdAdminStateCmd.EDSTATE_ED);
        }

        @Override
        protected Object cloneValue() {
            return CloneHelper.clone((eAdminState)this.value);
        }
    }

    private class CircuitId
    extends CachedValue {
        public CircuitId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchncConnectionModel.this.getConnectionRef().circuitId();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            OchncConnectionModel.this.getConnectionRef().circuitId((sCircuitId)object);
        }
    }

    private class ConnectionName
    extends CachedValue {
        public ConnectionName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchncConnectionModel.this.getConnectionRef().getConnectionName();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            OchncConnectionModel.this.getConnectionRef().setConnectionName((String)object);
        }
    }

    private class ConnectionType
    extends CachedValue {
        public ConnectionType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchncConnectionModel.this.getConnectionRef().connectionType();
        }
    }

    private class Destroy
    extends NonCachedValue {
        public Destroy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            OchncConnectionModel.this.getConnectionRef().destroy();
            return null;
        }
    }

    private class DiagInfo
    extends NonCachedValue {
        public DiagInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchncConnectionModel.this.getConnectionRef().getDiagnosticInfo();
        }
    }

    private class IsDcnConnection
    extends CachedValue {
        public IsDcnConnection(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            boolean bl = OchncConnectionModel.this.getConnectionRef().isDCN();
            return new Boolean(bl);
        }
    }

    private class IsPartial
    extends CachedValue {
        public IsPartial(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchncConnectionModel.this.getConnectionRef().isPartial();
        }

        @Override
        protected Object cloneValue() {
            return CloneHelper.clone((Boolean)this.value);
        }
    }

    private class ObjIndex
    extends CachedValue {
        public ObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            int n = OchncConnectionModel.this.getConnectionRef().objIndex();
            return new Integer(n);
        }
    }

    private class Paths
    extends CachedValue {
        public Paths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchncPathDefModelFactory.getIOchncPathDefArray(this.node, OchncConnectionModel.this.getConnectionRef().paths());
        }

        @Override
        public void setValueExternally(Object object) {
            super.setValueExternally(OchncPathDefModelFactory.getIOchncPathDefArray(this.node, (sOchncPathDef[])object));
        }

        @Override
        protected Object cloneValue() {
            return CloneHelper.clone((IOchncPathDefModel[])this.value);
        }
    }

    private class ServiceState
    extends CachedValue {
        public ServiceState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchncConnectionModel.this.getConnectionRef().getServiceState();
        }

        @Override
        protected Object cloneValue() {
            return CloneHelper.clone((sServiceState)this.value);
        }
    }
}

