/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.Connections;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IOhConnectionModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public abstract class OhAbstractConnections
extends Connections
implements Observer {
    protected OhConnectionModelsDelegate container;
    protected NodeModelDelegate node;
    protected ConnDebug db;
    private EventDispatcher dispatcher;

    protected abstract ObjectType getObjectType();

    protected abstract ConnectionModel createConnectionModel(NodeModelDelegate var1, Object var2);

    protected abstract Object[] getConnectionItems();

    abstract Integer getIdlObjIdx(Object var1);

    public OhAbstractConnections(OhConnectionModelsDelegate ohConnectionModelsDelegate, String string) {
        this.container = ohConnectionModelsDelegate;
        this.node = ohConnectionModelsDelegate.node;
        this.db = new ConnDebug(this.node.db, string);
        this.dispatcher = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(this.getObjectType(), 0, (Observer)this);
        }
        OhAbstractConnections ohAbstractConnections = this;
        synchronized (ohAbstractConnections) {
            this.discover(this.connectionModels);
            for (ConnectionModel connectionModel : this.connectionModels.values()) {
                connectionModel.init();
            }
        }
    }

    @Override
    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(this.getObjectType(), 0, (Observer)this);
        }
        super.dispose();
    }

    public Collection getConnectionModels(IChassisModel iChassisModel) {
        Collection collection = this.cloneConnectionModels().values();
        Iterator iterator = collection.iterator();
        int n = iChassisModel.getShelfId();
        while (iterator.hasNext()) {
            if (n == ((ConnectionModel)iterator.next()).getShelfId()) continue;
            iterator.remove();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionModel add(Object object) {
        ConnectionModel connectionModel = null;
        if (object == null) {
            return null;
        }
        OhAbstractConnections ohAbstractConnections = this;
        synchronized (ohAbstractConnections) {
            block8: {
                Integer n = this.getIdlObjIdx(object);
                connectionModel = (ConnectionModel)this.connectionModels.get(n);
                if (connectionModel == null) {
                    try {
                        connectionModel = this.createConnectionModel(this.node, object);
                        connectionModel.init();
                        this.connectionModels.put(n, connectionModel);
                        this.setChanged();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (this.db.on()) {
                            this.db.warning("Exception occured in add-Conn " + (Object)((Object)abstractCmsIOException));
                            this.printStackTrace((Exception)((Object)abstractCmsIOException));
                        }
                        if (connectionModel == null) break block8;
                        connectionModel.dispose();
                        connectionModel = null;
                    }
                }
            }
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        return connectionModel;
    }

    private synchronized void discover(Map map) {
        block5: {
            try {
                Object[] objectArray = this.getConnectionItems();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) continue;
                    try {
                        ConnectionModel connectionModel = this.createConnectionModel(this.node, objectArray[i]);
                        map.put(new Integer(connectionModel.getObjIndex()), connectionModel);
                        continue;
                    }
                    catch (Exception exception) {
                        this.db.println("Caught Exception in discover");
                        if (!this.db.on()) continue;
                        ConnDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                this.db.println("Caught Exception in discover");
                if (!this.db.on()) break block5;
                ConnDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void discoverConnectionItems(HashMap hashMap) {
        block3: {
            try {
                Object[] objectArray = this.getConnectionItems();
                for (int i = 0; i < objectArray.length; ++i) {
                    hashMap.put(this.getIdlObjIdx(objectArray[i]), objectArray[i]);
                }
            }
            catch (Exception exception) {
                this.db.println("Caught Exception in discoverConnectionItems");
                if (!this.db.on()) break block3;
                ConnDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    protected boolean updateStructure() {
        return this.updateConnectionStructure();
    }

    private synchronized boolean updateConnectionStructure() {
        if (this.db.on()) {
            this.db.fine("Entry:: ConnectionModels::updateConnectionStructure");
        }
        HashMap hashMap = new HashMap();
        boolean bl = false;
        this.discoverConnectionItems(hashMap);
        Collection collection = OhAbstractConnections.getAddedObjects(hashMap.keySet(), this.connectionModels.keySet());
        Iterator iterator = collection.iterator();
        if (collection.size() > 0) {
            if (this.db.on()) {
                this.db.fine("New vt found # " + collection.size());
            }
            while (iterator.hasNext()) {
                Object v = hashMap.get(iterator.next());
                ConnectionModel connectionModel = this.createConnectionModel(this.node, v);
                connectionModel.init();
                Integer n = new Integer(connectionModel.getObjIndex());
                this.connectionModels.put(n, connectionModel);
            }
            bl = true;
        }
        if (this.db.on()) {
            this.db.finer("Exit:: ConnectionModels::updateConnectionStructure");
        }
        return bl;
    }

    public synchronized void remove(ConnectionModel connectionModel) {
        this.connectionModels.remove(new Integer(connectionModel.getObjIndex()));
    }

    @Override
    public void update(Observable observable, Object object) {
        int n = ((IObjectMessageInfo)object).getUpdateType();
        switch (n) {
            case 1: {
                if (this.db.on()) {
                    this.db.info("Got a Changed Message");
                }
                this.container.updateLocal();
                break;
            }
            case 2: {
                if (this.db.on()) {
                    this.db.info("Got an update structure Message");
                }
                if (!this.updateConnectionStructure()) break;
                if (this.db.on()) {
                    this.db.info("Going to notify Observers of change");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.ADDED);
                break;
            }
            case 0: {
                break;
            }
            default: {
                String string = "Unknown update message (" + n + ") on OhAbstractConnections";
                this.db.info(string);
                ConnDebug.printStackTrace((Throwable)new IllegalArgumentException(string));
            }
        }
    }

    public boolean isChannelInUse(int n, OhChannelType ohChannelType) {
        return this.findConnectionModel(n, ohChannelType) != null;
    }

    public IOhConnectionModel findConnectionModel(int n, OhChannelType ohChannelType) {
        for (IOhConnectionModel iOhConnectionModel : this.cloneConnectionModels().values()) {
            if (!iOhConnectionModel.usedChannel(n, ohChannelType)) continue;
            return iOhConnectionModel;
        }
        return null;
    }

    public class ConnDebug
    extends SDebug {
        ConnDebug(SDebug sDebug, String string) {
            super((KDebug)sDebug, string);
        }

        public final void update() {
            OhAbstractConnections.this.updateConnectionStructure();
        }

        public final void printConnections() {
            OhAbstractConnections.this.db.fine("Printing List of Connections \n");
            OhAbstractConnections.this.printConnectionString(this);
        }
    }
}

