/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.util.ISequenceNumberConstants;
import cerent.util.LongObjHolder;
import cerent.util.ShortHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class QueuedSequenceNumberAdjuster {
    private static final long UNINITIALIZED_SEQ_NUM = -1L;
    private static final Long UNINITIALIZED_SEQ_NUM_OBJ = ISequenceNumberConstants.UNINITIALIZED_SEQ_NUM_OBJ;
    private static final Long ZERO_SEQ_NUM_OBJ = new Long(0L);
    private ArrayList seqNumCounts = new ArrayList();
    private short numZeroCounts;
    private static SequenceNumComparator comp = new SequenceNumComparator();

    protected short getCount(Long l, short s) {
        short s2 = 0;
        if (s < 0) {
            throw new IllegalArgumentException("slotNum must be >= 0");
        }
        if (l == UNINITIALIZED_SEQ_NUM_OBJ) {
            return 0;
        }
        if (this.seqNumCounts.size() > s) {
            Long l2 = l;
            Map map = (Map)this.seqNumCounts.get(s);
            ShortHolder shortHolder = (ShortHolder)map.get(l2);
            if (shortHolder != null) {
                s2 = shortHolder.shortValue();
            }
        }
        return s2;
    }

    protected void insertSeqNum(Long l, short s) {
        if (s < 0) {
            throw new IllegalArgumentException("slotNum must be >= 0");
        }
        if (l == UNINITIALIZED_SEQ_NUM_OBJ) {
            return;
        }
        Map map = null;
        Long l2 = l;
        if (this.seqNumCounts.size() <= s) {
            this.seqNumCounts.ensureCapacity(s + 1);
            for (int i = this.seqNumCounts.size(); i <= s; ++i) {
                map = QueuedSequenceNumberAdjuster.createMap();
                this.seqNumCounts.add(i, map);
                map.put(UNINITIALIZED_SEQ_NUM_OBJ, new LongObjHolder(UNINITIALIZED_SEQ_NUM_OBJ));
            }
            map.put(l2, new ShortHolder(1));
        } else {
            map = (Map)this.seqNumCounts.get(s);
            ShortHolder shortHolder = (ShortHolder)map.get(l2);
            if (shortHolder == null) {
                shortHolder = new ShortHolder(1);
                map.put(l2, shortHolder);
            } else {
                shortHolder.setValue((short)(shortHolder.shortValue() + 1));
            }
        }
    }

    private static Map createMap() {
        return new TreeMap();
    }

    protected boolean removeSeqNum(Long l, short s) {
        boolean bl = false;
        if (s < 0) {
            throw new IllegalArgumentException("slotNum must be >= 0");
        }
        if (l == UNINITIALIZED_SEQ_NUM_OBJ) {
            // empty if block
        }
        if (this.seqNumCounts.size() > s) {
            short s2;
            Long l2 = l;
            Map map = (Map)this.seqNumCounts.get(s);
            ShortHolder shortHolder = (ShortHolder)map.get(l2);
            if (shortHolder != null && (s2 = shortHolder.shortValue()) > 0) {
                shortHolder.setValue((short)(s2 - 1));
                if (s2 == 1) {
                    bl = true;
                    this.numZeroCounts = (short)(this.numZeroCounts + 1);
                }
            }
        }
        return bl;
    }

    protected Long getPersistSeqNum(short s) {
        Map map;
        LongObjHolder longObjHolder;
        if (s < 0) {
            throw new IllegalArgumentException("slotNum must be >= 0");
        }
        Long l = UNINITIALIZED_SEQ_NUM_OBJ;
        if (this.seqNumCounts.size() > s && (longObjHolder = (LongObjHolder)(map = (Map)this.seqNumCounts.get(s)).get(UNINITIALIZED_SEQ_NUM_OBJ)) != null) {
            l = longObjHolder.longValue();
        }
        return l;
    }

    protected Long getLowestSeqNum(short s) {
        Map map;
        Long l;
        if (s < 0) {
            throw new IllegalArgumentException("slotNum must be >= 0");
        }
        Long l2 = UNINITIALIZED_SEQ_NUM_OBJ;
        if (this.seqNumCounts.size() > s && (l = (Long)Collections.min((map = (Map)this.seqNumCounts.get(s)).keySet(), comp)) != null) {
            l2 = l;
        }
        return l2;
    }

    protected void setPersistSeqNum(Long l, short s) {
        if (s < 0) {
            throw new IllegalArgumentException("slotNum must be >= 0");
        }
        if (l == UNINITIALIZED_SEQ_NUM_OBJ) {
            // empty if block
        }
        Map map = null;
        if (this.seqNumCounts.size() <= s) {
            this.seqNumCounts.ensureCapacity(s + 1);
            for (int i = this.seqNumCounts.size(); i <= s; ++i) {
                map = QueuedSequenceNumberAdjuster.createMap();
                this.seqNumCounts.add(i, map);
            }
            map.put(UNINITIALIZED_SEQ_NUM_OBJ, new LongObjHolder(l));
        } else {
            map = (Map)this.seqNumCounts.get(s);
            LongObjHolder longObjHolder = (LongObjHolder)map.get(UNINITIALIZED_SEQ_NUM_OBJ);
            if (longObjHolder == null) {
                map.put(UNINITIALIZED_SEQ_NUM_OBJ, new LongObjHolder(l));
            } else {
                longObjHolder.setValue(l);
            }
        }
    }

    protected Long findAndRemoveAllHigherEmptySeqNum(Long l, short s) {
        if (s < 0) {
            throw new IllegalArgumentException("slotNum must be >= 0");
        }
        if (l == UNINITIALIZED_SEQ_NUM_OBJ) {
            return l;
        }
        Long l2 = l;
        LinkedList<Long> linkedList = null;
        if (this.seqNumCounts.size() > s) {
            TreeMap treeMap = (TreeMap)this.seqNumCounts.get(s);
            Long l32 = l;
            SortedMap sortedMap = treeMap.tailMap(l32);
            Set<Long> set = sortedMap.keySet();
            for (Long l32 : set) {
                Long l4 = l32;
                if (l4 <= l) continue;
                short s2 = this.getCount(l4, s);
                if (s2 != 0) break;
                l2 = l4;
                if (linkedList == null) {
                    linkedList = new LinkedList<Long>();
                }
                linkedList.add(l32);
            }
            boolean bl = true;
            int n = sortedMap.size();
            if (n > 0) {
                --n;
            }
            if (linkedList != null) {
                bl = linkedList.size() < n;
                for (Long l32 : linkedList) {
                    treeMap.remove(l32);
                }
            }
            sortedMap = treeMap.headMap(l32);
            if (!bl && sortedMap != null && n > 0 && l != 0L) {
                l2 = this.findAndRemoveAllHigherEmptySeqNum(ZERO_SEQ_NUM_OBJ, s);
            }
        }
        return l2;
    }

    public void enqueue(Long l, short s) {
        if (l != UNINITIALIZED_SEQ_NUM_OBJ && s >= 0) {
            if (l != null && l == -1L) {
                new Exception().printStackTrace(System.out);
            }
            this.insertSeqNum(l, s);
        }
    }

    public void change(Long l, Long l2, short s) {
        if (l != l2 && this.removeSeqNum(l, s)) {
            this.insertSeqNum(l2, s);
        }
    }

    public Long dequeue(Long l, short s) {
        if (s < 0) {
            throw new IllegalArgumentException("slotNum must be >= 0");
        }
        if (l == UNINITIALIZED_SEQ_NUM_OBJ) {
            return UNINITIALIZED_SEQ_NUM_OBJ;
        }
        if (l != UNINITIALIZED_SEQ_NUM_OBJ && l == -1L) {
            return UNINITIALIZED_SEQ_NUM_OBJ;
        }
        Long l2 = this.getPersistSeqNum(s);
        if (l2 > l) {
            return l2;
        }
        if (this.getCount(l, s) == 0) {
            return l2;
        }
        boolean bl = this.removeSeqNum(l, s);
        if (bl && l2 == UNINITIALIZED_SEQ_NUM_OBJ && (l2 = this.getLowestSeqNum(s)) != UNINITIALIZED_SEQ_NUM_OBJ) {
            l2 = new Long(l2 - 1L);
        }
        if (l2 != UNINITIALIZED_SEQ_NUM_OBJ && l2 < l && bl) {
            l2 = this.findAndRemoveAllHigherEmptySeqNum(l2, s);
            this.setPersistSeqNum(l2, s);
        }
        return l2;
    }

    public String prettyString() {
        return this.prettyString(null);
    }

    public String prettyString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string + "\n");
        }
        int n = this.seqNumCounts.size();
        stringBuffer.append("# slots: " + (n == 0 ? 0 : n - 1) + "\n");
        for (int i = 1; i < n; ++i) {
            Map map = (Map)this.seqNumCounts.get(i);
            stringBuffer.append("  slot " + i);
            if (map == null) {
                stringBuffer.append(": null\n");
                continue;
            }
            stringBuffer.append(": ");
            ArrayList arrayList = new ArrayList(map.keySet());
            Collections.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                long l2 = l;
                Object v = map.get(l);
                long l3 = v instanceof ShortHolder ? (long)((ShortHolder)v).shortValue() : ((LongObjHolder)v).longValue();
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((l2 == -1L ? "P" : l.toString()) + "/" + (l3 == -1L ? "U" : Long.toString(l3)));
                ++n2;
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        short s = 1;
        System.out.println("all tests are applied to slot 1");
        System.out.println("*** test case A");
        QueuedSequenceNumberAdjuster queuedSequenceNumberAdjuster = new QueuedSequenceNumberAdjuster();
        System.out.println("...new adjuster");
        queuedSequenceNumberAdjuster.enqueue(new Long(1L), s);
        System.out.println(queuedSequenceNumberAdjuster.prettyString("...1 - sn 1 is now in the Q"));
        queuedSequenceNumberAdjuster.dequeue(new Long(2L), s);
        System.out.println(queuedSequenceNumberAdjuster.prettyString("A - dq 2 (no change)"));
        System.out.println("*** test case B");
        queuedSequenceNumberAdjuster = new QueuedSequenceNumberAdjuster();
        System.out.println("...new adjuster");
        queuedSequenceNumberAdjuster.enqueue(new Long(1L), s);
        System.out.println(queuedSequenceNumberAdjuster.prettyString("...sn 1 are now in the Q"));
        queuedSequenceNumberAdjuster.dequeue(new Long(1L), s);
        System.out.println(queuedSequenceNumberAdjuster.prettyString("B - dq 1 (now no sn 1's are in the Q)"));
        System.out.println("*** test case C");
        queuedSequenceNumberAdjuster = new QueuedSequenceNumberAdjuster();
        System.out.println("...new adjuster");
        queuedSequenceNumberAdjuster.enqueue(new Long(1L), s);
        queuedSequenceNumberAdjuster.enqueue(new Long(2L), s);
        queuedSequenceNumberAdjuster.enqueue(new Long(1L), s);
        System.out.println(queuedSequenceNumberAdjuster.prettyString("C - enqueue sn's 1, 2, 1"));
        queuedSequenceNumberAdjuster.dequeue(new Long(1L), s);
        System.out.println(queuedSequenceNumberAdjuster.prettyString("C - dq 1 (no change in last persist sequence #. Q should now has just 1 - sn 1"));
        queuedSequenceNumberAdjuster.dequeue(new Long(2L), s);
        System.out.println(queuedSequenceNumberAdjuster.prettyString("C - dq 2 (no change in last persist sequence #. Q should now have 0 - sn 2's"));
        queuedSequenceNumberAdjuster.dequeue(new Long(1L), s);
        System.out.println(queuedSequenceNumberAdjuster.prettyString("C - dq 1 (persist sequence # should now be 2 & Q should be empty)"));
        System.out.println("*** test case D");
        queuedSequenceNumberAdjuster = new QueuedSequenceNumberAdjuster();
        queuedSequenceNumberAdjuster.setPersistSeqNum(new Long(2L), s);
        System.out.println("...new adjuster");
        queuedSequenceNumberAdjuster.enqueue(new Long(7L), s);
        queuedSequenceNumberAdjuster.enqueue(new Long(5L), s);
        queuedSequenceNumberAdjuster.insertSeqNum(new Long(3L), s);
        queuedSequenceNumberAdjuster.insertSeqNum(new Long(4L), s);
        queuedSequenceNumberAdjuster.insertSeqNum(new Long(6L), s);
        queuedSequenceNumberAdjuster.removeSeqNum(new Long(3L), s);
        queuedSequenceNumberAdjuster.removeSeqNum(new Long(4L), s);
        queuedSequenceNumberAdjuster.removeSeqNum(new Long(6L), s);
        System.out.println(queuedSequenceNumberAdjuster.prettyString("D - enqueue sn's 7, 5 w/ 3-4-6 @ a zero count"));
        queuedSequenceNumberAdjuster.dequeue(new Long(7L), s);
        System.out.println(queuedSequenceNumberAdjuster.prettyString("D - Q should 5,6,7 in it and the new persist seq #: 4"));
        System.out.println("*** test completed");
    }

    private static class SequenceNumComparator
    implements Comparator {
        private SequenceNumComparator() {
        }

        public int compare(Object object, Object object2) {
            Long l = (Long)object;
            Long l2 = (Long)object2;
            long l3 = l;
            long l4 = l2;
            int n = 0;
            n = l3 == -1L ? 1 : (l4 == -1L ? -1 : l.compareTo(l2));
            return n;
        }

        @Override
        public boolean equals(Object object) {
            boolean bl = object != null && object instanceof SequenceNumComparator;
            return bl;
        }
    }
}

