/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IModel;
import cerent.cms.model.ModelReflectionUtil;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PersistableCachedValue;
import cerent.util.matcher.AbstractMatcher;
import cerent.util.matcher.AndMatcher;
import cerent.util.matcher.NotMatcher;
import cerent.util.matcher.StringFieldMatcher;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ReflectionUtil
extends ModelReflectionUtil {
    private static final String PLAT_PKG = "com.cisco.ctc";
    private static final String PLAT_DIR = "com/cisco/";
    private static final String PLAT_DIR_END = "/model/";
    private static final ClassLoader LOADER = ReflectionUtil.class.getClassLoader();
    private static final String[] NePkgs = ReflectionUtil.getNePkgs();
    public static final StringFieldMatcher ModelPkgMatcher = new StringFieldMatcher("ModelPkgMatcher", "cerent.cms.model", 6, true, null, null);
    private static final Class PCV_CLASS = PersistableCachedValue.class;
    private static final Class NCV_CLASS = NonCachedValue.class;
    public static final PersistableCachedValueMatcher pcvMatcher = new PersistableCachedValueMatcher("PCVMatcher");
    public static final NonCachedValueMatcher ncvMatcher = new NonCachedValueMatcher("NCVMatcher");
    public static final AbstractMatcher notPcvMatcher = new NotMatcher("NotPCVMatcher", (AbstractMatcher)pcvMatcher);
    public static final AbstractMatcher ncvNotPcvMatcher = new AndMatcher("NCVNotPCVMatcher", new AbstractMatcher[]{ncvMatcher, notPcvMatcher});
    public static final int UNCLASSIFIABLE_CLASS = -1;
    public static final int UNKNOWN_CLASS = 0;
    public static final int ARRAY_CLASS = 1;
    public static final int COLLECTION_CLASS = 2;
    public static final int MAP_CLASS = 3;
    public static final int MODEL_CLASS = 4;
    public static final int ENUM_CLASS = 5;
    public static final int STRUCT_CLASS = 6;
    public static final int BEAN_CLASS = 7;
    public static final int MODEL_ARRAY_CLASS = 8;
    public static final int IDL_VALUE_CLASS = 20;
    public static final int IDL_HOLDER_CLASS = 21;
    public static final int JAVA_PRIM_CLASS = 22;
    protected static final Class CONTEXT = ReflectionUtil.class;

    protected ReflectionUtil() {
    }

    public static Class[] superclasses(Class clazz) {
        return ReflectionUtil.superclasses(clazz, false);
    }

    public static Class[] superclasses(String string) throws ClassNotFoundException {
        return ReflectionUtil.superclasses(string, false);
    }

    public static Class[] superclasses(String string, boolean bl) throws ClassNotFoundException {
        return ReflectionUtil.superclasses(Class.forName(string), bl);
    }

    public static List subclasses(String string) {
        return ReflectionUtil.subclasses((Object)CONTEXT, (String)string, (AbstractMatcher)ModelPkgMatcher, (AbstractMatcher)LikeAModelMatcher);
    }

    public static int categorizeClass(Class clazz) {
        int n = 0;
        if (ReflectionUtil.isArrayClass((Class)clazz)) {
            Class<?> clazz2 = clazz.getComponentType();
            n = ReflectionUtil.doesImplement(clazz2, IModel.class) ? 8 : 1;
        }
        if (ReflectionUtil.isCollectionClass((Class)clazz)) {
            n = n == 0 ? 2 : -1;
        }
        if (ReflectionUtil.isMapClass((Class)clazz)) {
            n = n == 0 ? 3 : -1;
        }
        if (ReflectionUtil.isModelClass(clazz)) {
            n = n == 0 ? 4 : -1;
        }
        if (ReflectionUtil.isEnumClass((Class)clazz)) {
            if (n == 0) {
                n = 5;
            } else if (n != 4) {
                n = -1;
            }
        }
        if (ReflectionUtil.isStructClass((Class)clazz)) {
            n = n == 0 ? 6 : -1;
        }
        if (ReflectionUtil.isBeanClass((Class)clazz)) {
            if (n == 0) {
                n = 7;
            } else if (n == 5) {
                n = 7;
            } else if (n != 6) {
                n = -1;
            }
        }
        return n;
    }

    public static int determineCorbaStreamableClass(Class clazz) {
        int n;
        int n2 = -1;
        if (ReflectionUtil.isIdlValueClass((Class)clazz)) {
            n2 = 20;
        } else if (ReflectionUtil.isIdlHolderClass((Class)clazz)) {
            n2 = 21;
        } else if (clazz.equals(String.class) || clazz.equals(Character.class) || ReflectionUtil.doesExtend((Class)clazz, Number.class) || clazz.equals(Boolean.class) || clazz.isPrimitive()) {
            n2 = 22;
        } else if (clazz.isArray() && (n = ReflectionUtil.determineCorbaStreamableClass(clazz.getComponentType())) != -1) {
            n2 = 1;
        }
        return n2;
    }

    public static boolean isNestedTypeCategory(int n) {
        return n == 6 || n == 1 || n == 2 || n == 7;
    }

    public static Class forName(String string) throws ClassNotFoundException {
        return ReflectionUtil.forName((Object)CONTEXT, (String)string);
    }

    public static Class[] forName(String[] stringArray) throws ClassNotFoundException {
        return ReflectionUtil.forName((Object)CONTEXT, (String[])stringArray);
    }

    public static Field[] getPersistableCVs(Class clazz) {
        Field[] fieldArray = ReflectionUtil.getMatchingFields(clazz, pcvMatcher);
        return fieldArray;
    }

    public static Field[] getNCVNotPersistableCVs(Class clazz) {
        Field[] fieldArray = ReflectionUtil.getMatchingFields(clazz, ncvNotPcvMatcher);
        return fieldArray;
    }

    public static Field[] getNCVs(Class clazz) {
        Field[] fieldArray = ReflectionUtil.getMatchingFields(clazz, ncvMatcher);
        return fieldArray;
    }

    public static String[] getWhichPlatforms(String string) {
        if (!string.startsWith(PLAT_PKG)) {
            return null;
        }
        String string2 = string.substring(PLAT_PKG.length());
        string2 = string2.substring(string2.indexOf(".") + 1);
        String[] stringArray = NePkgs;
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                StringBuffer stringBuffer = new StringBuffer(stringArray[i]);
                stringBuffer.append(".");
                stringBuffer.append(string2);
                Class.forName(stringBuffer.toString());
                ++n;
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        String[] stringArray2 = null;
        if (n > 0) {
            stringArray2 = new String[n];
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    StringBuffer stringBuffer = new StringBuffer(stringArray[i]);
                    stringBuffer.append(".");
                    stringBuffer.append(string2);
                    Class.forName(stringBuffer.toString());
                    stringArray2[n2++] = stringArray[i].substring(PLAT_PKG.length());
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return stringArray2;
    }

    private static String[] getNePkgs() {
        URL uRL = LOADER.getResource(PLAT_DIR);
        String[] stringArray = null;
        String string = uRL.getProtocol();
        if (string.startsWith("jar")) {
            stringArray = ReflectionUtil.getPkgsFromJar(uRL);
        } else if (string.startsWith("file")) {
            stringArray = ReflectionUtil.getPkgsFromFiles(uRL);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].replaceAll("/", ".");
            }
        }
        return stringArray;
    }

    private static String[] getPkgsFromJar(URL uRL) {
        String[] stringArray = null;
        try {
            Object object;
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                object = jarEntry.getName();
                if (!((String)object).startsWith(PLAT_DIR) || !((String)object).endsWith(PLAT_DIR_END)) continue;
                ++n;
            }
            if (n > 0) {
                stringArray = new String[n];
                enumeration = jarFile.entries();
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    String string = ((ZipEntry)object).getName();
                    if (!string.startsWith(PLAT_DIR) || !string.endsWith(PLAT_DIR_END)) continue;
                    int n3 = string.length() - PLAT_DIR_END.length();
                    stringArray[n2++] = string.substring(0, n3);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringArray;
    }

    private static String[] getPkgsFromFiles(URL uRL) {
        String string;
        File file;
        int n;
        String[] stringArray = null;
        String string2 = uRL.getPath();
        File file2 = new File(string2);
        File[] fileArray = file2.listFiles();
        int n2 = 0;
        for (n = 0; n < fileArray.length; ++n) {
            file = fileArray[n];
            if (!file.isDirectory() || !(string = file.getName()).startsWith(PLAT_DIR) || !string.endsWith(PLAT_DIR_END)) continue;
            ++n2;
        }
        if (n2 > 0) {
            stringArray = new String[n2];
            for (n = 0; n < fileArray.length; ++n) {
                file = fileArray[n];
                if (!file.isDirectory() || !(string = file.getName()).startsWith(PLAT_DIR) || !string.endsWith(PLAT_DIR_END)) continue;
                int n3 = string.length() - PLAT_DIR_END.length();
                stringArray[n++] = string.substring(0, n3);
            }
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        List list = ReflectionUtil.subclasses("cerent.cms.model.Model");
        Object[] objectArray = list.toArray(StringArrayTemplate);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            System.out.println((String)objectArray[i]);
        }
    }

    private static class NonCachedValueMatcher
    extends SubclassMatcher {
        public NonCachedValueMatcher(String string) {
            super(string, NCV_CLASS);
        }
    }

    private static class PersistableCachedValueMatcher
    extends SubclassMatcher {
        public PersistableCachedValueMatcher(String string) {
            super(string, PCV_CLASS);
        }
    }

    private static class SubclassMatcher
    extends AbstractMatcher {
        private Class baseClass;

        public SubclassMatcher(String string, Class clazz) {
            super(string, 0);
            this.baseClass = clazz;
        }

        public boolean doesMatch(Object object) {
            boolean bl = false;
            if (object instanceof Field) {
                bl = cerent.util.ReflectionUtil.doesExtend(((Field)object).getType(), (Class)this.baseClass);
            }
            return bl;
        }

        public Object getCriteria() {
            return null;
        }

        public Object[] getMetadata() {
            return null;
        }
    }
}

