/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Node.sRipAddressSummary;
import cerent.cms.idl.Node.xInvalidMask;
import cerent.cms.idl.Node.xInvalidRipCost;
import cerent.cms.idl.Node.xInvalidRipSummaryAddress;
import cerent.cms.idl.Node.xMaxRipSummaryAddress;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRipAddressSummary;
import cerent.cms.model.IRipAddressSummaryModel;
import cerent.cms.model.InvalidMask;
import cerent.cms.model.InvalidRipCost;
import cerent.cms.model.InvalidRipSummaryAddress;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.MaxRipSummaryAddress;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.RipAddressSummaryFactory;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class RipAddressSummaryModel
extends Model
implements IRipAddressSummaryModel {
    private RipAddressSummaryTable ripAddressSummaryTable;
    private SetRipAddressSummary setRipAddressSummary;
    private DeleteRipAddressSummary deleteRipAddressSummary;
    private NodeModelDelegate nmd;
    private static NodeSingletonFactory<RipAddressSummaryModel> sfactory = new NodeSingletonFactory<RipAddressSummaryModel>(RipAddressSummaryModel.class);
    private EventDispatcher dispatcher;

    public static RipAddressSummaryModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private RipAddressSummaryModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(RipAddressSummaryModel.class));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.ripAddressSummaryTable = new RipAddressSummaryTable(this.nmd, "RipAddressSummaryModel.ripAddressSummaryTable");
        this.setRipAddressSummary = new SetRipAddressSummary(this.nmd, "RipAddressSummaryModel.setRipAddressSummary");
        this.deleteRipAddressSummary = new DeleteRipAddressSummary(this.nmd, "RipAddressSummaryModel.deleteRipAddressSummary");
        this.dispatcher = null;
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSystem, 1, (Observer)this);
        }
    }

    @Override
    public void dispose() {
        if (this.db.on) {
            this.db.println("Enter LanRipConfigModel dispose()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSystem, 1, (Observer)this);
        }
        this.ripAddressSummaryTable.dispose();
        super.dispose();
        if (this.db.on) {
            this.db.println("Exit LanRipConfigModel dispose()");
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.ripAddressSummaryTable = null;
        this.setRipAddressSummary = null;
        this.nmd = null;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 1: {
                    if (this.db.on()) {
                        this.db.println("ripAddressSummaryModel Making local changes.");
                    }
                    this.updateLocal();
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("ripAddressSummaryModel update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    @Override
    protected void updateLocal() {
        this.ripAddressSummaryTable.update();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public IRipAddressSummary[] getRipAddressSummaryTable() {
        try {
            sRipAddressSummary[] sRipAddressSummaryArray = (sRipAddressSummary[])this.ripAddressSummaryTable.get();
            return RipAddressSummaryFactory.getIRipAddressSummaryArray(sRipAddressSummaryArray);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setRipAddressSummary(IRipAddressSummary iRipAddressSummary) throws MaxRipSummaryAddress, InvalidRipSummaryAddress, InvalidRipCost, InvalidMask {
        try {
            sRipAddressSummary sRipAddressSummary2 = RipAddressSummaryFactory.getRipAddressSummary(iRipAddressSummary);
            this.setRipAddressSummary.set(sRipAddressSummary2);
        }
        catch (xMaxRipSummaryAddress xMaxRipSummaryAddress2) {
            throw new MaxRipSummaryAddress((UserException)xMaxRipSummaryAddress2);
        }
        catch (xInvalidRipSummaryAddress xInvalidRipSummaryAddress2) {
            throw new InvalidRipSummaryAddress((UserException)xInvalidRipSummaryAddress2);
        }
        catch (xInvalidRipCost xInvalidRipCost2) {
            throw new InvalidRipCost((UserException)xInvalidRipCost2);
        }
        catch (xInvalidMask xInvalidMask2) {
            throw new InvalidMask((UserException)xInvalidMask2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setRipAddressSummaryTable(IRipAddressSummary[] iRipAddressSummaryArray) throws MaxRipSummaryAddress, InvalidRipSummaryAddress, InvalidRipCost, InvalidMask {
        try {
            int n = iRipAddressSummaryArray.length;
            for (int i = 0; i < n; ++i) {
                sRipAddressSummary sRipAddressSummary2 = RipAddressSummaryFactory.getRipAddressSummary(iRipAddressSummaryArray[i]);
                this.setRipAddressSummary.set(sRipAddressSummary2);
            }
        }
        catch (xMaxRipSummaryAddress xMaxRipSummaryAddress2) {
            throw new MaxRipSummaryAddress((UserException)xMaxRipSummaryAddress2);
        }
        catch (xInvalidRipSummaryAddress xInvalidRipSummaryAddress2) {
            throw new InvalidRipSummaryAddress((UserException)xInvalidRipSummaryAddress2);
        }
        catch (xInvalidRipCost xInvalidRipCost2) {
            throw new InvalidRipCost((UserException)xInvalidRipCost2);
        }
        catch (xInvalidMask xInvalidMask2) {
            throw new InvalidMask((UserException)xInvalidMask2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void deleteRipAddressSummary(IIpAddr iIpAddr) {
        Object[] objectArray = new Object[]{IpAddrFactory.getIpAddr(iIpAddr)};
        try {
            this.deleteRipAddressSummary.set(objectArray);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    class DeleteRipAddressSummary
    extends NonCachedValue {
        public DeleteRipAddressSummary(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            sIpAddr sIpAddr2 = (sIpAddr)objectArray[0];
            this.node.getIorRepository().getNodeNetRef().deleteRipAddressSummary(sIpAddr2);
        }

        public Object outer() {
            return RipAddressSummaryModel.this;
        }
    }

    class RipAddressSummaryTable
    extends CachedValue {
        public RipAddressSummaryTable(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getNodeNetRef().addressSummaryTable();
        }

        public Object outer() {
            return RipAddressSummaryModel.this;
        }
    }

    class SetRipAddressSummary
    extends NonCachedValue {
        public SetRipAddressSummary(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getNodeNetRef().setRipAddressSummary((sRipAddressSummary)object);
        }

        public Object outer() {
            return RipAddressSummaryModel.this;
        }
    }
}

