/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.EtherL2Media.SvlanProfile;
import cerent.cms.idl.EtherL2Media.sSvlanProfile;
import cerent.cms.idl.EtherMedia.eBucketSize;
import cerent.cms.idl.EtherMedia.sIngressQOSInfo;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.OnsError.eProvDataError;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ErrorMsgFormatter;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IROSVlanProfile;
import cerent.cms.model.ISVlanProfile;
import cerent.cms.model.ISVlanProfileModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SVlanProfile;
import cerent.cms.model.SVlanProfileModels;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class SVlanProfileModel
extends Model
implements ISVlanProfileModel {
    private static String[] errorCodes = EnumStrings.getStrings(eProvDataError.class);
    private static final int UNKNOWN_INDEX = -1;
    public static final int DEFAULT_INDEX = 0;
    public static String DEFAULT_NAME = "Defaults";
    private String name;
    private NodeModelDelegate nmd;
    private SvlanProfile ref;
    private boolean isNEDirty;
    private SvlanProfileCV svlanProfile;

    private static CTCUserException toUserException(xProvisionError xProvisionError2) {
        return ErrorMsgFormatter.getEquipmentProvisionError(xProvisionError2, null);
    }

    public static boolean canProfileBeModifiedOrDeleted(int n) {
        return n != 0;
    }

    public boolean isImmutable() {
        return !SVlanProfileModel.canProfileBeModifiedOrDeleted(this.index);
    }

    public boolean isModifiable() {
        return SVlanProfileModel.canProfileBeModifiedOrDeleted(this.index);
    }

    public SVlanProfileModel(NodeModelDelegate nodeModelDelegate, int n, SvlanProfile svlanProfile, SDebug sDebug) {
        super(sDebug);
        this.nmd = nodeModelDelegate;
        this.index = n;
        this.ref = svlanProfile;
        this.svlanProfile = new SvlanProfileCV(nodeModelDelegate, "SvlanProfile");
    }

    public SVlanProfileModel(NodeModelDelegate nodeModelDelegate, sSvlanProfile sSvlanProfile2, SvlanProfile svlanProfile, SDebug sDebug) {
        super(sDebug);
        this.nmd = nodeModelDelegate;
        this.index = sSvlanProfile2.UniqueID;
        this.ref = svlanProfile;
        this.svlanProfile = new SvlanProfileCV(nodeModelDelegate, "SvlanProfile");
        ISVlanProfile iSVlanProfile = SVlanProfileModel.toProfile(sSvlanProfile2);
        this.svlanProfile.setValueExternally(iSVlanProfile);
        this.name = iSVlanProfile.getName();
    }

    public SVlanProfileModel(NodeModelDelegate nodeModelDelegate, IROSVlanProfile iROSVlanProfile, SvlanProfile svlanProfile, SDebug sDebug) {
        super(sDebug);
        this.nmd = nodeModelDelegate;
        this.index = -1;
        this.ref = svlanProfile;
        this.svlanProfile = new SvlanProfileCV(nodeModelDelegate, "SvlanProfile");
        this.svlanProfile.setValueExternally(iROSVlanProfile);
        this.name = iROSVlanProfile.getName();
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public void init() {
        EventDispatcher eventDispatcher;
        int n = this.index;
        super.init0();
        this.index = n;
        if (this.isModifiable() && (eventDispatcher = this.nmd.getDispatcher()) != null) {
            if (this.db.on()) {
                this.db.println("adding dispatcher observing for: " + this);
            }
            eventDispatcher.addObserver(ObjectType.ObjectSvlanProfileDb, this.index, (Observer)this);
        }
    }

    @Override
    public void dispose() {
        EventDispatcher eventDispatcher;
        if (this.isModifiable() && (eventDispatcher = this.nmd.getDispatcher()) != null) {
            if (this.db.on()) {
                this.db.println("removing dispatcher observing for: SVlanProfileModel(" + this.getIndex() + ")");
            }
            eventDispatcher.deleteObserver(ObjectType.ObjectSvlanProfileDb, this.index, (Observer)this);
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        block3: {
            if (this.nmd != null) {
                SVlanProfileModels sVlanProfileModels = this.nmd.getSVlanProfileModels();
                try {
                    sVlanProfileModels.remove(this.getIndex());
                }
                catch (RuntimeException runtimeException) {
                    if (!this.db.on()) break block3;
                    SDebug.printStackTrace((Throwable)runtimeException);
                }
            }
        }
        super.destroy();
        this.nmd = null;
    }

    public void delete() throws CTCUserException {
        if (this.isImmutable()) {
            return;
        }
        try {
            if (this.db.on()) {
                this.db.println("at index: " + this.index + " deleting profile: " + this.get());
            }
            this.svlanProfile.delete();
        }
        catch (xProvisionError xProvisionError2) {
            int n = xProvisionError2.dataError.value();
            CTCUserException cTCUserException = SVlanProfileModel.toUserException(xProvisionError2);
            if (this.db.on()) {
                this.db.println("delete on model: " + this.index + " failed (maybe in use for a mapping) got dataError: " + n);
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            throw cTCUserException;
        }
        catch (UserException userException) {
            throw new CmsCommFailException(userException);
        }
    }

    public Object clone() {
        RuntimeException runtimeException = null;
        try {
            return new SVlanProfile(this.index, (IROSVlanProfile)this.get());
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
            if (this.svlanProfile.value instanceof ISVlanProfile) {
                return new SVlanProfile(this.index, (IROSVlanProfile)((ISVlanProfile)this.svlanProfile.value));
            }
            if (this.db.on()) {
                this.db.println("No usable state for cloning of model: " + this.getIndex());
            }
            if (runtimeException != null) {
                throw runtimeException;
            }
            return null;
        }
    }

    protected ISVlanProfile get() {
        try {
            return (ISVlanProfile)this.svlanProfile.get();
        }
        catch (xProvisionError xProvisionError2) {
            throw new RuntimeException(new CTCUserException((UserException)this.handleProvError(xProvisionError2)));
        }
        catch (UserException userException) {
            throw new CmsCommFailException(new CTCUserException(userException));
        }
    }

    public String getName() {
        return this.name != null ? this.name : this.get().getName();
    }

    public short getCommittedInfoRate() {
        return this.get().getCommittedInfoRate();
    }

    public short getPeakInfoRate() {
        return this.get().getPeakInfoRate();
    }

    public int getCommittedBurstSize() {
        return this.get().getCommittedBurstSize();
    }

    public eBucketSize getCommittedBurstSizeEnum() {
        return eBucketSize.from_int(this.getCommittedBurstSize());
    }

    public int getPeakBurstSize() {
        return this.get().getPeakBurstSize();
    }

    public eBucketSize getPeakBurstSizeEnum() {
        return eBucketSize.from_int(this.getPeakBurstSize());
    }

    public boolean getCouplingFlag() {
        return this.get().getCouplingFlag();
    }

    public boolean getColorMode() {
        return this.get().getColorMode();
    }

    public boolean getLinkIntegrity() {
        return this.get().getLinkIntegrity();
    }

    void apply() throws CTCUserException {
        if (this.getIndex() != -1) {
            return;
        }
        try {
            this.svlanProfile.apply();
            this.init();
        }
        catch (xProvisionError xProvisionError2) {
            throw SVlanProfileModel.toUserException(this.handleProvError(xProvisionError2));
        }
        catch (UserException userException) {
            throw new CmsCommFailException(userException);
        }
    }

    public void set(IROSVlanProfile iROSVlanProfile) throws CTCUserException {
        ISVlanProfile iSVlanProfile = this.get();
        if (!iSVlanProfile.equals(iROSVlanProfile)) {
            try {
                if (this.db.on()) {
                    this.db.println("setting profile for model index: " + this.index);
                }
                Object object = this.svlanProfile.value;
                this.svlanProfile.set(iROSVlanProfile);
                Object object2 = this.svlanProfile.value;
                if (object != object2) {
                    this.changed();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                }
            }
            catch (xProvisionError xProvisionError2) {
                throw SVlanProfileModel.toUserException(this.handleProvError(xProvisionError2));
            }
            catch (UserException userException) {
                throw new CmsCommFailException(userException);
            }
        }
    }

    public int compareTo(IROSVlanProfile iROSVlanProfile) {
        return this.get().compareTo((Object)iROSVlanProfile);
    }

    public String toString() {
        String string = null;
        try {
            string = this.get().toString();
        }
        catch (RuntimeException runtimeException) {
            string = this.svlanProfile.value + " - " + runtimeException.getMessage();
        }
        return "SVlanProfileModel(" + this.getIndex() + ") " + string;
    }

    private void handleDelete() {
        if (this.isModifiable()) {
            this.destroy();
        }
    }

    @Override
    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("index: " + this.index + " marked dirty");
        }
        this.svlanProfile.update();
        this.setChanged();
        super.updateLocal();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            CmsObservable cmsObservable = (CmsObservable)((Object)observable);
            ObjectMessageInfo objectMessageInfo = (ObjectMessageInfo)object;
            int n = objectMessageInfo.getUpdateType();
            if (this.db.on()) {
                this.db.println("update(): this=" + this + ", From=" + observable + ", arg=" + EnumStrings.getStrings(eUpdateType.class)[n]);
            }
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println("DELETED update(): " + this);
                    }
                    this.handleDelete();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println("CHANGED update(): " + this);
                    }
                    this.updateLocal();
                    break;
                }
                case 2: {
                    if (this.index == 0) break;
                    this.db.warning("update(): unhandled UpdateType: " + n);
                    break;
                }
                default: {
                    this.db.warning("update(): unhandled UpdateType: " + n);
                }
            }
        }
    }

    private static ISVlanProfile toProfile(sSvlanProfile sSvlanProfile2) {
        sIngressQOSInfo sIngressQOSInfo2 = sSvlanProfile2.QOS;
        SVlanProfile sVlanProfile = new SVlanProfile(sSvlanProfile2.UniqueID, sSvlanProfile2.name, sIngressQOSInfo2.committedInfoRate, sIngressQOSInfo2.committedBurstSize.value(), sIngressQOSInfo2.peakInfoRate, sIngressQOSInfo2.excOrPeakBurstSize.value(), sIngressQOSInfo2.couplingFlag, sIngressQOSInfo2.colorMode, sSvlanProfile2.LinkIntegrity);
        return sVlanProfile;
    }

    private xProvisionError handleProvError(xProvisionError xProvisionError2) {
        if (this.db.isFinerEnabled()) {
            int n = xProvisionError2.dataError.value();
            String string = n < errorCodes.length ? errorCodes[n] : "???";
            this.db.println("Got provisioning error with error code: " + n + "(" + string + ")");
            SDebug.printStackTrace((Throwable)((Object)xProvisionError2));
        }
        return xProvisionError2;
    }

    private static sSvlanProfile fromProfile(IROSVlanProfile iROSVlanProfile) {
        return SVlanProfileModel.fromProfile(iROSVlanProfile, iROSVlanProfile.getIndex());
    }

    private static sSvlanProfile fromProfile(IROSVlanProfile iROSVlanProfile, int n) {
        sIngressQOSInfo sIngressQOSInfo2 = new sIngressQOSInfo(iROSVlanProfile.getCommittedInfoRate(), eBucketSize.from_int(iROSVlanProfile.getCommittedBurstSize()), eBucketSize.from_int(iROSVlanProfile.getPeakBurstSize()), iROSVlanProfile.getPeakInfoRate(), iROSVlanProfile.getCouplingFlag(), iROSVlanProfile.getColorMode());
        sSvlanProfile sSvlanProfile2 = new sSvlanProfile(iROSVlanProfile.getName(), (short)n, iROSVlanProfile.getLinkIntegrity(), sIngressQOSInfo2);
        return sSvlanProfile2;
    }

    class SvlanProfileCV
    extends CachedValue {
        public SvlanProfileCV(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xProvisionError {
            ISVlanProfile iSVlanProfile = SVlanProfileModel.toProfile(SVlanProfileModel.this.ref.getProfileByID((short)SVlanProfileModel.this.index));
            SVlanProfileModel.this.isNEDirty = false;
            return iSVlanProfile;
        }

        @Override
        public Object get() throws AbstractCmsIOException, UserException {
            if (this.state != 1) {
                return super.get();
            }
            String string = null;
            if (this.value instanceof ISVlanProfile) {
                string = ((ISVlanProfile)this.value).getName();
            }
            Object object = super.get();
            String string2 = null;
            if (this.value instanceof ISVlanProfile) {
                string2 = ((ISVlanProfile)this.value).getName();
            }
            if (string2 != null) {
                SVlanProfileModel.this.name = string2;
            }
            if (string != null && string2 != null && !string2.equals(string)) {
                NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)SVlanProfileModel.this.getNodeModel();
                SVlanProfileModels sVlanProfileModels = nodeModelDelegate.getSVlanProfileModels();
                sVlanProfileModels.rename(string, string2);
            }
            return object;
        }

        void apply() throws xProvisionError, UserException {
            this.apply(false);
        }

        void apply(boolean bl) throws xProvisionError, UserException {
            sSvlanProfile sSvlanProfile2 = SVlanProfileModel.fromProfile((IROSVlanProfile)((ISVlanProfile)this.get()));
            this.apply(sSvlanProfile2, bl);
        }

        void apply(sSvlanProfile sSvlanProfile2, boolean bl) throws xProvisionError, UserException {
            boolean bl2;
            boolean bl3 = bl2 = SVlanProfileModel.this.index != -1;
            if (!bl2) {
                try {
                    this._add(sSvlanProfile2, bl);
                }
                catch (xProvisionError xProvisionError2) {
                    int n = xProvisionError2.dataError.value();
                    if (n != eProvDataError.ID_EXISTS.value()) {
                        throw xProvisionError2;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                if (SVlanProfileModel.this.db.on()) {
                    SVlanProfileModel.this.db.println("modifying profile: " + sSvlanProfile2);
                }
                try {
                    SVlanProfileModel.this.ref.modifyProfileByID(sSvlanProfile2);
                }
                catch (xProvisionError xProvisionError3) {
                    throw SVlanProfileModel.this.handleProvError(xProvisionError3);
                }
            }
        }

        void _add(sSvlanProfile sSvlanProfile2, boolean bl) throws xProvisionError {
            if (SVlanProfileModel.this.db.on()) {
                SVlanProfileModel.this.db.println("creating profile: " + SVlanProfileModel.toProfile(sSvlanProfile2));
            }
            try {
                SVlanProfileModel.this.index = SVlanProfileModel.this.ref.addProfile(sSvlanProfile2, true);
                if (SVlanProfileModel.this.db.on()) {
                    SVlanProfileModel.this.db.println("created profile(" + SVlanProfileModel.this.index + "): " + SVlanProfileModel.toProfile(sSvlanProfile2));
                }
            }
            catch (xProvisionError xProvisionError2) {
                throw SVlanProfileModel.this.handleProvError(xProvisionError2);
            }
            if (bl) {
                ISVlanProfile iSVlanProfile = SVlanProfileModel.toProfile(sSvlanProfile2);
                String string = this.value == null ? null : ((ISVlanProfile)this.value).getName();
                String string2 = iSVlanProfile.getName();
                if (!string2.equals(string)) {
                    NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)SVlanProfileModel.this.getNodeModel();
                    SVlanProfileModels sVlanProfileModels = nodeModelDelegate.getSVlanProfileModels();
                    sVlanProfileModels.rename(string, string2);
                }
                this.value = iSVlanProfile;
            }
        }

        void delete() throws xProvisionError {
            if (SVlanProfileModel.this.index == -1) {
                return;
            }
            SVlanProfileModel.this.ref.removeProfileByID((short)SVlanProfileModel.this.index);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            IROSVlanProfile iROSVlanProfile = (IROSVlanProfile)object;
            if (iROSVlanProfile == null) {
                throw new xProvisionError("Cannot set using a null profile", eProvDataError.PROV_GENERIC_ERROR);
            }
            sSvlanProfile sSvlanProfile2 = SVlanProfileModel.fromProfile(iROSVlanProfile, SVlanProfileModel.this.index);
            this.apply(sSvlanProfile2, true);
        }

        @Override
        protected void setValue() throws UserException {
            this.apply(true);
        }
    }
}

