/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Common.xInvalidRange;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.Security.ExistingUser;
import cerent.cms.idl.Security.General;
import cerent.cms.idl.Security.NotAuthenticated;
import cerent.cms.idl.Security.UnknownUser;
import cerent.cms.idl.Security.eAccessMechanism;
import cerent.cms.idl.Security.eAccessState;
import cerent.cms.idl.Security.eOperation;
import cerent.cms.idl.Security.ePasswordCharsRule;
import cerent.cms.idl.Security.eSecurityLevel;
import cerent.cms.idl.Security.eSerialPortId;
import cerent.cms.idl.Security.sActiveUserInfo;
import cerent.cms.idl.Security.sAuthInput;
import cerent.cms.idl.Security.sAuthOutput;
import cerent.cms.idl.Security.sDisableInactiveUserPolicy;
import cerent.cms.idl.Security.sIdleUserTimeout;
import cerent.cms.idl.Security.sLockoutPolicy;
import cerent.cms.idl.Security.sPasswordExpr;
import cerent.cms.idl.Security.sPasswordExprPolicy;
import cerent.cms.idl.Security.sPasswordFlippingPolicy;
import cerent.cms.idl.Security.userInfo;
import cerent.cms.idl.Security.xActiveUserSession;
import cerent.cms.idl.Security.xBadMinPwdDiff;
import cerent.cms.idl.Security.xBadPasswordFlipping;
import cerent.cms.idl.Security.xBadPasswordSimple;
import cerent.cms.idl.Security.xBadPasswordToggling;
import cerent.cms.idl.Security.xDccNotConnected;
import cerent.cms.idl.Security.xIPv6NotEnabled;
import cerent.cms.idl.Security.xInvalidParms;
import cerent.cms.idl.Security.xKeepOneSuperUser;
import cerent.cms.idl.Security.xMaximumUsers;
import cerent.cms.idl.Security.xOperationFailed;
import cerent.cms.idl.Security.xOperationNotSupported;
import cerent.cms.idl.Security.xPortInUse;
import cerent.cms.idl.Security.xSerialPortIdNotSupported;
import cerent.cms.idl.Security.xSessionNotFound;
import cerent.cms.model.AccessMechanism;
import cerent.cms.model.AccessState;
import cerent.cms.model.ActiveUserInfoModel;
import cerent.cms.model.BadSerialPortException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.DccNotConnected;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.IActiveUserInfoModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPv4CannotBeDisabledInMultishelf;
import cerent.cms.model.IPv6NotEnabledException;
import cerent.cms.model.ISecurityModel;
import cerent.cms.model.ISecurityPolicy;
import cerent.cms.model.IUserInfoModel;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.InvalidRange;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.LANAccessMode;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.Operation;
import cerent.cms.model.OperationFailed;
import cerent.cms.model.PortInUse;
import cerent.cms.model.SecurityActiveUserSession;
import cerent.cms.model.SecurityBadMinPwdDiff;
import cerent.cms.model.SecurityBadPassword;
import cerent.cms.model.SecurityBadPasswordFlipping;
import cerent.cms.model.SecurityBadPasswordToggling;
import cerent.cms.model.SecurityExistingUser;
import cerent.cms.model.SecurityKeepOneSuperUser;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SecurityMaximumUsers;
import cerent.cms.model.SecurityNotAuthenticated;
import cerent.cms.model.SecurityNotAuthorized;
import cerent.cms.model.SecurityPolicy;
import cerent.cms.model.SecurityUnknownUser;
import cerent.cms.model.SecurityUserNotLoggedIn;
import cerent.cms.model.SessionNotFound;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.UserInfoModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.model.vf.AbstractVersionedFeature;
import cerent.cms.model.vf.SecurityVersionedFeature;
import cerent.launcher.CtcHttpRetriever;
import cerent.util.DetailedLog;
import cerent.util.EMC;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.ShortHolder;
import org.omg.CORBA.UserException;

public class SecurityModel
extends Model
implements ISecurityModel {
    NodeModelDelegate nodeModel;
    Authenticate authenticate;
    UserList userList;
    ActiveUserList activeUserList;
    CreateUser createUser;
    DeleteUser deleteUser;
    ClearSecurityIntrusionAlarm clearSecurityIntrusionAlarm;
    UserPassword userPassword;
    UserSecurityLevel userSecurityLevel;
    AdminLockUsername adminLockUsername;
    AdminUnlockUsername adminUnlockUsername;
    LogoutSession logoutSession;
    Logout logout;
    LockoutPolicy lockoutPolicy;
    PasswordTogglingPolicy passwordTogglingPolicy;
    SingleSessionPerUser singleSessionPerUser;
    IdleUserTimeout idleUserTimeout;
    LegalDisclaimer legalDisclaimer;
    ForcePasswordChange forcePasswordChange;
    RequirePasswordChange requirePasswordChange;
    PasswordFlippingPolicy passwordFlippingPolicy;
    PasswordExprPolicy passwordExprPolicy;
    DisableInactiveUserPolicy disableInactiveUserPolicy;
    UserDisabled userDisabled;
    FrontLANAccess frontLanAccess;
    BackLANAccess backLanAccess;
    IPv4Access ipv4Access;
    LANAccessTimeout lanAccessTimeout;
    SerialPortAccess serialPortAccess;
    TelnetPort telnetPort;
    PCLIPort pcliPort;
    PCLISecurePort pcliSecurePort;
    EnforceShellPassword enforceShellPassword;
    OperationPrivilege operationPrivilege;
    PasswordCloseToExpiring passwordCloseToExpiring;
    UserForcePasswordChange userForcePasswordChange;
    AlarmOnLostBackLanLink alarmOnLostBackLanLink;
    MinChangedCharsInPwd minChangedCharsInPwd;
    AccessMechanismState accessMechanismState;
    SessionSecurityLevel sessionSecurityLevel;
    PreventSuperUserDisablePolicy preventSuperUserDisablePolicy;
    ReverseUserIdAllowed defReverseUserIdAllowed;
    MaximumLength defMaximumLength;
    MinimumLength defMinimumLength;
    IdenticalConsecutiveChars defIdenticalConsecutiveChars;
    MinimumRequiredChars defMinimumRequiredChars;
    private EventDispatcher dispatcher;
    private static NodeSingletonFactory<SecurityModel> sfactory = new NodeSingletonFactory<SecurityModel>(SecurityModel.class);
    private SecurityVersionedFeature securityVersion;
    private static final Integer NO_WARNING = new Integer(-1);
    private static final SecurityPolicy DEF_POLICY = new SecurityPolicy();
    private static final int STANDARD_SSH_PORT = 22;
    private static final int STANDARD_TELNET_PORT = 23;
    private static final int NONSTANDARD_SFTP_PORT = 4022;

    public static SecurityModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private SecurityModel(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.setDebug(nodeModelDelegate.getChildDebug(SecurityModel.class, SecurityModelDebug.class, this));
        this.nodeModel = nodeModelDelegate;
        this.index = 0;
        this.authenticate = new Authenticate(nodeModelDelegate, "SecurityModel::authenticate");
        this.logoutSession = new LogoutSession(nodeModelDelegate, "SecurityModel::logoutSession");
        this.logout = new Logout(nodeModelDelegate, "SecurityModel::logout");
        this.userList = new UserList(nodeModelDelegate, "SecurityModel::userList");
        this.activeUserList = new ActiveUserList(nodeModelDelegate, "SecurityModel::activeUserList");
        this.createUser = new CreateUser(nodeModelDelegate, "SecurityModel::createUser");
        this.deleteUser = new DeleteUser(nodeModelDelegate, "SecurityModel::deleteUser");
        this.clearSecurityIntrusionAlarm = new ClearSecurityIntrusionAlarm(nodeModelDelegate, "SecurityModel::clearSecurityIntrusionAlarm");
        this.userPassword = new UserPassword(nodeModelDelegate, "SecurityModel::userPassword");
        this.userSecurityLevel = new UserSecurityLevel(nodeModelDelegate, "SecurityModel::userSecurityLevel");
        this.adminLockUsername = new AdminLockUsername(nodeModelDelegate, "SecurityModel::adminLockUsername");
        this.adminUnlockUsername = new AdminUnlockUsername(nodeModelDelegate, "SecurityModel::adminUnlockUsername");
        this.lockoutPolicy = new LockoutPolicy(nodeModelDelegate, "SecurityModel::lockoutPolicy");
        this.passwordTogglingPolicy = new PasswordTogglingPolicy(nodeModelDelegate, "SecurityModel::passwordTogglingPolicy");
        this.singleSessionPerUser = new SingleSessionPerUser(nodeModelDelegate, "SecurityModel::singleSessionPerUser");
        this.legalDisclaimer = new LegalDisclaimer(nodeModelDelegate, "SecurityModel::legalDisclaimer");
        this.idleUserTimeout = new IdleUserTimeout(nodeModelDelegate, "SecurityModel::idleUserTimeout");
        this.forcePasswordChange = new ForcePasswordChange(nodeModelDelegate, "SecurityModel::forcePasswordChange");
        this.requirePasswordChange = new RequirePasswordChange(nodeModelDelegate, "SecurityModel::requirePasswordChange");
        this.passwordFlippingPolicy = new PasswordFlippingPolicy(nodeModelDelegate, "SecurityModel::passwordFlippingPolicy");
        this.passwordExprPolicy = new PasswordExprPolicy(nodeModelDelegate, "SecurityModel::passwordExprPolicy");
        this.disableInactiveUserPolicy = new DisableInactiveUserPolicy(nodeModelDelegate, "SecurityModel::disableInactiveUserPolicy");
        this.userDisabled = new UserDisabled(nodeModelDelegate, "SecurityModel::userDisabled");
        this.frontLanAccess = new FrontLANAccess(nodeModelDelegate, "SecurityModel::frontLanAccess");
        this.backLanAccess = new BackLANAccess(nodeModelDelegate, "SecurityModel::backLanAccess");
        this.ipv4Access = new IPv4Access(nodeModelDelegate, "SecurityModel::ipv4Access");
        this.lanAccessTimeout = new LANAccessTimeout(nodeModelDelegate, "SecurityModel::lanAccessTimeout");
        this.serialPortAccess = new SerialPortAccess(nodeModelDelegate, "SecurityModel::serialPortAccess");
        this.telnetPort = new TelnetPort(nodeModelDelegate, "SecurityModel::telnetPort");
        this.pcliPort = new PCLIPort(nodeModelDelegate, "SecurityModel::pcliPort");
        this.pcliSecurePort = new PCLISecurePort(nodeModelDelegate, "SecurityModel::pcliSecurePort");
        this.enforceShellPassword = new EnforceShellPassword(nodeModelDelegate, "SecurityModel::enforceShellPassword");
        this.operationPrivilege = new OperationPrivilege(nodeModelDelegate, "SecurityModel::operationPrivilege");
        this.passwordCloseToExpiring = new PasswordCloseToExpiring(nodeModelDelegate, "SecurityModel::passwordCloseToExpiring");
        this.userForcePasswordChange = new UserForcePasswordChange(nodeModelDelegate, "SecurityModel::userForcePasswordChange");
        this.alarmOnLostBackLanLink = new AlarmOnLostBackLanLink(nodeModelDelegate, "SecurityModel::alarmOnLostBackLanLink");
        this.minChangedCharsInPwd = new MinChangedCharsInPwd(nodeModelDelegate, "SecurityModel::MinChangedCharsInPwd");
        this.accessMechanismState = new AccessMechanismState(nodeModelDelegate, "SecurityModel::AccessMechanismState");
        this.sessionSecurityLevel = new SessionSecurityLevel(nodeModelDelegate, "SecurityModel::SessionSecurityLevel");
        this.preventSuperUserDisablePolicy = new PreventSuperUserDisablePolicy(nodeModelDelegate, "SecurityModel::preventSuperUserDisablePolicy");
        this.defReverseUserIdAllowed = new ReverseUserIdAllowed(nodeModelDelegate, "SecurityModel::ReverseUserIdAllowed");
        this.defMinimumLength = new MinimumLength(nodeModelDelegate, "SecurityModel::MinimumLength");
        this.defMaximumLength = new MaximumLength(nodeModelDelegate, "SecurityModel::MaximumLength");
        this.defIdenticalConsecutiveChars = new IdenticalConsecutiveChars(nodeModelDelegate, "SecurityModel::IdenticalConsecutiveChars");
        this.defMinimumRequiredChars = new MinimumRequiredChars(nodeModelDelegate, "SecurityModel::MinimumRequiredChars");
        this.dispatcher = null;
        this.securityVersion = new SecurityVersionedFeature();
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nodeModel;
    }

    private General getSecurityRef() {
        try {
            return this.nodeModel.getIorRepository().getSecurityRef();
        }
        catch (MalformedURLException malformedURLException) {
            throw new CmsCommFailException(malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            throw new CmsCommFailException(iOException.getMessage());
        }
    }

    public void init() {
        super.init0();
        if (this.db.on) {
            this.db.println("Enter SecurityModel init()");
        }
        this.userList.init();
        this.lockoutPolicy.init();
        this.passwordTogglingPolicy.init();
        this.singleSessionPerUser.init();
        this.idleUserTimeout.init();
        this.legalDisclaimer.init();
        this.forcePasswordChange.init();
        this.passwordFlippingPolicy.init();
        this.passwordExprPolicy.init();
        this.dispatcher = this.nodeModel.getDispatcher();
        this.disableInactiveUserPolicy.init();
        this.frontLanAccess.init();
        this.backLanAccess.init();
        this.lanAccessTimeout.init();
        this.telnetPort.init();
        this.ipv4Access.init();
        this.enforceShellPassword.init();
        this.alarmOnLostBackLanLink.init();
        this.minChangedCharsInPwd.init();
        this.logoutSession.init();
        this.preventSuperUserDisablePolicy.init();
        this.defReverseUserIdAllowed.init();
        this.defMaximumLength.init();
        this.defMinimumLength.init();
        this.defIdenticalConsecutiveChars.init();
        this.defMinimumRequiredChars.init();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSecurity, 0, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectSecurity, 1, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectSecurity, 2, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectSecurity, 3, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectSecurity, 4, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectSecurity, 5, (Observer)this);
        }
    }

    public sAuthOutput authenticate(String string, String string2) throws NotAuthenticated {
        return this.authenticate(string, string2, "", (short)0);
    }

    public sAuthOutput authenticate(String string, String string2, String string3, short s) throws NotAuthenticated {
        if (this.db.on()) {
            this.db.println("authenticate(" + string + ")");
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string4 = inetAddress.getHostAddress();
            IIpAddr iIpAddr = InetUtil.makeIpAddr(string4);
            sIpAddr sIpAddr2 = IpAddrFactory.getIpAddr(iIpAddr);
            if (this.db.on()) {
                this.db.println("logging in from " + string4);
            }
            sAuthInput sAuthInput2 = new sAuthInput(string, string2, string3, sIpAddr2, s);
            Object[] objectArray = new Object[]{sAuthInput2};
            return (sAuthOutput)this.authenticate.get(objectArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new CmsCommFailException(unknownHostException.getMessage());
        }
        catch (NotAuthenticated notAuthenticated) {
            throw notAuthenticated;
        }
        catch (UserException userException) {
            throw new CmsCommFailException(userException.getMessage());
        }
    }

    public IActiveUserInfoModel[] getActiveUsers() {
        try {
            return (IActiveUserInfoModel[])this.activeUserList.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private UserInfoModel[] asUserInfoModelArray(ArrayList arrayList) {
        return arrayList.toArray(new UserInfoModel[arrayList.size()]);
    }

    public UserInfoModel[] users() {
        try {
            return this.asUserInfoModelArray((ArrayList)this.userList.get());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IUserInfoModel[] getUsers() {
        try {
            return this.asUserInfoModelArray((ArrayList)this.userList.get());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void createUser(String string, String string2, int n) throws SecurityExistingUser, SecurityBadPassword, SecurityMaximumUsers, EMCProvisionError {
        this.createUser(string, string2, eSecurityLevel.from_int(n));
    }

    public void createUser(String string, String string2, eSecurityLevel eSecurityLevel2) throws SecurityExistingUser, SecurityBadPassword, SecurityMaximumUsers, EMCProvisionError {
        try {
            Object[] objectArray = new Object[]{string, string2, eSecurityLevel2};
            this.createUser.set(objectArray);
        }
        catch (ExistingUser existingUser) {
            throw new SecurityExistingUser((UserException)existingUser);
        }
        catch (xBadPasswordSimple xBadPasswordSimple2) {
            throw new SecurityBadPassword((UserException)xBadPasswordSimple2);
        }
        catch (xMaximumUsers xMaximumUsers2) {
            throw new SecurityMaximumUsers("The maximum number of users has been reached.");
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void deleteUser(String string) throws SecurityNotAuthorized, SecurityUnknownUser, SecurityActiveUserSession, SecurityKeepOneSuperUser {
        try {
            this.deleteUser.set(string);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (xKeepOneSuperUser xKeepOneSuperUser2) {
            throw new SecurityKeepOneSuperUser((UserException)xKeepOneSuperUser2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void clearSecurityViolationAlarm() {
        try {
            this.clearSecurityIntrusionAlarm.set();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setUserPassword(String string, String string2) throws SecurityNotAuthorized, SecurityUnknownUser, SecurityBadPassword, SecurityBadPasswordToggling, SecurityBadPasswordFlipping, SecurityActiveUserSession, EMCProvisionError {
        try {
            Object[] objectArray = new Object[]{string, string2};
            this.userPassword.set(objectArray);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xBadPasswordSimple xBadPasswordSimple2) {
            throw new SecurityBadPassword((UserException)xBadPasswordSimple2);
        }
        catch (xBadPasswordToggling xBadPasswordToggling2) {
            throw new SecurityBadPasswordToggling((UserException)xBadPasswordToggling2);
        }
        catch (xBadPasswordFlipping xBadPasswordFlipping2) {
            throw new SecurityBadPasswordFlipping((UserException)xBadPasswordFlipping2);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setUserSecurityLevel(String string, int n) throws SecurityNotAuthorized, SecurityUnknownUser, SecurityKeepOneSuperUser, SecurityActiveUserSession {
        try {
            Object[] objectArray = new Object[]{string, eSecurityLevel.from_int(n)};
            this.userSecurityLevel.set(objectArray);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xKeepOneSuperUser xKeepOneSuperUser2) {
            throw new SecurityKeepOneSuperUser((UserException)xKeepOneSuperUser2);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void changePassword(String string, String string2, String string3) throws SecurityNotAuthorized, SecurityUnknownUser, SecurityBadPassword, SecurityBadPasswordToggling, SecurityBadPasswordFlipping, SecurityNotAuthenticated, SecurityBadMinPwdDiff, SecurityActiveUserSession, EMCProvisionError {
        try {
            Object[] objectArray = new Object[]{string, string2, string3};
            this.userPassword.set(objectArray);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xBadPasswordSimple xBadPasswordSimple2) {
            throw new SecurityBadPassword((UserException)xBadPasswordSimple2);
        }
        catch (xBadMinPwdDiff xBadMinPwdDiff2) {
            throw new SecurityBadMinPwdDiff((UserException)xBadMinPwdDiff2);
        }
        catch (xBadPasswordToggling xBadPasswordToggling2) {
            throw new SecurityBadPasswordToggling((UserException)xBadPasswordToggling2);
        }
        catch (xBadPasswordFlipping xBadPasswordFlipping2) {
            throw new SecurityBadPasswordFlipping((UserException)xBadPasswordFlipping2);
        }
        catch (NotAuthenticated notAuthenticated) {
            throw new SecurityNotAuthenticated((UserException)notAuthenticated);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public eSecurityLevel getUserSecurityLevel(String string) throws UnknownUser {
        try {
            return (eSecurityLevel)this.userSecurityLevel.get(string);
        }
        catch (UnknownUser unknownUser) {
            throw unknownUser;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public int getLockoutThreshold() {
        try {
            return ((sLockoutPolicy)this.lockoutPolicy.get()).maxBadLogins;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public boolean getLockoutForever() {
        try {
            return ((sLockoutPolicy)this.lockoutPolicy.get()).durationForever;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public int getLockoutDuration() {
        try {
            return ((sLockoutPolicy)this.lockoutPolicy.get()).lockoutSeconds;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setLockoutPolicy(int n, boolean bl, int n2) throws InvalidParams {
        sLockoutPolicy sLockoutPolicy2 = new sLockoutPolicy();
        sLockoutPolicy2.maxBadLogins = (short)n;
        sLockoutPolicy2.durationForever = bl;
        sLockoutPolicy2.lockoutSeconds = (short)n2;
        try {
            this.lockoutPolicy.set(sLockoutPolicy2);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("Invalid Lockout Policy");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getPasswordTogglingPolicy() {
        try {
            return ((Short)this.passwordTogglingPolicy.get()).shortValue();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setPasswordTogglingPolicy(int n) throws InvalidParams {
        try {
            this.passwordTogglingPolicy.set(new Short((short)n));
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("Invalid Password Change Policy");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public short getMinChangedCharsInPwd() {
        try {
            return (Short)this.minChangedCharsInPwd.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setMinChangedCharsInPwd(short s) throws InvalidRange {
        try {
            this.minChangedCharsInPwd.set(new Short(s));
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange("The value must be between " + xInvalidRange2.lowerBound + " and " + xInvalidRange2.upperBound);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getSingleSessionPerUser() {
        try {
            return (Boolean)this.singleSessionPerUser.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setSingleSessionPerUser(boolean bl) {
        try {
            this.singleSessionPerUser.set(bl ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public String getLegalDisclaimer() {
        try {
            return (String)this.legalDisclaimer.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public int getLegalDisclaimerMaxLength() {
        return 1600;
    }

    public void setLegalDisclaimer(String string) throws Exception {
        if (string.length() > 1600) {
            throw new Exception("The login legal disclaimer field is limited to 1600 characters.");
        }
        try {
            this.legalDisclaimer.set(string);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void adminLockUsername(String string) throws SecurityUnknownUser, SecurityKeepOneSuperUser, SecurityActiveUserSession {
        try {
            this.adminLockUsername.set(string);
        }
        catch (xKeepOneSuperUser xKeepOneSuperUser2) {
            throw new SecurityKeepOneSuperUser((UserException)xKeepOneSuperUser2);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void adminUnlockUsername(String string) throws SecurityUnknownUser, SecurityActiveUserSession {
        try {
            this.adminUnlockUsername.set(string);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void logoutUser(String string, IIpAddr iIpAddr, boolean bl) throws SecurityUnknownUser, SecurityUserNotLoggedIn, SecurityKeepOneSuperUser {
        throw new FeatureNotSupported("logoutUser() not supported");
    }

    public int getIdleUserPolicy(eSecurityLevel eSecurityLevel2) {
        try {
            sIdleUserTimeout[] sIdleUserTimeoutArray = (sIdleUserTimeout[])this.idleUserTimeout.get();
            for (int i = 0; i < sIdleUserTimeoutArray.length; ++i) {
                if (sIdleUserTimeoutArray[i].securityLevel.value() != eSecurityLevel2.value()) continue;
                return sIdleUserTimeoutArray[i].timeoutMinutes;
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return 0;
    }

    public void setIdleUserPolicy(eSecurityLevel eSecurityLevel2, int n) throws InvalidParams {
        sIdleUserTimeout sIdleUserTimeout2 = new sIdleUserTimeout();
        sIdleUserTimeout2.securityLevel = eSecurityLevel2;
        sIdleUserTimeout2.timeoutMinutes = (short)n;
        try {
            this.idleUserTimeout.set(sIdleUserTimeout2);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("The user idle time is invalid.");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public ISecurityPolicy getSecurityPolicy() {
        try {
            int n;
            sIdleUserTimeout[] sIdleUserTimeoutArray = (sIdleUserTimeout[])this.idleUserTimeout.get();
            sLockoutPolicy sLockoutPolicy2 = (sLockoutPolicy)this.lockoutPolicy.get();
            sPasswordFlippingPolicy sPasswordFlippingPolicy2 = (sPasswordFlippingPolicy)this.passwordFlippingPolicy.get();
            sPasswordExprPolicy sPasswordExprPolicy2 = (sPasswordExprPolicy)this.passwordExprPolicy.get();
            sDisableInactiveUserPolicy sDisableInactiveUserPolicy2 = (sDisableInactiveUserPolicy)this.disableInactiveUserPolicy.get();
            SecurityPolicy securityPolicy = new SecurityPolicy();
            for (n = 0; n < sIdleUserTimeoutArray.length; ++n) {
                securityPolicy.setIdleTimeout(sIdleUserTimeoutArray[n].securityLevel.value(), sIdleUserTimeoutArray[n].timeoutMinutes);
            }
            securityPolicy.setLockoutThreshold(sLockoutPolicy2.maxBadLogins);
            securityPolicy.setManualUnlock(sLockoutPolicy2.durationForever);
            securityPolicy.setLockoutDuration(sLockoutPolicy2.lockoutSeconds);
            securityPolicy.setPasswordReuseThreshold(this.getPasswordTogglingPolicy());
            securityPolicy.setSingleSessionPerUser(this.getSingleSessionPerUser());
            securityPolicy.setForcePasswordChange(this.getForcePasswordChange());
            securityPolicy.setPasswordFlippingPolicyEnabled(sPasswordFlippingPolicy2.enforce);
            securityPolicy.setPasswordFlippingPolicyThreshold(sPasswordFlippingPolicy2.minDaysBetweenChanges);
            if (sDisableInactiveUserPolicy2.maxInactiveDays == 0) {
                securityPolicy.setDisableInactiveUserPolicyEnabled(false);
                securityPolicy.setMaxInactiveDaysBeforeDisable(45);
            } else {
                securityPolicy.setDisableInactiveUserPolicyEnabled(true);
                securityPolicy.setMaxInactiveDaysBeforeDisable(sDisableInactiveUserPolicy2.maxInactiveDays);
            }
            securityPolicy.setPasswordExprPolicyEnabled(sPasswordExprPolicy2.enforce);
            securityPolicy.setMinChangedCharsInPwd(this.getMinChangedCharsInPwd());
            securityPolicy.setPreventSuperUserDisabledPolicy(this.getPreventSuperUserDisabledPolicy());
            for (n = 0; n < sPasswordExprPolicy2.pwExprList.length; ++n) {
                sPasswordExpr sPasswordExpr2 = sPasswordExprPolicy2.pwExprList[n];
                securityPolicy.setPasswordExprPolicy(sPasswordExpr2.securityLevel.value(), sPasswordExpr2.numDaysPasswordValid, sPasswordExpr2.numDaysWarningPeriod);
            }
            securityPolicy.setReverseUserIdAllowed(this.getReverseUserIdAllowed());
            securityPolicy.setIdenticalConsecutiveCharactersAllowed(this.getIdenticalConsecutiveChars());
            securityPolicy.setMinimumLength(this.getMinimumLength());
            securityPolicy.setMaximumLength(this.getMaximumLength());
            securityPolicy.setMinimumRequiredCharacters(this.getMinimumRequiredChars());
            return securityPolicy;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return DEF_POLICY;
        }
    }

    public void setSecurityPolicy(ISecurityPolicy iSecurityPolicy) throws InvalidParams, InvalidRange {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        int n5;
        ArrayList<sPasswordExpr> arrayList = new ArrayList<sPasswordExpr>();
        if (iSecurityPolicy.getLockoutThreshold() != this.getLockoutThreshold() || iSecurityPolicy.isManualUnlock() != this.getLockoutForever() || iSecurityPolicy.getLockoutDuration() != this.getLockoutDuration()) {
            this.setLockoutPolicy(iSecurityPolicy.getLockoutThreshold(), iSecurityPolicy.isManualUnlock(), iSecurityPolicy.getLockoutDuration());
        }
        if (iSecurityPolicy.getPasswordReuseThreshold() != this.getPasswordTogglingPolicy()) {
            this.setPasswordTogglingPolicy(iSecurityPolicy.getPasswordReuseThreshold());
        }
        if (iSecurityPolicy.isSingleSessionPerUser() != this.getSingleSessionPerUser()) {
            this.setSingleSessionPerUser(iSecurityPolicy.isSingleSessionPerUser());
        }
        for (n5 = 0; n5 < SecurityLevel.SECURITY_LEVELS.length; ++n5) {
            n4 = SecurityLevel.SECURITY_LEVELS[n5].value();
            object = eSecurityLevel.from_int(n4);
            n3 = iSecurityPolicy.getIdleTimeout(n4);
            if (this.getIdleUserPolicy((eSecurityLevel)object) != n3) {
                this.setIdleUserPolicy((eSecurityLevel)object, n3);
            }
            n2 = iSecurityPolicy.getPasswordExprPeriod(n4);
            n = iSecurityPolicy.getPasswordExprWarningPeriod(n4);
            if (this.getPasswordExprAgingPeriod((eSecurityLevel)object) == n2 && this.getPasswordExprWarningPeriod((eSecurityLevel)object) == n) continue;
            arrayList.add(SecurityModel.createPasswordExpr(object, n2, n));
        }
        if (iSecurityPolicy.getForcePasswordChange() != this.getForcePasswordChange()) {
            this.setForcePasswordChange(iSecurityPolicy.getForcePasswordChange());
        }
        n5 = arrayList.size() > 0 || iSecurityPolicy.isPasswordExprPolicyEnabled() != this.getPasswordExprPolicyEnabled() ? 1 : 0;
        int n6 = n4 = iSecurityPolicy.getPasswordFlippingPolicyEnabled() != this.getPasswordFlippingPolicyEnabled() || iSecurityPolicy.getPasswordFlippingPolicyThreshold() != this.getPasswordFlippingPolicyThreshold() ? 1 : 0;
        if (n5 != 0 && n4 != 0 && iSecurityPolicy.getPasswordFlippingPolicyThreshold() < this.getPasswordFlippingPolicyThreshold()) {
            this.setPasswordFlippingPolicy(iSecurityPolicy.getPasswordFlippingPolicyEnabled(), iSecurityPolicy.getPasswordFlippingPolicyThreshold());
            n4 = 0;
        }
        if (n5 != 0) {
            object = new sPasswordExprPolicy();
            ((sPasswordExprPolicy)object).enforce = iSecurityPolicy.isPasswordExprPolicyEnabled();
            ((sPasswordExprPolicy)object).pwExprList = arrayList.toArray(new sPasswordExpr[arrayList.size()]);
            this.setPasswordExprPolicy((sPasswordExprPolicy)object);
        }
        if (n4 != 0) {
            this.setPasswordFlippingPolicy(iSecurityPolicy.getPasswordFlippingPolicyEnabled(), iSecurityPolicy.getPasswordFlippingPolicyThreshold());
        }
        if (iSecurityPolicy.getMinChangedCharsInPwd() != this.getMinChangedCharsInPwd()) {
            this.setMinChangedCharsInPwd(iSecurityPolicy.getMinChangedCharsInPwd());
            this.setPasswordFlippingPolicy(iSecurityPolicy.getPasswordFlippingPolicyEnabled(), iSecurityPolicy.getPasswordFlippingPolicyThreshold());
        }
        int n7 = iSecurityPolicy.getDisableInactiveUserPolicyEnabled();
        n3 = this.getDisableInactiveUserPolicyEnabled() ? 1 : 0;
        n2 = iSecurityPolicy.getMaxInactiveDaysBeforeDisable();
        n = this.getDisableInactiveUserPolicyThreshold();
        if (n7 != n3) {
            this.setDisableInactiveUserPolicy(n7 != 0, n2);
        } else if (n7 && n3 != 0 && n2 != n) {
            this.setDisableInactiveUserPolicy(n7 != 0, n2);
        }
        boolean bl = iSecurityPolicy.getPreventSuperUserDisabledPolicy();
        boolean bl2 = this.getPreventSuperUserDisabledPolicy();
        if (bl != bl2) {
            this.setPreventSuperUserDisabledPolicy(iSecurityPolicy.getPreventSuperUserDisabledPolicy());
        }
        if (iSecurityPolicy.getMinimumLength() != -1) {
            int n8;
            int n9;
            short s;
            short s2;
            short s3;
            short s4;
            short s5;
            short s6;
            boolean bl3;
            boolean bl4 = this.getReverseUserIdAllowed();
            if (bl4 != (bl3 = iSecurityPolicy.getReverseUserIdAllowed())) {
                this.setReverseUserIdAllowed(bl3);
            }
            if ((s6 = this.getMaximumLength()) != (s5 = iSecurityPolicy.getMaximumLength())) {
                this.setMaximumLength(s5);
            }
            if ((s4 = this.getMinimumLength()) != (s3 = iSecurityPolicy.getMinimumLength())) {
                this.setMinimumLength(iSecurityPolicy.getMinimumLength());
            }
            if ((s2 = this.getIdenticalConsecutiveChars()) != (s = iSecurityPolicy.getIdenticalConsecutiveCharactersAllowed())) {
                this.setIdenticalConsecutiveChars(s);
            }
            if ((n9 = this.getMinimumRequiredChars()) != (n8 = iSecurityPolicy.getMinimumRequiredCharacters())) {
                this.setMinimumRequiredChars(n8);
            }
        }
    }

    private UserInfoModel findUser(String string) {
        try {
            ArrayList arrayList = (ArrayList)this.userList.get();
            for (UserInfoModel userInfoModel : arrayList) {
                if (!userInfoModel.getName().equals(string)) continue;
                return userInfoModel;
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return null;
    }

    public IUserInfoModel[] getLoggedOnUsers() {
        IActiveUserInfoModel[] iActiveUserInfoModelArray = this.getActiveUsers();
        IUserInfoModel[] iUserInfoModelArray = null;
        if (iActiveUserInfoModelArray != null) {
            iUserInfoModelArray = new IUserInfoModel[iActiveUserInfoModelArray.length];
            for (int i = 0; i < iActiveUserInfoModelArray.length; ++i) {
                iUserInfoModelArray[i] = this.findUser(iActiveUserInfoModelArray[i].getUserId());
            }
        }
        return iUserInfoModelArray;
    }

    public boolean getForcePasswordChange() {
        try {
            return (Boolean)this.forcePasswordChange.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setForcePasswordChange(boolean bl) {
        try {
            this.forcePasswordChange.set(bl ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setUserForcePasswordChange(String string, boolean bl) throws SecurityUnknownUser, SecurityActiveUserSession {
        try {
            Object[] objectArray = new Object[]{string, bl ? Boolean.TRUE : Boolean.FALSE};
            this.userForcePasswordChange.set(objectArray);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean isPasswordChangeRequired(String string) throws SecurityUnknownUser {
        try {
            return (Boolean)this.requirePasswordChange.get(string);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public int getRemainingPasswordDays(String string) throws SecurityUnknownUser {
        try {
            return (Integer)this.passwordCloseToExpiring.get(string);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public boolean getPasswordFlippingPolicyEnabled() {
        try {
            return ((sPasswordFlippingPolicy)this.passwordFlippingPolicy.get()).enforce;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public int getPasswordFlippingPolicyThreshold() {
        try {
            return ((sPasswordFlippingPolicy)this.passwordFlippingPolicy.get()).minDaysBetweenChanges;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setPasswordFlippingPolicy(boolean bl, int n) throws InvalidParams {
        try {
            sPasswordFlippingPolicy sPasswordFlippingPolicy2 = new sPasswordFlippingPolicy();
            sPasswordFlippingPolicy2.enforce = bl;
            sPasswordFlippingPolicy2.minDaysBetweenChanges = (short)n;
            this.passwordFlippingPolicy.set(sPasswordFlippingPolicy2);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("The minimum number of days to change the password policy value is invalid.\nThe value must be between 20 and 95 days and less than password aging period.");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getDisableInactiveUserPolicyEnabled() {
        try {
            return ((sDisableInactiveUserPolicy)this.disableInactiveUserPolicy.get()).enforce;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public int getDisableInactiveUserPolicyThreshold() {
        try {
            return ((sDisableInactiveUserPolicy)this.disableInactiveUserPolicy.get()).maxInactiveDays;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setDisableInactiveUserPolicy(boolean bl, int n) throws InvalidParams {
        sDisableInactiveUserPolicy sDisableInactiveUserPolicy2 = new sDisableInactiveUserPolicy();
        if (bl) {
            sDisableInactiveUserPolicy2.enforce = bl;
            sDisableInactiveUserPolicy2.maxInactiveDays = (short)n;
        } else {
            sDisableInactiveUserPolicy2.enforce = bl;
            sDisableInactiveUserPolicy2.maxInactiveDays = 0;
        }
        try {
            this.disableInactiveUserPolicy.set(sDisableInactiveUserPolicy2);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("The disable user ID policy is invalid.\nThe idle duration must be between 45 and 90 days.");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setUserDisabled(String string, boolean bl) throws SecurityUnknownUser, SecurityActiveUserSession {
        try {
            Object[] objectArray = new Object[]{string, bl ? Boolean.TRUE : Boolean.FALSE};
            this.userDisabled.set(objectArray);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setPasswordExprPolicyEnabled(boolean bl) throws InvalidParams {
        sPasswordExprPolicy sPasswordExprPolicy2 = new sPasswordExprPolicy();
        sPasswordExprPolicy2.enforce = bl;
        sPasswordExprPolicy2.pwExprList = new sPasswordExpr[0];
        this.setPasswordExprPolicy(sPasswordExprPolicy2);
    }

    public void setPasswordExprPolicy(eSecurityLevel eSecurityLevel2, int n, int n2) throws InvalidParams {
        sPasswordExprPolicy sPasswordExprPolicy2 = new sPasswordExprPolicy();
        sPasswordExprPolicy2.enforce = this.getPasswordExprPolicyEnabled();
        sPasswordExprPolicy2.pwExprList = new sPasswordExpr[1];
        sPasswordExprPolicy2.pwExprList[0] = SecurityModel.createPasswordExpr(eSecurityLevel2, n, n2);
        this.setPasswordExprPolicy(sPasswordExprPolicy2);
    }

    public boolean getPasswordExprPolicyEnabled() {
        try {
            return ((sPasswordExprPolicy)this.passwordExprPolicy.get()).enforce;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public int getPasswordExprAgingPeriod(eSecurityLevel eSecurityLevel2) {
        sPasswordExpr sPasswordExpr2 = this.getPasswordExpr(eSecurityLevel2);
        return sPasswordExpr2 == null ? (short)0 : sPasswordExpr2.numDaysPasswordValid;
    }

    public int getPasswordExprWarningPeriod(eSecurityLevel eSecurityLevel2) {
        sPasswordExpr sPasswordExpr2 = this.getPasswordExpr(eSecurityLevel2);
        return sPasswordExpr2 == null ? (short)0 : sPasswordExpr2.numDaysWarningPeriod;
    }

    private sPasswordExpr getPasswordExpr(eSecurityLevel eSecurityLevel2) {
        try {
            sPasswordExprPolicy sPasswordExprPolicy2 = (sPasswordExprPolicy)this.passwordExprPolicy.get();
            for (int i = 0; i < sPasswordExprPolicy2.pwExprList.length; ++i) {
                if (sPasswordExprPolicy2.pwExprList[i].securityLevel != eSecurityLevel2) continue;
                return sPasswordExprPolicy2.pwExprList[i];
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return null;
    }

    private void setPasswordExprPolicy(sPasswordExprPolicy sPasswordExprPolicy2) throws InvalidParams {
        try {
            this.passwordExprPolicy.set(sPasswordExprPolicy2);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("The password aging policy is invalid.\nThe password aging period must be between 20 and 90 days\nand greater than the password change waiting period.\nThe password warning period must be between 2 and 20 days");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getFrontLANAccess() {
        try {
            return (Boolean)this.frontLanAccess.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public boolean getBackLANAccess() {
        try {
            return (Boolean)this.backLanAccess.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public LANAccessMode getLANAccess() {
        return LANAccessMode.from_int((this.getFrontLANAccess() ? 2 : 0) + (this.getBackLANAccess() ? 1 : 0), this.getNodeModelDelegate().getChassisModel());
    }

    public void setLANAccess(LANAccessMode lANAccessMode) throws DccNotConnected, OperationFailed, UnsupportedOperation {
        try {
            Object[] objectArray = new Object[]{lANAccessMode.isFrontLANAccessEnabled() ? Boolean.TRUE : Boolean.FALSE, lANAccessMode.isBackLANAccessEnabled() ? Boolean.TRUE : Boolean.FALSE};
            this.backLanAccess.set(objectArray);
        }
        catch (xDccNotConnected xDccNotConnected2) {
            throw new DccNotConnected((UserException)xDccNotConnected2);
        }
        catch (xOperationFailed xOperationFailed2) {
            throw new OperationFailed((UserException)xOperationFailed2);
        }
        catch (xOperationNotSupported xOperationNotSupported2) {
            throw new UnsupportedOperation((UserException)xOperationNotSupported2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getIPv4Access() {
        try {
            return (Boolean)this.ipv4Access.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setIPv4Access(boolean bl) throws OperationFailed, IPv6NotEnabledException, IPv4CannotBeDisabledInMultishelf {
        try {
            this.ipv4Access.set(bl ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (xIPv6NotEnabled xIPv6NotEnabled2) {
            throw new IPv6NotEnabledException((UserException)xIPv6NotEnabled2);
        }
        catch (xOperationFailed xOperationFailed2) {
            throw new OperationFailed((UserException)xOperationFailed2);
        }
        catch (xOperationNotSupported xOperationNotSupported2) {
            throw new IPv4CannotBeDisabledInMultishelf((UserException)xOperationNotSupported2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getLANAccessTimeout() {
        try {
            return ((Short)this.lanAccessTimeout.get()).shortValue();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setLANAccessTimeout(int n) throws InvalidParams {
        try {
            this.lanAccessTimeout.set(new Short((short)n));
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("The LAN access timeout is invalid.\nThe value must be between 0 and 60 minutes.");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getSerialPortAccess(eSerialPortId eSerialPortId2) throws BadSerialPortException {
        try {
            return (Boolean)this.serialPortAccess.get(eSerialPortId2);
        }
        catch (xSerialPortIdNotSupported xSerialPortIdNotSupported2) {
            throw new BadSerialPortException((Throwable)((Object)xSerialPortIdNotSupported2));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setSerialPortAccess(eSerialPortId eSerialPortId2, boolean bl) throws BadSerialPortException {
        try {
            this.serialPortAccess.set(new Object[]{eSerialPortId2, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        catch (xSerialPortIdNotSupported xSerialPortIdNotSupported2) {
            throw new BadSerialPortException((Throwable)((Object)xSerialPortIdNotSupported2));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getTelnetPort() {
        try {
            return (Short)this.telnetPort.get() & 0xFFFF;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public int getStandardTelnetPort() {
        return 23;
    }

    public void setTelnetPort(int n) throws InvalidParams, PortInUse {
        try {
            this.telnetPort.set(new Short((short)n));
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams(EMC.EID_SECURITY_INVALID_TELNET_PORT.getMessage());
        }
        catch (xPortInUse xPortInUse2) {
            throw new PortInUse(EMC.EID_SECURITY_TELNET_PORT_IN_USE.getMessage());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getSshPort() {
        return 22;
    }

    public int getPCLIPort() {
        try {
            return (Short)this.pcliPort.get() & 0xFFFF;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setPCLIPort(int n) throws InvalidParams, PortInUse {
        try {
            this.pcliPort.set(new Short((short)n));
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams(EMC.EID_SECURITY_INVALID_PCLI_PORT.getMessage());
        }
        catch (xPortInUse xPortInUse2) {
            throw new PortInUse(EMC.EID_SECURITY_PCLI_PORT_IN_USE.getMessage());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getPCLISecurePort() {
        try {
            return (Short)this.pcliSecurePort.get() & 0xFFFF;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setPCLISecurePort(int n) throws InvalidParams, PortInUse {
        try {
            this.pcliSecurePort.set(new Short((short)n));
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams(EMC.EID_SECURITY_INVALID_PCLI_PORT.getMessage());
        }
        catch (xPortInUse xPortInUse2) {
            throw new PortInUse(EMC.EID_SECURITY_PCLI_PORT_IN_USE.getMessage());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean isPCLIConsoleEnabled() {
        return this.getAccessState(AccessMechanism.PCLI_ACCESS).intValue() != AccessState.DISABLED.intValue();
    }

    public boolean isPCLIConsoleSecure() {
        return this.getAccessState(AccessMechanism.PCLI_ACCESS).intValue() == AccessState.SECURE.intValue();
    }

    public int getSftpPort() {
        return 4022;
    }

    public boolean isEnforceShellPassword() {
        try {
            return (Boolean)this.enforceShellPassword.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setEnforceShellPasswordOn() {
        try {
            this.enforceShellPassword.set(null);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setEnforceShellPasswordOff(String string) throws NotAuthenticated {
        try {
            this.enforceShellPassword.set(string);
        }
        catch (NotAuthenticated notAuthenticated) {
            throw notAuthenticated;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public SecurityLevel getOperationPrivilege(Operation operation) {
        eOperation eOperation2 = eOperation.from_int(operation.value());
        eSecurityLevel eSecurityLevel2 = this.getOperationPrivilege(eOperation2);
        return SecurityLevel.from_int((int)eSecurityLevel2.value());
    }

    public eSecurityLevel getOperationPrivilege(eOperation eOperation2) {
        try {
            return (eSecurityLevel)this.operationPrivilege.get(eOperation2);
        }
        catch (UserException userException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            return eSecurityLevel.SUPERUSER;
        }
    }

    public void setOperationPrivilege(Operation operation, SecurityLevel securityLevel) throws InvalidParams {
        eOperation eOperation2 = eOperation.from_int(operation.value());
        eSecurityLevel eSecurityLevel2 = eSecurityLevel.from_int(securityLevel.value());
        this.setOperationPrivilege(eOperation2, eSecurityLevel2);
    }

    public void setOperationPrivilege(eOperation eOperation2, eSecurityLevel eSecurityLevel2) throws InvalidParams {
        try {
            Object[] objectArray = new Object[]{eOperation2, eSecurityLevel2};
            this.operationPrivilege.set(objectArray);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("The security level for the " + eOperation2.toString() + " operation is invalid.");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getAlarmOnLostBackLanLink() {
        try {
            return (Boolean)this.alarmOnLostBackLanLink.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setAlarmOnLostBackLanLink(boolean bl) throws UnsupportedOperation {
        try {
            this.alarmOnLostBackLanLink.set(bl ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (xOperationNotSupported xOperationNotSupported2) {
            throw new UnsupportedOperation((UserException)xOperationNotSupported2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public AbstractVersionedFeature getSecurityVersion() {
        return this.securityVersion;
    }

    public AccessState getAccessState(AccessMechanism accessMechanism) {
        eAccessMechanism eAccessMechanism2 = eAccessMechanism.from_int(accessMechanism.intValue());
        eAccessState eAccessState2 = this.getAccessState(eAccessMechanism2);
        if (eAccessState2 != null) {
            return AccessState.from_int(eAccessState2.value());
        }
        return null;
    }

    public eAccessState getAccessState(eAccessMechanism eAccessMechanism2) {
        try {
            return (eAccessState)this.accessMechanismState.get(eAccessMechanism2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setAccessState(AccessMechanism accessMechanism, AccessState accessState) throws UnsupportedOperation {
        eAccessMechanism eAccessMechanism2 = eAccessMechanism.from_int(accessMechanism.intValue());
        eAccessState eAccessState2 = eAccessState.from_int(accessState.intValue());
        this.setAccessState(eAccessMechanism2, eAccessState2);
    }

    public void setAccessState(eAccessMechanism eAccessMechanism2, eAccessState eAccessState2) throws UnsupportedOperation {
        try {
            this.accessMechanismState.set(new Object[]{eAccessMechanism2, eAccessState2});
        }
        catch (xOperationNotSupported xOperationNotSupported2) {
            SDebug.printStackTrace((Throwable)((Object)xOperationNotSupported2));
            throw new UnsupportedOperation((UserException)xOperationNotSupported2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        if (eAccessMechanism2.equals(eAccessMechanism.EMS_ACCESS)) {
            if (eAccessState2 == eAccessState.SECURE) {
                CtcHttpRetriever.addSecureNode((String)this.nodeModel.getHostName());
            } else {
                CtcHttpRetriever.removeSecureNode((String)this.nodeModel.getHostName());
            }
        }
    }

    public eSecurityLevel getSessionSecurityLevel(int n) throws SessionNotFound {
        try {
            Integer n2 = new Integer(n);
            return (eSecurityLevel)this.sessionSecurityLevel.get(n2);
        }
        catch (xSessionNotFound xSessionNotFound2) {
            throw new SessionNotFound((UserException)xSessionNotFound2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "SecurityModel.getSessionSecurityLevel", userException);
        }
    }

    public void logoutSession(int n, boolean bl) throws SessionNotFound {
        try {
            Object[] objectArray = new Object[]{new Integer(n), new Boolean(bl)};
            this.logoutSession.set(objectArray);
        }
        catch (xSessionNotFound xSessionNotFound2) {
            throw new SessionNotFound((UserException)xSessionNotFound2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void logout() throws SecurityUnknownUser {
        try {
            this.logout.set();
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getPreventSuperUserDisabledPolicy() {
        try {
            return (Boolean)this.preventSuperUserDisablePolicy.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setPreventSuperUserDisabledPolicy(boolean bl) {
        try {
            this.preventSuperUserDisablePolicy.set(bl);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getReverseUserIdAllowed() {
        try {
            return (Boolean)this.defReverseUserIdAllowed.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setReverseUserIdAllowed(boolean bl) {
        Object[] objectArray = new Object[]{new Boolean(bl)};
        try {
            this.defReverseUserIdAllowed.set(objectArray[0]);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public short getMaximumLength() {
        short s = 0;
        try {
            s = (Short)this.defMaximumLength.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return s;
    }

    public void setMaximumLength(short s) {
        Object[] objectArray = new Object[]{new Short(s)};
        try {
            this.defMaximumLength.set(objectArray[0]);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public short getMinimumLength() {
        short s = 0;
        try {
            s = (Short)this.defMinimumLength.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return s;
    }

    public void setMinimumLength(short s) {
        Object[] objectArray = new Object[]{new Short(s)};
        try {
            this.defMinimumLength.set(objectArray[0]);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public short getIdenticalConsecutiveChars() {
        short s = 0;
        try {
            s = (Short)this.defIdenticalConsecutiveChars.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return s;
    }

    public void setIdenticalConsecutiveChars(short s) {
        Object[] objectArray = new Object[]{new Short(s)};
        try {
            this.defIdenticalConsecutiveChars.set(objectArray[0]);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getMinimumRequiredChars() {
        ePasswordCharsRule ePasswordCharsRule2 = null;
        int n = 0;
        try {
            ePasswordCharsRule2 = (ePasswordCharsRule)this.defMinimumRequiredChars.get();
            n = ePasswordCharsRule2.value();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return n;
    }

    public void setMinimumRequiredChars(int n) {
        ePasswordCharsRule ePasswordCharsRule2 = ePasswordCharsRule.from_int(n);
        Object[] objectArray = new Object[]{ePasswordCharsRule2};
        try {
            this.defMinimumRequiredChars.set(objectArray[0]);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public void dispose() {
        if (this.db.on) {
            this.db.println("Enter SecurityModel dispose()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSecurity, 0, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectSecurity, 1, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectSecurity, 2, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectSecurity, 3, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectSecurity, 4, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectSecurity, 5, (Observer)this);
        }
        this.userList.dispose();
        this.lockoutPolicy.dispose();
        this.passwordTogglingPolicy.dispose();
        this.singleSessionPerUser.dispose();
        this.legalDisclaimer.dispose();
        this.forcePasswordChange.dispose();
        this.passwordFlippingPolicy.dispose();
        this.passwordExprPolicy.dispose();
        this.disableInactiveUserPolicy.dispose();
        this.frontLanAccess.dispose();
        this.backLanAccess.dispose();
        this.lanAccessTimeout.dispose();
        this.telnetPort.dispose();
        this.ipv4Access.dispose();
        this.enforceShellPassword.dispose();
        this.alarmOnLostBackLanLink.dispose();
        this.idleUserTimeout.dispose();
        this.minChangedCharsInPwd.dispose();
        this.logoutSession.dispose();
        this.preventSuperUserDisablePolicy.dispose();
        this.defReverseUserIdAllowed.dispose();
        this.defMaximumLength.dispose();
        this.defMinimumLength.dispose();
        this.defIdenticalConsecutiveChars.dispose();
        this.defMinimumRequiredChars.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void update(Observable observable, Object object) {
        Integer n = ModelUpdateType.CHANGED;
        int n2 = ((IObjectMessageInfo)object).getIndex();
        if (this.db.on) {
            this.db.println("SecurityModel.update(): Entry. arg=" + n2 + "; from=" + observable.toString());
        }
        switch (n2) {
            case 0: {
                this.userList.update();
                break;
            }
            case 1: {
                this.legalDisclaimer.update();
                break;
            }
            case 3: {
                this.lockoutPolicy.update();
                this.passwordTogglingPolicy.update();
                this.singleSessionPerUser.update();
                this.idleUserTimeout.update();
                this.forcePasswordChange.update();
                this.passwordFlippingPolicy.update();
                this.passwordExprPolicy.update();
                this.disableInactiveUserPolicy.update();
                this.backLanAccess.update();
                this.lanAccessTimeout.update();
                this.telnetPort.update();
                this.passwordFlippingPolicy.update();
                this.passwordExprPolicy.update();
                this.disableInactiveUserPolicy.update();
                this.minChangedCharsInPwd.update();
                this.preventSuperUserDisablePolicy.update();
                this.defReverseUserIdAllowed.update();
                this.defMaximumLength.update();
                this.defMinimumLength.update();
                this.defIdenticalConsecutiveChars.update();
                this.defMinimumRequiredChars.update();
                break;
            }
            case 5: {
                this.frontLanAccess.update();
                this.backLanAccess.update();
                this.lanAccessTimeout.update();
                this.telnetPort.update();
                this.enforceShellPassword.update();
                this.alarmOnLostBackLanLink.update();
                this.ipv4Access.update();
                break;
            }
            case 4: {
                if (this.db.on) {
                    this.db.println("SecurityModel.update(): case=LOGOUT");
                }
                this.logoutSession.update();
                if (this.nodeModel.forcedLogout()) {
                    if (this.db.on) {
                        this.db.println("SecurityModel.update(): forcedLogout()==true");
                    }
                    n = ModelUpdateType.LOGOUT;
                    String string = "You were logged out from " + this.getNodeModel().getHostName() + ".";
                    DetailedLog detailedLog = new DetailedLog(2, string);
                    EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
                    break;
                }
                if (!this.db.on) break;
                this.db.println("SecurityModel.update(): forcedLogout()==false");
                break;
            }
            default: {
                if (!this.db.on) break;
                this.db.println("Unknown notification index from securityObject");
            }
        }
        if (this.db.on) {
            this.db.println("SecurityModel.update(): Notifying Observers. msg=" + n);
        }
        this.setChanged();
        this.notifyObservers(n);
        if (this.db.on) {
            this.db.println("SecurityModel.update(): Exit");
        }
    }

    private static sPasswordExpr createPasswordExpr(eSecurityLevel eSecurityLevel2, int n, int n2) {
        sPasswordExpr sPasswordExpr2 = new sPasswordExpr();
        sPasswordExpr2.securityLevel = eSecurityLevel2;
        sPasswordExpr2.numDaysPasswordValid = (short)n;
        sPasswordExpr2.numDaysWarningPeriod = (short)n2;
        return sPasswordExpr2;
    }

    class AccessMechanismState
    extends NonCachedValue {
        public AccessMechanismState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) {
            return SecurityModel.this.getSecurityRef().getAccessMechanismState((eAccessMechanism)object);
        }

        @Override
        protected void setValue(Object object) throws xOperationNotSupported {
            Object[] objectArray = (Object[])object;
            eAccessMechanism eAccessMechanism2 = (eAccessMechanism)objectArray[0];
            eAccessState eAccessState2 = (eAccessState)objectArray[1];
            SecurityModel.this.getSecurityRef().setAccessMechanismState(eAccessMechanism2, eAccessState2);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class ActiveUserList
    extends NonCachedValue {
        public ActiveUserList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            sActiveUserInfo[] sActiveUserInfoArray = SecurityModel.this.getSecurityRef().loggedOnUsers();
            ActiveUserInfoModel[] activeUserInfoModelArray = new ActiveUserInfoModel[sActiveUserInfoArray.length];
            for (int i = 0; i < sActiveUserInfoArray.length; ++i) {
                activeUserInfoModelArray[i] = new ActiveUserInfoModel(SecurityModel.this.nodeModel, sActiveUserInfoArray[i]);
            }
            return activeUserInfoModelArray;
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class AdminLockUsername
    extends NonCachedValue {
        public AdminLockUsername(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().adminLockUsername((String)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class AdminUnlockUsername
    extends NonCachedValue {
        public AdminUnlockUsername(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().adminUnlockUsername((String)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class AlarmOnLostBackLanLink
    extends CachedValue {
        public AlarmOnLostBackLanLink(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().isAlarmOnLostBackLanLinkEnabled() ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setAlarmOnLostBackLanLink((Boolean)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class Authenticate
    extends NonCachedValue {
        public Authenticate(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return SecurityModel.this.getSecurityRef().authenticate((sAuthInput)objectArray[0]);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class BackLANAccess
    extends CachedValue {
        public BackLANAccess(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getBackLanAccess() ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SecurityModel.this.getSecurityRef().setBothLanAccess((Boolean)objectArray[0], (Boolean)objectArray[1]);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class ClearSecurityIntrusionAlarm
    extends NonCachedValue {
        public ClearSecurityIntrusionAlarm(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue() throws UserException {
            SecurityModel.this.getSecurityRef().clearSecurityIntrusionAlarm();
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class CreateUser
    extends NonCachedValue {
        public CreateUser(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SecurityModel.this.getSecurityRef().createUser((String)objectArray[0], (String)objectArray[1], (eSecurityLevel)objectArray[2]);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class DeleteUser
    extends NonCachedValue {
        public DeleteUser(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().deleteUser((String)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class DisableInactiveUserPolicy
    extends CachedValue {
        public DisableInactiveUserPolicy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getDisableInactiveUserPolicy();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setDisableInactiveUserPolicy((sDisableInactiveUserPolicy)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class EnforceShellPassword
    extends CachedValue {
        public EnforceShellPassword(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Boolean(SecurityModel.this.getSecurityRef().getEnforceShellPassword());
        }

        @Override
        protected void setValue(Object object) throws UserException {
            if (object == null) {
                SecurityModel.this.getSecurityRef().setEnforceShellPasswordOn();
            } else {
                SecurityModel.this.getSecurityRef().setEnforceShellPasswordOff((String)object);
            }
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class ForcePasswordChange
    extends CachedValue {
        public ForcePasswordChange(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getDefaultForcePasswordChange() ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setDefaultForcePasswordChange((Boolean)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class FrontLANAccess
    extends CachedValue {
        public FrontLANAccess(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getFrontLanAccess() ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class IPv4Access
    extends CachedValue {
        public IPv4Access(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getIPv4Access() ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setIPv4Access((Boolean)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    private class IdenticalConsecutiveChars
    extends CachedValue {
        public IdenticalConsecutiveChars(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            short s = (Short)object;
            SecurityModel.this.getSecurityRef().setIdenticalConsecutiveCharsAllowed((Short)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Short(SecurityModel.this.getSecurityRef().getIdenticalConsecutiveCharsAllowed());
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class IdleUserTimeout
    extends CachedValue {
        public IdleUserTimeout(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getIdleUserTimeoutList();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setIdleUserTimeOut((sIdleUserTimeout)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class LANAccessTimeout
    extends CachedValue {
        public LANAccessTimeout(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Short(SecurityModel.this.getSecurityRef().getLanAccessTimeout());
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setLanAccessTimeout((Short)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class LegalDisclaimer
    extends CachedValue {
        public LegalDisclaimer(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getDisclaimer();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setDisclaimer((String)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class LockoutPolicy
    extends CachedValue {
        public LockoutPolicy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getLockoutPolicy();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setLockoutPolicy((sLockoutPolicy)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class Logout
    extends NonCachedValue {
        public Logout(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue() throws UserException {
            SecurityModel.this.getSecurityRef().logout();
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class LogoutSession
    extends CachedValue {
        public LogoutSession(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            boolean bl = (Boolean)objectArray[1];
            SecurityModel.this.getSecurityRef().logoutSession(n, bl);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    private class MaximumLength
    extends CachedValue {
        public MaximumLength(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            short s = (Short)object;
            SecurityModel.this.getSecurityRef().setMaxPasswordLength((Short)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Short(SecurityModel.this.getSecurityRef().getMaxPasswordLength());
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class MinChangedCharsInPwd
    extends CachedValue {
        public MinChangedCharsInPwd(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            return new Short(SecurityModel.this.getSecurityRef().getMinChangedCharsInPwd());
        }

        @Override
        protected void setValue(Object object) throws xInvalidRange {
            SecurityModel.this.getSecurityRef().setMinChangedCharsInPwd((Short)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    private class MinimumLength
    extends CachedValue {
        public MinimumLength(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            short s = (Short)object;
            SecurityModel.this.getSecurityRef().setMinPasswordLength((Short)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Short(SecurityModel.this.getSecurityRef().getMinPasswordLength());
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    private class MinimumRequiredChars
    extends CachedValue {
        public MinimumRequiredChars(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setPasswordCharsRule((ePasswordCharsRule)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getPasswordCharsRule();
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class OperationPrivilege
    extends NonCachedValue {
        public OperationPrivilege(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            return SecurityModel.this.getSecurityRef().getOperationPrivilege((eOperation)object);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            eOperation eOperation2 = (eOperation)objectArray[0];
            eSecurityLevel eSecurityLevel2 = (eSecurityLevel)objectArray[1];
            SecurityModel.this.getSecurityRef().setOperationPrivilege(eOperation2, eSecurityLevel2);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class PCLIPort
    extends CachedValue {
        public PCLIPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            eAccessState eAccessState2 = eAccessState.NONSECURE;
            return new Short(SecurityModel.this.getSecurityRef().getPCLIPort(eAccessState2));
        }

        @Override
        protected void setValue(Object object) throws UserException {
            eAccessState eAccessState2 = eAccessState.NONSECURE;
            SecurityModel.this.getSecurityRef().setPCLIPort(eAccessState2, (Short)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class PCLISecurePort
    extends CachedValue {
        public PCLISecurePort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            eAccessState eAccessState2 = eAccessState.SECURE;
            return new Short(SecurityModel.this.getSecurityRef().getPCLIPort(eAccessState2));
        }

        @Override
        protected void setValue(Object object) throws UserException {
            eAccessState eAccessState2 = eAccessState.SECURE;
            SecurityModel.this.getSecurityRef().setPCLIPort(eAccessState2, (Short)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class PasswordCloseToExpiring
    extends NonCachedValue {
        public PasswordCloseToExpiring(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            ShortHolder shortHolder = new ShortHolder();
            if (SecurityModel.this.getSecurityRef().isPasswordCloseToExpiring((String)object, shortHolder)) {
                return new Integer(shortHolder.value);
            }
            return NO_WARNING;
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class PasswordExprPolicy
    extends CachedValue {
        public PasswordExprPolicy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getPasswordExprPolicy();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setPasswordExprPolicy((sPasswordExprPolicy)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class PasswordFlippingPolicy
    extends CachedValue {
        public PasswordFlippingPolicy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getPasswordFlippingPolicy();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setPasswordFlippingPolicy((sPasswordFlippingPolicy)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class PasswordTogglingPolicy
    extends CachedValue {
        public PasswordTogglingPolicy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Short(SecurityModel.this.getSecurityRef().getPasswordTogglingPolicy());
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setPasswordTogglingPolicy((Short)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class PreventSuperUserDisablePolicy
    extends CachedValue {
        public PreventSuperUserDisablePolicy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getPreventSuperUserDisablePolicy();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setPreventSuperUserDisablePolicy((Boolean)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class RequirePasswordChange
    extends NonCachedValue {
        public RequirePasswordChange(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            return SecurityModel.this.getSecurityRef().isPasswordChangeRequired((String)object) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    private class ReverseUserIdAllowed
    extends CachedValue {
        public ReverseUserIdAllowed(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setReverseUserIdAllowed((Boolean)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Boolean(SecurityModel.this.getSecurityRef().getReverseUserIdAllowed());
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    public class SecurityModelDebug
    extends SDebug {
        public SecurityModelDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public final void testTelnetPorts() {
            for (int n = Short.MIN_VALUE; n < Short.MAX_VALUE; n = (int)((short)(n + 1))) {
                try {
                    SecurityModel.this.setTelnetPort(n);
                    SecurityModel.this.telnetPort.update();
                    int n2 = SecurityModel.this.getTelnetPort();
                    if (n == n2) continue;
                    SecurityModel.this.db.println("set(" + n + ") != get(" + n2 + ")");
                    continue;
                }
                catch (InvalidParams invalidParams) {
                    SecurityModel.this.db.println("set(" + n + "): invalid parameter");
                    continue;
                }
                catch (PortInUse portInUse) {
                    SecurityModel.this.db.println("set(" + n + "): port in use");
                    continue;
                }
                catch (Exception exception) {
                    SecurityModel.this.db.println("set(" + n + "): " + exception);
                }
            }
        }
    }

    class SerialPortAccess
    extends NonCachedValue {
        public SerialPortAccess(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            return SecurityModel.this.getSecurityRef().getSerialPortAccess((eSerialPortId)object) ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SecurityModel.this.getSecurityRef().setSerialPortAccess((eSerialPortId)objectArray[0], (Boolean)objectArray[1]);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class SessionSecurityLevel
    extends NonCachedValue {
        public SessionSecurityLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return SecurityModel.this.getSecurityRef().getSessionSecurityLevel(n);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class SingleSessionPerUser
    extends CachedValue {
        public SingleSessionPerUser(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getOneActiveLogin() ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setOneActiveLogin((Boolean)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class TelnetPort
    extends CachedValue {
        public TelnetPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Short(SecurityModel.this.getSecurityRef().getTelnetPort());
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setTelnetPort((Short)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class UserDisabled
    extends NonCachedValue {
        public UserDisabled(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SecurityModel.this.getSecurityRef().setUserDisabled((String)objectArray[0], (Boolean)objectArray[1]);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class UserForcePasswordChange
    extends NonCachedValue {
        public UserForcePasswordChange(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SecurityModel.this.getSecurityRef().setUserForcePasswordChange((String)objectArray[0], (Boolean)objectArray[1]);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class UserList
    extends CachedValue {
        public UserList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            List list = (List)this.value;
            ArrayList<UserInfoModel> arrayList = new ArrayList<UserInfoModel>();
            userInfo[] userInfoArray = SecurityModel.this.getSecurityRef().users();
            if (list == null || list.isEmpty()) {
                for (int i = 0; i < userInfoArray.length; ++i) {
                    arrayList.add(new UserInfoModel(SecurityModel.this.nodeModel, userInfoArray[i]));
                }
            } else {
                for (int i = 0; i < userInfoArray.length; ++i) {
                    UserInfoModel userInfoModel = null;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        UserInfoModel userInfoModel2 = (UserInfoModel)iterator.next();
                        if (userInfoModel2.getName() != userInfoArray[i].name) continue;
                        userInfoModel = userInfoModel2;
                        iterator.remove();
                        break;
                    }
                    if (userInfoModel == null) {
                        userInfoModel = new UserInfoModel(SecurityModel.this.nodeModel, userInfoArray[i]);
                    }
                    arrayList.add(userInfoModel);
                }
            }
            return arrayList;
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class UserPassword
    extends NonCachedValue {
        public UserPassword(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            if (objectArray.length == 2) {
                SecurityModel.this.getSecurityRef().setUserPassword((String)objectArray[0], (String)objectArray[1]);
            } else if (objectArray.length == 3) {
                SecurityModel.this.getSecurityRef().changePassword((String)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
            } else {
                throw new IllegalArgumentException("UserPassword.setValue: internal error: expecting an array of length 2 or 3");
            }
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class UserSecurityLevel
    extends NonCachedValue {
        public UserSecurityLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            return SecurityModel.this.getSecurityRef().getUserSecurityLevel((String)object);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SecurityModel.this.getSecurityRef().setUserSecurityLevel((String)objectArray[0], (eSecurityLevel)objectArray[1]);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }
}

