/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.fv.IFvSideModel;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SideModels;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.DwdmSide;
import java.util.Observable;
import java.util.Observer;

public class SideModel
extends Model
implements ISideModel,
IFvSideModel {
    private String className = null;
    private int sideId;
    private int lineInIdx;
    private int lineOutIdx;
    private int oscIdx;
    private String sideName;
    private boolean dcnEnabled;
    private long uniqueLinkSRLG;
    private String additionalLinkSRLG;
    private NodeModelDelegate nmd;
    private EventDispatcher dispatcher;

    public SideModel(int n, int n2, int n3, int n4, boolean bl, long l, String string, NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(SideModel.class));
        this.sideId = n;
        this.sideName = DwdmSide.getSideFromOffset(n);
        this.dcnEnabled = bl;
        this.lineInIdx = n2;
        this.lineOutIdx = n3;
        this.oscIdx = n4;
        this.uniqueLinkSRLG = l;
        this.additionalLinkSRLG = string;
        this.nmd = nodeModelDelegate;
        this.className = this.getClass().toString();
        this.init();
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    private void addObserver() {
        if (this.db.on()) {
            this.db.println(this.className + ":: addObserver()  ");
        }
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectDwdmSide, this.lineInIdx, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectDwdmSide, this.sideId, (Observer)this);
        }
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nmd.getDispatcher();
        this.addObserver();
        if (this.db.on()) {
            this.db.println(this.className + ":: init()");
        }
    }

    private void deleteObserver() {
        if (this.db.on()) {
            this.db.println(this.className + ":: deleteObserver()  ");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmSide, this.lineInIdx, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmSide, this.sideId, (Observer)this);
        }
    }

    public int getId() {
        return this.sideId;
    }

    public String getName() {
        return this.sideName;
    }

    public String getNameLabel() {
        return DwdmSide.getSideLabelFromOffset(this.sideId);
    }

    public int getNameLabelValue() {
        return DwdmSide.getSideLabelFromId(this.sideId);
    }

    public int getRole() {
        return DwdmSide.getSideRole(this.sideId);
    }

    public int getLineIn() {
        return this.lineInIdx;
    }

    public int getLineOut() {
        return this.lineOutIdx;
    }

    public int getOsc() {
        return this.oscIdx;
    }

    public int[] getLinesIn() {
        int[] nArray = new int[]{this.lineInIdx};
        return nArray;
    }

    public int[] getLinesOut() {
        int[] nArray = new int[]{this.lineOutIdx};
        return nArray;
    }

    public boolean isDcnEnabled() {
        return this.dcnEnabled;
    }

    public long getUniqueLinkSRLG() {
        return this.uniqueLinkSRLG;
    }

    public String getAdditionalLinkSRLG() {
        return this.additionalLinkSRLG;
    }

    public void setLineIn(int n) {
        this.lineInIdx = n;
    }

    public void setLineOut(int n) {
        this.lineOutIdx = n;
    }

    public void setId(int n) {
        this.sideId = n;
        this.sideName = DwdmSide.getSideFromOffset(n);
    }

    public void setUniqueLinkSRLG(long l) {
        this.uniqueLinkSRLG = l;
    }

    public void setAdditionalLinkSRLG(String string) {
        this.additionalLinkSRLG = string;
    }

    public int compareTo(Object object) {
        if (object != null && object instanceof ISideModel) {
            ISideModel iSideModel = (ISideModel)object;
            if (this.db.on()) {
                this.db.fine("compareTo: this is " + this);
                this.db.fine("          other is " + iSideModel);
            }
            if (this.sideId == iSideModel.getId()) {
                if (this.lineInIdx == iSideModel.getLineIn()) {
                    if (this.lineOutIdx == iSideModel.getLineOut()) {
                        return 0;
                    }
                    return this.lineOutIdx - iSideModel.getLineOut();
                }
                return this.lineInIdx - iSideModel.getLineIn();
            }
            return this.sideId - iSideModel.getId();
        }
        return 1;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println(this.className + ":: update()  ");
        }
        this.db.fine("update from " + observable + " regarding " + object);
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            SideModels sideModels = SideModels.getInstance(this.nmd);
            switch (n) {
                case 0: {
                    this.setChanged();
                    sideModels.removeSide(this.lineInIdx);
                    this.destroy();
                    break;
                }
                case 1: {
                    this.setChanged();
                    sideModels.updateSide(this.lineInIdx);
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.deleteObserver();
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void updateModel(int n, int n2, int n3, int n4, boolean bl, long l, String string) {
        this.sideId = n;
        this.lineInIdx = n2;
        this.lineOutIdx = n3;
        this.oscIdx = n4;
        this.dcnEnabled = bl;
        this.sideName = DwdmSide.getSideFromOffset(n);
        this.uniqueLinkSRLG = l;
        this.additionalLinkSRLG = string;
    }

    public void updateModel(short s, int n, int n2, boolean bl) {
    }

    public void updateModel(int n, int n2, int n3, int n4, boolean bl) {
    }

    public String toString() {
        String string = "SideId: " + this.sideId + "[" + DwdmSide.getSideFromOffset(this.sideId) + "] SideName: " + this.sideName + " Role: " + this.getRole() + " LineIn: " + Integer.toHexString(this.lineInIdx) + " LineOut: " + Integer.toHexString(this.lineOutIdx) + " Osc: " + Integer.toHexString(this.oscIdx) + " DCNEnabled: " + this.dcnEnabled + "Unique SRLG: " + this.uniqueLinkSRLG + "Additional SRLG: " + this.additionalLinkSRLG;
        return string;
    }
}

