/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Node.General;
import cerent.cms.idl.Node.SnmpMPM;
import cerent.cms.idl.Node.SnmpV3AuthProtocol;
import cerent.cms.idl.Node.SnmpV3PrivProtocol;
import cerent.cms.idl.Node.SnmpV3ProxyType;
import cerent.cms.idl.Node.SnmpV3SecurityLevel;
import cerent.cms.idl.Node.sSnmpOID;
import cerent.cms.idl.Node.sSnmpTrapDestination;
import cerent.cms.idl.Node.sSnmpV3Access;
import cerent.cms.idl.Node.sSnmpV3Engine;
import cerent.cms.idl.Node.sSnmpV3Key;
import cerent.cms.idl.Node.sSnmpV3Notify;
import cerent.cms.idl.Node.sSnmpV3NotifyFilter;
import cerent.cms.idl.Node.sSnmpV3NotifyFilterProfile;
import cerent.cms.idl.Node.sSnmpV3PassKey;
import cerent.cms.idl.Node.sSnmpV3Proxy;
import cerent.cms.idl.Node.sSnmpV3TargetAddress;
import cerent.cms.idl.Node.sSnmpV3TargetParams;
import cerent.cms.idl.Node.sSnmpV3User;
import cerent.cms.idl.Node.sSnmpV3ViewTreeFamily;
import cerent.cms.idl.Node.xConfigError;
import cerent.cms.idl.Node.xDoesNotExist;
import cerent.cms.idl.Node.xMaxSnmpDestinations;
import cerent.cms.idl.Node.xOperationNotSupported;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISnmpModel;
import cerent.cms.model.IorRepository;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.MaxSnmpDestinations;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.SnmpProxyConfigAlreadyExists;
import cerent.cms.model.SnmpV3EngineContainer;
import cerent.cms.model.SnmpV3PassKey;
import cerent.cms.model.SnmpV3ProxyContainer;
import cerent.cms.model.SnmpV3ProxyFwd;
import cerent.cms.model.SnmpV3ProxyTrapFwd;
import cerent.cms.model.SnmpV3ProxyUser;
import cerent.cms.model.SnmpV3Target;
import cerent.cms.model.SnmpV3TargetAddressContainer;
import cerent.cms.model.SnmpV3TargetParamsContainer;
import cerent.cms.model.SnmpV3TrapDestination;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.shelf.snmp.SnmpV3Util;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.SnmpUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class SnmpModel
extends Model
implements ISnmpModel {
    NodeModelDelegate nodeModel;
    private SnmpTrapDestinations snmpTrapDestinations;
    private DeleteSnmpTrapDestination deleteSnmpTrapDestination;
    private SnmpSetEnable snmpSetEnable;
    private SnmpProxyEnable snmpProxyEnable;
    private SnmpV3TargetAddress snmpV3TargetAddress;
    private SnmpV3Access snmpV3Access;
    private SnmpV3NotifyFilter snmpV3NotifyFilter;
    private SnmpV3NotifyFilterProfile snmpV3NotifyFilterProfile;
    private SnmpV3Notify snmpV3Notify;
    private SnmpV3User snmpV3User;
    private SnmpV3Engine snmpV3Engine;
    private SnmpV3TargetParams snmpV3TargetParams;
    private SnmpV3Proxy snmpV3Proxy;
    private SnmpV3ViewTreeFamily snmpV3ViewTreeFamily;
    private UseGenericMib useGenericMib;
    private static ModelSingletonCollection snmpModelSingletons;
    private EventDispatcher dispatcher;
    protected IPlatform pci;
    private static NodeSingletonFactory<SnmpModel> sfactory;

    private SnmpModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(SnmpModel.class));
        this.nodeModel = nodeModelDelegate;
        this.pci = nodeModelDelegate.getPlatform();
        this.index = 0;
        this.snmpTrapDestinations = new SnmpTrapDestinations(nodeModelDelegate, "SnmpModel.snmpTrapDestinations");
        this.deleteSnmpTrapDestination = new DeleteSnmpTrapDestination(nodeModelDelegate, "SnmpModel.deleteSnmpTrapDestination");
        this.snmpSetEnable = new SnmpSetEnable(nodeModelDelegate, "SnmpModel.snmpSetEnable");
        this.snmpProxyEnable = new SnmpProxyEnable(nodeModelDelegate, "SnmpModel.snmpProxyEnable");
        this.useGenericMib = new UseGenericMib(nodeModelDelegate, "SnmpModel.useGenericMib");
        this.snmpV3Access = new SnmpV3Access(nodeModelDelegate, "SnmpModel.snmpV3Access");
        this.snmpV3TargetAddress = new SnmpV3TargetAddress(nodeModelDelegate, "SnmpModel.snmpV3TArgetAddress");
        this.snmpV3NotifyFilter = new SnmpV3NotifyFilter(nodeModelDelegate, "SnmpModel.snmpV3NotifyFilter");
        this.snmpV3NotifyFilterProfile = new SnmpV3NotifyFilterProfile(nodeModelDelegate, "SnmpModel.snmpV3NotifyFilterProfile");
        this.snmpV3Notify = new SnmpV3Notify(nodeModelDelegate, "SnmpModel.snmpV3Notify");
        this.snmpV3User = new SnmpV3User(nodeModelDelegate, "SnmpModel.snmpV3User");
        this.snmpV3Engine = new SnmpV3Engine(nodeModelDelegate, "SnmpModel.snmpV3Engine");
        this.snmpV3TargetParams = new SnmpV3TargetParams(nodeModelDelegate, "SnmpModel.snmpV3TargetParams");
        this.snmpV3ViewTreeFamily = new SnmpV3ViewTreeFamily(nodeModelDelegate, "SnmpModel.snmpV3ViewTreeFamily");
        this.snmpV3Proxy = new SnmpV3Proxy(nodeModelDelegate, "SnmpModel.snmpV3Proxy");
        this.dispatcher = null;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nodeModel;
    }

    public static synchronized SnmpModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    public void init() {
        super.init0();
        if (this.db.on) {
            this.db.println("Enter SsnmpModel init()");
        }
        this.dispatcher = this.nodeModel.getDispatcher();
        this.snmpTrapDestinations.init();
        this.snmpSetEnable.init();
        this.snmpSetEnable.init();
        this.snmpProxyEnable.init();
        this.useGenericMib.init();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSystem, 0, (Observer)this);
        }
    }

    @Override
    public void dispose() {
        if (this.db.on) {
            this.db.println("Enter SsnmpModel init()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSystem, 0, (Observer)this);
        }
        this.snmpTrapDestinations.dispose();
        this.snmpSetEnable.dispose();
        this.snmpSetEnable.dispose();
        this.snmpProxyEnable.dispose();
        this.useGenericMib.dispose();
        this.dispatcher = null;
        super.dispose();
    }

    public List getSnmpTrapDestinations() throws AbstractCmsIOException {
        try {
            return Arrays.asList((sSnmpTrapDestination[])this.snmpTrapDestinations.get());
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpTrapDestinations", userException);
        }
    }

    public sSnmpTrapDestination[] getSnmpTrapDestination() throws AbstractCmsIOException {
        try {
            return (sSnmpTrapDestination[])this.snmpTrapDestinations.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpTrapDestinations", userException);
        }
    }

    public void deleteSnmpTrapDestination(sIpAddr sIpAddr2) throws AbstractCmsIOException {
        try {
            this.snmpTrapDestinations.set(sIpAddr2);
        }
        catch (UserException userException) {
            throw this.doUnknown("deleteSnmpTrapDestination", userException);
        }
    }

    public void setSnmpTrapDestination(sSnmpTrapDestination sSnmpTrapDestination2) throws AbstractCmsIOException, MaxSnmpDestinations, ConfigError, xProvisionError {
        try {
            this.snmpTrapDestinations.set(sSnmpTrapDestination2);
        }
        catch (xMaxSnmpDestinations xMaxSnmpDestinations2) {
            throw new MaxSnmpDestinations((UserException)xMaxSnmpDestinations2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xProvisionError xProvisionError2) {
            throw xProvisionError2;
        }
        catch (UserException userException) {
            throw this.doUnknown("setSnmpTrapDestinations", userException);
        }
    }

    public boolean allowSnmpSets() throws AbstractCmsIOException {
        boolean bl = false;
        try {
            bl = (Boolean)this.snmpSetEnable.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("allowSnmpSets (get)", userException);
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            this.db.fine("NE doesn't support allowSnmpSets operation");
        }
        return bl;
    }

    public void allowSnmpSets(boolean bl) throws AbstractCmsIOException {
        try {
            this.snmpSetEnable.set(new Boolean(bl));
        }
        catch (UserException userException) {
            throw this.doUnknown("allowSnmpSets (set)", userException);
        }
    }

    public boolean allowSnmpProxy() {
        try {
            return (Boolean)this.snmpProxyEnable.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("allowSnmpProxy (get)", userException);
        }
    }

    public void allowSnmpProxy(boolean bl) {
        try {
            this.snmpProxyEnable.set(new Boolean(bl));
        }
        catch (UserException userException) {
            throw this.doUnknown("allowSnmpProxy (set)", userException);
        }
    }

    public boolean getGenericMib() {
        if (!this.pci.is454() && !this.pci.is455()) {
            return true;
        }
        try {
            return (Boolean)this.useGenericMib.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("useGenericMib (get)", userException);
        }
    }

    public void setGenericMib(boolean bl) throws UnsupportedOperation {
        if (!this.pci.is454() && !this.pci.is455()) {
            return;
        }
        try {
            this.useGenericMib.set(new Boolean(bl));
        }
        catch (xOperationNotSupported xOperationNotSupported2) {
            throw new UnsupportedOperation((UserException)xOperationNotSupported2);
        }
        catch (UserException userException) {
            throw this.doUnknown("useGenericMib (set)", userException);
        }
    }

    public sSnmpV3User[] getSnmpV3User() {
        try {
            return (sSnmpV3User[])this.snmpV3User.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpUser", userException);
        }
    }

    public void deleteSnmpV3User(String string, sSnmpV3Engine sSnmpV3Engine2) {
        Object[] objectArray = new Object[]{string, sSnmpV3Engine2};
        try {
            this.snmpV3User.set(objectArray);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpUser", userException);
        }
    }

    public void setSnmpV3User(sSnmpV3User sSnmpV3User2) {
        try {
            this.snmpV3User.set(sSnmpV3User2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpUser", userException);
        }
    }

    public void setSnmpV3User(sSnmpV3Engine sSnmpV3Engine2, SnmpV3AuthProtocol snmpV3AuthProtocol, String string, String string2, SnmpV3PrivProtocol snmpV3PrivProtocol, String string3, String string4) {
        sSnmpV3User sSnmpV3User2 = new sSnmpV3User();
        sSnmpV3User2.engine = sSnmpV3Engine2;
        sSnmpV3User2.authProtocol = snmpV3AuthProtocol;
        sSnmpV3User2.authKey = this.getPassKey(string);
        sSnmpV3User2.group = string2;
        sSnmpV3User2.privKey = this.getPassKey(string3);
        sSnmpV3User2.privProtocol = snmpV3PrivProtocol;
        sSnmpV3User2.username = string4;
        try {
            this.snmpV3User.set(sSnmpV3User2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpUser", userException);
        }
    }

    private sSnmpV3PassKey getPassKey(String string) {
        sSnmpV3PassKey sSnmpV3PassKey2 = new sSnmpV3PassKey();
        sSnmpV3PassKey2.password = string;
        sSnmpV3PassKey2.regenerateKey = true;
        sSnmpV3PassKey2.key = new sSnmpV3Key();
        sSnmpV3PassKey2.key.key = new byte[20];
        sSnmpV3PassKey2.key.keylen = 0;
        return sSnmpV3PassKey2;
    }

    public SnmpV3ProxyUser[] getSnmpV3UserWrapper() {
        sSnmpV3User[] sSnmpV3UserArray = this.getSnmpV3User();
        SnmpV3ProxyUser[] snmpV3ProxyUserArray = new SnmpV3ProxyUser[sSnmpV3UserArray.length];
        for (int i = 0; i < sSnmpV3UserArray.length; ++i) {
            snmpV3ProxyUserArray[i] = new SnmpV3ProxyUser(new SnmpV3PassKey(sSnmpV3UserArray[i].authKey.key.key, sSnmpV3UserArray[i].authKey.key.keylen, sSnmpV3UserArray[i].authKey.password, sSnmpV3UserArray[i].authKey.regenerateKey), sSnmpV3UserArray[i].authProtocol.value(), sSnmpV3UserArray[i].group, new SnmpV3PassKey(sSnmpV3UserArray[i].privKey.key.key, sSnmpV3UserArray[i].privKey.key.keylen, sSnmpV3UserArray[i].privKey.password, sSnmpV3UserArray[i].privKey.regenerateKey), sSnmpV3UserArray[i].privProtocol.value(), sSnmpV3UserArray[i].username, new SnmpV3EngineContainer(sSnmpV3UserArray[i].engine.engineid, sSnmpV3UserArray[i].engine.engineidlen, sSnmpV3UserArray[i].engine.boots));
        }
        return snmpV3ProxyUserArray;
    }

    public void setSnmpV3UserWrapper(Object object) {
        if (object instanceof SnmpV3ProxyUser) {
            SnmpV3ProxyUser snmpV3ProxyUser = (SnmpV3ProxyUser)object;
            sSnmpV3User sSnmpV3User2 = new sSnmpV3User();
            sSnmpV3PassKey sSnmpV3PassKey2 = new sSnmpV3PassKey();
            sSnmpV3PassKey sSnmpV3PassKey3 = new sSnmpV3PassKey();
            sSnmpV3Key sSnmpV3Key2 = new sSnmpV3Key();
            sSnmpV3Key sSnmpV3Key3 = new sSnmpV3Key();
            sSnmpV3Engine sSnmpV3Engine2 = new sSnmpV3Engine();
            sSnmpV3Engine2.boots = snmpV3ProxyUser.getEngine().getEngineBoots();
            sSnmpV3Engine2.engineid = snmpV3ProxyUser.getEngine().getContextEngID();
            sSnmpV3Engine2.engineidlen = snmpV3ProxyUser.getEngine().getContextEngIDLength();
            sSnmpV3User2.engine = sSnmpV3Engine2;
            sSnmpV3User2.authProtocol = SnmpV3AuthProtocol.from_int(snmpV3ProxyUser.getauthProtocol());
            sSnmpV3User2.privProtocol = SnmpV3PrivProtocol.from_int(snmpV3ProxyUser.getprivProtocol());
            sSnmpV3User2.group = snmpV3ProxyUser.getGroup();
            sSnmpV3User2.username = snmpV3ProxyUser.getuserName();
            sSnmpV3Key2.key = snmpV3ProxyUser.getAuthKey().getKey();
            sSnmpV3Key2.keylen = snmpV3ProxyUser.getAuthKey().getKeyLen();
            sSnmpV3PassKey2.key = sSnmpV3Key2;
            sSnmpV3PassKey2.password = snmpV3ProxyUser.getAuthKey().getPwd();
            sSnmpV3PassKey2.regenerateKey = snmpV3ProxyUser.getAuthKey().getRegenKey();
            sSnmpV3User2.authKey = sSnmpV3PassKey2;
            sSnmpV3Key3.key = snmpV3ProxyUser.getPrivKey().getKey();
            sSnmpV3Key3.keylen = snmpV3ProxyUser.getPrivKey().getKeyLen();
            sSnmpV3PassKey3.key = sSnmpV3Key3;
            sSnmpV3PassKey3.password = snmpV3ProxyUser.getPrivKey().getPwd();
            sSnmpV3PassKey3.regenerateKey = snmpV3ProxyUser.getPrivKey().getRegenKey();
            sSnmpV3User2.privKey = sSnmpV3PassKey3;
            this.setSnmpV3User(sSnmpV3User2);
        } else {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = (Object[])object;
            objectArray[0] = (String)objectArray2[0];
            SnmpV3EngineContainer snmpV3EngineContainer = (SnmpV3EngineContainer)objectArray2[1];
            sSnmpV3Engine sSnmpV3Engine3 = new sSnmpV3Engine();
            sSnmpV3Engine3.boots = snmpV3EngineContainer.getEngineBoots();
            sSnmpV3Engine3.engineid = snmpV3EngineContainer.getContextEngID();
            sSnmpV3Engine3.engineidlen = snmpV3EngineContainer.getContextEngIDLength();
            objectArray[1] = sSnmpV3Engine3;
            this.deleteSnmpV3User((String)objectArray2[0], sSnmpV3Engine3);
        }
    }

    public sSnmpV3Engine getSnmpV3Engine() {
        try {
            return (sSnmpV3Engine)this.snmpV3Engine.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpV3Engine", userException);
        }
    }

    public SnmpV3EngineContainer getSnmpV3EngineWrapper() {
        sSnmpV3Engine sSnmpV3Engine2 = this.getSnmpV3Engine();
        SnmpV3EngineContainer snmpV3EngineContainer = new SnmpV3EngineContainer(sSnmpV3Engine2.engineid, sSnmpV3Engine2.engineidlen, sSnmpV3Engine2.boots);
        return snmpV3EngineContainer;
    }

    public String[] getSnmpV3GroupList() {
        sSnmpV3User[] sSnmpV3UserArray = this.getSnmpV3User();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < sSnmpV3UserArray.length; ++i) {
            hashSet.add(sSnmpV3UserArray[i].group);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public String[] getSnmpV3UserList() {
        sSnmpV3User[] sSnmpV3UserArray = this.getSnmpV3User();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < sSnmpV3UserArray.length; ++i) {
            hashSet.add(sSnmpV3UserArray[i].username);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public sSnmpV3TargetAddress[] getSnmpV3TargetAddress() {
        try {
            return (sSnmpV3TargetAddress[])this.snmpV3TargetAddress.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpV3TArgetAddress", userException);
        }
    }

    public void deleteSnmpV3TargetAddress(String string) {
        try {
            this.snmpV3TargetAddress.set(string);
        }
        catch (UserException userException) {
            throw this.doUnknown("deleteSnmpV3TargetAddress", userException);
        }
    }

    public void setSnmpV3TargetAddress(sSnmpV3TargetAddress sSnmpV3TargetAddress2) {
        try {
            this.snmpV3TargetAddress.set(sSnmpV3TargetAddress2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSnmpV3TargteAddress", userException);
        }
    }

    public void setSnmpV3TrapDestination(String string, SnmpV3SecurityLevel snmpV3SecurityLevel, sIpAddr sIpAddr2, int n, String string2, String string3, boolean bl) {
        String string4 = this.getRowName();
        SnmpV3Target snmpV3Target = this.getSnmpV3Target(string, snmpV3SecurityLevel, sIpAddr2);
        if (snmpV3Target == null) {
            sSnmpV3TargetParams sSnmpV3TargetParams2 = new sSnmpV3TargetParams();
            sSnmpV3TargetParams2.name = string4;
            sSnmpV3TargetParams2.model = SnmpMPM.SNMPV3;
            sSnmpV3TargetParams2.username = string;
            sSnmpV3TargetParams2.securityLevel = snmpV3SecurityLevel;
            this.setSnmpV3TargetParams(sSnmpV3TargetParams2);
            sSnmpV3TargetAddress sSnmpV3TargetAddress2 = new sSnmpV3TargetAddress();
            sSnmpV3TargetAddress2.targetName = string4;
            sSnmpV3TargetAddress2.ipAddress = sIpAddr2;
            sSnmpV3TargetAddress2.udpSocketNumber = (short)n;
            sSnmpV3TargetAddress2.timeout = SnmpV3Util.TIMEOUT_DEFVAL;
            sSnmpV3TargetAddress2.retryCount = SnmpV3Util.RETRY_COUNT_DEFVAL;
            sSnmpV3TargetAddress2.tagList = this.getProxyTag(bl) + " " + string2;
            sSnmpV3TargetAddress2.targetAddrParams = string4;
            this.setSnmpV3TargetAddress(sSnmpV3TargetAddress2);
            if (string3.length() > 0) {
                sSnmpV3NotifyFilterProfile sSnmpV3NotifyFilterProfile2 = new sSnmpV3NotifyFilterProfile();
                sSnmpV3NotifyFilterProfile2.profileName = string3;
                sSnmpV3NotifyFilterProfile2.targetParamsName = string4;
                this.setSnmpV3NotifyFilterProfile(sSnmpV3NotifyFilterProfile2);
            }
        } else {
            snmpV3Target.sTargetAddress.udpSocketNumber = (short)n;
            snmpV3Target.sTargetAddress.tagList = this.getProxyTag(bl) + " " + string2;
            this.setSnmpV3TargetAddress(snmpV3Target.sTargetAddress);
            if (string3.length() > 0) {
                if (snmpV3Target.sFilterProfile != null) {
                    snmpV3Target.sFilterProfile.profileName = string3;
                    this.setSnmpV3NotifyFilterProfile(snmpV3Target.sFilterProfile);
                } else {
                    snmpV3Target.sFilterProfile = new sSnmpV3NotifyFilterProfile();
                    snmpV3Target.sFilterProfile.targetParamsName = snmpV3Target.sParams.name;
                    snmpV3Target.sFilterProfile.profileName = string3;
                    this.setSnmpV3NotifyFilterProfile(snmpV3Target.sFilterProfile);
                }
            } else if (snmpV3Target.sFilterProfile != null) {
                this.deleteSnmpV3NotifyFilterProfile(snmpV3Target.sFilterProfile.targetParamsName);
            }
        }
    }

    protected String getProxyTag(boolean bl) {
        if (!bl) {
            return "_targetTag__";
        }
        return "";
    }

    protected String getRowName() {
        String string = "p" + Long.toString(System.currentTimeMillis());
        return string;
    }

    private SnmpV3Target getSnmpV3Target(String string, SnmpV3SecurityLevel snmpV3SecurityLevel, sIpAddr sIpAddr2) {
        SnmpV3Target[] snmpV3TargetArray = this.getSnmpV3TargetList();
        if (snmpV3TargetArray != null) {
            for (int i = 0; i < snmpV3TargetArray.length; ++i) {
                SnmpV3Target snmpV3Target = snmpV3TargetArray[i];
                if (!Arrays.equals(snmpV3Target.sTargetAddress.ipAddress.addr, sIpAddr2.addr) || snmpV3Target.sParams.securityLevel != snmpV3SecurityLevel || !snmpV3Target.sParams.username.equals(string)) continue;
                return snmpV3Target;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSnmpV3TrapDestination(String string, SnmpV3SecurityLevel snmpV3SecurityLevel, sIpAddr sIpAddr2) {
        SnmpV3Target snmpV3Target;
        SnmpV3Target snmpV3Target2 = snmpV3Target = this.getSnmpV3Target(string, snmpV3SecurityLevel, sIpAddr2);
        synchronized (snmpV3Target2) {
            if (snmpV3Target.sParams != null) {
                this.deleteSnmpV3TargetParams(snmpV3Target.sParams.name);
            }
            if (snmpV3Target.sTargetAddress != null) {
                this.deleteSnmpV3TargetAddress(snmpV3Target.sTargetAddress.targetName);
            }
            if (snmpV3Target.sFilterProfile != null) {
                this.deleteSnmpV3NotifyFilterProfile(snmpV3Target.sFilterProfile.targetParamsName);
            }
        }
    }

    private SnmpV3Target[] getSnmpV3TargetList() {
        Object[] objectArray;
        ArrayList<SnmpV3Target> arrayList = new ArrayList<SnmpV3Target>();
        try {
            objectArray = this.getSnmpV3TargetParams();
            sSnmpV3TargetAddress[] sSnmpV3TargetAddressArray = this.getSnmpV3TargetAddress();
            sSnmpV3NotifyFilterProfile[] sSnmpV3NotifyFilterProfileArray = this.getSnmpV3NotifyFilterProfile();
            for (int i = 0; i < sSnmpV3TargetAddressArray.length; ++i) {
                int n;
                SnmpV3Target snmpV3Target = new SnmpV3Target();
                if (!sSnmpV3TargetAddressArray[i].targetName.startsWith("p")) continue;
                snmpV3Target.sTargetAddress = sSnmpV3TargetAddressArray[i];
                for (n = 0; n < objectArray.length; ++n) {
                    if (!sSnmpV3TargetAddressArray[i].targetAddrParams.equalsIgnoreCase(((sSnmpV3TargetParams)objectArray[n]).name)) continue;
                    snmpV3Target.sParams = objectArray[n];
                }
                for (n = 0; n < sSnmpV3NotifyFilterProfileArray.length; ++n) {
                    if (!sSnmpV3TargetAddressArray[i].targetAddrParams.equalsIgnoreCase(sSnmpV3NotifyFilterProfileArray[n].targetParamsName)) continue;
                    snmpV3Target.sFilterProfile = sSnmpV3NotifyFilterProfileArray[n];
                }
                if (null == snmpV3Target.sTargetAddress || null == snmpV3Target.sParams) continue;
                arrayList.add(snmpV3Target);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.db.println("Error in getting SnmpV3 Trap Params: " + exception);
        }
        objectArray = arrayList.toArray(new SnmpV3Target[arrayList.size()]);
        return objectArray;
    }

    public SnmpV3TrapDestination[] getSnmpV3TrapDestination() {
        SnmpV3Target[] snmpV3TargetArray = this.getSnmpV3TargetList();
        SnmpV3TrapDestination[] snmpV3TrapDestinationArray = new SnmpV3TrapDestination[snmpV3TargetArray.length];
        for (int i = 0; i < snmpV3TargetArray.length; ++i) {
            SnmpV3Target snmpV3Target = snmpV3TargetArray[i];
            String string = "";
            if (snmpV3Target.sFilterProfile != null) {
                string = snmpV3Target.sFilterProfile.profileName;
            }
            String string2 = snmpV3Target.sTargetAddress.tagList;
            String string3 = "_targetTag__";
            boolean bl = false;
            if (string2.contains(string3.subSequence(0, string3.length()))) {
                bl = false;
                string2 = string2.substring(string3.length(), string2.length());
            } else {
                bl = true;
            }
            snmpV3TrapDestinationArray[i] = new SnmpV3TrapDestination(snmpV3Target.sParams.username, snmpV3Target.sParams.securityLevel, snmpV3Target.sTargetAddress.ipAddress, snmpV3Target.sTargetAddress.udpSocketNumber, string2, string, bl);
        }
        return snmpV3TrapDestinationArray;
    }

    public void setSnmpV3TargetAddressWrapper(Object object) {
        if (object instanceof SnmpV3TargetAddressContainer) {
            SnmpV3TargetAddressContainer snmpV3TargetAddressContainer = (SnmpV3TargetAddressContainer)object;
            sSnmpV3TargetAddress sSnmpV3TargetAddress2 = new sSnmpV3TargetAddress();
            sSnmpV3TargetAddress2.ipAddress = IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(snmpV3TargetAddressContainer.getipAddress()));
            sSnmpV3TargetAddress2.retryCount = snmpV3TargetAddressContainer.getretryCount();
            sSnmpV3TargetAddress2.timeout = snmpV3TargetAddressContainer.gettimeout();
            sSnmpV3TargetAddress2.tagList = snmpV3TargetAddressContainer.gettagList();
            sSnmpV3TargetAddress2.udpSocketNumber = snmpV3TargetAddressContainer.getudpSocketNumber();
            sSnmpV3TargetAddress2.targetAddrParams = snmpV3TargetAddressContainer.gettargetAddrParams();
            sSnmpV3TargetAddress2.targetName = snmpV3TargetAddressContainer.gettargetName();
            this.setSnmpV3TargetAddress(sSnmpV3TargetAddress2);
        } else {
            this.setSnmpV3TargetAddress((sSnmpV3TargetAddress)object);
        }
    }

    public SnmpV3TargetAddressContainer[] getSnmpV3TargetAddressWrapper() {
        sSnmpV3TargetAddress[] sSnmpV3TargetAddressArray = this.getSnmpV3TargetAddress();
        SnmpV3TargetAddressContainer[] snmpV3TargetAddressContainerArray = new SnmpV3TargetAddressContainer[sSnmpV3TargetAddressArray.length];
        for (int i = 0; i < sSnmpV3TargetAddressArray.length; ++i) {
            snmpV3TargetAddressContainerArray[i] = new SnmpV3TargetAddressContainer(sSnmpV3TargetAddressArray[i].targetName, InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sSnmpV3TargetAddressArray[i].ipAddress)), sSnmpV3TargetAddressArray[i].udpSocketNumber, sSnmpV3TargetAddressArray[i].timeout, sSnmpV3TargetAddressArray[i].retryCount, sSnmpV3TargetAddressArray[i].tagList, sSnmpV3TargetAddressArray[i].targetAddrParams);
        }
        return snmpV3TargetAddressContainerArray;
    }

    public sSnmpV3Proxy[] getSnmpV3Proxy() {
        try {
            return (sSnmpV3Proxy[])this.snmpV3Proxy.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpV3Proxy", userException);
        }
    }

    public void deleteSnmpV3Proxy(String string) {
        try {
            this.snmpV3Proxy.set(string);
        }
        catch (UserException userException) {
            throw this.doUnknown("deleteSnmpV3Proxy", userException);
        }
    }

    public void setSnmpV3Proxy(sSnmpV3Proxy sSnmpV3Proxy2) {
        try {
            this.snmpV3Proxy.set(sSnmpV3Proxy2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSnmpV3Proxy", userException);
        }
    }

    public void setSnmpV3ProxyWrapper(Object object) {
        if (object instanceof SnmpV3ProxyContainer) {
            SnmpV3ProxyContainer snmpV3ProxyContainer = (SnmpV3ProxyContainer)object;
            sSnmpV3Proxy sSnmpV3Proxy2 = new sSnmpV3Proxy();
            sSnmpV3Proxy2.contextEngineid = snmpV3ProxyContainer.getcontextEngID();
            sSnmpV3Proxy2.contextEngineidlen = snmpV3ProxyContainer.getcontextEngIDLength();
            sSnmpV3Proxy2.context_name = snmpV3ProxyContainer.getcontextName();
            sSnmpV3Proxy2.multiple_target_out = snmpV3ProxyContainer.getmultipleTargetOut();
            sSnmpV3Proxy2.proxy_name = snmpV3ProxyContainer.getproxyName();
            sSnmpV3Proxy2.proxy_type = SnmpV3ProxyType.from_int(snmpV3ProxyContainer.getproxyType());
            sSnmpV3Proxy2.single_target_out = snmpV3ProxyContainer.getsingleTargetOut();
            sSnmpV3Proxy2.target_params_in = snmpV3ProxyContainer.gettargetParamsIn();
            this.setSnmpV3Proxy(sSnmpV3Proxy2);
        } else {
            this.deleteSnmpV3Proxy((String)object);
        }
    }

    public SnmpV3ProxyContainer[] getSnmpV3ProxyListWrapper() {
        sSnmpV3Proxy[] sSnmpV3ProxyArray = this.getSnmpV3Proxy();
        SnmpV3ProxyContainer[] snmpV3ProxyContainerArray = new SnmpV3ProxyContainer[sSnmpV3ProxyArray.length];
        for (int i = 0; i < sSnmpV3ProxyArray.length; ++i) {
            snmpV3ProxyContainerArray[i] = new SnmpV3ProxyContainer(sSnmpV3ProxyArray[i].proxy_name, sSnmpV3ProxyArray[i].contextEngineid, sSnmpV3ProxyArray[i].contextEngineidlen, sSnmpV3ProxyArray[i].context_name, sSnmpV3ProxyArray[i].target_params_in, sSnmpV3ProxyArray[i].single_target_out, sSnmpV3ProxyArray[i].multiple_target_out, sSnmpV3ProxyArray[i].proxy_type.value());
        }
        return snmpV3ProxyContainerArray;
    }

    public ArrayList getSnmpV3ProxyFwd() {
        sSnmpV3Proxy[] sSnmpV3ProxyArray = this.getSnmpV3Proxy();
        ArrayList<SnmpV3ProxyFwd> arrayList = new ArrayList<SnmpV3ProxyFwd>();
        for (int i = 0; i < sSnmpV3ProxyArray.length; ++i) {
            if (sSnmpV3ProxyArray[i].proxy_type.value() != SnmpUtil._ProxyType_Read && sSnmpV3ProxyArray[i].proxy_type.value() != SnmpUtil._ProxyType_Write) continue;
            String string = this.getValueFromTargetAddress(1, sSnmpV3ProxyArray[i].single_target_out);
            String string2 = this.getValueFromTargetParams(2, sSnmpV3ProxyArray[i].target_params_in);
            String string3 = this.getRemoteUserDetailFromTargetParams(2, sSnmpV3ProxyArray[i].single_target_out);
            String string4 = this.getRemoteUserDetailFromTargetParams(3, sSnmpV3ProxyArray[i].single_target_out);
            String string5 = null;
            string5 = sSnmpV3ProxyArray[i].proxy_type.value() == SnmpUtil._ProxyType_Read ? "READ" : "WRITE";
            String string6 = this.getValueFromTargetParams(3, sSnmpV3ProxyArray[i].target_params_in);
            SnmpV3ProxyFwd snmpV3ProxyFwd = new SnmpV3ProxyFwd(sSnmpV3ProxyArray[i].proxy_name, SnmpUtil.toStringEngineID(sSnmpV3ProxyArray[i].contextEngineid, sSnmpV3ProxyArray[i].contextEngineidlen), string, string2, string6, string3, string4, string5);
            arrayList.add(snmpV3ProxyFwd);
        }
        return arrayList;
    }

    public ArrayList getSnmpV3ProxyTrapFwd() {
        sSnmpV3Proxy[] sSnmpV3ProxyArray = this.getSnmpV3Proxy();
        ArrayList<SnmpV3ProxyTrapFwd> arrayList = new ArrayList<SnmpV3ProxyTrapFwd>();
        for (int i = 0; i < sSnmpV3ProxyArray.length; ++i) {
            if (sSnmpV3ProxyArray[i].proxy_type.value() != SnmpUtil._ProxyType_Trap) continue;
            String string = this.getValueFromTargetParams(2, sSnmpV3ProxyArray[i].target_params_in);
            String string2 = this.getValueFromTargetParams(3, sSnmpV3ProxyArray[i].target_params_in);
            SnmpV3ProxyTrapFwd snmpV3ProxyTrapFwd = new SnmpV3ProxyTrapFwd(sSnmpV3ProxyArray[i].proxy_name, SnmpUtil.toStringEngineID(sSnmpV3ProxyArray[i].contextEngineid, sSnmpV3ProxyArray[i].contextEngineidlen), sSnmpV3ProxyArray[i].multiple_target_out, string, string2);
            arrayList.add(snmpV3ProxyTrapFwd);
        }
        return arrayList;
    }

    public void setProxyFwd(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SnmpProxyConfigAlreadyExists {
        Object object;
        ArrayList arrayList = this.getSnmpV3ProxyFwd();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (SnmpV3ProxyFwd)arrayList.get(i);
            if (string.compareTo(((SnmpV3ProxyFwd)object).contextEngID) != 0 || string2.compareTo(((SnmpV3ProxyFwd)object).targetIP) != 0 || string3.compareTo(((SnmpV3ProxyFwd)object).localUser) != 0 || string4.compareTo(SnmpUtil.getSecLevelStdString(((SnmpV3ProxyFwd)object).localUserSecLevel)) != 0 || string5.compareTo(((SnmpV3ProxyFwd)object).remoteUser) != 0 || string6.compareTo(((SnmpV3ProxyFwd)object).remoteUserSecLevel) != 0 || string7.compareTo(((SnmpV3ProxyFwd)object).proxyType) != 0) continue;
            throw new SnmpProxyConfigAlreadyExists("SNMPv3 Proxy configuration already exists");
        }
        try {
            String string8;
            String string9;
            SnmpV3TargetParamsContainer snmpV3TargetParamsContainer = this.checkIfTargetParamExists(string3, SnmpUtil.getSecurityLevel(string4), 3);
            if (null == snmpV3TargetParamsContainer) {
                object = Long.toString(System.currentTimeMillis());
                snmpV3TargetParamsContainer = new SnmpV3TargetParamsContainer((String)object, 3, string3, SnmpUtil.getSecurityLevel(string4));
                this.setSnmpV3TargetParamsWrapper(snmpV3TargetParamsContainer);
            }
            object = SnmpUtil.getEngineIDPadded(string);
            byte[] byArray = SnmpUtil.toBytesEngineID((String)object, ((String)object).length());
            SnmpV3TargetParamsContainer snmpV3TargetParamsContainer2 = this.checkIfTargetParamExists(string5, SnmpUtil.getSecurityLevel(string6), 3);
            if (null == snmpV3TargetParamsContainer2) {
                string9 = Long.toString(System.currentTimeMillis() + 2L);
                snmpV3TargetParamsContainer2 = new SnmpV3TargetParamsContainer(string9, 3, string5, SnmpUtil.getSecurityLevel(string6));
                this.setSnmpV3TargetParamsWrapper(snmpV3TargetParamsContainer2);
            }
            if (null == (string9 = this.checkIfTargetAddressExists(string2, 161, 10000, 10, "", snmpV3TargetParamsContainer2.getparamsName()))) {
                string8 = Long.toString(System.currentTimeMillis() + 3L);
                string9 = new SnmpV3TargetAddressContainer(string8, string2, 161, 10000, 10, "", snmpV3TargetParamsContainer2.getparamsName());
                this.setSnmpV3TargetAddressWrapper(string9);
            }
            string8 = Long.toString(System.currentTimeMillis() + 4L);
            SnmpV3ProxyContainer snmpV3ProxyContainer = new SnmpV3ProxyContainer(string8, byArray, ((String)object).length() / 2, "", snmpV3TargetParamsContainer.getparamsName(), string9.gettargetName(), "", SnmpUtil.getProxyType(string7));
            this.setSnmpV3ProxyWrapper(snmpV3ProxyContainer);
            Thread.currentThread();
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            SDebug.printStackTrace((Throwable)interruptedException);
            this.db.println("Error while setting Proxy configuration .... delay interrupted");
        }
    }

    public void setProxyTrapFwd(String string, String string2, String string3, String string4) throws SnmpProxyConfigAlreadyExists {
        String string5;
        Object object;
        ArrayList arrayList = this.getSnmpV3ProxyTrapFwd();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (SnmpV3ProxyTrapFwd)arrayList.get(i);
            if (string.compareTo(object.contextEngID) != 0 || string2.compareTo(object.targetTag) != 0 || string3.compareTo(object.incomingUser) != 0 || string4.compareTo(SnmpUtil.getSecLevelStdString(object.secLevel)) != 0) continue;
            throw new SnmpProxyConfigAlreadyExists("SNMPv3 Proxy configuration already exists");
        }
        String string6 = SnmpUtil.getEngineIDPadded(string);
        object = SnmpUtil.toBytesEngineID(string6, string6.length());
        SnmpV3TargetParamsContainer snmpV3TargetParamsContainer = this.checkIfTargetParamExists(string3, SnmpUtil.getSecurityLevel(string4), 3);
        if (null == snmpV3TargetParamsContainer) {
            string5 = Long.toString(System.currentTimeMillis());
            snmpV3TargetParamsContainer = new SnmpV3TargetParamsContainer(string5, 3, string3, SnmpUtil.getSecurityLevel(string4));
            this.setSnmpV3TargetParamsWrapper(snmpV3TargetParamsContainer);
        }
        string5 = Long.toString(System.currentTimeMillis() + 1L);
        SnmpV3ProxyContainer snmpV3ProxyContainer = new SnmpV3ProxyContainer(string5, (byte[])object, string6.length() / 2, "", snmpV3TargetParamsContainer.getparamsName(), "", string2, SnmpUtil._ProxyType_Trap);
        this.setSnmpV3ProxyWrapper(snmpV3ProxyContainer);
    }

    public SnmpV3ProxyUser checkIfUserExists(String string) {
        block3: {
            try {
                SnmpV3ProxyUser[] snmpV3ProxyUserArray;
                for (SnmpV3ProxyUser snmpV3ProxyUser : snmpV3ProxyUserArray = this.getSnmpV3UserWrapper()) {
                    if (!snmpV3ProxyUser.getuserName().equals(string)) continue;
                    return snmpV3ProxyUser;
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
                this.db.println("Error while fetching SNMPv3 users");
            }
        }
        return null;
    }

    public SnmpV3TargetParamsContainer checkIfTargetParamExists(String string, int n, int n2) {
        block3: {
            try {
                SnmpV3TargetParamsContainer[] snmpV3TargetParamsContainerArray = this.getSnmpV3TargetParamsWrapper();
                for (int i = 0; i < snmpV3TargetParamsContainerArray.length; ++i) {
                    if (!snmpV3TargetParamsContainerArray[i].getuserName().equals(string) || snmpV3TargetParamsContainerArray[i].getSecurityLevel() != n || snmpV3TargetParamsContainerArray[i].getMpm() != n2) continue;
                    return snmpV3TargetParamsContainerArray[i];
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
                this.db.println("Error while fetching SNMPv3 Target Params data");
            }
        }
        return null;
    }

    public SnmpV3TargetAddressContainer checkIfTargetAddressExists(String string, int n, int n2, int n3, String string2, String string3) {
        block3: {
            try {
                SnmpV3TargetAddressContainer[] snmpV3TargetAddressContainerArray = this.getSnmpV3TargetAddressWrapper();
                for (int i = 0; i < snmpV3TargetAddressContainerArray.length; ++i) {
                    if (!snmpV3TargetAddressContainerArray[i].getipAddress().equals(string) || snmpV3TargetAddressContainerArray[i].getudpSocketNumber() != 161 || snmpV3TargetAddressContainerArray[i].gettimeout() != 10000 || snmpV3TargetAddressContainerArray[i].getretryCount() != 10 || !snmpV3TargetAddressContainerArray[i].gettagList().equals(string2) || !snmpV3TargetAddressContainerArray[i].gettargetAddrParams().equals(string3)) continue;
                    return snmpV3TargetAddressContainerArray[i];
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
                this.db.println("Error while fetching SNMPv3 Target Address data");
            }
        }
        return null;
    }

    private String getRemoteUserDetailFromTargetParams(int n, String string) {
        block6: {
            String string2 = null;
            try {
                SnmpV3TargetAddressContainer[] snmpV3TargetAddressContainerArray = this.getSnmpV3TargetAddressWrapper();
                for (int i = 0; i < snmpV3TargetAddressContainerArray.length; ++i) {
                    if (!snmpV3TargetAddressContainerArray[i].gettargetName().equals(string)) continue;
                    string2 = snmpV3TargetAddressContainerArray[i].gettargetAddrParams();
                    break;
                }
                if (string2 != null) {
                    SnmpV3TargetParamsContainer[] snmpV3TargetParamsContainerArray = this.getSnmpV3TargetParamsWrapper();
                    for (int i = 0; i < snmpV3TargetParamsContainerArray.length; ++i) {
                        if (!snmpV3TargetParamsContainerArray[i].getparamsName().equals(string2)) continue;
                        if (2 == n) {
                            return snmpV3TargetParamsContainerArray[i].getuserName();
                        }
                        if (3 != n) continue;
                        return SnmpUtil.securityLevel[snmpV3TargetParamsContainerArray[i].getSecurityLevel()].getKey();
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block6;
                SDebug.printStackTrace((Throwable)exception);
                this.db.println("Error while fetching SNMPv3 Target Address data");
            }
        }
        return null;
    }

    private String getValueFromTargetParams(int n, String string) {
        block7: {
            try {
                SnmpV3TargetParamsContainer[] snmpV3TargetParamsContainerArray = this.getSnmpV3TargetParamsWrapper();
                for (int i = 0; i < snmpV3TargetParamsContainerArray.length; ++i) {
                    if (!snmpV3TargetParamsContainerArray[i].getparamsName().equals(string)) continue;
                    switch (n) {
                        case 2: {
                            return snmpV3TargetParamsContainerArray[i].getuserName();
                        }
                        case 3: {
                            return SnmpUtil.securityLevel[snmpV3TargetParamsContainerArray[i].getSecurityLevel()].getKey();
                        }
                    }
                    return null;
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block7;
                SDebug.printStackTrace((Throwable)exception);
                this.db.println("Error while fetching SNMPv3 Target Params data");
            }
        }
        return null;
    }

    private String getValueFromTargetAddress(int n, String string) {
        block7: {
            try {
                SnmpV3TargetAddressContainer[] snmpV3TargetAddressContainerArray = this.getSnmpV3TargetAddressWrapper();
                for (int i = 0; i < snmpV3TargetAddressContainerArray.length; ++i) {
                    if (!snmpV3TargetAddressContainerArray[i].gettargetName().equals(string)) continue;
                    switch (n) {
                        case 1: {
                            return snmpV3TargetAddressContainerArray[i].getipAddress();
                        }
                        case 5: {
                            return snmpV3TargetAddressContainerArray[i].gettagList();
                        }
                    }
                    return null;
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block7;
                SDebug.printStackTrace((Throwable)exception);
                this.db.println("Error while fetching SNMPv3 Target Address data");
            }
        }
        return null;
    }

    public sSnmpV3TargetParams[] getSnmpV3TargetParams() {
        try {
            return (sSnmpV3TargetParams[])this.snmpV3TargetParams.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpV3TArgetParams", userException);
        }
    }

    public void deleteSnmpV3TargetParams(String string) {
        try {
            this.snmpV3TargetParams.set(string);
        }
        catch (UserException userException) {
            throw this.doUnknown("deleteSnmpV3TargetParams", userException);
        }
    }

    public String[] getSnmpV3Params() {
        sSnmpV3TargetParams[] sSnmpV3TargetParamsArray = this.getSnmpV3TargetParams();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < sSnmpV3TargetParamsArray.length; ++i) {
            hashSet.add(sSnmpV3TargetParamsArray[i].name);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void setSnmpV3TargetParams(sSnmpV3TargetParams sSnmpV3TargetParams2) {
        try {
            this.snmpV3TargetParams.set(sSnmpV3TargetParams2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSnmpV3TargteParams", userException);
        }
    }

    public void setSnmpV3TargetParamsWrapper(Object object) {
        if (object instanceof SnmpV3TargetParamsContainer) {
            SnmpV3TargetParamsContainer snmpV3TargetParamsContainer = (SnmpV3TargetParamsContainer)object;
            sSnmpV3TargetParams sSnmpV3TargetParams2 = new sSnmpV3TargetParams();
            sSnmpV3TargetParams2.model = SnmpMPM.from_int(snmpV3TargetParamsContainer.getMpm());
            sSnmpV3TargetParams2.name = snmpV3TargetParamsContainer.getparamsName();
            sSnmpV3TargetParams2.username = snmpV3TargetParamsContainer.getuserName();
            sSnmpV3TargetParams2.securityLevel = SnmpV3SecurityLevel.from_int(snmpV3TargetParamsContainer.getSecurityLevel());
            this.setSnmpV3TargetParams(sSnmpV3TargetParams2);
        } else {
            this.deleteSnmpV3TargetParams((String)object);
        }
    }

    public SnmpV3TargetParamsContainer[] getSnmpV3TargetParamsWrapper() {
        sSnmpV3TargetParams[] sSnmpV3TargetParamsArray = this.getSnmpV3TargetParams();
        SnmpV3TargetParamsContainer[] snmpV3TargetParamsContainerArray = new SnmpV3TargetParamsContainer[sSnmpV3TargetParamsArray.length];
        for (int i = 0; i < sSnmpV3TargetParamsArray.length; ++i) {
            snmpV3TargetParamsContainerArray[i] = new SnmpV3TargetParamsContainer(sSnmpV3TargetParamsArray[i].name, sSnmpV3TargetParamsArray[i].model.value(), sSnmpV3TargetParamsArray[i].username, sSnmpV3TargetParamsArray[i].securityLevel.value());
        }
        return snmpV3TargetParamsContainerArray;
    }

    public sSnmpV3Access[] getSnmpV3Access() {
        try {
            return (sSnmpV3Access[])this.snmpV3Access.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpAccess", userException);
        }
    }

    public void deleteSnmpV3Access(SnmpV3SecurityLevel snmpV3SecurityLevel, String string) {
        Object[] objectArray = new Object[]{snmpV3SecurityLevel, string};
        try {
            this.snmpV3Access.set(objectArray);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpAccess", userException);
        }
    }

    public void setSnmpV3Access(sSnmpV3Access sSnmpV3Access2) {
        try {
            this.snmpV3Access.set(sSnmpV3Access2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpAccess", userException);
        }
    }

    public sSnmpV3ViewTreeFamily[] getSnmpV3ViewTreeFamily() {
        try {
            return (sSnmpV3ViewTreeFamily[])this.snmpV3ViewTreeFamily.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpV3ViewTreeFamily", userException);
        }
    }

    public void deleteSnmpV3ViewTreeFamily(String string, sSnmpOID sSnmpOID2) throws ConfigError {
        Object[] objectArray = new Object[]{string, sSnmpOID2};
        try {
            this.snmpV3ViewTreeFamily.set(objectArray);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("deleteSnmpV3ViewTreeFamily", userException);
        }
    }

    public void setSnmpV3ViewTreeFamily(sSnmpV3ViewTreeFamily sSnmpV3ViewTreeFamily2) {
        try {
            this.snmpV3ViewTreeFamily.set(sSnmpV3ViewTreeFamily2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSnmpV3ViewTreeFamily", userException);
        }
    }

    public String[] getSnmpV3ViewTreeList() {
        sSnmpV3ViewTreeFamily[] sSnmpV3ViewTreeFamilyArray = this.getSnmpV3ViewTreeFamily();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < sSnmpV3ViewTreeFamilyArray.length; ++i) {
            hashSet.add(sSnmpV3ViewTreeFamilyArray[i].viewName);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public sSnmpV3NotifyFilter[] getSnmpV3NotifyFilter() {
        try {
            return (sSnmpV3NotifyFilter[])this.snmpV3NotifyFilter.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpV3NotifyFilter", userException);
        }
    }

    public String[] getSnmpV3ProfileList() {
        sSnmpV3NotifyFilter[] sSnmpV3NotifyFilterArray = this.getSnmpV3NotifyFilter();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < sSnmpV3NotifyFilterArray.length; ++i) {
            hashSet.add(sSnmpV3NotifyFilterArray[i].profileName);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void deleteSnmpV3NotifyFilter(String string, sSnmpOID sSnmpOID2) {
        Object[] objectArray = new Object[]{string, sSnmpOID2};
        try {
            this.snmpV3NotifyFilter.set(objectArray);
        }
        catch (UserException userException) {
            throw this.doUnknown("deleteSnmpV3NotifyFilter", userException);
        }
    }

    public void setSnmpV3NotifyFilter(sSnmpV3NotifyFilter sSnmpV3NotifyFilter2) {
        try {
            this.snmpV3NotifyFilter.set(sSnmpV3NotifyFilter2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSnmpV3NotifyFilter", userException);
        }
    }

    public sSnmpV3NotifyFilterProfile[] getSnmpV3NotifyFilterProfile() {
        try {
            return (sSnmpV3NotifyFilterProfile[])this.snmpV3NotifyFilterProfile.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpV3NotifyFilterProfile", userException);
        }
    }

    public void deleteSnmpV3NotifyFilterProfile(String string) {
        try {
            this.snmpV3NotifyFilterProfile.set(string);
        }
        catch (UserException userException) {
            throw this.doUnknown("deleteSnmpV3NotifyFilterProfile", userException);
        }
    }

    public void setSnmpV3NotifyFilterProfile(sSnmpV3NotifyFilterProfile sSnmpV3NotifyFilterProfile2) {
        try {
            this.snmpV3NotifyFilterProfile.set(sSnmpV3NotifyFilterProfile2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSnmpV3NotifyFilterProfile", userException);
        }
    }

    public sSnmpV3Notify[] getSnmpV3Notify() {
        try {
            return (sSnmpV3Notify[])this.snmpV3Notify.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getSnmpV3Notify", userException);
        }
    }

    public String[] getSnmpV3TagList() {
        sSnmpV3Notify[] sSnmpV3NotifyArray = this.getSnmpV3Notify();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < sSnmpV3NotifyArray.length; ++i) {
            hashSet.add(sSnmpV3NotifyArray[i].tag);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    @Override
    public void update(Observable observable, Object object) {
        Integer n = ModelUpdateType.CHANGED;
        int n2 = ((IObjectMessageInfo)object).getIndex();
        this.snmpV3User.update();
        this.snmpTrapDestinations.update();
        this.snmpSetEnable.update();
        this.snmpSetEnable.update();
        this.snmpProxyEnable.update();
        this.useGenericMib.update();
        this.changed();
        this.notifyObservers(ModelUpdateType.CHANGED);
        this.db.fine("SnmpModel.update(): Exit");
    }

    public General getNodeRef() {
        return this.getIorRepository().getNodeRef();
    }

    public IorRepository getIorRepository() {
        return IorRepository.getInstance(this.nodeModel);
    }

    public static UNKNOWN doUnknown(SDebug sDebug, String string, UserException userException) {
        if (sDebug != null) {
            sDebug.println("Caught unexpected exception in " + string);
            SDebug.printStackTrace((Throwable)userException);
        }
        return new UNKNOWN("Caught unexpected exception in " + string + " : " + (Object)((Object)userException));
    }

    private UNKNOWN doUnknown(String string, UserException userException) {
        return SnmpModel.doUnknown(this.db, string, userException);
    }

    static {
        sfactory = new NodeSingletonFactory<SnmpModel>(SnmpModel.class);
    }

    class DeleteSnmpTrapDestination
    extends NonCachedValue {
        public DeleteSnmpTrapDestination(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            if (object instanceof sIpAddr) {
                SnmpModel.this.snmpTrapDestinations.set(object);
            } else {
                SnmpModel.this.db.fine("DeleteSnmpTrapDestination failed");
            }
        }
    }

    class SnmpProxyEnable
    extends CachedValue {
        public SnmpProxyEnable(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SnmpModel.this.getNodeRef().allowSnmpProxy((Boolean)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Boolean(SnmpModel.this.getNodeRef().allowSnmpProxy());
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }

    class SnmpSetEnable
    extends CachedValue {
        public SnmpSetEnable(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            SnmpModel.this.getNodeRef().allowSnmpSet((Boolean)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Boolean(SnmpModel.this.getNodeRef().allowSnmpSet());
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }

    class SnmpTrapDestinations
    extends CachedValue {
        public SnmpTrapDestinations(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xMaxSnmpDestinations, xConfigError, xProvisionError {
            if (object instanceof sIpAddr) {
                SnmpModel.this.getNodeRef().deleteSnmpTrapDestination((sIpAddr)object);
            } else {
                SnmpModel.this.getNodeRef().setSnmpTrapDestination((sSnmpTrapDestination)object);
            }
        }

        @Override
        protected Object getValue() {
            return SnmpModel.this.getNodeRef().snmpTrapDestinations();
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }

    class SnmpV3Access
    extends NonCachedValue {
        public SnmpV3Access(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xDoesNotExist, xConfigError, xProvisionError {
            if (object instanceof sSnmpV3Access) {
                SnmpModel.this.getNodeRef().setSnmpV3Access((sSnmpV3Access)object);
            } else {
                Object[] objectArray = new Object[2];
                SnmpModel.this.getNodeRef().deleteSnmpV3Access((SnmpV3SecurityLevel)((Object[])object)[0], (String)((Object[])object)[1]);
            }
        }

        @Override
        protected Object getValue() {
            return SnmpModel.this.getNodeRef().snmpV3AccessList();
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }

    class SnmpV3Engine
    extends NonCachedValue {
        public SnmpV3Engine(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            return SnmpModel.this.getNodeRef().snmpV3Engine();
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }

    class SnmpV3Notify
    extends NonCachedValue {
        public SnmpV3Notify(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xDoesNotExist, xConfigError, xProvisionError {
            if (object instanceof sSnmpV3Notify) {
                SnmpModel.this.getNodeRef().setSnmpV3Notify((sSnmpV3Notify)object);
            } else {
                SnmpModel.this.getNodeRef().deleteSnmpV3Notify((String)object);
            }
        }

        @Override
        protected Object getValue() {
            return SnmpModel.this.getNodeRef().snmpV3NotifyList();
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }

    class SnmpV3NotifyFilter
    extends NonCachedValue {
        public SnmpV3NotifyFilter(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xDoesNotExist, xConfigError, xProvisionError {
            if (object instanceof sSnmpV3NotifyFilter) {
                SnmpModel.this.getNodeRef().setSnmpV3NotifyFilter((sSnmpV3NotifyFilter)object);
            } else {
                Object[] objectArray = new Object[2];
                SnmpModel.this.getNodeRef().deleteSnmpV3NotifyFilter((String)((Object[])object)[0], (sSnmpOID)((Object[])object)[1]);
            }
        }

        @Override
        protected Object getValue() {
            return SnmpModel.this.getNodeRef().snmpV3NotifyFilterList();
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }

    class SnmpV3NotifyFilterProfile
    extends NonCachedValue {
        public SnmpV3NotifyFilterProfile(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xDoesNotExist, xConfigError, xProvisionError {
            if (object instanceof sSnmpV3NotifyFilterProfile) {
                SnmpModel.this.getNodeRef().setSnmpV3NotifyFilterProfile((sSnmpV3NotifyFilterProfile)object);
            } else {
                SnmpModel.this.getNodeRef().deleteSnmpV3NotifyFilterProfile((String)object);
            }
        }

        @Override
        protected Object getValue() {
            return SnmpModel.this.getNodeRef().snmpV3NotifyFilterProfileList();
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }

    class SnmpV3Proxy
    extends NonCachedValue {
        public SnmpV3Proxy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xDoesNotExist, xConfigError, xProvisionError {
            if (object instanceof sSnmpV3Proxy) {
                SnmpModel.this.getNodeRef().setSnmpV3Proxy((sSnmpV3Proxy)object);
            } else {
                SnmpModel.this.getNodeRef().deleteSnmpV3Proxy((String)object);
            }
        }

        @Override
        protected Object getValue() {
            return SnmpModel.this.getNodeRef().snmpV3ProxyList();
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }

    class SnmpV3TargetAddress
    extends NonCachedValue {
        public SnmpV3TargetAddress(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xMaxSnmpDestinations, xConfigError, xProvisionError, xDoesNotExist {
            if (object instanceof sSnmpV3TargetAddress) {
                SnmpModel.this.getNodeRef().setSnmpV3TargetAddress((sSnmpV3TargetAddress)object);
            } else {
                SnmpModel.this.getNodeRef().deleteSnmpV3TargetAddress((String)object);
            }
        }

        @Override
        protected Object getValue() {
            return SnmpModel.this.getNodeRef().snmpV3TargetAddressList();
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }

    class SnmpV3TargetParams
    extends NonCachedValue {
        public SnmpV3TargetParams(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xDoesNotExist, xConfigError, xProvisionError {
            if (object instanceof sSnmpV3TargetParams) {
                SnmpModel.this.getNodeRef().setSnmpV3TargetParams((sSnmpV3TargetParams)object);
            } else {
                SnmpModel.this.getNodeRef().deleteSnmpV3TargetParams((String)object);
            }
        }

        @Override
        protected Object getValue() {
            return SnmpModel.this.getNodeRef().snmpV3TargetParamsList();
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }

    class SnmpV3User
    extends NonCachedValue {
        public SnmpV3User(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xDoesNotExist, xConfigError, xProvisionError {
            if (object instanceof sSnmpV3User) {
                SnmpModel.this.getNodeRef().setSnmpV3User((sSnmpV3User)object);
            } else {
                SnmpModel.this.getNodeRef().deleteSnmpV3User((String)((Object[])object)[0], (sSnmpV3Engine)((Object[])object)[1]);
            }
        }

        @Override
        protected Object getValue() {
            return SnmpModel.this.getNodeRef().snmpV3UserList();
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }

    class SnmpV3ViewTreeFamily
    extends NonCachedValue {
        public SnmpV3ViewTreeFamily(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xDoesNotExist, xConfigError, xProvisionError {
            if (object instanceof sSnmpV3ViewTreeFamily) {
                SnmpModel.this.getNodeRef().setSnmpV3ViewTreeFamily((sSnmpV3ViewTreeFamily)object);
            } else {
                Object[] objectArray = new Object[2];
                SnmpModel.this.getNodeRef().deleteSnmpV3ViewTreeFamily((String)((Object[])object)[0], (sSnmpOID)((Object[])object)[1]);
            }
        }

        @Override
        protected Object getValue() {
            return SnmpModel.this.getNodeRef().snmpV3ViewTreeFamilyList();
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }

    class UseGenericMib
    extends CachedValue {
        public UseGenericMib(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xOperationNotSupported {
            SnmpModel.this.getNodeRef().setUseGenericMib((Boolean)object);
        }

        @Override
        protected Object getValue() {
            return new Boolean(SnmpModel.this.getNodeRef().getUseGenericMib());
        }

        public Object outer() {
            return SnmpModel.this;
        }
    }
}

