/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xInvalidState;
import cerent.cms.idl.If.xLoopbackActive;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.SonetMedia.General;
import cerent.cms.idl.SonetMedia.sPathStats;
import cerent.cms.idl.SonetMedia.sPathStats600;
import cerent.cms.idl.SonetMedia.sPathStats600ListHolder;
import cerent.cms.idl.SonetMedia.sPathStatsHolder;
import cerent.cms.idl.SonetMedia.sPathThresholds;
import cerent.cms.idl.SonetMedia.sPathThresholds600;
import cerent.cms.idl.SonetMedia.sPathThresholds600Holder;
import cerent.cms.idl.SonetMedia.sPathThresholdsHolder;
import cerent.cms.idl.SonetMedia.sStsAttributes;
import cerent.cms.idl.SonetMedia.sStsPathDef;
import cerent.cms.idl.SonetMedia.tPathTraceArrayHolder;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.idl.SonetTopology.sStsLoopbackItem;
import cerent.cms.idl.SonetTopology.xConnectionInLoopback;
import cerent.cms.idl.SonetTopology.xConnectionInRoll;
import cerent.cms.idl.SonetTopology.xConnectionInTestAccess;
import cerent.cms.idl.SonetTopology.xInvalidPath;
import cerent.cms.idl.SonetTopology.xNoSuchLoopback;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractPersistableModelState;
import cerent.cms.model.AsapPosPortModel;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.HoPathDefModelFactory;
import cerent.cms.model.HoPathTraceModel;
import cerent.cms.model.HoSfSdModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IGenericTraceLine;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPathTraceModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISfSdModel;
import cerent.cms.model.ITdmHoModel;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoAditModel;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchLoopback;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PathInfoFactory;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SimpleMuxIndex;
import cerent.cms.model.TdmHoInterfaceAttrs;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.PathTraceUtil;
import cerent.util.SDebug;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class TdmHoModel
extends InterfaceModel
implements ITdmHoModel,
IGenericTraceLine {
    private HoPathTraceModel hoPathTraceModel;
    private HoSfSdModel hoSfSdModel;
    private StsPathStats stsPathStats;
    private StsTermCurrentPayloadLabel stsTermCurrentPayloadLabel;
    private StsReceivedPathTrace stsReceivedPathTrace;
    private PmThresholds pmThresholds;
    private StsPathPjcStats stsPathPjcStats;
    private StsPathThresholds stsPathThreshold;
    private ClearStatsPerParam clearStatsPerParam;
    private XcLoopback xcLoopback;
    private EventDispatcher dispatcher;
    private int hoConnectionIndex = 0;
    private AbstractPersistableModelState attrs;

    public TdmHoModel(NodeModelDelegate nodeModelDelegate, int n, SDebug sDebug) {
        this(nodeModelDelegate, n, null, sDebug);
    }

    public TdmHoModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2, SDebug sDebug) {
        this(nodeModelDelegate, n, sInterface2, sDebug, -1);
    }

    public TdmHoModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2, SDebug sDebug, short s) {
        super(nodeModelDelegate, n, sInterface2, sDebug);
        this.index = n;
        this.setSlotNum(s);
        this.stsPathStats = new StsPathStats(nodeModelDelegate, "TdmHoModel::stsPathStats");
        this.stsTermCurrentPayloadLabel = new StsTermCurrentPayloadLabel(nodeModelDelegate, "TdmHoModel::stsTermCurrentPayloadLabel");
        this.stsReceivedPathTrace = new StsReceivedPathTrace(nodeModelDelegate, "TdmHoModel::stsReceivedPathTrace");
        this.pmThresholds = new PmThresholds(nodeModelDelegate, "TdmHoModel.pmThresholds");
        this.stsPathPjcStats = new StsPathPjcStats(nodeModelDelegate, "TdmHoModel::stsPathPjcStats");
        this.stsPathThreshold = new StsPathThresholds(nodeModelDelegate, "TdmHoModel.stsPathThresholds");
        this.clearStatsPerParam = new ClearStatsPerParam(nodeModelDelegate, "TdmHoModel::clearStatsPerParam");
        this.xcLoopback = new XcLoopback(nodeModelDelegate, "TdmHoModel::xcLoopback");
    }

    public synchronized IPathTraceModel getHoPathTraceModel() {
        if (this.hoPathTraceModel == null) {
            try {
                InterfaceModel interfaceModel = this.getHighestParent();
                if (this.db.on()) {
                    this.db.println("Highest Parent is: " + interfaceModel);
                }
                if (interfaceModel != null && interfaceModel instanceof ITdmLineModel) {
                    IPortModel iPortModel = ((ITdmLineModel)interfaceModel).getPortModel();
                    if (this.db.on()) {
                        this.db.println("Check HoPathTraceModel re port: " + iPortModel);
                    }
                    if (PathTraceUtil.supportsJ1PathTrace((IEntityModel)iPortModel) || PathTraceUtil.supportsJ2PathTrace((IEntityModel)iPortModel)) {
                        this.hoPathTraceModel = new HoPathTraceModel(this);
                    } else if (this.db.on()) {
                        this.db.println("Not creating HoPathTraceModel for " + this + "because neither J1 nor J2 are supported.");
                    }
                } else {
                    this.hoPathTraceModel = new HoPathTraceModel(this);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return this.hoPathTraceModel;
    }

    public synchronized ISfSdModel getHoSfSdModel() {
        if (this.hoSfSdModel == null) {
            this.hoSfSdModel = new HoSfSdModel(this);
        }
        return this.hoSfSdModel;
    }

    public void setAttributes(sStsAttributes sStsAttributes2, long l) {
        super.setAttributes(sStsAttributes2.base, l);
        this.getSfBerLevelCV().setValueExternally(new Short(sStsAttributes2.sfBerLevel), l);
        this.getSdBerLevelCV().setValueExternally(new Short(sStsAttributes2.sdBerLevel), l);
        this.hoConnectionIndex = sStsAttributes2.connObjIndex;
    }

    @Override
    protected void handleIfModelInterconnect() {
        super.handleIfModelInterconnect();
        this.registerForUpdates();
    }

    private void registerForUpdates() {
        NodeModelDelegate nodeModelDelegate;
        block4: {
            nodeModelDelegate = this.getNodeModelDelegate();
            try {
                HoPathDefModel hoPathDefModel;
                if (this.hoConnectionIndex == 0 && (hoPathDefModel = this.getHoPathDefModel()) != null) {
                    this.hoConnectionIndex = nodeModelDelegate.getConnectionModels().getHoConnection((IHoPathDefModel)hoPathDefModel).getIndex();
                }
            }
            catch (CTCUserException cTCUserException) {
                if (!this.db.on()) break block4;
                this.db.println("TdmHoModel::TdmHoModel Could not find HoConnection for this HO.");
            }
        }
        this.dispatcher = nodeModelDelegate.getDispatcher();
        int n = this.getIfIndex();
        if (this.dispatcher != null && this.hoConnectionIndex != 0) {
            this.dispatcher.addObserver(ObjectType.ObjectLoopbackList, this.hoConnectionIndex, (Observer)this);
        }
    }

    public HoPathDefModel getHoPathDefModel() {
        IHoNum iHoNum;
        IPortModel iPortModel;
        block12: {
            iPortModel = null;
            try {
                iPortModel = this.getPortModel();
                if (this.db.on()) {
                    this.db.println("getHoPathDefModel: portModel is " + iPortModel);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block12;
                this.db.println("Could not retrieve PortModel");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (iPortModel != null && iPortModel.getModuleModel().getEqType() == 293) {
            return null;
        }
        if (iPortModel == null || !iPortModel.isOptical() && !(iPortModel instanceof AsapPosPortModel)) {
            return null;
        }
        try {
            int n = this.calcFramingType();
            iHoNum = HoLoFactory.ho2HoNum(n, this.getStartingHoNumber());
        }
        catch (Exception exception) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
        IPoolModel[] iPoolModelArray = this.getNodeModelDelegate().getPoolModels().getPoolModels(iPortModel.getIndex());
        for (int i = 0; i < iPoolModelArray.length; ++i) {
            IPoolModel iPoolModel = iPoolModelArray[i];
            if (!iPoolModel.containsEntity(iPortModel.getIndex())) continue;
            IPathInfo[] iPathInfoArray = iPoolModel.connectedPaths();
            for (int j = 0; j < iPathInfoArray.length; ++j) {
                IPathInfo iPathInfo = iPathInfoArray[j];
                int n = PathInfoFactory.calcFramingType(iPathInfo, this.getNodeModel());
                IHoNum iHoNum2 = iPathInfo.getStartingHo(n);
                IHoNum iHoNum3 = HoPathDefModel.physicalHo(iPoolModel, iHoNum2);
                if (!HoLoComparator.instance().isEqual(iHoNum, iHoNum3)) continue;
                HoPathDefModel hoPathDefModel = new HoPathDefModel(iPoolModel, iPathInfo.getPathWidth(), iHoNum2, 0);
                if (this.db.on()) {
                    this.db.println("getHoPathDefModel returning " + hoPathDefModel);
                }
                return hoPathDefModel;
            }
        }
        if (this.db.on()) {
            this.db.println("getHoPathDefModel returning null");
        }
        return null;
    }

    protected sStsPathDef getStsPathDefFor(HoPathDefModel hoPathDefModel) {
        sStsPathDef sStsPathDef2 = null;
        if (hoPathDefModel != null) {
            sStsPathDef2 = HoPathDefModelFactory.getStsPathDef(hoPathDefModel);
        }
        return sStsPathDef2;
    }

    @Override
    public void dispose() {
        int n = this.getModelType(this._getPersistType());
        if (this.dispatcher != null && this.hoConnectionIndex != -1) {
            this.dispatcher.deleteObserver(ObjectType.ObjectLoopback, this.getIndex(), (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectLoopbackList, this.hoConnectionIndex, (Observer)this);
        }
        if (this.hoPathTraceModel != null) {
            this.hoPathTraceModel.dispose();
        }
        if (this.hoSfSdModel != null) {
            this.hoSfSdModel.dispose();
        }
        this.dispose(n);
        super.dispose();
    }

    @Override
    public void destroy() {
        int n = this.getModelType(this._getPersistType());
        if (this.hoPathTraceModel != null) {
            this.hoPathTraceModel.destroy();
        }
        if (this.hoSfSdModel != null) {
            this.hoSfSdModel.destroy();
        }
        super.destroy();
        this.destroy(n);
    }

    public sPathThresholds getPmThresholds(boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2};
            return (sPathThresholds)this.pmThresholds.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPmthresholds", userException);
        }
    }

    public void setPmThresholds(boolean bl, eIntervalType eIntervalType2, sPathThresholds sPathThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, sPathThresholds2};
            this.pmThresholds.set(objectArray);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setPmthresholds", userException);
        }
    }

    public void clearStats(boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2};
            this.stsPathStats.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearStats", userException);
        }
    }

    public sPathStats getStats(boolean bl, eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, new Short(s)};
            sPathStats sPathStats2 = (sPathStats)this.stsPathStats.get(objectArray);
            return sPathStats2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getStats", userException);
        }
    }

    public boolean getIPPMEnabled() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Boolean)this.getIppmEnabledCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getIPPMEnabled", userException);
        }
    }

    public void setIPPMEnabled(boolean bl) throws NoSuchInterface, WrongInterfaceType {
        try {
            this.getIppmEnabledCV().set(new Boolean(bl));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setIPPMEnabled", userException);
        }
    }

    public boolean hasXcLoopback() throws InvalidPath {
        boolean bl = false;
        try {
            this.xcLoopback.get();
            bl = true;
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xNoSuchLoopback xNoSuchLoopback2) {
            bl = false;
        }
        catch (UserException userException) {
            throw this.doUnknown("hasXcLoopback", userException);
        }
        if (this.db.on()) {
            this.db.println("hasXcLoopback returning " + bl);
        }
        return bl;
    }

    public void setXcLoopback(boolean bl) throws ConnectionInLoopback, ConnectionInTestAccess, InvalidPath, InvalidState, LoopbackActive, ConnectionInRoll, NoSuchLoopback {
        try {
            this.xcLoopback.set(new Boolean(bl));
        }
        catch (xConnectionInLoopback xConnectionInLoopback2) {
            throw new ConnectionInLoopback((UserException)xConnectionInLoopback2);
        }
        catch (xConnectionInTestAccess xConnectionInTestAccess2) {
            throw new ConnectionInTestAccess((UserException)xConnectionInTestAccess2);
        }
        catch (xConnectionInRoll xConnectionInRoll2) {
            throw new ConnectionInRoll((UserException)xConnectionInRoll2);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xInvalidState xInvalidState2) {
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (xLoopbackActive xLoopbackActive2) {
            throw new LoopbackActive((UserException)xLoopbackActive2);
        }
        catch (xNoSuchLoopback xNoSuchLoopback2) {
            throw new NoSuchLoopback((UserException)xNoSuchLoopback2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setXcLoopback", userException);
        }
    }

    public short getSfBerLevel() throws NoSuchInterface, WrongInterfaceType {
        throw new FeatureNotSupported("getSfBerLevel() not supported");
    }

    public void setSfBerLevel(short s) throws NoSuchInterface, WrongInterfaceType {
        throw new FeatureNotSupported("setSfBerLevel() not supported");
    }

    public short getSdBerLevel() throws NoSuchInterface, WrongInterfaceType {
        throw new FeatureNotSupported("getSdBerLevel() not supported");
    }

    public void setSdBerLevel(short s) throws NoSuchInterface, WrongInterfaceType {
        throw new FeatureNotSupported("setSdBerLevel() not supported");
    }

    public byte getHoTermCurrentPayloadLabel() throws NoSuchInterface, WrongInterfaceType {
        throw new FeatureNotSupported("getHoTermCurrentPayloadLabel() not supported");
    }

    public byte getHoTermExpectedPayloadCode() throws NoSuchInterface, WrongInterfaceType {
        throw new FeatureNotSupported("getHoTermExpectedPayloadCode() not supported");
    }

    public void setHoTermExpectedPayloadCode(byte by) throws NoSuchInterface, WrongInterfaceType {
        throw new FeatureNotSupported("getHoTermExpectedPayloadCode() not supported");
    }

    public int getHoPathTraceFormat() {
        throw new FeatureNotSupported("getHoPathTraceForamt() not supported");
    }

    public void setHoPathTraceFormat(int n) {
        throw new FeatureNotSupported("setHoPathTraceFormat() not supported");
    }

    public String getHoTermSendPathTrace() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        throw new FeatureNotSupported("getHoTermSendPathTrace() not supported");
    }

    public void setHoTermSendPathTrace(String string) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        throw new FeatureNotSupported("setHoTermSendPathTrace() not supported");
    }

    public char[] getHoTermExpectedPathTrace() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        throw new FeatureNotSupported("getHoTermExpectedPathTrace() not supported");
    }

    public void setHoTermExpectedPathTrace(String string) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        throw new FeatureNotSupported("setHoTermExpectedPathTrace() not supported");
    }

    public char[] getHoTermReceivedPathTrace() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        throw new FeatureNotSupported("getHoTermReceivedPathTrace() not supported");
    }

    public int getHoPathTraceMode() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        throw new FeatureNotSupported("getHoPathTraceMode() not supported");
    }

    public void setHoPathTraceMode(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        throw new FeatureNotSupported("setHoPathTraceMode() not supported");
    }

    public boolean getHpMonitor() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            return (Boolean)this.getHpMonitorCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getHpMonitor", userException);
        }
    }

    public void setHpMonitor(boolean bl) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            this.getHpMonitorCV().set(new Boolean(bl));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setHpMonitor", userException);
        }
    }

    public int getHoPayloadMode() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        throw new FeatureNotSupported("getHoPayloadMode() not supported");
    }

    public void setHoPayloadMode(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        throw new FeatureNotSupported("setHoPayloadMode() not supported");
    }

    public boolean getAisInsertionPlm() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            return (Boolean)this.getAisInsertionPlmCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAisInsertionPlm", userException);
        }
    }

    public void setAisInsertionPlm(boolean bl) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            this.getAisInsertionPlmCV().set(new Boolean(bl));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setAisInsertionPlm", userException);
        }
    }

    @Override
    public List getConnectionsList() {
        LinkedList<ConnectionModel> linkedList = new LinkedList<ConnectionModel>();
        HoPathDefModel hoPathDefModel = this.getHoPathDefModel();
        if (hoPathDefModel != null) {
            ConnectionModel connectionModel;
            try {
                connectionModel = (ConnectionModel)this.getNodeModelDelegate().getConnectionModels().getLoAdit((IHoPathDefModel)hoPathDefModel);
            }
            catch (NoSuchConnection noSuchConnection) {
                ConnectionModel connectionModel2;
                try {
                    connectionModel2 = (ConnectionModel)this.getNodeModelDelegate().getConnectionModels().getHoConnection((IHoPathDefModel)hoPathDefModel);
                }
                catch (NoSuchConnection noSuchConnection2) {
                    return linkedList;
                }
                if (connectionModel2 != null) {
                    linkedList.add(connectionModel2);
                }
                return linkedList;
            }
            linkedList.addAll(((LoAditModel)connectionModel).getConnectionsList());
            linkedList.add(connectionModel);
        }
        return linkedList;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            if (object instanceof IObjectMessageInfo) {
                IObjectMessageInfo iObjectMessageInfo = (IObjectMessageInfo)object;
                int n = iObjectMessageInfo.getObjectType();
                if (n == 54 || n == 55) {
                    this.xcLoopback.update();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                } else {
                    super.update(observable, object);
                }
            } else {
                super.update(observable, object);
            }
        }
    }

    @Override
    protected void updateLocal(long l) {
        this.getTdmHoInterfaceAttrs().update(l);
        this.setChanged();
        super.updateLocal(l);
    }

    General getSonetRef() {
        return this.getNodeModelDelegate().getIorRepository().getSonetRef();
    }

    SonetFactory getSonetFactoryRef() {
        return this.getNodeModelDelegate().getIorRepository().getSonetFactoryRef();
    }

    public int getStartingHoNumber() {
        IHoNum iHoNum;
        block2: {
            iHoNum = null;
            try {
                int n = this.getInfo().muxIndex;
                int n2 = this.calcFramingType();
                n = new SimpleMuxIndex(this).getExternalMuxIndex();
                iHoNum = HoLoFactory.idlSts2HoNum(n2, n);
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on) break block2;
                this.db.println("getStartingHoNumber: Could not retrieve MuxIndex");
            }
        }
        return iHoNum == null ? (short)0 : iHoNum.getHoNum();
    }

    public void getStsPathThresholds(boolean bl, eIntervalType eIntervalType2, sPathThresholds600 sPathThresholds6002) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2};
            sPathThresholds600 sPathThresholds6003 = (sPathThresholds600)this.stsPathThreshold.get(objectArray);
            sPathThresholds6002.es = sPathThresholds6003.es;
            sPathThresholds6002.ses = sPathThresholds6003.ses;
            sPathThresholds6002.cv = sPathThresholds6003.cv;
            sPathThresholds6002.uas = sPathThresholds6003.uas;
            sPathThresholds6002.fc = sPathThresholds6003.fc;
            sPathThresholds6002.pjpIn = sPathThresholds6003.pjpIn;
            sPathThresholds6002.pjpOut = sPathThresholds6003.pjpOut;
            sPathThresholds6002.pjnIn = sPathThresholds6003.pjnIn;
            sPathThresholds6002.pjnOut = sPathThresholds6003.pjnOut;
            sPathThresholds6002.bbe = sPathThresholds6003.bbe;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getStsPathThresholds", userException);
        }
    }

    public void setStsPathThresholds(boolean bl, eIntervalType eIntervalType2, sPathThresholds600 sPathThresholds6002) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, sPathThresholds6002};
            this.stsPathThreshold.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setStsPathThresholds", userException);
        }
    }

    public void getPathStats(boolean bl, eIntervalType eIntervalType2, short s, sPathStats600[] sPathStats600Array) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, new Short(s)};
            Object[] objectArray2 = (Object[])this.stsPathPjcStats.get(objectArray);
            sPathStats600[] sPathStats600Array2 = (sPathStats600[])objectArray2[0];
            int n = sPathStats600Array2.length;
            for (int i = 0; i < n; ++i) {
                sPathStats600Array[i].cv = sPathStats600Array2[i].cv;
                sPathStats600Array[i].es = sPathStats600Array2[i].es;
                sPathStats600Array[i].fc = sPathStats600Array2[i].fc;
                sPathStats600Array[i].ses = sPathStats600Array2[i].ses;
                sPathStats600Array[i].uas = sPathStats600Array2[i].uas;
                sPathStats600Array[i].pjpIn = sPathStats600Array2[i].pjpIn;
                sPathStats600Array[i].pjnIn = sPathStats600Array2[i].pjnIn;
                sPathStats600Array[i].pjpOut = sPathStats600Array2[i].pjpOut;
                sPathStats600Array[i].pjnOut = sPathStats600Array2[i].pjnOut;
                sPathStats600Array[i].bbe = sPathStats600Array2[i].bbe;
                sPathStats600Array[i].esr = sPathStats600Array2[i].esr;
                sPathStats600Array[i].sesr = sPathStats600Array2[i].sesr;
                sPathStats600Array[i].bber = sPathStats600Array2[i].bber;
            }
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPathStats", userException);
        }
    }

    public void clearPathStats(boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2};
            this.stsPathPjcStats.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearStats", userException);
        }
    }

    public void clearStatsPerParam(boolean bl, eIntervalType eIntervalType2, String[] stringArray) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, stringArray};
            this.clearStatsPerParam.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearStatsPerParam", userException);
        }
    }

    public boolean isSdhAu3() {
        return this.isOfSdhType(2);
    }

    public boolean isSdhAu4() {
        return this.isOfSdhType(1);
    }

    private boolean isOfSdhType(int n) {
        boolean bl;
        block3: {
            if (this.node.getTdmProtocolTypeObj().isSonet()) {
                return false;
            }
            bl = true;
            try {
                bl = this.calcFramingType() == n;
            }
            catch (Exception exception) {
                if (!this.db.on()) break block3;
                this.db.println("Unable to determine framing type of Ho - a path may show in the wrong list.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return bl;
    }

    private TdmHoInterfaceAttrs getTdmHoInterfaceAttrs() {
        int n = this._getPersistType();
        return (TdmHoInterfaceAttrs)this.retrieveAttrs(this.getModelType(n), n);
    }

    private CachedValue getIppmEnabledCV() {
        return this.getTdmHoInterfaceAttrs().getIPPMEnabled();
    }

    private CachedValue getSfBerLevelCV() {
        return this.getTdmHoInterfaceAttrs().getSfBerLevel();
    }

    private CachedValue getSdBerLevelCV() {
        return this.getTdmHoInterfaceAttrs().getSdBerLevel();
    }

    private CachedValue getStsTermExpectedPayloadCodeCV() {
        return this.getTdmHoInterfaceAttrs().getStsTermExpectedPayloadCode();
    }

    private CachedValue getStsTermSendPathTraceCV() {
        return this.getTdmHoInterfaceAttrs().getStsTermSendPathTrace();
    }

    private CachedValue getStsTermExpectedPathTraceCV() {
        return this.getTdmHoInterfaceAttrs().getStsExpectedPathTrace();
    }

    private CachedValue getStsPathTraceModeCV() {
        return this.getTdmHoInterfaceAttrs().getStsPathTraceMode();
    }

    private CachedValue getStsPayloadModeCV() {
        return this.getTdmHoInterfaceAttrs().getStsPayloadMode();
    }

    private CachedValue getStsPathTraceFormatCV() {
        return this.getTdmHoInterfaceAttrs().getStsPathTraceFormat();
    }

    private CachedValue getHpMonitorCV() {
        return this.getTdmHoInterfaceAttrs().getHpMonitor();
    }

    private CachedValue getAisInsertionPlmCV() {
        return this.getTdmHoInterfaceAttrs().getAisInsertionPlm();
    }

    @Override
    protected Class state(int n) {
        return n == this._getPersistType() ? TdmHoModel._state() : super.state(n);
    }

    private static Class _me() {
        return TdmHoModel.class;
    }

    private static Class _state() {
        return TdmHoInterfaceAttrs.class;
    }

    public static Field[] getAttrFields(Class clazz) {
        return TdmHoModel.getAttrsFields(clazz, TdmHoModel._me(), TdmHoModel._state());
    }

    private int _getPersistType() {
        return TdmHoInterfaceAttrs.getCookie();
    }

    @Override
    protected AbstractPersistableModelState createInitialStateValue(int n) {
        if (n == -1 || n == this._getPersistType()) {
            return this.createInitialStateValue(TdmHoModel._state());
        }
        return super.createInitialStateValue(n);
    }

    @Override
    protected AbstractPersistableModelState getAttrsField(int n) {
        return n == this._getPersistType() ? this.attrs : super.getAttrsField(n);
    }

    @Override
    public int getAttrFieldsInMemory(int n) {
        boolean bl;
        boolean bl2 = bl = this.attrs != null;
        if (bl) {
            n |= 1 << this._getPersistType();
        }
        n |= super.getAttrFieldsInMemory(n);
        return n;
    }

    @Override
    protected void setAttrsField(AbstractPersistableModelState abstractPersistableModelState, int n) {
        if (n == this._getPersistType() || abstractPersistableModelState instanceof TdmHoInterfaceAttrs) {
            this.attrs = abstractPersistableModelState;
        } else if (n == -1 && abstractPersistableModelState == null) {
            if (this.attrs != null) {
                this.attrs.linkModel(null);
            }
            this.attrs = abstractPersistableModelState;
            super.setAttrsField(abstractPersistableModelState, n);
        } else {
            super.setAttrsField(abstractPersistableModelState, n);
        }
    }

    @Override
    void allAttributesIndicateWriteAccess(long l) {
        this.getTdmHoInterfaceAttrs().indicateWriteAccess(l);
        super.allAttributesIndicateWriteAccess(l);
    }

    public int calcFramingType() throws NoSuchInterface {
        return TdmHoModel.calcFramingType(this.getNodeModel(), this.getInfo().ifSpeed);
    }

    public static int calcFramingType(INodeModel iNodeModel, long l) {
        if (iNodeModel.getTdmProtocolTypeObj().isSonet()) {
            return 0;
        }
        int n = (int)(l / 50112000L);
        return n <= 1 ? 2 : 1;
    }

    public sPathThresholds getDefaultPmThresholds(boolean bl, eIntervalType eIntervalType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        short s = 1;
        HoPathDefModel hoPathDefModel = this.getHoPathDefModel();
        if (hoPathDefModel != null) {
            s = hoPathDefModel.getPathWidth();
        }
        return neDefaultsModel.getDefPathThrCmn(eEqType2, eEqType3, s, bl, eIntervalType2);
    }

    public byte getCurrentPayloadLabel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return this.getHoPathTraceModel().getCurrentPayloadLabel();
        }
        catch (InternalCommError internalCommError) {
            internalCommError.printStackTrace();
            byte by = 1;
            return by;
        }
    }

    public void setTraceFormat(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError, ProvisionError {
        this.getHoPathTraceModel().setPathTraceFormat(n);
    }

    public int getTraceFormat() throws NoSuchInterface, WrongInterfaceType {
        try {
            return this.getHoPathTraceModel().getPathTraceFormat();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            unsupportedOperation.printStackTrace();
            return 0;
        }
    }

    public int getTraceMode() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        return this.getHoPathTraceModel().getPathTraceMode();
    }

    public void setTraceMode(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError, ProvisionError {
        this.getHoPathTraceModel().setPathTraceMode(n);
    }

    public void setSendTrace(String string) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError {
        this.getHoPathTraceModel().setSendPathTrace(string);
    }

    public IGenericTraceLine.Trace getSendTraceAsTrace() throws NoSuchInterface, WrongInterfaceType {
        String string = "";
        try {
            string = this.getHoPathTraceModel().getSendPathTrace();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            unsupportedOperation.printStackTrace();
        }
        return new IGenericTraceLine.Trace(string.toCharArray(), true);
    }

    public void setExpectedTrace(String string) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError {
        this.getHoPathTraceModel().setExpectedPathTrace(string);
    }

    public IGenericTraceLine.Trace getExpectedTraceAsTrace() throws NoSuchInterface, WrongInterfaceType {
        char[] cArray = "".toCharArray();
        try {
            cArray = this.getHoPathTraceModel().getExpectedPathTrace();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            unsupportedOperation.printStackTrace();
        }
        return new IGenericTraceLine.Trace(cArray, true);
    }

    public IGenericTraceLine.Trace getReceivedTraceAsTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        char[] cArray = "".toCharArray();
        try {
            cArray = this.getHoPathTraceModel().getReceivedPathTrace();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            unsupportedOperation.printStackTrace();
        }
        return new IGenericTraceLine.Trace(cArray, true);
    }

    public boolean supportsAutoTrace() throws AbstractCmsNoSuchEntityException {
        return false;
    }

    public boolean isProtectLine() {
        return false;
    }

    public boolean canRequestReceivedTrace() {
        return true;
    }

    public String getSendTrace() throws NoSuchInterface, WrongInterfaceType {
        try {
            return this.getHoPathTraceModel().getSendPathTrace();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            unsupportedOperation.printStackTrace();
            return null;
        }
    }

    public char[] getExpectedTrace() throws NoSuchInterface, WrongInterfaceType {
        try {
            return this.getHoPathTraceModel().getExpectedPathTrace();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            unsupportedOperation.printStackTrace();
            return null;
        }
    }

    public char[] getReceivedTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            return this.getHoPathTraceModel().getReceivedPathTrace();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            unsupportedOperation.printStackTrace();
            return null;
        }
    }

    public boolean isSectionTerminated() {
        return false;
    }

    public boolean isLineTerminated() {
        return false;
    }

    class ClearStatsPerParam
    extends NonCachedValue {
        public ClearStatsPerParam(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            TdmHoModel.this.getSonetRef().clearStsStatsPerParam(TdmHoModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], (String[])objectArray[2]);
        }
    }

    class PmThresholds
    extends NonCachedValue {
        public PmThresholds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            sPathThresholdsHolder sPathThresholdsHolder2 = new sPathThresholdsHolder();
            Object[] objectArray = (Object[])object;
            TdmHoModel.this.getSonetRef().getStsTermPmThresholds(TdmHoModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], sPathThresholdsHolder2);
            return sPathThresholdsHolder2.value;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            TdmHoModel.this.getSonetRef().setStsTermPmThresholds(TdmHoModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], (sPathThresholds)objectArray[2]);
        }
    }

    class StsPathPjcStats
    extends NonCachedValue {
        public StsPathPjcStats(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            TdmHoModel.this.getSonetRef().clearStsPathStats(TdmHoModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1]);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            sPathStats600ListHolder sPathStats600ListHolder2 = new sPathStats600ListHolder();
            Object[] objectArray = (Object[])object;
            TdmHoModel.this.getSonetRef().getStsPathStats600(TdmHoModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], (Short)objectArray[2], sPathStats600ListHolder2);
            Object[] objectArray2 = new Object[]{sPathStats600ListHolder2.value};
            return objectArray2;
        }
    }

    class StsPathStats
    extends NonCachedValue {
        public StsPathStats(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            TdmHoModel.this.getSonetRef().clearStsPathStats(TdmHoModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1]);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            sPathStatsHolder sPathStatsHolder2 = new sPathStatsHolder();
            TdmHoModel.this.getSonetRef().getStsPathStats(TdmHoModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], (Short)objectArray[2], sPathStatsHolder2);
            return sPathStatsHolder2.value;
        }

        public Object outer() {
            return TdmHoModel.this;
        }
    }

    class StsPathThresholds
    extends NonCachedValue {
        public StsPathThresholds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            sPathThresholds600Holder sPathThresholds600Holder2 = new sPathThresholds600Holder();
            Object[] objectArray = (Object[])object;
            TdmHoModel.this.getSonetRef().getStsTermPmThresholds600(TdmHoModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], sPathThresholds600Holder2);
            return sPathThresholds600Holder2.value;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            TdmHoModel.this.getSonetRef().setStsTermPmThresholds600(TdmHoModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], (sPathThresholds600)objectArray[2]);
        }
    }

    class StsReceivedPathTrace
    extends NonCachedValue {
        public StsReceivedPathTrace(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            tPathTraceArrayHolder tPathTraceArrayHolder2 = new tPathTraceArrayHolder();
            TdmHoModel.this.getSonetRef().getStsReceivedPathTrace(TdmHoModel.this.getIndex(), tPathTraceArrayHolder2);
            return tPathTraceArrayHolder2.value;
        }

        public Object outer() {
            return TdmHoModel.this;
        }
    }

    class StsTermCurrentPayloadLabel
    extends NonCachedValue {
        public StsTermCurrentPayloadLabel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Byte(TdmHoModel.this.getSonetRef().getStsTermCurrentPayloadLabel(TdmHoModel.this.getIndex()));
        }

        public Object outer() {
            return TdmHoModel.this;
        }
    }

    class XcLoopback
    extends CachedValue {
        public XcLoopback(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xInvalidPath, xNoSuchLoopback {
            HoPathDefModel hoPathDefModel = TdmHoModel.this.getHoPathDefModel();
            sStsPathDef sStsPathDef2 = TdmHoModel.this.getStsPathDefFor(hoPathDefModel);
            if (sStsPathDef2 == null) {
                throw new xInvalidPath();
            }
            return TdmHoModel.this.getSonetFactoryRef().getStsLoopbackFromPath(sStsPathDef2);
        }

        @Override
        protected void setValue(Object object) throws xInvalidPath, xLoopbackActive, xConnectionInLoopback, xConnectionInTestAccess, xInvalidState, xNoSuchLoopback, xConnectionInRoll {
            HoPathDefModel hoPathDefModel = TdmHoModel.this.getHoPathDefModel();
            sStsPathDef sStsPathDef2 = TdmHoModel.this.getStsPathDefFor(hoPathDefModel);
            if (sStsPathDef2 == null) {
                throw new xInvalidPath();
            }
            if (((Boolean)object).booleanValue()) {
                TdmHoModel.this.getSonetFactoryRef().createStsLoopback(sStsPathDef2);
            } else {
                sStsLoopbackItem sStsLoopbackItem2 = TdmHoModel.this.getSonetFactoryRef().getStsLoopbackFromPath(sStsPathDef2);
                sStsLoopbackItem2.loopbackRef.destroy();
            }
        }
    }
}

