/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.SonetMedia.eStm1eMode;
import cerent.cms.idl.SonetTopology.eBlsrProtectionOp;
import cerent.cms.idl.SonetTopology.eProtectionOp;
import cerent.cms.idl.Synchronization.eRef;
import cerent.cms.idl.Synchronization.sInfo;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.BlsrProvisionFactory;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementModel;
import cerent.cms.model.ForceToPrimaryNotAllowed;
import cerent.cms.model.HoConnectionModel;
import cerent.cms.model.IBlsrProvision;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IDwdmLineModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoConnectionModel;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.UnprotectedLineModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.Map;
import org.omg.CORBA.UserException;

public class TdmPortModel
extends PortModel
implements ITdmPortModel {
    public TdmPortModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(TdmPortModel.class));
        this.index = n;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public boolean isOptical() {
        boolean bl;
        block4: {
            bl = false;
            try {
                int n = this.getEqType();
                bl = n != 31 && (n != 114 || this.getTdmLineModel().getStm1eMode() == eStm1eMode.STM_MODE);
            }
            catch (NoSuchInterface noSuchInterface) {
                this.db.println("Caught NoSuchInterface in isOptical!");
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.db.println("Caught WrongInterfaceType in isOptical!");
                if (!this.db.on()) break block4;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return bl;
    }

    public int getPortSize() {
        int n = this.getEqType();
        switch (n) {
            case 28: {
                return 3;
            }
            case 29: {
                return 12;
            }
            case 30: {
                return 48;
            }
            case 61: {
                return 192;
            }
        }
        throw new IllegalStateException("The port type " + n + " is unknown.");
    }

    @Override
    public boolean hasOpticalProtection() {
        try {
            return this.isOptical() && this.getTdmLineModel().getElementModel().getType() != 0;
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
            return false;
        }
    }

    public boolean hasOnePlusOneProtection() {
        try {
            ElementModel elementModel = this.getTdmLineModel().getElementModel();
            return elementModel instanceof OnePlusOneModel;
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
            return false;
        }
    }

    public TdmLineModel getTdmLineModel() {
        return (TdmLineModel)this.getInterfaceModel();
    }

    public ITdmLineModel getITdmLineModel() {
        return this.getTdmLineModel();
    }

    public IBlsrProvision getBlsrProvision() {
        block3: {
            try {
                ElementModel elementModel = this.getTdmLineModel().getElementModel();
                if (elementModel instanceof BlsrModel) {
                    return BlsrProvisionFactory.getIBlsrProvision(((BlsrModel)elementModel).getProvision());
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        return null;
    }

    public boolean isUpsrSelectorPresent() {
        return this.isUpsrSelectorPresent(false);
    }

    public boolean isUpsrSelectorPresent(boolean bl) {
        Map map = this.getTdmLineModel().getUpsrConnectionModels();
        HoConnectionModel[] hoConnectionModelArray = (HoConnectionModel[])map.get("ho");
        LoConnectionModel[] loConnectionModelArray = (LoConnectionModel[])map.get("lo");
        return this.isPathSelectorForHoConnectionModelPresent(hoConnectionModelArray, bl) || this.isPathSelectorForLoConnectionModelPresent(loConnectionModelArray, bl);
    }

    private static boolean isConnectionValid(int n) {
        return n == 4 || n == 2 || n == 5 || n == 7 || n == 6 || n == 3;
    }

    private boolean isPathSelectorForHoConnectionModelPresent(HoConnectionModel[] hoConnectionModelArray, boolean bl) {
        IHoPathDefModel[] iHoPathDefModelArray = null;
        IHoPathDefModel iHoPathDefModel = null;
        int n = 0;
        for (int i = 0; i < hoConnectionModelArray.length; ++i) {
            int n2;
            if (bl && (n2 = hoConnectionModelArray[i].getDriNodeType()) != 0) continue;
            n = hoConnectionModelArray[i].getConnectionType();
            if (!TdmPortModel.isConnectionValid(n)) {
                throw new IllegalArgumentException("The precondition for this method has been violated\nif TdmLineModel.private static boolean isConnectionModelUpsr(ConnectionModel cm)\nhas been modified then this method may require modification as well");
            }
            iHoPathDefModelArray = hoConnectionModelArray[i].getPaths();
            IHoPathDefModel iHoPathDefModel2 = iHoPathDefModelArray[0];
            IHoPathDefModel iHoPathDefModel3 = iHoPathDefModelArray[1];
            if (n != 3) {
                if (iHoPathDefModel2.getPool().getEntityIndex() != this.getEntityIndex() && iHoPathDefModel3.getPool().getEntityIndex() != this.getEntityIndex()) continue;
                return true;
            }
            IHoPathDefModel iHoPathDefModel4 = iHoPathDefModelArray[2];
            iHoPathDefModel = iHoPathDefModelArray[3];
            if (iHoPathDefModel2.getPool().getEntityIndex() != this.getEntityIndex() && iHoPathDefModel3.getPool().getEntityIndex() != this.getEntityIndex() && iHoPathDefModel4.getPool().getEntityIndex() != this.getEntityIndex() && iHoPathDefModel.getPool().getEntityIndex() != this.getEntityIndex()) continue;
            return true;
        }
        return false;
    }

    private boolean isPathSelectorForLoConnectionModelPresent(LoConnectionModel[] loConnectionModelArray, boolean bl) {
        ILoDefModel[] iLoDefModelArray = null;
        ILoDefModel iLoDefModel = null;
        int n = 0;
        for (int i = 0; i < loConnectionModelArray.length; ++i) {
            int n2;
            if (bl && (n2 = loConnectionModelArray[i].getDriNodeType()) != 0) continue;
            n = loConnectionModelArray[i].getConnectionType();
            if (!TdmPortModel.isConnectionValid(n)) {
                throw new IllegalArgumentException("The precondition for this method has been violated\nif SonetLineModel.private static boolean isConnectionModelUpsr(ConnectionModel cm)\nhas been modified then this method may require modification as well");
            }
            iLoDefModelArray = loConnectionModelArray[i].getPaths();
            ILoDefModel iLoDefModel2 = iLoDefModelArray[0];
            ILoDefModel iLoDefModel3 = iLoDefModelArray[1];
            if (n != 3) {
                if (iLoDefModel2.getLoAdit().getHo().getPool().getEntityIndex() != this.getEntityIndex() && iLoDefModel3.getLoAdit().getHo().getPool().getEntityIndex() != this.getEntityIndex()) continue;
                return true;
            }
            ILoDefModel iLoDefModel4 = iLoDefModelArray[2];
            iLoDefModel = iLoDefModelArray[3];
            if (iLoDefModel2.getLoAdit().getHo().getPool().getEntityIndex() != this.getEntityIndex() && iLoDefModel3.getLoAdit().getHo().getPool().getEntityIndex() != this.getEntityIndex() && iLoDefModel4.getLoAdit().getHo().getPool().getEntityIndex() != this.getEntityIndex() && iLoDefModel.getLoAdit().getHo().getPool().getEntityIndex() != this.getEntityIndex()) continue;
            return true;
        }
        return false;
    }

    public boolean isBlsrClear(int n) {
        block7: {
            try {
                ElementModel elementModel = this.getTdmLineModel().getElementModel();
                if (elementModel instanceof BlsrModel) {
                    BlsrModel blsrModel = (BlsrModel)elementModel;
                    eBlsrProtectionOp eBlsrProtectionOp2 = eBlsrProtectionOp.BLSR_CMD_CLEAR;
                    if (n == blsrModel.getEastEntityIndex()) {
                        eBlsrProtectionOp2 = blsrModel.getEastProtectionOp().kOp;
                    } else if (n == blsrModel.getWestEntityIndex()) {
                        eBlsrProtectionOp2 = blsrModel.getWestProtectionOp().kOp;
                    } else {
                        this.db.println("Unknown entity");
                        return false;
                    }
                    return eBlsrProtectionOp2 == eBlsrProtectionOp.BLSR_CMD_CLEAR || eBlsrProtectionOp2 == eBlsrProtectionOp.BLSR_CMD_APS_CLEAR;
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block7;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        return false;
    }

    public int get4FBlsrProtectEntityIndex(int n) {
        return -1;
    }

    public boolean isSonetDccTermination() {
        return this.isSdccTermination() || this.isLdccTermination();
    }

    public boolean isSdccTermination() {
        return this.getChassis().getOhConnectionModels().isChannelInUse(this.entityIndex, OhChannelType.SDCC_OBJ);
    }

    public boolean isLdccTermination() {
        return this.getChassis().getOhConnectionModels().isChannelInUse(this.entityIndex, OhChannelType.LDCC_OBJ);
    }

    public boolean hasOhChannel() {
        OhConnectionModelsDelegate ohConnectionModelsDelegate = this.getChassis().getOhConnectionModels();
        Iterator iterator = OhChannelType.getAllOhChannelTypes().iterator();
        while (iterator.hasNext()) {
            if (!ohConnectionModelsDelegate.isChannelInUse(this.entityIndex, (OhChannelType)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isOrderwireOn() {
        return this.isLocalOrderwireOn() || this.isExpressOrderwireOn();
    }

    public boolean isLocalOrderwireOn() {
        OhConnectionModelsDelegate ohConnectionModelsDelegate = this.getChassis().getOhConnectionModels();
        return ohConnectionModelsDelegate.isChannelInUse(this.entityIndex, OhChannelType.LOW_OBJ);
    }

    public boolean isExpressOrderwireOn() {
        OhConnectionModelsDelegate ohConnectionModelsDelegate = this.getChassis().getOhConnectionModels();
        return ohConnectionModelsDelegate.isChannelInUse(this.entityIndex, OhChannelType.EOW_OBJ);
    }

    public boolean isOnePlusOnePortActive() throws NoSuchInterface, WrongInterfaceType {
        block5: {
            try {
                ElementModel elementModel = this.getTdmLineModel().getElementModel();
                if (elementModel instanceof OnePlusOneModel) {
                    return this.getTdmLineModel().isCurrentlyActive();
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                }
            }
            catch (UnsupportedOperation unsupportedOperation) {
                if (!this.db.on()) break block5;
                SDebug.printStackTrace((Throwable)unsupportedOperation);
            }
        }
        return false;
    }

    public int getOnePlusOneWorkingEntityIndex() {
        block3: {
            try {
                ElementModel elementModel = this.getTdmLineModel().getElementModel();
                if (elementModel instanceof OnePlusOneModel) {
                    return ((OnePlusOneModel)elementModel).getMainEntityIndex();
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        return -1;
    }

    public int getOnePlusOneProtectEntityIndex() {
        block3: {
            try {
                ElementModel elementModel = this.getTdmLineModel().getElementModel();
                if (elementModel instanceof OnePlusOneModel) {
                    return ((OnePlusOneModel)elementModel).getProtectEntityIndex();
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        return -1;
    }

    public void setOnePlusOneForceSwitchToWorking() throws InvalidProtectionOp, ForceToPrimaryNotAllowed, InternalCommError {
        block3: {
            try {
                ElementModel elementModel = this.getTdmLineModel().getElementModel();
                if (elementModel instanceof OnePlusOneModel) {
                    ((OnePlusOneModel)elementModel).setProtectionOp(eProtectionOp.FORCE_SWITCH_TO_WORKING);
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
    }

    public void setOnePlusOneForceSwitchToProtect() throws InvalidProtectionOp, ForceToPrimaryNotAllowed, InternalCommError {
        block3: {
            try {
                ElementModel elementModel = this.getTdmLineModel().getElementModel();
                if (elementModel instanceof OnePlusOneModel) {
                    ((OnePlusOneModel)elementModel).setProtectionOp(eProtectionOp.FORCE_SWITCH_TO_PROTECT);
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
    }

    public void setOnePlusOneClear() throws InvalidProtectionOp, InternalCommError {
        block5: {
            try {
                ElementModel elementModel = this.getTdmLineModel().getElementModel();
                if (elementModel instanceof OnePlusOneModel) {
                    ((OnePlusOneModel)elementModel).setProtectionOp(eProtectionOp.CLEAR);
                }
            }
            catch (ForceToPrimaryNotAllowed forceToPrimaryNotAllowed) {
                if (this.db.on()) {
                    this.db.println(forceToPrimaryNotAllowed.getMessage());
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block5;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
    }

    public boolean isOnePlusOneClear() {
        block3: {
            try {
                ElementModel elementModel = this.getTdmLineModel().getElementModel();
                if (elementModel instanceof OnePlusOneModel) {
                    eProtectionOp eProtectionOp2 = ((OnePlusOneModel)elementModel).getProtectionOp();
                    return eProtectionOp2 == eProtectionOp.CLEAR || eProtectionOp2 == eProtectionOp.APS_CLEAR;
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        return false;
    }

    public IElementModel getElementModel() throws AbstractCmsNoSuchElementException {
        ElementModel elementModel;
        block4: {
            elementModel = this.getTdmLineModel().getElementModel();
            InterfaceModel interfaceModel = this.getTdmLineModel().getHighestParent();
            if (interfaceModel instanceof IDwdmLineModel && elementModel instanceof UnprotectedLineModel) {
                try {
                    IPortModel iPortModel = interfaceModel.getPortModel();
                    if (iPortModel instanceof IDwdmPortModel && ((IDwdmPortModel)iPortModel).isClientPort()) {
                        elementModel = ((IDwdmPortModel)iPortModel).getElementModel();
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.db.warning("Cannot get highest parent port for " + this);
                    if (!this.db.on()) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return elementModel;
    }

    public boolean isPortActive() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        return this.getTdmLineModel().isCurrentlyActive();
    }

    public boolean isPortIS() throws NoSuchInterface {
        throw new NoSuchInterface((UserException)new xNoSuchInterface());
    }

    public void setPortOOS() throws NoSuchInterface {
        throw new NoSuchInterface((UserException)new xNoSuchInterface());
    }

    public void setPortIS() throws NoSuchInterface {
        throw new NoSuchInterface((UserException)new xNoSuchInterface());
    }

    @Override
    public String toString() {
        return "Tdm" + super.toString();
    }

    @Override
    public boolean isInLoopback() {
        TdmLineModel tdmLineModel = this.getTdmLineModel();
        int n = 0;
        try {
            n = tdmLineModel.getLoopbackAsInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tdmLineModel != null && n != 0;
    }

    @Override
    public boolean isTimingSource() {
        boolean bl;
        block6: {
            bl = false;
            IChassisModel iChassisModel = this.getChassis();
            SynchronizationModel synchronizationModel = iChassisModel.getSyncModel();
            try {
                sInfo[] sInfoArray = synchronizationModel.getRefSources(eRef.NE);
                int n = this.getIndex();
                int n2 = this.getOnePlusOneWorkingEntityIndex();
                if (n2 == n) {
                    n2 = -1;
                }
                for (int i = 0; !bl && i < sInfoArray.length; ++i) {
                    if (sInfoArray[i].line == n) {
                        bl = true;
                        continue;
                    }
                    if (n2 <= 0 || sInfoArray[i].line != n2) continue;
                    bl = true;
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                this.db.println("Caught unexpected exception in isTimingSource");
                if (!this.db.on()) break block6;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        if (this.db.on()) {
            this.db.info(Integer.toHexString(this.getIndex()) + " isTimingSource is " + bl);
        }
        return bl;
    }

    private boolean inProhibitiveOpticalProtectionGroup() {
        boolean bl = false;
        if (this.hasOnePlusOneProtection()) {
            int n = this.getOnePlusOneWorkingEntityIndex();
            if (n != this.getIndex()) {
                IModel iModel;
                IEntityModel iEntityModel = null;
                try {
                    iModel = this.getChassis();
                    iEntityModel = iModel.getEntityTableModel().getEntityModelByIndex(n);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.db.severe(abstractCmsNoSuchEntityException.toString());
                }
                if (iEntityModel instanceof TdmPortModel) {
                    iModel = (TdmPortModel)iEntityModel;
                    bl = iModel.hasOhChannel() || iModel.isTimingSource();
                }
            }
        } else if (this.hasOpticalProtection()) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean maybeSetAdminState(int n, int n2, int n3) throws NoSuchInterface, LoopbackActive, UnsupportedOperation, SyncProvError, InvalidState, ProvisionError {
        this.db.info("TdmPortModel" + this + ".maybeSetAdminState(): targetState:" + n + ", policy:" + n2 + ", circuitSize:" + n3);
        boolean bl = false;
        boolean bl2 = true;
        int n4 = this.getAdminState();
        if (n4 != 1 && n != 0 && n4 != n) {
            boolean bl3 = bl2 = !this.hasOhChannel() && !this.inProhibitiveOpticalProtectionGroup();
            if (bl2 && n == 1 && n2 != 1 && this.isSonetDccTermination()) {
                this.db.fine("Skipping SonetDccTermination");
                bl2 = false;
            }
        }
        if (bl2) {
            bl = super.maybeSetAdminState(n, n2, n3);
        } else {
            this.db.info("Skipping because TDM level services provided by port");
        }
        return bl;
    }

    public int getADMobTrunkPort() {
        TdmLineModel tdmLineModel;
        InterfaceModel interfaceModel;
        int n = 0;
        if (this.getModuleModel().getEqType() == 273 && (interfaceModel = (tdmLineModel = this.getTdmLineModel()).getFirstLowerLayerModels()) != null && interfaceModel instanceof DwdmTrkLineModel) {
            try {
                n = interfaceModel.getPortModel().getEntityIndex();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.println("getADMobTrunkPort: " + (Object)((Object)abstractCmsNoSuchEntityException));
            }
        }
        return n;
    }

    public boolean hasTestAccessPoint() {
        return this.getNodeModelDelegate().getTapModels().hasTap(this);
    }
}

